/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicInternalException;

public enum Format {
    BINARY,
    JSON,
    TEXT,
    XML,
    UNKNOWN;


    public String getDefaultMimetype() {
        switch (this) {
            case UNKNOWN: {
                return null;
            }
            case BINARY: {
                return "application/octet-stream";
            }
            case JSON: {
                return "application/json";
            }
            case TEXT: {
                return "text/plain";
            }
            case XML: {
                return "application/xml";
            }
        }
        throw new MarkLogicInternalException("Unknown format " + this.toString());
    }

    public static Format getFromMimetype(String mimeType) {
        if (mimeType == null) {
            return UNKNOWN;
        }
        if (mimeType.startsWith("application/xml")) {
            return XML;
        }
        if (mimeType.startsWith("text/xml")) {
            return XML;
        }
        if (mimeType.startsWith("application/json")) {
            return JSON;
        }
        if (mimeType.startsWith("text/xml")) {
            return JSON;
        }
        if (mimeType.startsWith("application/octet-stream")) {
            return BINARY;
        }
        if (mimeType.startsWith("text/")) {
            return TEXT;
        }
        return UNKNOWN;
    }
}

