/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.SearchReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.query.ExtractedItem;
import com.marklogic.client.query.ExtractedResult;
import com.marklogic.client.query.FacetHeatmapValue;
import com.marklogic.client.query.FacetResult;
import com.marklogic.client.query.FacetValue;
import com.marklogic.client.query.MatchDocumentSummary;
import com.marklogic.client.query.MatchLocation;
import com.marklogic.client.query.MatchSnippet;
import com.marklogic.client.query.QueryDefinition;
import com.marklogic.client.query.SearchMetrics;
import com.marklogic.client.query.SearchResults;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SearchHandle
extends BaseHandle<InputStream, OperationNotSupported>
implements SearchReadHandle,
SearchResults {
    private static final Logger logger = LoggerFactory.getLogger(SearchHandle.class);
    private static String SEARCH_NS = "http://marklogic.com/appservices/search";
    private static String QUERY_NS = "http://marklogic.com/cts/query";
    private QueryDefinition querydef;
    private DatabaseClientFactory.HandleFactoryRegistry registry;
    private MatchDocumentSummary[] summary;
    private SearchMetrics metrics;
    private List<Warning> warnings;
    private List<Report> reports;
    private Map<String, FacetResult> facets;
    private Map<String, EventRange> constraints;
    private EventRange planEvents;
    private List<XMLEvent> events;
    private long totalResults = -1L;
    private long start = -1L;
    private int pageLength = 0;
    private String snippetType;
    private String[] qtext;
    private EventRange queryEvents;

    public SearchHandle() {
        super.setFormat(Format.XML);
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("SearchHandle supports the XML format only");
        }
    }

    public SearchHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            factory.setProperty("javax.xml.stream.isValidating", false);
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLEventReader reader = factory.createXMLEventReader(content, "UTF-8");
            SearchResponseImpl response = new SearchResponseImpl();
            response.parse(reader);
            reader.close();
            try {
                content.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.summary = response.tempSummary == null || response.tempSummary.size() < 1 ? new MatchDocumentSummary[]{} : response.tempSummary.toArray(new MatchDocumentSummary[response.tempSummary.size()]);
            this.metrics = response.tempMetrics;
            this.facets = response.tempFacets;
            this.warnings = response.tempWarnings;
            this.reports = response.tempReports;
            this.planEvents = response.tempPlanEvents;
            this.constraints = response.tempConstraints;
            this.events = response.tempEvents;
            this.totalResults = response.tempTotalResults;
            this.start = response.tempStart;
            this.pageLength = response.tempPageLength;
            this.snippetType = response.tempSnippetType;
            this.qtext = response.qtextList == null || response.qtextList.size() < 1 ? null : response.qtextList.toArray(new String[response.qtextList.size()]);
            this.queryEvents = response.tempQueryEvents;
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException("Could not construct search results: parser error", e);
        }
    }

    public void setQueryCriteria(QueryDefinition querydef) {
        this.querydef = querydef;
        this.summary = null;
        this.metrics = null;
        this.facets = null;
        this.warnings = null;
        this.reports = null;
        this.planEvents = null;
        this.constraints = null;
        this.events = null;
        this.totalResults = -1L;
        this.start = -1L;
        this.pageLength = 0;
        this.snippetType = null;
        this.qtext = null;
        this.queryEvents = null;
    }

    @Override
    public QueryDefinition getQueryCriteria() {
        return this.querydef;
    }

    public final void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry registry) {
        this.registry = registry;
    }

    private DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.registry;
    }

    @Override
    public long getTotalResults() {
        return this.totalResults;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public int getPageLength() {
        return this.pageLength;
    }

    @Override
    public String getSnippetTransformType() {
        return this.snippetType;
    }

    @Override
    public String[] getStringQueries() {
        return this.qtext;
    }

    @Override
    public <T extends XMLReadHandle> T getQuery(T handle) {
        return Utilities.exportToHandle(this.getSlice(this.events, this.queryEvents), handle);
    }

    @Override
    public SearchMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public MatchDocumentSummary[] getMatchResults() {
        return this.summary;
    }

    @Override
    public String[] getFacetNames() {
        if (this.facets == null || this.facets.isEmpty()) {
            return new String[0];
        }
        Set<String> names = this.facets.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public FacetResult getFacetResult(String name) {
        if (this.facets == null || this.facets.isEmpty()) {
            return null;
        }
        return this.facets.get(name);
    }

    @Override
    public FacetResult[] getFacetResults() {
        if (this.facets == null || this.facets.isEmpty()) {
            return new FacetResult[0];
        }
        Collection<FacetResult> facetResults = this.facets.values();
        return facetResults.toArray(new FacetResult[facetResults.size()]);
    }

    @Override
    public String[] getConstraintNames() {
        if (this.constraints == null || this.constraints.isEmpty()) {
            return new String[0];
        }
        Set<String> names = this.constraints.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public <T extends XMLReadHandle> T getConstraint(String name, T handle) {
        if (this.constraints == null || this.constraints.isEmpty()) {
            return null;
        }
        EventRange constraintEvents = this.constraints.get(name);
        if (constraintEvents == null) {
            return null;
        }
        return Utilities.exportToHandle(this.getSlice(this.events, constraintEvents), handle);
    }

    @Override
    public <T extends XMLReadHandle> Iterator<T> getConstraintIterator(T handle) {
        if (this.constraints == null || this.constraints.isEmpty()) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        ArrayList<EventRange> constraintList = new ArrayList<EventRange>(this.constraints.values());
        return new EventIterator(this, this.events, constraintList, handle);
    }

    @Override
    public Document getPlan() {
        DOMHandle handle = this.getPlan(new DOMHandle());
        return handle == null ? null : handle.get();
    }

    @Override
    public <T extends XMLReadHandle> T getPlan(T handle) {
        return Utilities.exportToHandle(this.getSlice(this.events, this.planEvents), handle);
    }

    @Override
    public Warning[] getWarnings() {
        return this.warnings == null ? new Warning[]{} : this.warnings.toArray(new Warning[0]);
    }

    @Override
    public Report[] getReports() {
        return this.reports == null ? new Report[]{} : this.reports.toArray(new Report[0]);
    }

    private List<XMLEvent> getSlice(List<XMLEvent> eventList, EventRange eventRange) {
        if (eventList == null || eventRange == null) {
            return null;
        }
        return eventList.subList(eventRange.getFirst(), eventRange.getNext());
    }

    private Document[] getEventDocuments(List<XMLEvent> eventList, List<EventRange> rangeList) {
        if (rangeList == null || rangeList.size() < 1) {
            return new Document[0];
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        DOMHandle handle = new DOMHandle();
        for (int i = 0; i < rangeList.size(); ++i) {
            Document document;
            EventRange eventRange = rangeList.get(i);
            handle = Utilities.exportToHandle(this.getSlice(eventList, eventRange), handle);
            Document document2 = document = handle == null ? null : handle.get();
            if (document == null) continue;
            documents.add(document);
        }
        int size = documents.size();
        return size == 0 ? null : documents.toArray(new Document[size]);
    }

    private static class ExtractedResultImpl
    implements ExtractedResult {
        boolean isEmpty = false;
        String kind;
        private List<String> itemStrings;
        private List<ExtractedItem> items;
        private Iterator<ExtractedItem> internalIterator;

        private ExtractedResultImpl() {
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }

        @Override
        public String getKind() {
            return this.kind;
        }

        @Override
        public int size() {
            if (this.items == null) {
                return 0;
            }
            return this.items.size();
        }

        @Override
        public Iterator<ExtractedItem> iterator() {
            return this.items.iterator();
        }

        private void setItems(List<String> itemStrings) {
            if (itemStrings == null) {
                return;
            }
            this.itemStrings = itemStrings;
            this.items = new ArrayList<ExtractedItem>(itemStrings.size());
            for (String itemString : itemStrings) {
                this.items.add(new ExtractedItemImpl(itemString));
            }
            this.internalIterator = this.items.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public ExtractedItem next() {
            return this.internalIterator.next();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ExtractedResult: ");
            sb.append(this.isEmpty ? "isEmpty:[true] " : "");
            sb.append(this.kind != null ? "kind:[" + this.kind + "] " : "");
            for (int i = 1; i <= this.itemStrings.size(); ++i) {
                String item = this.itemStrings.get(i - 1);
                sb.append("item_" + i + ":[" + item + "] ");
            }
            return sb.toString();
        }
    }

    private static class ExtractedItemImpl
    implements ExtractedItem {
        String item;

        public ExtractedItemImpl(String item) {
            this.item = item;
        }

        @Override
        public <T extends StructureReadHandle> T get(T handle) {
            HandleAccessor.receiveContent(handle, this.item);
            return handle;
        }

        @Override
        public <T> T getAs(Class<T> as) {
            ContentHandle<T> readHandle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
            if (readHandle == null) {
                return null;
            }
            HandleAccessor.receiveContent(readHandle, this.item);
            return readHandle.get();
        }
    }

    private class SearchResponseImpl {
        private List<MatchDocumentSummary> tempSummary;
        private MatchDocumentSummaryImpl currSummary;
        private List<Warning> tempWarnings;
        private List<Report> tempReports;
        private SearchMetrics tempMetrics;
        private EventRange tempPlanEvents;
        private List<XMLEvent> tempEvents;
        private long tempTotalResults = -1L;
        private long tempStart = -1L;
        private int tempPageLength = 0;
        private Map<String, FacetResult> tempFacets;
        private Map<String, EventRange> tempConstraints;
        private String tempSnippetType;
        private String tempExtractSelected;
        private List<String> qtextList;
        private EventRange tempQueryEvents;

        private SearchResponseImpl() {
        }

        private void parse(XMLEventReader reader) throws XMLStreamException {
            this.tempEvents = new ArrayList<XMLEvent>();
            block4: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        this.handleTop(reader, event.asStartElement());
                        continue block4;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        continue block4;
                    }
                }
                throw new InternalError("unknown event type: " + eventType);
            }
        }

        private void handleTop(XMLEventReader reader, StartElement element) throws XMLStreamException {
            QName name = element.getName();
            if (!SEARCH_NS.equals(name.getNamespaceURI())) {
                logger.warn("unexpected top element " + name.toString());
                return;
            }
            String localName = name.getLocalPart();
            if ("response".equals(localName)) {
                this.handleResponse(reader, element);
            } else if ("result".equals(localName)) {
                this.handleResult(reader, element);
            } else if ("facet".equals(localName)) {
                this.handleFacet(reader, element);
            } else if ("boxes".equals(localName)) {
                this.handleGeoFacet(reader, element);
            } else if ("qtext".equals(localName)) {
                this.handleQText(reader, element);
            } else if ("query".equals(localName)) {
                this.handleQuery(reader, element);
            } else if ("constraint".equals(localName)) {
                this.handleConstraint(reader, element);
            } else if ("warning".equals(localName)) {
                this.handleWarning(reader, element);
            } else if ("report".equals(localName)) {
                this.handleReport(reader, element);
            } else if ("plan".equals(localName)) {
                this.handlePlan(reader, element);
            } else if ("metrics".equals(localName)) {
                this.handleMetrics(reader, element);
            } else {
                logger.warn("Unexpected top search element " + name.toString());
            }
        }

        private void handleResponse(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.tempSnippetType = this.getAttribute(element, "snippet-format");
            if (this.getAttribute(element, "total") != null) {
                this.tempTotalResults = Long.parseLong(this.getAttribute(element, "total"));
            }
            this.tempPageLength = Integer.parseInt(this.getAttribute(element, "page-length"));
            this.tempStart = Long.parseLong(this.getAttribute(element, "start"));
            this.tempExtractSelected = this.getAttribute(element, "selected");
            this.collectTop(reader, element);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void collectTop(XMLEventReader reader, StartElement element) throws XMLStreamException {
            QName startName = element.getName();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        this.handleTop(reader, event.asStartElement());
                        break;
                    }
                    case 2: {
                        if (!startName.equals(event.asEndElement().getName())) break;
                        return;
                    }
                }
            }
        }

        private void handleResult(XMLEventReader reader, StartElement element) throws XMLStreamException {
            String ruri = this.getAttribute(element, "uri");
            String path = this.getAttribute(element, "path");
            String mimeType = this.getAttribute(element, "mimetype");
            String formatString = this.getAttribute(element, "format");
            Format format = Format.UNKNOWN;
            if (formatString != null && !formatString.equals("")) {
                format = Format.valueOf(formatString.toUpperCase());
            }
            int score = Integer.parseInt(this.getAttribute(element, "score"));
            double confidence = Double.parseDouble(this.getAttribute(element, "confidence"));
            double fitness = Double.parseDouble(this.getAttribute(element, "fitness"));
            this.currSummary = new MatchDocumentSummaryImpl(ruri, score, confidence, fitness, path, mimeType, format, this.tempExtractSelected);
            if (this.tempSummary == null) {
                this.tempSummary = new ArrayList<MatchDocumentSummary>();
            }
            this.tempSummary.add(this.currSummary);
            this.collectResult(reader, element);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void collectResult(XMLEventReader reader, StartElement element) throws XMLStreamException {
            QName snippetName = new QName(SEARCH_NS, "snippet");
            QName extractedName = new QName(SEARCH_NS, "extracted");
            QName extractedNoneName = new QName(SEARCH_NS, "extracted-none");
            QName metadataName = new QName(SEARCH_NS, "metadata");
            QName similarName = new QName(SEARCH_NS, "similar");
            QName relevanceInfoName = new QName(QUERY_NS, "relevance-info");
            ArrayList<XMLEvent> eventBuf = new ArrayList<XMLEvent>();
            QName resultName = element.getName();
            block4: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        QName startName = startElement.getName();
                        if (snippetName.equals(startName)) {
                            this.handleSnippet(reader, startElement);
                        } else if (extractedName.equals(startName)) {
                            this.handleExtracted(reader, startElement);
                        } else if (extractedNoneName.equals(startName)) {
                            this.handleExtracted(reader, startElement);
                        } else if (metadataName.equals(startName)) {
                            this.handleMetadata(reader, startElement);
                        } else if (similarName.equals(startName)) {
                            this.handleSimilar(reader, startElement);
                        } else {
                            if (!relevanceInfoName.equals(startName)) break;
                            this.handleRelevanceInfo(reader, startElement);
                        }
                        if (eventBuf == null) break;
                        eventBuf = null;
                        break;
                    }
                    case 2: {
                        if (resultName.equals(event.asEndElement().getName())) break block4;
                    }
                }
                if (eventBuf == null) continue;
                eventBuf.add(event);
            }
            if (eventBuf != null) {
                int first = this.tempEvents.size();
                this.tempEvents.addAll(eventBuf);
                this.addSnippet(new EventRange(first, this.tempEvents.size()));
            }
        }

        private void handleExtracted(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.currSummary.extractedEvents = this.consumeEvents(reader, element);
        }

        private void handleMetadata(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.currSummary.metadataEvents = this.consumeEvents(reader, element);
        }

        private void handleSimilar(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.currSummary.similarUris == null) {
                this.currSummary.similarUris = new ArrayList();
            }
            this.currSummary.similarUris.add(reader.getElementText());
        }

        private void handleRelevanceInfo(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.currSummary.relevanceEvents = this.consumeEvents(reader, element);
        }

        private void handlePlan(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.tempPlanEvents = this.consumeEvents(reader, element);
        }

        private void handleSnippet(XMLEventReader reader, StartElement element) throws XMLStreamException {
            int first = this.tempEvents.size();
            this.tempEvents.add(element);
            this.collectSnippet(reader, element);
            this.addSnippet(new EventRange(first, this.tempEvents.size()));
        }

        /*
         * Enabled aggressive block sorting
         */
        private void collectSnippet(XMLEventReader reader, StartElement element) throws XMLStreamException {
            QName matchName = new QName(SEARCH_NS, "match");
            QName snippetName = element.getName();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                this.tempEvents.add(event);
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        if (!matchName.equals(startElement.getName())) break;
                        this.handleMatch(reader, startElement);
                        break;
                    }
                    case 2: {
                        if (!snippetName.equals(event.asEndElement().getName())) break;
                        return;
                    }
                }
            }
        }

        private void addSnippet(EventRange snippetRange) {
            if (this.currSummary.snippetEvents == null) {
                this.currSummary.snippetEvents = new ArrayList();
            }
            this.currSummary.snippetEvents.add(snippetRange);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleMatch(XMLEventReader reader, StartElement element) throws XMLStreamException {
            MatchLocationImpl location = new MatchLocationImpl(this.getAttribute(element, "path"));
            QName highlightName = new QName(SEARCH_NS, "highlight");
            StringBuilder buf = new StringBuilder();
            QName matchName = element.getName();
            block5: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                this.tempEvents.add(event);
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        if (!highlightName.equals(startElement.getName()) || buf.length() <= 0) break;
                        location.addMatchSnippet(new MatchSnippetImpl(false, buf.toString()));
                        buf.setLength(0);
                        break;
                    }
                    case 4: 
                    case 12: {
                        buf.append(event.asCharacters().getData());
                        break;
                    }
                    case 2: {
                        EndElement endElement = event.asEndElement();
                        QName endName = endElement.getName();
                        if (matchName.equals(endName)) {
                            if (buf.length() <= 0) break block5;
                            location.addMatchSnippet(new MatchSnippetImpl(false, buf.toString()));
                            break block5;
                        }
                        if (!highlightName.equals(endName)) break;
                        location.addMatchSnippet(new MatchSnippetImpl(true, buf.toString()));
                        buf.setLength(0);
                    }
                }
            }
            buf = null;
            this.currSummary.addLocation(location);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleFacet(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.tempFacets == null) {
                this.tempFacets = new LinkedHashMap<String, FacetResult>();
            }
            String facetName = this.getAttribute(element, "name");
            ArrayList<FacetValue> values = new ArrayList<FacetValue>();
            QName facetValuesName = new QName(SEARCH_NS, "facet-value");
            QName facetElementName = element.getName();
            block4: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        if (facetValuesName.equals(startElement.getName())) {
                            values.add(this.handleFacetValue(reader, startElement));
                            break;
                        }
                        logger.warn("Unexpected facet element " + startElement.getName().toString());
                        break;
                    }
                    case 2: {
                        if (facetElementName.equals(event.asEndElement().getName())) break block4;
                    }
                }
            }
            this.tempFacets.put(facetName, new FacetResultImpl(facetName, values.toArray(new FacetValue[values.size()])));
        }

        private FacetValue handleFacetValue(XMLEventReader reader, StartElement element) throws XMLStreamException {
            String name = this.getAttribute(element, "name");
            long count = Long.parseLong(this.getAttribute(element, "count"));
            FacetValueImpl facetValue = new FacetValueImpl(name, count);
            facetValue.setLabel(reader.getElementText());
            return facetValue;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleGeoFacet(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.tempFacets == null) {
                this.tempFacets = new LinkedHashMap<String, FacetResult>();
            }
            String facetName = this.getAttribute(element, "name");
            ArrayList<FacetValue> values = new ArrayList<FacetValue>();
            QName boxName = new QName(SEARCH_NS, "box");
            QName boxesName = element.getName();
            block4: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        if (boxName.equals(startElement.getName())) {
                            values.add(this.handleGeoFacetValue(reader, startElement));
                            break;
                        }
                        logger.warn("Unexpected boxes element " + startElement.getName().toString());
                        break;
                    }
                    case 2: {
                        if (boxesName.equals(event.asEndElement().getName())) break block4;
                    }
                }
            }
            this.tempFacets.put(facetName, new FacetResultImpl(facetName, values.toArray(new FacetValue[values.size()])));
        }

        private FacetValue handleGeoFacetValue(XMLEventReader reader, StartElement element) {
            String name = this.getAttribute(element, "name");
            long count = Long.parseLong(this.getAttribute(element, "count"));
            double s = Double.parseDouble(this.getAttribute(element, "s"));
            double w = Double.parseDouble(this.getAttribute(element, "w"));
            double n = Double.parseDouble(this.getAttribute(element, "n"));
            double e = Double.parseDouble(this.getAttribute(element, "e"));
            return new FacetHeatmapValueImpl(name, count, s, w, n, e);
        }

        private void handleQText(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.qtextList == null) {
                this.qtextList = new ArrayList<String>();
            }
            this.qtextList.add(reader.getElementText());
        }

        private void handleQuery(XMLEventReader reader, StartElement element) throws XMLStreamException {
            this.tempQueryEvents = this.consumeEvents(reader, element);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleMetrics(XMLEventReader reader, StartElement element) throws XMLStreamException {
            DatatypeFactory dtFactory;
            try {
                dtFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException dce) {
                throw new MarkLogicIOException("Cannot instantiate datatypeFactory", dce);
            }
            Calendar now = Calendar.getInstance();
            QName queryName = new QName(SEARCH_NS, "query-resolution-time");
            QName facetName = new QName(SEARCH_NS, "facet-resolution-time");
            QName snippetName = new QName(SEARCH_NS, "snippet-resolution-time");
            QName metadataName = new QName(SEARCH_NS, "metadata-resolution-time");
            QName extractName = new QName(SEARCH_NS, "extract-resolution-time");
            QName totalName = new QName(SEARCH_NS, "total-time");
            long qrTime = -1L;
            long frTime = -1L;
            long srTime = -1L;
            long mrTime = -1L;
            long erTime = -1L;
            long tTime = -1L;
            QName metricsName = element.getName();
            block6: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElement = event.asStartElement();
                        QName startName = startElement.getName();
                        String readerValue = reader.getElementText();
                        if (readerValue == null || readerValue.length() <= 0) break;
                        if (queryName.equals(startName)) {
                            qrTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        if (facetName.equals(startName)) {
                            frTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        if (snippetName.equals(startName)) {
                            srTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        if (metadataName.equals(startName)) {
                            mrTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        if (extractName.equals(startName)) {
                            erTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        if (totalName.equals(startName)) {
                            tTime = this.parseTime(dtFactory, now, readerValue);
                            break;
                        }
                        logger.warn("Unexpected metrics element " + startName.toString());
                        break;
                    }
                    case 2: {
                        if (metricsName.equals(event.asEndElement().getName())) break block6;
                    }
                }
            }
            this.tempMetrics = new SearchMetricsImpl(qrTime, frTime, srTime, mrTime, erTime, tTime);
        }

        private void handleConstraint(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.tempConstraints == null) {
                this.tempConstraints = new LinkedHashMap<String, EventRange>();
            }
            String constraintName = this.getAttribute(element, "name");
            this.tempConstraints.put(constraintName, this.consumeEvents(reader, element));
        }

        private void handleWarning(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.tempWarnings == null) {
                this.tempWarnings = new ArrayList<Warning>();
            }
            Warning warning = new Warning();
            warning.setId(this.getAttribute(element, "id"));
            warning.setMessage(reader.getElementText());
            this.tempWarnings.add(warning);
        }

        private void handleReport(XMLEventReader reader, StartElement element) throws XMLStreamException {
            if (this.tempReports == null) {
                this.tempReports = new ArrayList<Report>();
            }
            Report report = new Report();
            report.setId(this.getAttribute(element, "id"));
            report.setName(this.getAttribute(element, "name"));
            report.setType(this.getAttribute(element, "type"));
            report.setMessage(reader.getElementText());
            this.tempReports.add(report);
        }

        private String getAttribute(StartElement element, String name) {
            Attribute att = element.getAttributeByName(new QName(name));
            return att != null ? att.getValue() : null;
        }

        private long parseTime(DatatypeFactory dtFactory, Calendar now, String time) {
            return dtFactory.newDurationDayTime(time).getTimeInMillis(now);
        }

        private EventRange consumeEvents(XMLEventReader reader, StartElement element) throws XMLStreamException {
            int first = this.tempEvents.size();
            this.tempEvents.add(element);
            QName startName = element.getName();
            block3: while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                this.tempEvents.add(event);
                int eventType = event.getEventType();
                switch (eventType) {
                    case 2: {
                        if (startName.equals(event.asEndElement().getName())) break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            return new EventRange(first, this.tempEvents.size());
        }
    }

    static class EventIterator<T extends XMLReadHandle>
    implements Iterator<T> {
        private List<XMLEvent> eventList;
        private List<EventRange> rangeList;
        private T handle;
        private int nextEvent = 0;
        final /* synthetic */ SearchHandle this$0;

        EventIterator(List<XMLEvent> eventList, List<EventRange> rangeList, T handle) {
            this.this$0 = this$0;
            this.eventList = eventList;
            this.rangeList = rangeList;
            this.handle = handle;
        }

        @Override
        public boolean hasNext() {
            return this.rangeList != null && this.nextEvent < this.rangeList.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                return null;
            }
            EventRange eventRange = this.rangeList.get(this.nextEvent++);
            return (T)((XMLReadHandle)Utilities.exportToHandle(this.this$0.getSlice(this.eventList, eventRange), this.handle));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }

    public static class Report {
        private String id = null;
        private String name = null;
        private String type = null;
        private String text = null;

        protected Report() {
        }

        public String getId() {
            return this.id;
        }

        protected void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        protected void setType(String type) {
            this.type = type;
        }

        public String getMessage() {
            return this.text;
        }

        protected void setMessage(String msg) {
            this.text = msg;
        }
    }

    public static class Warning {
        private String id = null;
        private String text = null;

        protected Warning() {
        }

        public String getId() {
            return this.id;
        }

        protected void setId(String id) {
            this.id = id;
        }

        public String getMessage() {
            return this.text;
        }

        protected void setMessage(String msg) {
            this.text = msg;
        }
    }

    private static class FacetHeatmapValueImpl
    implements FacetHeatmapValue {
        private String name = null;
        private long count = 0L;
        private String label = null;
        private double[] box = new double[4];

        public FacetHeatmapValueImpl(String name, long count, double s, double w, double n, double e) {
            this.box[0] = s;
            this.box[1] = w;
            this.box[2] = n;
            this.box[3] = e;
            this.name = "[" + this.box[0] + ", " + this.box[1] + ", " + this.box[2] + ", " + this.box[3] + "]";
            this.count = count;
            this.label = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public double[] getBox() {
            return this.box;
        }
    }

    private static class FacetValueImpl
    implements FacetValue {
        private String name = null;
        private long count = 0L;
        private String label = null;

        public FacetValueImpl(String name, long count) {
            this.name = name;
            this.count = count;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }

    private static class FacetResultImpl
    implements FacetResult {
        private String name = null;
        private FacetValue[] values = null;

        public FacetResultImpl(String name, FacetValue[] values) {
            this.name = name;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public FacetValue[] getFacetValues() {
            return this.values;
        }
    }

    private static class MatchSnippetImpl
    implements MatchSnippet {
        private boolean high = false;
        private String text = null;

        public MatchSnippetImpl(boolean high, String text) {
            this.high = high;
            this.text = text;
        }

        @Override
        public boolean isHighlighted() {
            return this.high;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class MatchLocationImpl
    implements MatchLocation {
        private String path = null;
        private List<MatchSnippet> matchEvents = new ArrayList<MatchSnippet>();

        public MatchLocationImpl(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getAllSnippetText() {
            if (this.matchEvents == null) {
                return null;
            }
            StringBuilder text = new StringBuilder();
            for (MatchSnippet snippet : this.matchEvents) {
                text.append(snippet.getText());
            }
            return text.toString();
        }

        @Override
        public MatchSnippet[] getSnippets() {
            if (this.matchEvents == null) {
                return new MatchSnippet[0];
            }
            return this.matchEvents.toArray(new MatchSnippet[this.matchEvents.size()]);
        }

        public void addMatchSnippet(MatchSnippet s) {
            this.matchEvents.add(s);
        }
    }

    private class MatchDocumentSummaryImpl
    implements MatchDocumentSummary {
        private String uri = null;
        private int score = -1;
        private double conf = -1.0;
        private double fit = -1.0;
        private String path = null;
        private List<MatchLocation> locations = new ArrayList<MatchLocation>();
        private String mimeType = null;
        private Format format = null;
        private List<EventRange> snippetEvents;
        private EventRange extractedEvents;
        private EventRange metadataEvents;
        private EventRange relevanceEvents;
        private List<String> similarUris;
        private String extractSelected;

        public MatchDocumentSummaryImpl(String uri, int score, double confidence, double fitness, String path, String mimeType, Format format, String extractSelected) {
            this.uri = uri;
            this.score = score;
            this.conf = confidence;
            this.fit = fitness;
            this.path = path;
            this.mimeType = mimeType;
            this.format = format;
            this.extractSelected = extractSelected;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        @Override
        public int getScore() {
            return this.score;
        }

        @Override
        public double getConfidence() {
            return this.conf;
        }

        @Override
        public double getFitness() {
            return this.fit;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public ExtractedResult getExtracted() {
            ExtractedResultImpl result = new ExtractedResultImpl();
            this.populateExtractedResult(result, SearchHandle.this.events, this.extractedEvents);
            return result;
        }

        private void populateExtractedResult(ExtractedResultImpl result, List<XMLEvent> events, EventRange extractedEvents) {
            int start = extractedEvents.first;
            int end = extractedEvents.next;
            StartElement element = events.get(start).asStartElement();
            QName elementName = element.getName();
            if ("extracted-none".equals(elementName.getLocalPart())) {
                result.isEmpty = true;
            } else {
                Iterator<Attribute> attributes = element.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attr = attributes.next();
                    String attrName = attr.getName().getLocalPart();
                    if (!"kind".equals(attrName)) continue;
                    result.kind = attr.getValue();
                }
                int startChildren = start + 1;
                int endChildren = end - 1;
                EventRange extractedItemEvents = new EventRange(startChildren, endChildren);
                if (Format.XML == this.getFormat()) {
                    result.setItems(this.populateExtractedItems(SearchHandle.this.getSlice(events, extractedItemEvents)));
                } else if (Format.JSON == this.getFormat() && "include".equals(this.extractSelected)) {
                    XMLEvent event = events.get(startChildren);
                    if (4 != event.getEventType()) {
                        throw new MarkLogicIOException("Cannot parse JSON for " + this.getPath() + "--content should be characters");
                    }
                    String json = event.asCharacters().getData();
                    try {
                        JsonNode jsonArray = new ObjectMapper().readTree(json);
                        ArrayList<String> items = new ArrayList<String>(jsonArray.size());
                        for (JsonNode item : jsonArray) {
                            items.add(item.toString());
                        }
                        result.setItems(items);
                    }
                    catch (Throwable e) {
                        throw new MarkLogicIOException("Cannot parse JSON '" + json + "' for " + this.getPath(), e);
                    }
                } else {
                    XMLEvent event = events.get(startChildren);
                    if (4 != event.getEventType()) {
                        throw new MarkLogicIOException("Cannot read " + this.getPath() + "--content should be characters");
                    }
                    String text = event.asCharacters().getData();
                    ArrayList<String> items = new ArrayList<String>(1);
                    items.add(event.asCharacters().getData());
                    result.setItems(items);
                }
            }
        }

        private List<String> populateExtractedItems(List<XMLEvent> events) {
            ArrayList<String> items = new ArrayList<String>();
            ArrayList<XMLEvent> itemEvents = new ArrayList<XMLEvent>();
            ArrayList<QName> startNames = new ArrayList<QName>();
            for (XMLEvent event : events) {
                itemEvents.add(event);
                switch (event.getEventType()) {
                    case 1: {
                        startNames.add(event.asStartElement().getName());
                        break;
                    }
                    case 2: {
                        QName startName = (QName)startNames.remove(startNames.size() - 1);
                        if (startNames.size() != 0) break;
                        if (startName.equals(event.asEndElement().getName())) {
                            items.add(Utilities.eventsToString(itemEvents));
                            itemEvents = new ArrayList();
                            break;
                        }
                        throw new IllegalStateException("Error parsing xml \"" + Utilities.eventsToString(itemEvents) + "\", element " + startName + " doesn't end as expected");
                    }
                }
            }
            return items;
        }

        @Override
        public <T> T getFirstSnippetAs(Class<T> as) {
            ContentHandle<T> handle = SearchHandle.this.getHandleRegistry().makeHandle(as);
            if (!XMLReadHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("cannot read snippet from XML with " + handle.getClass());
            }
            if (null == this.getFirstSnippet((XMLReadHandle)((Object)handle))) {
                return null;
            }
            return handle.get();
        }

        @Override
        public <T extends XMLReadHandle> T getFirstSnippet(T handle) {
            if (this.snippetEvents == null || this.snippetEvents.size() < 1) {
                return null;
            }
            return Utilities.exportToHandle(SearchHandle.this.getSlice(SearchHandle.this.events, this.snippetEvents.get(0)), handle);
        }

        @Override
        public String getFirstSnippetText() {
            if (this.snippetEvents == null || this.snippetEvents.size() < 1) {
                return null;
            }
            return Utilities.eventTextToString(SearchHandle.this.getSlice(SearchHandle.this.events, this.snippetEvents.get(0)));
        }

        @Override
        public Document[] getSnippets() {
            return SearchHandle.this.getEventDocuments(SearchHandle.this.events, this.snippetEvents);
        }

        @Override
        public <T extends XMLReadHandle> Iterator<T> getSnippetIterator(T handle) {
            if (this.snippetEvents == null || this.snippetEvents.size() < 1) {
                List list = Collections.emptyList();
                return list.iterator();
            }
            return new EventIterator(SearchHandle.this, SearchHandle.this.events, this.snippetEvents, handle);
        }

        @Override
        public MatchLocation[] getMatchLocations() {
            if (this.locations == null) {
                return new MatchLocation[0];
            }
            return this.locations.toArray(new MatchLocation[this.locations.size()]);
        }

        @Override
        public Document getMetadata() {
            DOMHandle handle = this.getMetadata(new DOMHandle());
            return handle == null ? null : handle.get();
        }

        @Override
        public <T> T getMetadataAs(Class<T> as) {
            ContentHandle<T> handle = SearchHandle.this.getHandleRegistry().makeHandle(as);
            if (!XMLReadHandle.class.isAssignableFrom(handle.getClass())) {
                throw new IllegalArgumentException("cannot read metadata from XML with " + handle.getClass());
            }
            this.getMetadata((XMLReadHandle)((Object)handle));
            return handle.get();
        }

        @Override
        public <T extends XMLReadHandle> T getMetadata(T handle) {
            return Utilities.exportToHandle(SearchHandle.this.getSlice(SearchHandle.this.events, this.metadataEvents), handle);
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        public void addLocation(MatchLocation loc) {
            this.locations.add(loc);
        }

        @Override
        public String[] getSimilarDocumentUris() {
            if (this.similarUris == null || this.similarUris.size() < 1) {
                return new String[0];
            }
            return this.similarUris.toArray(new String[this.similarUris.size()]);
        }

        @Override
        public Document getRelevanceInfo() {
            DOMHandle handle = this.getRelevanceInfo(new DOMHandle());
            return handle == null ? null : handle.get();
        }

        @Override
        public <T extends XMLReadHandle> T getRelevanceInfo(T handle) {
            return Utilities.exportToHandle(SearchHandle.this.getSlice(SearchHandle.this.events, this.relevanceEvents), handle);
        }
    }

    private static class EventRange {
        private int first = -1;
        private int next = -1;

        private EventRange(int first, int next) {
            this.first = first;
            this.next = next;
        }

        int getFirst() {
            return this.first;
        }

        int getNext() {
            return this.next;
        }
    }

    private static class SearchMetricsImpl
    implements SearchMetrics {
        long qrTime = -1L;
        long frTime = -1L;
        long srTime = -1L;
        long mrTime = -1L;
        long erTime = -1L;
        long totalTime = -1L;

        public SearchMetricsImpl(long qrTime, long frTime, long srTime, long mrTime, long erTime, long totalTime) {
            this.qrTime = qrTime;
            this.frTime = frTime;
            this.srTime = srTime;
            this.mrTime = mrTime;
            this.erTime = erTime;
            this.totalTime = totalTime;
        }

        @Override
        public long getQueryResolutionTime() {
            return this.qrTime;
        }

        @Override
        public long getFacetResolutionTime() {
            return this.frTime;
        }

        @Override
        public long getSnippetResolutionTime() {
            return this.srTime;
        }

        @Override
        public long getMetadataResolutionTime() {
            return this.mrTime;
        }

        @Override
        public long getExtractResolutionTime() {
            return this.erTime;
        }

        @Override
        public long getTotalTime() {
            return this.totalTime;
        }
    }
}

