/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<Source>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SourceHandle.class);
    private Transformer transformer;
    private Source content;
    private InputStream underlyingStream;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Source.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Source.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                SourceHandle handle = this.isHandled(type) ? new SourceHandle() : null;
                return handle;
            }
        };
    }

    public SourceHandle() {
        super.setFormat(Format.XML);
        this.setResendable(false);
    }

    public SourceHandle(Source content) {
        this();
        this.set(content);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public SourceHandle withTransformer(Transformer transformer) {
        this.setTransformer(transformer);
        return this;
    }

    @Override
    public Source get() {
        return this.content;
    }

    @Override
    public void set(Source content) {
        this.content = content;
    }

    public SourceHandle with(Source content) {
        this.set(content);
        return this;
    }

    public void transform(Result result) {
        if (logger.isInfoEnabled()) {
            logger.info("Transforming source into result");
        }
        try {
            if (this.content == null) {
                throw new IllegalStateException("No source to transform");
            }
            Transformer transformer = null;
            if (this.transformer != null) {
                transformer = this.getTransformer();
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("No transformer, so using identity transform");
                }
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            transformer.transform(this.content, result);
        }
        catch (TransformerException e) {
            logger.error("Failed to transform source into result", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("SourceHandle supports the XML format only");
        }
    }

    public SourceHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        try {
            return new String(this.toBuffer(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            if (content == null) {
                this.content = null;
                return;
            }
            this.underlyingStream = content;
            this.content = new StreamSource(new InputStreamReader(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No source to transform to result for writing");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.transform(new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    @Override
    public void close() {
        if (this.underlyingStream != null) {
            try {
                this.underlyingStream.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

