/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

class DocDescriptorUtil {
    DocDescriptorUtil() {
    }

    public static ArrayNode buildDocDescriptors(DocumentWriteSet writeSet) {
        return DocDescriptorUtil.buildDocDescriptors(writeSet, null);
    }

    public static ArrayNode buildDocDescriptors(DocumentWriteSet writeSet, Map<String, AbstractWriteHandle> attachments) {
        ArrayNode docDescriptors = new ObjectMapper().createArrayNode();
        writeSet.stream().forEach(writeOp -> DocDescriptorUtil.populateDocDescriptor(writeOp, docDescriptors.addObject(), attachments));
        return docDescriptors;
    }

    public static void populateDocDescriptor(DocumentWriteOperation writeOp, ObjectNode docDescriptor) {
        DocDescriptorUtil.populateDocDescriptor(writeOp, docDescriptor, null);
    }

    public static void populateDocDescriptor(DocumentWriteOperation writeOp, ObjectNode docDescriptor, Map<String, AbstractWriteHandle> attachments) {
        AbstractWriteHandle content;
        String uri = writeOp.getUri();
        docDescriptor.put("uri", uri);
        if (StringUtils.isNotBlank((CharSequence)writeOp.getTemporalDocumentURI())) {
            docDescriptor.put("temporalCollection", writeOp.getTemporalDocumentURI());
        }
        if ((content = writeOp.getContent()) != null) {
            JsonNode jsonContent = DocDescriptorUtil.getJsonNodeFromContent(content);
            if (jsonContent != null) {
                docDescriptor.set("doc", jsonContent);
            } else if (attachments != null) {
                docDescriptor.put("doc", "attachment-" + uri);
                attachments.put("attachment-" + uri, content);
            } else {
                throw new IllegalArgumentException("Only JSON content can be used with fromDocDescriptors; non-JSON content found for document with URI: " + uri);
            }
        }
        if (writeOp.getMetadata() instanceof DocumentMetadataHandle) {
            DocDescriptorUtil.populateMetadata((DocumentMetadataHandle)writeOp.getMetadata(), docDescriptor);
        } else if (writeOp.getMetadata() != null) {
            LoggerFactory.getLogger(DocDescriptorUtil.class).warn("Can only add metadata to a doc descriptor when the class is an instance of DocumentMetadataHandle; document URI: " + uri);
        }
    }

    private static void populateMetadata(DocumentMetadataHandle metadata, ObjectNode docDescriptor) {
        docDescriptor.put("quality", metadata.getQuality());
        if (!metadata.getCollections().isEmpty()) {
            ArrayNode collections = docDescriptor.putArray("collections");
            metadata.getCollections().forEach(c -> collections.add(c));
        }
        if (!metadata.getPermissions().isEmpty()) {
            ArrayNode permissions = docDescriptor.putArray("permissions");
            for (String roleName : metadata.getPermissions().keySet()) {
                for (DocumentMetadataHandle.Capability c2 : (Set)metadata.getPermissions().get(roleName)) {
                    permissions.addObject().put("roleName", roleName).put("capability", c2.toString().toLowerCase());
                }
            }
        }
        if (!metadata.getMetadataValues().isEmpty()) {
            ObjectNode values = docDescriptor.putObject("metadata");
            for (String key : metadata.getMetadataValues().keySet()) {
                values.put(key, (String)metadata.getMetadataValues().get(key));
            }
        }
    }

    private static JsonNode getJsonNodeFromContent(AbstractWriteHandle content) {
        BaseHandle h;
        if (content instanceof JacksonHandle) {
            return ((JacksonHandle)content).get();
        }
        if (content instanceof BaseHandle && Format.JSON.equals((Object)(h = (BaseHandle)((Object)content)).getFormat())) {
            String json = HandleAccessor.contentAsString(content);
            try {
                return new ObjectMapper().readTree(json);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to read content as JSON; cause: " + e.getMessage(), e);
            }
        }
        return null;
    }
}

