/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.SocketFactory;

class SocketFactoryDelegator
extends SocketFactory {
    private final SocketFactory delegate;

    SocketFactoryDelegator(SocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.configureSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.delegate.createSocket(host, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.configureSocket(this.delegate.createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.delegate.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.configureSocket(this.delegate.createSocket());
    }

    private Socket configureSocket(Socket socket) throws SocketException {
        socket.setKeepAlive(true);
        return socket;
    }
}

