/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.OkHttpUtil;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkLogicCloudAuthenticationConfigurer
implements AuthenticationConfigurer<DatabaseClientFactory.MarkLogicCloudAuthContext> {
    private static final Logger logger = LoggerFactory.getLogger(MarkLogicCloudAuthenticationConfigurer.class);
    private String host;

    public MarkLogicCloudAuthenticationConfigurer(String host) {
        this.host = host;
    }

    @Override
    public void configureAuthentication(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.MarkLogicCloudAuthContext securityContext) {
        String apiKey = securityContext.getApiKey();
        if (apiKey == null || apiKey.trim().length() < 1) {
            throw new IllegalArgumentException("No API key provided");
        }
        Response response = this.callTokenEndpoint(securityContext);
        String accessToken = this.getAccessTokenFromResponse(response);
        if (logger.isInfoEnabled()) {
            logger.info("Successfully obtained authentication token");
        }
        clientBuilder.addInterceptor(chain -> {
            Request authenticatedRequest = chain.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
            return chain.proceed(authenticatedRequest);
        });
    }

    private Response callTokenEndpoint(DatabaseClientFactory.MarkLogicCloudAuthContext securityContext) {
        HttpUrl tokenUrl = this.buildTokenUrl(securityContext);
        OkHttpClient.Builder clientBuilder = OkHttpUtil.newClientBuilder();
        OkHttpUtil.configureSocketFactory(clientBuilder, securityContext.getSSLContext(), securityContext.getTrustManager());
        OkHttpUtil.configureHostnameVerifier(clientBuilder, securityContext.getSSLHostnameVerifier());
        if (logger.isInfoEnabled()) {
            logger.info("Calling token endpoint at: " + tokenUrl);
        }
        Call call = clientBuilder.build().newCall(new Request.Builder().url(tokenUrl).post((RequestBody)this.newFormBody(securityContext)).build());
        try {
            return call.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to call token endpoint at %s; cause: %s", tokenUrl, e.getMessage(), e));
        }
    }

    protected HttpUrl buildTokenUrl(DatabaseClientFactory.MarkLogicCloudAuthContext securityContext) {
        return new HttpUrl.Builder().scheme("https").host(this.host).port(443).build().resolve(securityContext.getTokenEndpoint()).newBuilder().build();
    }

    protected FormBody newFormBody(DatabaseClientFactory.MarkLogicCloudAuthContext securityContext) {
        return new FormBody.Builder().add("grant_type", securityContext.getGrantType()).add("key", securityContext.getApiKey()).build();
    }

    private String getAccessTokenFromResponse(Response response) {
        JsonNode payload;
        String responseBody = null;
        try {
            responseBody = response.body().string();
            payload = new ObjectMapper().readTree(responseBody);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to get access token; response: " + responseBody, ex);
        }
        if (!payload.has("access_token")) {
            throw new RuntimeException("Unable to get access token; unexpected JSON response: " + payload);
        }
        return payload.get("access_token").asText();
    }
}

