/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXBHandle<C>
extends BaseHandle<InputStream, OutputStreamSender>
implements ResendableContentHandle<C, InputStream>,
OutputStreamSender,
XMLReadHandle,
XMLWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(JAXBHandle.class);
    private final JAXBContext context;
    private final Class<C> contentClass;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private C content;

    public static ContentHandleFactory newFactory(Class<?> ... pojoClasses) throws JAXBException {
        if (pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JAXBHandleFactory((Class[])pojoClasses);
    }

    public static ContentHandleFactory newFactory(JAXBContext context, Class<?> ... pojoClasses) {
        if (context == null || pojoClasses == null || pojoClasses.length == 0) {
            return null;
        }
        return new JAXBHandleFactory(context, (Class[])pojoClasses);
    }

    public JAXBHandle(JAXBContext context) {
        this(context, null);
    }

    public JAXBHandle(JAXBContext context, Class<C> contentClass) {
        this.setResendable(true);
        if (context == null) {
            throw new IllegalArgumentException("null JAXB context for converting classes");
        }
        super.setFormat(Format.XML);
        this.context = context;
        this.contentClass = contentClass;
    }

    @Override
    public C get() {
        return this.content;
    }

    public <T> T get(Class<T> as) {
        if (this.content == null) {
            return null;
        }
        if (as == null) {
            throw new IllegalArgumentException("Cannot cast content to null class");
        }
        if (!as.isAssignableFrom(this.content.getClass())) {
            throw new IllegalArgumentException("Cannot cast " + this.content.getClass().getName() + " to " + as.getName());
        }
        C content = this.get();
        return (T)content;
    }

    @Override
    public void set(C content) {
        this.content = content;
    }

    public JAXBHandle<C> with(C content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<C> getContentClass() {
        if (this.contentClass != null) {
            return this.contentClass;
        }
        if (this.content != null) {
            return this.content.getClass();
        }
        return null;
    }

    @Override
    public JAXBHandle<C> newHandle() {
        return new JAXBHandle<C>(this.context, this.getContentClass()).withMimetype(this.getMimetype());
    }

    public JAXBHandle<C>[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JAXBHandle[length];
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("JAXBHandle supports the XML format only");
        }
    }

    public JAXBHandle<C> withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public C bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : (C)this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(C content) {
        try {
            if (content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public C toContent(InputStream serialization) {
        Object object;
        if (serialization == null) {
            return null;
        }
        try {
            Object unmarshalled;
            object = unmarshalled = this.getUnmarshaller().unmarshal((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8));
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall object read from database document", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
        return (C)object;
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        return this.getUnmarshaller(true);
    }

    public Unmarshaller getUnmarshaller(boolean reuse) throws JAXBException {
        if (!reuse || this.unmarshaller == null) {
            this.unmarshaller = this.context.createUnmarshaller();
        }
        return this.unmarshaller;
    }

    public Marshaller getMarshaller() throws JAXBException {
        return this.getMarshaller(true);
    }

    public Marshaller getMarshaller(boolean reuse) throws JAXBException {
        if (!reuse || this.marshaller == null) {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller = marshaller;
        }
        return this.marshaller;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream serialization) {
        this.set(this.toContent(serialization));
    }

    @Override
    protected OutputStreamSender sendContent() {
        try {
            return new OutputStreamSenderImpl(this.getMarshaller(), this.get());
        }
        catch (JAXBException e) {
            logger.error("Failed to construct marshaller for output stream sender", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class JAXBHandleFactory
    implements ContentHandleFactory {
        private final Class<?>[] pojoClasses;
        private final JAXBContext factoryContext;
        private final Set<Class<?>> classSet;

        private JAXBHandleFactory(Class<?> ... pojoClasses) throws JAXBException {
            this(JAXBContext.newInstance((Class[])pojoClasses), pojoClasses);
        }

        private JAXBHandleFactory(JAXBContext factoryContext, Class<?> ... pojoClasses) {
            this.pojoClasses = pojoClasses;
            this.factoryContext = factoryContext;
            this.classSet = new HashSet(Arrays.asList(pojoClasses));
        }

        @Override
        public Class<?>[] getHandledClasses() {
            return this.pojoClasses;
        }

        @Override
        public boolean isHandled(Class<?> type) {
            return this.classSet.contains(type);
        }

        @Override
        public <C> ContentHandle<C> newHandle(Class<C> type) {
            return this.isHandled(type) ? new JAXBHandle<C>(this.factoryContext, type) : null;
        }
    }

    private static class OutputStreamSenderImpl<C>
    implements OutputStreamSender {
        private final Marshaller marshaller;
        private final C content;

        private OutputStreamSenderImpl(Marshaller marshaller, C content) {
            if (content == null) {
                throw new IllegalStateException("No object to write");
            }
            this.marshaller = marshaller;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            try {
                this.marshaller.marshal(this.content, out);
            }
            catch (JAXBException e) {
                logger.error("Failed to marshall object for writing to database document", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

