/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.DatabaseClientPropertySource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class DatabaseClientBuilder {
    public static final String PREFIX = "marklogic.client.";
    public static final String AUTH_TYPE_BASIC = "basic";
    public static final String AUTH_TYPE_DIGEST = "digest";
    public static final String AUTH_TYPE_MARKLOGIC_CLOUD = "cloud";
    public static final String AUTH_TYPE_KERBEROS = "kerberos";
    public static final String AUTH_TYPE_CERTIFICATE = "certificate";
    public static final String AUTH_TYPE_SAML = "saml";
    private final Map<String, Object> props = new HashMap<String, Object>();

    public DatabaseClientBuilder() {
    }

    public DatabaseClientBuilder(Map<String, Object> props) {
        this();
        this.props.putAll(props);
    }

    public DatabaseClient build() {
        return DatabaseClientFactory.newClient(this.getPropertySource());
    }

    public DatabaseClientFactory.Bean buildBean() {
        return new DatabaseClientPropertySource(this.getPropertySource()).newClientBean();
    }

    private Function<String, Object> getPropertySource() {
        return propertyName -> this.props.get(propertyName);
    }

    public DatabaseClientBuilder withHost(String host) {
        this.props.put("marklogic.client.host", host);
        return this;
    }

    public DatabaseClientBuilder withPort(int port) {
        this.props.put("marklogic.client.port", port);
        return this;
    }

    public DatabaseClientBuilder withBasePath(String basePath) {
        this.props.put("marklogic.client.basePath", basePath);
        return this;
    }

    public DatabaseClientBuilder withDatabase(String database) {
        this.props.put("marklogic.client.database", database);
        return this;
    }

    public DatabaseClientBuilder withUsername(String username) {
        this.props.put("marklogic.client.username", username);
        return this;
    }

    public DatabaseClientBuilder withPassword(String password) {
        this.props.put("marklogic.client.password", password);
        return this;
    }

    public DatabaseClientBuilder withSecurityContext(DatabaseClientFactory.SecurityContext securityContext) {
        this.props.put("marklogic.client.securityContext", securityContext);
        return this;
    }

    public DatabaseClientBuilder withAuthType(String type) {
        this.props.put("marklogic.client.authType", type);
        return this;
    }

    public DatabaseClientBuilder withBasicAuth(String username, String password) {
        return this.withAuthType(AUTH_TYPE_BASIC).withUsername(username).withPassword(password);
    }

    public DatabaseClientBuilder withDigestAuth(String username, String password) {
        return this.withAuthType(AUTH_TYPE_DIGEST).withUsername(username).withPassword(password);
    }

    public DatabaseClientBuilder withCloudAuth(String apiKey, String basePath) {
        return this.withAuthType(AUTH_TYPE_MARKLOGIC_CLOUD).withCloudApiKey(apiKey).withBasePath(basePath);
    }

    public DatabaseClientBuilder withKerberosAuth(String principal) {
        return this.withAuthType(AUTH_TYPE_KERBEROS).withKerberosPrincipal(principal);
    }

    public DatabaseClientBuilder withCertificateAuth(String file, String password) {
        return this.withAuthType(AUTH_TYPE_CERTIFICATE).withCertificateFile(file).withCertificatePassword(password);
    }

    public DatabaseClientBuilder withCertificateAuth(SSLContext sslContext, X509TrustManager trustManager) {
        return this.withAuthType(AUTH_TYPE_CERTIFICATE).withSSLContext(sslContext).withTrustManager(trustManager);
    }

    public DatabaseClientBuilder withSAMLAuth(String token) {
        return this.withAuthType(AUTH_TYPE_SAML).withSAMLToken(token);
    }

    public DatabaseClientBuilder withConnectionType(DatabaseClient.ConnectionType type) {
        this.props.put("marklogic.client.connectionType", (Object)type);
        return this;
    }

    public DatabaseClientBuilder withCloudApiKey(String cloudApiKey) {
        this.props.put("marklogic.client.cloud.apiKey", cloudApiKey);
        return this;
    }

    public DatabaseClientBuilder withCertificateFile(String file) {
        this.props.put("marklogic.client.certificate.file", file);
        return this;
    }

    public DatabaseClientBuilder withCertificatePassword(String password) {
        this.props.put("marklogic.client.certificate.password", password);
        return this;
    }

    public DatabaseClientBuilder withKerberosPrincipal(String principal) {
        this.props.put("marklogic.client.kerberos.principal", principal);
        return this;
    }

    public DatabaseClientBuilder withSAMLToken(String token) {
        this.props.put("marklogic.client.saml.token", token);
        return this;
    }

    public DatabaseClientBuilder withSSLContext(SSLContext sslContext) {
        this.props.put("marklogic.client.sslContext", sslContext);
        return this;
    }

    public DatabaseClientBuilder withSSLProtocol(String sslProtocol) {
        this.props.put("marklogic.client.sslProtocol", sslProtocol);
        return this;
    }

    public DatabaseClientBuilder withTrustManager(X509TrustManager trustManager) {
        this.props.put("marklogic.client.trustManager", trustManager);
        return this;
    }

    public DatabaseClientBuilder withSSLHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier) {
        this.props.put("marklogic.client.sslHostnameVerifier", sslHostnameVerifier);
        return this;
    }
}

