/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.SSLUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClientPropertySource {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseClientPropertySource.class);
    private static final String PREFIX = "marklogic.client.";
    private final Function<String, Object> propertySource;
    private static Map<String, BiConsumer<DatabaseClientFactory.Bean, Object>> connectionPropertyHandlers = new LinkedHashMap<String, BiConsumer<DatabaseClientFactory.Bean, Object>>();

    public DatabaseClientPropertySource(Function<String, Object> propertySource) {
        this.propertySource = propertySource;
    }

    public DatabaseClient newClient() {
        DatabaseClientFactory.Bean bean = this.newClientBean();
        return DatabaseClientFactory.newClient(bean.getHost(), bean.getPort(), bean.getBasePath(), bean.getDatabase(), bean.getSecurityContext(), bean.getConnectionType());
    }

    public DatabaseClientFactory.Bean newClientBean() {
        DatabaseClientFactory.Bean bean = new DatabaseClientFactory.Bean();
        connectionPropertyHandlers.forEach((propName, consumer) -> {
            Object propValue = this.propertySource.apply((String)propName);
            if (propValue != null) {
                consumer.accept(bean, propValue);
            }
        });
        bean.setSecurityContext(this.newSecurityContext());
        return bean;
    }

    private DatabaseClientFactory.SecurityContext newSecurityContext() {
        SSLContext sslContext;
        Object securityContextValue = this.propertySource.apply("marklogic.client.securityContext");
        if (securityContextValue != null) {
            if (securityContextValue instanceof DatabaseClientFactory.SecurityContext) {
                return (DatabaseClientFactory.SecurityContext)securityContextValue;
            }
            throw new IllegalArgumentException("Security context must be of type " + DatabaseClientFactory.SecurityContext.class.getName());
        }
        Object typeValue = this.propertySource.apply("marklogic.client.authType");
        if (typeValue == null || !(typeValue instanceof String)) {
            throw new IllegalArgumentException("Security context should be set, or auth type must be of type String");
        }
        String authType = (String)typeValue;
        SSLInputs sslInputs = this.buildSSLInputs(authType);
        DatabaseClientFactory.SecurityContext securityContext = this.newSecurityContext(authType, sslInputs);
        X509TrustManager trustManager = this.determineTrustManager(sslInputs);
        SSLContext sSLContext = sslContext = sslInputs.getSslContext() != null ? sslInputs.getSslContext() : this.determineSSLContext(sslInputs, trustManager);
        if (sslContext != null) {
            securityContext.withSSLContext(sslContext, trustManager);
        }
        securityContext.withSSLHostnameVerifier(this.determineHostnameVerifier());
        return securityContext;
    }

    private DatabaseClientFactory.SecurityContext newSecurityContext(String type, SSLInputs sslInputs) {
        switch (type.toLowerCase()) {
            case "basic": {
                return this.newBasicAuthContext();
            }
            case "digest": {
                return this.newDigestAuthContext();
            }
            case "cloud": {
                return this.newCloudAuthContext();
            }
            case "kerberos": {
                return this.newKerberosAuthContext();
            }
            case "certificate": {
                return this.newCertificateAuthContext(sslInputs);
            }
            case "saml": {
                return this.newSAMLAuthContext();
            }
        }
        throw new IllegalArgumentException("Unrecognized auth type: " + type);
    }

    private String getRequiredStringValue(String propertyName) {
        Object value = this.propertySource.apply(PREFIX + propertyName);
        if (value == null || !(value instanceof String)) {
            throw new IllegalArgumentException(propertyName + " must be of type String");
        }
        return (String)value;
    }

    private String getNullableStringValue(String propertyName) {
        Object value = this.propertySource.apply(PREFIX + propertyName);
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException(propertyName + " must be of type String");
        }
        return (String)value;
    }

    private DatabaseClientFactory.SecurityContext newBasicAuthContext() {
        return new DatabaseClientFactory.BasicAuthContext(this.getRequiredStringValue("username"), this.getRequiredStringValue("password"));
    }

    private DatabaseClientFactory.SecurityContext newDigestAuthContext() {
        return new DatabaseClientFactory.DigestAuthContext(this.getRequiredStringValue("username"), this.getRequiredStringValue("password"));
    }

    private DatabaseClientFactory.SecurityContext newCloudAuthContext() {
        return new DatabaseClientFactory.MarkLogicCloudAuthContext(this.getRequiredStringValue("cloud.apiKey"));
    }

    private DatabaseClientFactory.SecurityContext newCertificateAuthContext(SSLInputs sslInputs) {
        String file = this.getNullableStringValue("certificate.file");
        String password = this.getNullableStringValue("certificate.password");
        if (file != null && file.trim().length() > 0) {
            try {
                if (password != null && password.trim().length() > 0) {
                    return new DatabaseClientFactory.CertificateAuthContext(file, password, sslInputs.getTrustManager());
                }
                return new DatabaseClientFactory.CertificateAuthContext(file, sslInputs.getTrustManager());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create CertificateAuthContext; cause " + e.getMessage(), e);
            }
        }
        return new DatabaseClientFactory.CertificateAuthContext(sslInputs.getSslContext(), sslInputs.getTrustManager());
    }

    private DatabaseClientFactory.SecurityContext newKerberosAuthContext() {
        return new DatabaseClientFactory.KerberosAuthContext(this.getRequiredStringValue("kerberos.principal"));
    }

    private DatabaseClientFactory.SecurityContext newSAMLAuthContext() {
        return new DatabaseClientFactory.SAMLAuthContext(this.getRequiredStringValue("saml.token"));
    }

    private SSLContext determineSSLContext(SSLInputs sslInputs, X509TrustManager trustManager) {
        String protocol = sslInputs.getSslProtocol();
        if (protocol != null) {
            SSLContext sslContext;
            if ("default".equalsIgnoreCase(protocol)) {
                try {
                    return SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Unable to obtain default SSLContext; cause: " + e.getMessage(), e);
                }
            }
            try {
                sslContext = SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Unable to get SSLContext instance with protocol: " + protocol + "; cause: " + e.getMessage(), e);
            }
            if (trustManager != null) {
                try {
                    sslContext.init(null, new X509TrustManager[]{trustManager}, null);
                }
                catch (KeyManagementException e) {
                    throw new RuntimeException("Unable to initialize SSLContext; protocol: " + protocol + "; cause: " + e.getMessage(), e);
                }
            }
            return sslContext;
        }
        return null;
    }

    private X509TrustManager determineTrustManager(SSLInputs sslInputs) {
        if (sslInputs.getTrustManager() != null) {
            return sslInputs.getTrustManager();
        }
        if ("default".equalsIgnoreCase(sslInputs.getSslProtocol())) {
            X509TrustManager defaultTrustManager = SSLUtil.getDefaultTrustManager();
            if (logger.isDebugEnabled() && defaultTrustManager != null && defaultTrustManager.getAcceptedIssuers() != null) {
                logger.debug("Count of accepted issuers in default trust manager: {}", (Object)defaultTrustManager.getAcceptedIssuers().length);
            }
            return defaultTrustManager;
        }
        return null;
    }

    private DatabaseClientFactory.SSLHostnameVerifier determineHostnameVerifier() {
        Object verifierObject = this.propertySource.apply("marklogic.client.sslHostnameVerifier");
        if (verifierObject instanceof DatabaseClientFactory.SSLHostnameVerifier) {
            return (DatabaseClientFactory.SSLHostnameVerifier)verifierObject;
        }
        if (verifierObject instanceof String) {
            String verifier = (String)verifierObject;
            if ("ANY".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            if ("COMMON".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.COMMON;
            }
            if ("STRICT".equalsIgnoreCase(verifier)) {
                return DatabaseClientFactory.SSLHostnameVerifier.STRICT;
            }
            throw new IllegalArgumentException(String.format("Unrecognized value for SSLHostnameVerifier: %s", verifier));
        }
        return null;
    }

    private SSLInputs buildSSLInputs(String authType) {
        SSLContext sslContext = null;
        Object val = this.propertySource.apply("marklogic.client.sslContext");
        if (val != null) {
            if (val instanceof SSLContext) {
                sslContext = (SSLContext)val;
            } else {
                throw new IllegalArgumentException("SSL context must be an instanceof " + SSLContext.class.getName());
            }
        }
        String sslProtocol = this.getNullableStringValue("sslProtocol");
        if (sslContext == null && (sslProtocol == null || sslProtocol.trim().length() == 0) && "cloud".equalsIgnoreCase(authType)) {
            sslProtocol = "default";
        }
        val = this.propertySource.apply("marklogic.client.trustManager");
        X509TrustManager trustManager = null;
        if (val != null) {
            if (val instanceof X509TrustManager) {
                trustManager = (X509TrustManager)val;
            } else {
                throw new IllegalArgumentException("Trust manager must be an instanceof " + X509TrustManager.class.getName());
            }
        }
        return new SSLInputs(sslContext, sslProtocol, trustManager);
    }

    static {
        connectionPropertyHandlers.put("marklogic.client.host", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Host must be of type String");
            }
            bean.setHost((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.port", (bean, value) -> {
            if (value instanceof String) {
                bean.setPort(Integer.parseInt((String)value));
            } else if (value instanceof Integer) {
                bean.setPort((Integer)value);
            } else {
                throw new IllegalArgumentException("Port must be of type String or Integer");
            }
        });
        connectionPropertyHandlers.put("marklogic.client.database", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Database must be of type String");
            }
            bean.setDatabase((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.basePath", (bean, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Base path must be of type String");
            }
            bean.setBasePath((String)value);
        });
        connectionPropertyHandlers.put("marklogic.client.connectionType", (bean, value) -> {
            if (value instanceof DatabaseClient.ConnectionType) {
                bean.setConnectionType((DatabaseClient.ConnectionType)((Object)((Object)value)));
            } else if (value instanceof String) {
                String val = (String)value;
                if (val.trim().length() > 0) {
                    bean.setConnectionType(DatabaseClient.ConnectionType.valueOf(val.toUpperCase()));
                }
            } else {
                throw new IllegalArgumentException("Connection type must either be a String or an instance of ConnectionType");
            }
        });
    }

    private static class SSLInputs {
        private final SSLContext sslContext;
        private final String sslProtocol;
        private final X509TrustManager trustManager;

        public SSLInputs(SSLContext sslContext, String sslProtocol, X509TrustManager trustManager) {
            this.sslContext = sslContext;
            this.sslProtocol = sslProtocol;
            this.trustManager = trustManager;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public String getSslProtocol() {
            return this.sslProtocol;
        }

        public X509TrustManager getTrustManager() {
            return this.trustManager;
        }
    }
}

