/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import java.util.List;
import javax.net.ssl.SSLContext;
import okhttp3.HttpUrl;

public class HttpUrlBuilder {
    public static HttpUrl newBaseUrl(String host, int port, String basePath, SSLContext sslContext) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(sslContext == null ? "http" : "https").host(host).port(port);
        if (basePath != null && basePath.trim().length() > 0) {
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            builder.addPathSegments(basePath);
        }
        builder.addPathSegment("v1");
        builder.addPathSegment("ping");
        return builder.build();
    }

    public static HttpUrl newDataServicesBaseUri(HttpUrl baseUrl) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseUrl.scheme()).host(baseUrl.host()).port(baseUrl.port());
        List segments = baseUrl.pathSegments();
        int segmentCount = segments.size();
        if (segmentCount > 2) {
            segments = segments.subList(0, segmentCount - 2);
            for (String segment : segments) {
                builder = builder.addPathSegment(segment);
            }
        }
        builder = builder.addPathSegment("");
        return builder.build();
    }
}

