/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.impl.ClientPropertiesImpl;
import com.marklogic.client.impl.DOMWriter;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.impl.ValueConverter;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.DocumentMetadataReadHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.util.NameMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMetadataHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
DocumentMetadataReadHandle,
DocumentMetadataWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(DOMHandle.class);
    private static final String REST_API_NS = "http://marklogic.com/rest-api";
    private static final String PROPERTY_API_NS = "http://marklogic.com/xdmp/property";
    private DocumentCollections collections;
    private DocumentPermissions permissions;
    private DocumentProperties properties;
    private int quality = 0;
    private DocumentMetadataValues metadataValues;
    private boolean qualityModified = false;

    public DocumentMetadataHandle() {
        super.setFormat(Format.XML);
        this.setResendable(true);
    }

    public DocumentCollections getCollections() {
        if (this.collections == null) {
            this.collections = new CollectionsImpl();
        }
        return this.collections;
    }

    public void setCollections(DocumentCollections collections) {
        this.collections = collections;
    }

    public DocumentMetadataHandle withCollections(String ... collections) {
        this.getCollections().addAll(collections);
        return this;
    }

    public DocumentPermissions getPermissions() {
        if (this.permissions == null) {
            this.permissions = new PermissionsImpl();
        }
        return this.permissions;
    }

    public void setPermissions(DocumentPermissions permissions) {
        this.permissions = permissions;
    }

    public DocumentMetadataHandle withPermission(String role, Capability ... capabilities) {
        this.getPermissions().add(role, capabilities);
        return this;
    }

    public DocumentProperties getProperties() {
        if (this.properties == null) {
            this.properties = new PropertiesImpl();
        }
        return this.properties;
    }

    public void setProperties(DocumentProperties properties) {
        this.properties = properties;
    }

    public DocumentMetadataHandle withProperty(QName name, Object value) {
        this.getProperties().put(name, value);
        return this;
    }

    public DocumentMetadataHandle withProperty(String name, Object value) {
        this.getProperties().put(name, value);
        return this;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
        this.qualityModified = true;
    }

    public DocumentMetadataHandle withQuality(int quality) {
        this.setQuality(quality);
        return this;
    }

    public DocumentMetadataValues getMetadataValues() {
        if (this.metadataValues == null) {
            this.metadataValues = new ValuesImpl();
        }
        return this.metadataValues;
    }

    public void setMetadataValues(DocumentMetadataValues metadataValues) {
        this.metadataValues = metadataValues;
    }

    public DocumentMetadataHandle withMetadataValue(String key, String value) {
        this.getMetadataValues().put(key, value);
        return this;
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("DocumentMetadataHandle supports the XML format only");
        }
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.receiveContent(null);
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Parsing metadata structure from input stream");
            }
            Document document = null;
            if (content != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(new InputSource(new InputStreamReader(content, StandardCharsets.UTF_8)));
                content.close();
            }
            this.receiveMetadataImpl(document);
        }
        catch (SAXException e) {
            logger.error("Failed to parse metadata structure from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (IOException e) {
            logger.error("Failed to parse metadata structure from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Failed to parse metadata structure from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendMetadataImpl(out);
    }

    private void receiveMetadataImpl(Document document) {
        this.receiveCollectionsImpl(document);
        this.receivePermissionsImpl(document);
        this.receivePropertiesImpl(document);
        this.receiveQualityImpl(document);
        this.receiveMetadataValuesImpl(document);
    }

    private void receiveMetadataValuesImpl(Document document) {
        DocumentMetadataValues metadataValues = this.getMetadataValues();
        metadataValues.clear();
        if (document == null) {
            return;
        }
        NodeList valuesIn = document.getElementsByTagNameNS(REST_API_NS, "metadata-values");
        int valuesInLength = valuesIn.getLength();
        for (int i = 0; i < valuesInLength; ++i) {
            String key = null;
            String value = null;
            NodeList children = valuesIn.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                if ("metadata-value".equals(element.getLocalName())) {
                    key = element.getAttribute("key");
                    value = element.getTextContent();
                } else if (logger.isWarnEnabled()) {
                    logger.warn("Skipping unknown value element", (Object)element.getTagName());
                }
                if (key == null || value == null) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Could not parse value");
                    continue;
                }
                metadataValues.put(key, value);
            }
        }
    }

    private void receiveCollectionsImpl(Document document) {
        DocumentCollections collections = this.getCollections();
        collections.clear();
        if (document == null) {
            return;
        }
        NodeList collectionsIn = document.getElementsByTagNameNS(REST_API_NS, "collection");
        int collectionsInLength = collectionsIn.getLength();
        for (int i = 0; i < collectionsInLength; ++i) {
            collections.add(collectionsIn.item(i).getTextContent());
        }
    }

    private void receivePermissionsImpl(Document document) {
        DocumentPermissions permissions = this.getPermissions();
        permissions.clear();
        if (document == null) {
            return;
        }
        NodeList permissionsIn = document.getElementsByTagNameNS(REST_API_NS, "permission");
        int permissionsInLength = permissionsIn.getLength();
        for (int i = 0; i < permissionsInLength; ++i) {
            String roleName = null;
            HashSet<Capability> caps = new HashSet<Capability>();
            NodeList children = permissionsIn.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                if ("role-name".equals(element.getLocalName())) {
                    roleName = element.getTextContent();
                    continue;
                }
                if ("capability".equals(element.getLocalName())) {
                    caps.add(Capability.getValueOf(element.getTextContent()));
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Skipping unknown permission element", (Object)element.getTagName());
            }
            if (roleName == null || caps.size() == 0) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Could not parse permission");
                continue;
            }
            permissions.put(roleName, caps);
        }
    }

    private void receivePropertiesImpl(Document document) {
        DocumentProperties properties = this.getProperties();
        properties.clear();
        if (document == null) {
            return;
        }
        Node propertyContainer = document.getElementsByTagNameNS(PROPERTY_API_NS, "properties").item(0);
        if (propertyContainer == null) {
            return;
        }
        NodeList propertiesIn = propertyContainer.getChildNodes();
        for (int i = 0; i < propertiesIn.getLength(); ++i) {
            String prefix;
            Node node = propertiesIn.item(i);
            if (node.getNodeType() != 1) continue;
            Element property = (Element)node;
            QName propertyName = null;
            String namespaceURI = property.getNamespaceURI();
            propertyName = namespaceURI != null ? ((prefix = property.getPrefix()) != null ? new QName(namespaceURI, property.getLocalName(), prefix) : new QName(namespaceURI, property.getTagName())) : new QName(property.getTagName());
            if (!property.hasChildNodes()) {
                properties.put(propertyName, (String)null);
                continue;
            }
            NodeList children = property.getChildNodes();
            boolean hasChildElements = false;
            int childCount = children.getLength();
            for (int j = 0; j < childCount; ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                hasChildElements = true;
                break;
            }
            if (hasChildElements) {
                properties.put(propertyName, children);
                continue;
            }
            String value = property.getTextContent();
            if (property.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
                String type = property.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                properties.put(propertyName, ValueConverter.convertToJava(type, value));
                continue;
            }
            properties.put(propertyName, value);
            properties.put(propertyName, value);
        }
    }

    private void receiveQualityImpl(Document document) {
        int qualityNum;
        block5: {
            if (document == null) {
                this.setQuality(0);
                return;
            }
            Node quality = document.getElementsByTagNameNS(REST_API_NS, "quality").item(0);
            if (quality == null) {
                this.setQuality(0);
                return;
            }
            String qualityText = quality.getTextContent();
            qualityNum = 0;
            try {
                qualityNum = Utilities.parseInt(qualityText);
                if (qualityNum < 0) {
                    qualityNum = 0;
                }
            }
            catch (NumberFormatException ex) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn("Could not parse quality integer from", (Object)qualityText);
            }
        }
        this.setQuality(qualityNum);
    }

    private void sendMetadataImpl(OutputStream out) {
        try {
            XMLOutputFactory factory = XmlFactories.getOutputFactory();
            XMLStreamWriter serializer = factory.createXMLStreamWriter(out, "UTF-8");
            serializer.writeStartDocument("utf-8", "1.0");
            serializer.writeStartElement("rapi", "metadata", REST_API_NS);
            serializer.writeNamespace("rapi", REST_API_NS);
            serializer.writeNamespace("prop", PROPERTY_API_NS);
            if (this.properties != null) {
                serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                serializer.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            }
            this.sendCollectionsImpl(serializer);
            this.sendPermissionsImpl(serializer);
            this.sendPropertiesImpl(serializer);
            this.sendQualityImpl(serializer);
            this.sendMetadataValuesImpl(serializer);
            serializer.writeEndElement();
            serializer.writeEndDocument();
            serializer.flush();
            serializer.close();
        }
        catch (Exception e) {
            throw new MarkLogicIOException("Failed to serialize metadata: cause: " + e.getMessage(), e);
        }
    }

    private void sendMetadataValuesImpl(XMLStreamWriter serializer) throws XMLStreamException {
        if (this.getMetadataValues() == null || this.getMetadataValues().size() == 0) {
            return;
        }
        serializer.writeStartElement(REST_API_NS, "metadata-values");
        for (Map.Entry value : this.getMetadataValues().entrySet()) {
            serializer.writeStartElement("rapi", "metadata-value", REST_API_NS);
            serializer.writeAttribute("key", (String)value.getKey());
            if (value.getValue() != null) {
                serializer.writeCharacters((String)value.getValue());
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void sendCollectionsImpl(XMLStreamWriter serializer) throws XMLStreamException {
        if (this.getCollections() == null || this.getCollections().size() == 0) {
            return;
        }
        serializer.writeStartElement("rapi", "collections", REST_API_NS);
        for (String collection : this.getCollections()) {
            serializer.writeStartElement("rapi", "collection", REST_API_NS);
            if (collection != null) {
                serializer.writeCharacters(collection);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void sendPermissionsImpl(XMLStreamWriter serializer) throws XMLStreamException {
        if (this.getPermissions() == null || this.getPermissions().size() == 0) {
            return;
        }
        serializer.writeStartElement("rapi", "permissions", REST_API_NS);
        for (Map.Entry permission : this.getPermissions().entrySet()) {
            serializer.writeStartElement("rapi", "permission", REST_API_NS);
            serializer.writeStartElement("rapi", "role-name", REST_API_NS);
            if (permission.getKey() != null) {
                serializer.writeCharacters((String)permission.getKey());
            }
            serializer.writeEndElement();
            for (Capability capability : (Set)permission.getValue()) {
                serializer.writeStartElement("rapi", "capability", REST_API_NS);
                serializer.writeCharacters(capability.toString().toLowerCase());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void sendPropertiesImpl(XMLStreamWriter serializer) throws XMLStreamException, TransformerFactoryConfigurationError, TransformerException {
        if (this.getProperties() == null || this.getProperties().size() == 0) {
            return;
        }
        ValueSerializer valueSerializer = null;
        serializer.writeStartElement("prop", "properties", PROPERTY_API_NS);
        for (Map.Entry property : this.getProperties().entrySet()) {
            QName propertyName = (QName)property.getKey();
            Object value = property.getValue();
            boolean hasNodeValue = value instanceof NodeList;
            String namespaceURI = propertyName.getNamespaceURI();
            String prefix = null;
            String localPart = propertyName.getLocalPart();
            if (namespaceURI != null && namespaceURI.length() > 0) {
                if (PROPERTY_API_NS.equals(namespaceURI)) continue;
                prefix = propertyName.getPrefix();
                serializer.writeStartElement(prefix, localPart, namespaceURI);
            } else {
                serializer.writeStartElement(localPart);
            }
            if (!hasNodeValue) {
                if (valueSerializer == null) {
                    valueSerializer = new ValueSerializer(serializer);
                }
                ValueConverter.convertFromJava(value, valueSerializer);
            } else {
                new DOMWriter(serializer).serializeNodeList((NodeList)value);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void sendQualityImpl(XMLStreamWriter serializer) throws XMLStreamException {
        if (!this.qualityModified) {
            return;
        }
        serializer.writeStartElement("rapi", "quality", REST_API_NS);
        serializer.writeCharacters(String.valueOf(this.getQuality()));
        serializer.writeEndElement();
    }

    private static class ValueSerializer
    implements ValueConverter.ValueProcessor {
        private XMLStreamWriter serializer;

        public ValueSerializer(XMLStreamWriter serializer) {
            this.serializer = serializer;
        }

        @Override
        public void process(Object original, String type, String value) {
            if (original == null) {
                return;
            }
            try {
                this.serializer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", type);
                if (value != null) {
                    this.serializer.writeCharacters(value);
                }
            }
            catch (XMLStreamException e) {
                throw new MarkLogicIOException(e);
            }
        }
    }

    private static class ValuesImpl
    extends HashMap<String, String>
    implements DocumentMetadataValues {
        private ValuesImpl() {
        }

        @Override
        public void add(String key, String value) {
            this.put(key, value);
        }
    }

    public static interface DocumentMetadataValues
    extends Map<String, String> {
        public void add(String var1, String var2);
    }

    private static class PropertiesImpl
    extends ClientPropertiesImpl
    implements DocumentProperties {
        private PropertiesImpl() {
        }
    }

    public static interface DocumentProperties
    extends NameMap<Object> {
        @Override
        public Object put(QName var1, BigDecimal var2);

        @Override
        public Object put(QName var1, BigInteger var2);

        @Override
        public Object put(QName var1, Boolean var2);

        @Override
        public Object put(QName var1, Byte var2);

        @Override
        public Object put(QName var1, byte[] var2);

        @Override
        public Object put(QName var1, Calendar var2);

        @Override
        public Object put(QName var1, Double var2);

        @Override
        public Object put(QName var1, Duration var2);

        @Override
        public Object put(QName var1, Float var2);

        @Override
        public Object put(QName var1, Integer var2);

        @Override
        public Object put(QName var1, Long var2);

        @Override
        public Object put(QName var1, NodeList var2);

        @Override
        public Object put(QName var1, Short var2);

        @Override
        public Object put(QName var1, String var2);
    }

    public static enum Capability {
        EXECUTE,
        INSERT,
        READ,
        UPDATE,
        NODE_UPDATE;


        public String toString() {
            return super.toString().replace('_', '-');
        }

        public static final Capability getValueOf(String name) {
            if (name != null) {
                name = name.replace('-', '_').toUpperCase();
            }
            return Capability.valueOf(name);
        }
    }

    private static class PermissionsImpl
    extends HashMap<String, Set<Capability>>
    implements DocumentPermissions {
        private PermissionsImpl() {
        }

        @Override
        public void add(String role, Capability ... capabilities) {
            if (capabilities == null || capabilities.length < 1) {
                return;
            }
            HashSet<Capability> caps = new HashSet<Capability>(capabilities.length);
            for (Capability capability : capabilities) {
                caps.add(capability);
            }
            this.put(role, caps);
        }

        public void add(String role, Capability capability) {
            if (this.containsKey(role)) {
                ((Set)this.get(role)).add(capability);
            } else {
                HashSet<Capability> caps = new HashSet<Capability>();
                caps.add(capability);
                this.put(role, caps);
            }
        }
    }

    public static interface DocumentPermissions
    extends Map<String, Set<Capability>> {
        public void add(String var1, Capability ... var2);
    }

    private static class CollectionsImpl
    extends HashSet<String>
    implements DocumentCollections {
        private CollectionsImpl() {
        }

        @Override
        public void addAll(String ... collections) {
            if (collections == null || collections.length < 1) {
                return;
            }
            for (String collection : collections) {
                this.add(collection);
            }
        }
    }

    public static interface DocumentCollections
    extends Set<String> {
        public void addAll(String ... var1);
    }
}

