/*
 * Copyright (c) 2022 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.marklogic.client.expression;

import com.marklogic.client.type.XsAnyAtomicTypeSeqVal;
import com.marklogic.client.type.XsAnyAtomicTypeVal;
import com.marklogic.client.type.XsDateTimeVal;
import com.marklogic.client.type.XsDoubleVal;
import com.marklogic.client.type.XsIntegerVal;
import com.marklogic.client.type.XsQNameSeqVal;
import com.marklogic.client.type.XsQNameVal;
import com.marklogic.client.type.XsStringSeqVal;
import com.marklogic.client.type.XsStringVal;
import com.marklogic.client.type.XsUnsignedLongVal;

import com.marklogic.client.type.ServerExpression;
import com.marklogic.client.type.CtsBoxExpr;
import com.marklogic.client.type.CtsBoxSeqExpr;
import com.marklogic.client.type.CtsCircleExpr;
import com.marklogic.client.type.CtsCircleSeqExpr;
import com.marklogic.client.type.CtsPeriodExpr;
import com.marklogic.client.type.CtsPeriodSeqExpr;
import com.marklogic.client.type.CtsPointExpr;
import com.marklogic.client.type.CtsPointSeqExpr;
import com.marklogic.client.type.CtsPolygonExpr;
import com.marklogic.client.type.CtsPolygonSeqExpr;
import com.marklogic.client.type.CtsQueryExpr;
import com.marklogic.client.type.CtsQuerySeqExpr;
import com.marklogic.client.type.CtsReferenceExpr;
import com.marklogic.client.type.CtsReferenceSeqExpr;
import com.marklogic.client.type.CtsRegionExpr;
import com.marklogic.client.type.CtsRegionSeqExpr;

// IMPORTANT: Do not edit. This file is generated. 

/**
 * Builds expressions to call functions in the cts server library for a row
 * pipeline.
 */
public interface CtsExpr {
    /**
  * Returns a query matching fragments committed after a specified timestamp.
  *
  * <a name="ml-server-type-after-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:after-query" target="mlserverdoc">cts:after-query</a> server function.
  * @param timestamp  A commit timestamp. Database fragments committed after this timestamp are matched.  (of <a href="{@docRoot}/doc-files/types/xs_unsignedLong.html">xs:unsignedLong</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr afterQuery(ServerExpression timestamp);
/**
  * Returns a query specifying the set difference of the matches specified by two sub-queries.
  *
  * <a name="ml-server-type-and-not-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:and-not-query" target="mlserverdoc">cts:and-not-query</a> server function.
  * @param positiveQuery  A positive query, specifying the search results filtered in.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param negativeQuery  A negative query, specifying the search results to filter out.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr andNotQuery(ServerExpression positiveQuery, ServerExpression negativeQuery);
/**
  * Returns a query specifying the intersection of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:and-query" target="mlserverdoc">cts:and-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr andQuery(CtsQueryExpr... queries);
/**
  * Returns a query specifying the intersection of the matches specified by the sub-queries.
  *
  * <a name="ml-server-type-and-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:and-query" target="mlserverdoc">cts:and-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr andQuery(ServerExpression queries);
/**
  * Returns a query specifying the intersection of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:and-query" target="mlserverdoc">cts:and-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param options  Options to this query. The default is ().  Options include:  "ordered" An ordered and-query, which specifies that the sub-query matches must occur in the order of the specified sub-queries. For example, if the sub-queries are "cat" and "dog", an ordered query will only match fragments where both "cat" and "dog" occur, and where "cat" comes before "dog" in the fragment. "unordered" An unordered and-query, which specifies that the sub-query matches can occur in any order.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr andQuery(ServerExpression queries, String options);
/**
  * Returns a query specifying the intersection of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:and-query" target="mlserverdoc">cts:and-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param options  Options to this query. The default is ().  Options include:  "ordered" An ordered and-query, which specifies that the sub-query matches must occur in the order of the specified sub-queries. For example, if the sub-queries are "cat" and "dog", an ordered query will only match fragments where both "cat" and "dog" occur, and where "cat" comes before "dog" in the fragment. "unordered" An unordered and-query, which specifies that the sub-query matches can occur in any order.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr andQuery(ServerExpression queries, XsStringSeqVal options);
/**
  * Returns a query matching fragments committed before or at a specified timestamp.
  *
  * <a name="ml-server-type-before-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:before-query" target="mlserverdoc">cts:before-query</a> server function.
  * @param timestamp  A commit timestamp. Database fragments committed before this timestamp are matched.  (of <a href="{@docRoot}/doc-files/types/xs_unsignedLong.html">xs:unsignedLong</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr beforeQuery(ServerExpression timestamp);
/**
  * Returns a query specifying that matches to matching-query should have their search relevance scores boosted if they also match boosting-query.
  *
  * <a name="ml-server-type-boost-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:boost-query" target="mlserverdoc">cts:boost-query</a> server function.
  * @param matchingQuery  A sub-query that is used for match and scoring.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param boostingQuery  A sub-query that is used only for boosting score.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr boostQuery(ServerExpression matchingQuery, ServerExpression boostingQuery);
/**
  * Returns a geospatial box value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box" target="mlserverdoc">cts:box</a> server function.
  * @param south  The southern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param west  The western boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param north  The northern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param east  The eastern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a> server data type
  */
  public CtsBoxExpr box(double south, double west, double north, double east);
/**
  * Returns a geospatial box value.
  *
  * <a name="ml-server-type-box"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box" target="mlserverdoc">cts:box</a> server function.
  * @param south  The southern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param west  The western boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param north  The northern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param east  The eastern boundary of the box.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a> server data type
  */
  public CtsBoxExpr box(ServerExpression south, ServerExpression west, ServerExpression north, ServerExpression east);
/**
  * Returns a box's eastern boundary.
  *
  * <a name="ml-server-type-box-east"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box-east" target="mlserverdoc">cts:box-east</a> server function.
  * @param box  The box.  (of <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression boxEast(ServerExpression box);
/**
  * Returns a box's northern boundary.
  *
  * <a name="ml-server-type-box-north"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box-north" target="mlserverdoc">cts:box-north</a> server function.
  * @param box  The box.  (of <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression boxNorth(ServerExpression box);
/**
  * Returns a box's southern boundary.
  *
  * <a name="ml-server-type-box-south"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box-south" target="mlserverdoc">cts:box-south</a> server function.
  * @param box  The box.  (of <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression boxSouth(ServerExpression box);
/**
  * Returns a box's western boundary.
  *
  * <a name="ml-server-type-box-west"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:box-west" target="mlserverdoc">cts:box-west</a> server function.
  * @param box  The box.  (of <a href="{@docRoot}/doc-files/types/cts_box.html">cts:box</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression boxWest(ServerExpression box);
/**
  * Returns a geospatial circle value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:circle" target="mlserverdoc">cts:circle</a> server function.
  * @param radius  The radius of the circle. The units for the radius is determined at runtime by the query options (miles is currently the only option).  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param center  A point representing the center of the circle.  (of <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_circle.html">cts:circle</a> server data type
  */
  public CtsCircleExpr circle(double radius, ServerExpression center);
/**
  * Returns a geospatial circle value.
  *
  * <a name="ml-server-type-circle"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:circle" target="mlserverdoc">cts:circle</a> server function.
  * @param radius  The radius of the circle. The units for the radius is determined at runtime by the query options (miles is currently the only option).  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param center  A point representing the center of the circle.  (of <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_circle.html">cts:circle</a> server data type
  */
  public CtsCircleExpr circle(ServerExpression radius, ServerExpression center);
/**
  * Returns a circle's center point.
  *
  * <a name="ml-server-type-circle-center"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:circle-center" target="mlserverdoc">cts:circle-center</a> server function.
  * @param circle  The circle.  (of <a href="{@docRoot}/doc-files/types/cts_circle.html">cts:circle</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a> server data type
  */
  public CtsPointExpr circleCenter(ServerExpression circle);
/**
  * Returns a circle's radius.
  *
  * <a name="ml-server-type-circle-radius"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:circle-radius" target="mlserverdoc">cts:circle-radius</a> server function.
  * @param circle  The circle.  (of <a href="{@docRoot}/doc-files/types/cts_circle.html">cts:circle</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression circleRadius(ServerExpression circle);
/**
  * Match documents in at least one of the specified collections. It will match both documents and properties documents in the collections with the given URIs.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:collection-query" target="mlserverdoc">cts:collection-query</a> server function.
  * @param uris  One or more collection URIs. A document matches the query if it is in at least one of these collections.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr collectionQuery(String uris);
/**
  * Match documents in at least one of the specified collections. It will match both documents and properties documents in the collections with the given URIs.
  *
  * <a name="ml-server-type-collection-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:collection-query" target="mlserverdoc">cts:collection-query</a> server function.
  * @param uris  One or more collection URIs. A document matches the query if it is in at least one of these collections.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr collectionQuery(ServerExpression uris);
/**
  * Creates a reference to the collection lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-collection-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:collection-reference" target="mlserverdoc">cts:collection-reference</a> server function.
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr collectionReference();
/**
  * Creates a reference to the collection lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:collection-reference" target="mlserverdoc">cts:collection-reference</a> server function.
  * @param options  Options. The default is ().  Options include:  "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr collectionReference(String options);
/**
  * Creates a reference to the collection lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:collection-reference" target="mlserverdoc">cts:collection-reference</a> server function.
  * @param options  Options. The default is ().  Options include:  "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr collectionReference(ServerExpression options);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(String schema, String view, String column, String value);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  *
  * <a name="ml-server-type-column-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(ServerExpression schema, ServerExpression view, ServerExpression column, ServerExpression value);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(String schema, String view, String column, String value, String operator);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(ServerExpression schema, ServerExpression view, ServerExpression column, ServerExpression value, ServerExpression operator);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(String schema, String view, String column, String value, String operator, String... options);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(ServerExpression schema, ServerExpression view, ServerExpression column, ServerExpression value, ServerExpression operator, ServerExpression options);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(String schema, String view, String column, String value, String operator, String options, double weight);
/**
  * Returns a cts:query matching documents matching a TDE-view column equals to an value. Searches with the cts:column-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:column-range-query" target="mlserverdoc">cts:column-range-query</a> server function.
  * @param schema  The TDE schema name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param view  The TDE view name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param column  The TDE column name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values used for querying.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  Operator for the $value values. The default operator is "=".  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr columnRangeQuery(ServerExpression schema, ServerExpression view, ServerExpression column, ServerExpression value, ServerExpression operator, ServerExpression options, ServerExpression weight);
/**
  * Returns a geospatial complex polygon value.
  *
  * <a name="ml-server-type-complex-polygon"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:complex-polygon" target="mlserverdoc">cts:complex-polygon</a> server function.
  * @param outer  The outer polygon.  (of <a href="{@docRoot}/doc-files/types/cts_polygon.html">cts:polygon</a>)
  * @param inner  The inner (hole) polygons.  (of <a href="{@docRoot}/doc-files/types/cts_polygon.html">cts:polygon</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_complex-polygon.html">cts:complex-polygon</a> server data type
  */
  public CtsPolygonExpr complexPolygon(ServerExpression outer, ServerExpression inner);
/**
  * Returns a query matching documents in the directories with the given URIs.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:directory-query" target="mlserverdoc">cts:directory-query</a> server function.
  * @param uris  One or more directory URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr directoryQuery(String uris);
/**
  * Returns a query matching documents in the directories with the given URIs.
  *
  * <a name="ml-server-type-directory-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:directory-query" target="mlserverdoc">cts:directory-query</a> server function.
  * @param uris  One or more directory URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr directoryQuery(ServerExpression uris);
/**
  * Returns a query matching documents in the directories with the given URIs.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:directory-query" target="mlserverdoc">cts:directory-query</a> server function.
  * @param uris  One or more directory URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param depth  "1" for immediate children, "infinity" for all. If not supplied, depth is "1".  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr directoryQuery(String uris, String depth);
/**
  * Returns a query matching documents in the directories with the given URIs.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:directory-query" target="mlserverdoc">cts:directory-query</a> server function.
  * @param uris  One or more directory URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param depth  "1" for immediate children, "infinity" for all. If not supplied, depth is "1".  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr directoryQuery(ServerExpression uris, ServerExpression depth);
/**
  * Returns a query that matches all documents where query matches any document fragment. When searching documents, document-properties, or document-locks, this function provides a convenient way to additionally constrain the search against any document fragment.
  *
  * <a name="ml-server-type-document-fragment-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:document-fragment-query" target="mlserverdoc">cts:document-fragment-query</a> server function.
  * @param query  A query to be matched against any document fragment.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr documentFragmentQuery(ServerExpression query);
/**
  * Returns a query matching documents with the given URIs. It will match both documents and properties documents with the given URIs.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:document-query" target="mlserverdoc">cts:document-query</a> server function.
  * @param uris  One or more document URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr documentQuery(String uris);
/**
  * Returns a query matching documents with the given URIs. It will match both documents and properties documents with the given URIs.
  *
  * <a name="ml-server-type-document-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:document-query" target="mlserverdoc">cts:document-query</a> server function.
  * @param uris  One or more document URIs.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr documentQuery(ServerExpression uris);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(String elementName, String latitudeName, String longitudeName, CtsRegionExpr... region);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-element-attribute-pair-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(String elementName, String latitudeName, String longitudeName, ServerExpression region, String... options);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(String elementName, String latitudeName, String longitudeName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching elements by name which has specific attributes representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-pair-geospatial-query" target="mlserverdoc">cts:element-attribute-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude attribute in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributePairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(String elementName, String attributeName, String operator, String value);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  *
  * <a name="ml-server-type-element-attribute-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression operator, ServerExpression value);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(String elementName, String attributeName, String operator, String value, String... options);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(String elementName, String attributeName, String operator, String value, String options, double weight);
/**
  * Constructs a query that matches element-attributes by name with a range-index entry equal to a given value. An element attribute range index on the specified QName(s) must exist when you use this query in a search; if no such range index exists, the search throws an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-range-query" target="mlserverdoc">cts:element-attribute-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  Some values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeRangeQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to an element attribute value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-reference" target="mlserverdoc">cts:element-attribute-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attribute  An attribute QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementAttributeReference(String element, String attribute);
/**
  * Creates a reference to an element attribute value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-element-attribute-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-reference" target="mlserverdoc">cts:element-attribute-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attribute  An attribute QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementAttributeReference(ServerExpression element, ServerExpression attribute);
/**
  * Creates a reference to an element attribute value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-reference" target="mlserverdoc">cts:element-attribute-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attribute  An attribute QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementAttributeReference(String element, String attribute, String options);
/**
  * Creates a reference to an element attribute value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-reference" target="mlserverdoc">cts:element-attribute-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attribute  An attribute QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementAttributeReference(ServerExpression element, ServerExpression attribute, ServerExpression options);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(String elementName, String attributeName, String text);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  *
  * <a name="ml-server-type-element-attribute-value-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(String elementName, String attributeName, String text, String... options);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(String elementName, String attributeName, String text, String options, double weight);
/**
  * Returns a query matching elements by name with attributes by name with text content equal a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-value-query" target="mlserverdoc">cts:element-attribute-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more attribute values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeValueQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(String elementName, String attributeName, String text);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  *
  * <a name="ml-server-type-element-attribute-word-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(String elementName, String attributeName, String text, String... options);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(String elementName, String attributeName, String text, String options, double weight);
/**
  * Returns a query matching elements by name with attributes by name with text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-attribute-word-query" target="mlserverdoc">cts:element-attribute-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param attributeName  One or more attribute QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementAttributeWordQuery(ServerExpression elementName, ServerExpression attributeName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(String elementName, String childName, CtsRegionExpr... region);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-element-child-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(ServerExpression elementName, ServerExpression childName, ServerExpression region);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(String elementName, String childName, ServerExpression region, String... options);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(ServerExpression elementName, ServerExpression childName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(String elementName, String childName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-child-geospatial-query" target="mlserverdoc">cts:element-child-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param childName  One or more child element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked. The element must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementChildGeospatialQuery(ServerExpression elementName, ServerExpression childName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(String elementName, CtsRegionExpr... region);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-element-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(ServerExpression elementName, ServerExpression region);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(String elementName, ServerExpression region, String... options);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(ServerExpression elementName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(String elementName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching elements by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-geospatial-query" target="mlserverdoc">cts:element-geospatial-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementGeospatialQuery(ServerExpression elementName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(String elementName, String latitudeName, String longitudeName, CtsRegionExpr... region);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-element-pair-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(String elementName, String latitudeName, String longitudeName, ServerExpression region, String... options);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(String elementName, String latitudeName, String longitudeName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching elements by name which has specific element children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-pair-geospatial-query" target="mlserverdoc">cts:element-pair-geospatial-query</a> server function.
  * @param elementName  One or more parent element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param latitudeName  One or more latitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param longitudeName  One or more longitude element QNames to match. When multiple QNames are specified, the query matches if any QName matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementPairGeospatialQuery(ServerExpression elementName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Constructs a query that matches elements by name with the content constrained by the query given in the second parameter. Searches for matches in the specified element and all of its descendants. If the query specified in the second parameter includes any element attribute sub-queries, it will search attributes on the specified element and attributes on any descendant elements. See the second example below).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-query" target="mlserverdoc">cts:element-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param query  A query for the element to match. If a string is entered, the string is treated as a cts:word-query of the specified string.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementQuery(String elementName, ServerExpression query);
/**
  * Constructs a query that matches elements by name with the content constrained by the query given in the second parameter. Searches for matches in the specified element and all of its descendants. If the query specified in the second parameter includes any element attribute sub-queries, it will search attributes on the specified element and attributes on any descendant elements. See the second example below).
  *
  * <a name="ml-server-type-element-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-query" target="mlserverdoc">cts:element-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param query  A query for the element to match. If a string is entered, the string is treated as a cts:word-query of the specified string.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementQuery(ServerExpression elementName, ServerExpression query);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(String elementName, String operator, String value);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  *
  * <a name="ml-server-type-element-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(ServerExpression elementName, ServerExpression operator, ServerExpression value);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(String elementName, String operator, String value, String... options);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(ServerExpression elementName, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(String elementName, String operator, String value, String options, double weight);
/**
  * Constructs a query that matches elements by name with range index entry equal to a given value. Searches that use an element range query require an element range index on the specified QName(s); if no such range index exists, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-range-query" target="mlserverdoc">cts:element-range-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more element values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementRangeQuery(ServerExpression elementName, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to an element value lexicon, for use as a parameter to cts:value-tuples, temporal:axis-create, or any other function that takes an index reference. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-reference" target="mlserverdoc">cts:element-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementReference(String element);
/**
  * Creates a reference to an element value lexicon, for use as a parameter to cts:value-tuples, temporal:axis-create, or any other function that takes an index reference. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-element-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-reference" target="mlserverdoc">cts:element-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementReference(ServerExpression element);
/**
  * Creates a reference to an element value lexicon, for use as a parameter to cts:value-tuples, temporal:axis-create, or any other function that takes an index reference. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-reference" target="mlserverdoc">cts:element-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementReference(String element, String options);
/**
  * Creates a reference to an element value lexicon, for use as a parameter to cts:value-tuples, temporal:axis-create, or any other function that takes an index reference. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-reference" target="mlserverdoc">cts:element-reference</a> server function.
  * @param element  An element QName.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr elementReference(ServerExpression element, ServerExpression options);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(String elementName);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  *
  * <a name="ml-server-type-element-value-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(ServerExpression elementName);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(String elementName, String text);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(ServerExpression elementName, ServerExpression text);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(String elementName, String text, String... options);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(ServerExpression elementName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(String elementName, String text, String options, double weight);
/**
  * Returns a query matching elements by name with text content equal a given phrase. cts:element-value-query only matches against simple elements (that is, elements that contain only text and have no element children).
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-value-query" target="mlserverdoc">cts:element-value-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  One or more element values to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementValueQuery(ServerExpression elementName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(String elementName, String text);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  *
  * <a name="ml-server-type-element-word-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(ServerExpression elementName, ServerExpression text);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(String elementName, String text, String... options);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(ServerExpression elementName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(String elementName, String text, String options, double weight);
/**
  * Returns a query matching elements by name with text content containing a given phrase. Searches only through immediate text node children of the specified element as well as any text node children of child elements defined in the Admin Interface as element-word-query-throughs or phrase-throughs; does not search through any other children of the specified element. If neither word searches nor stemmed word searches is enabled for the target database, an XDMP-SEARCH error is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:element-word-query" target="mlserverdoc">cts:element-word-query</a> server function.
  * @param elementName  One or more element QNames to match. When multiple QNames are specified, the query matches if any QName matches.  (of <a href="{@docRoot}/doc-files/types/xs_QName.html">xs:QName</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr elementWordQuery(ServerExpression elementName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a query that matches no fragments.
  *
  * <a name="ml-server-type-false-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:false-query" target="mlserverdoc">cts:false-query</a> server function.
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr falseQuery();
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(String fieldName, String operator, String value);
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  *
  * <a name="ml-server-type-field-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(ServerExpression fieldName, ServerExpression operator, ServerExpression value);
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(String fieldName, String operator, String value, String... options);
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(ServerExpression fieldName, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(String fieldName, String operator, String value, String options, double weight);
/**
  * Returns a cts:query matching fields by name with a range-index entry equal to a given value. Searches with the cts:field-range-query constructor require a field range index on the specified field name(s); if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-range-query" target="mlserverdoc">cts:field-range-query</a> server function.
  * @param fieldName  One or more field names to match. When multiple field names are specified, the query matches if any field name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more field values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldRangeQuery(ServerExpression fieldName, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to a field value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-reference" target="mlserverdoc">cts:field-reference</a> server function.
  * @param field  A field name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr fieldReference(String field);
/**
  * Creates a reference to a field value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-field-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-reference" target="mlserverdoc">cts:field-reference</a> server function.
  * @param field  A field name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr fieldReference(ServerExpression field);
/**
  * Creates a reference to a field value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-reference" target="mlserverdoc">cts:field-reference</a> server function.
  * @param field  A field name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr fieldReference(String field, String options);
/**
  * Creates a reference to a field value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-reference" target="mlserverdoc">cts:field-reference</a> server function.
  * @param field  A field name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr fieldReference(ServerExpression field, ServerExpression options);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(String fieldName, String text);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  *
  * <a name="ml-server-type-field-value-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(ServerExpression fieldName, ServerExpression text);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple or score-random (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(String fieldName, String text, String... options);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple or score-random (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(ServerExpression fieldName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple or score-random (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(String fieldName, String text, String options, double weight);
/**
  * Returns a query matching text content containing a given value in the specified field. If the specified field does not exist, cts:field-value-query throws an exception. If the specified field does not have the index setting field value searches enabled, either for the database or for the specified field, then a cts:search with a cts:field-value-query throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-value-query" target="mlserverdoc">cts:field-value-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The values to match. If multiple values are specified, the query matches if any of the values match (or-query semantics). For XML and metadata, the values should be strings. For JSON, the values can be strings, numbers or booleans to match correspondingly typed nodes. To match null, pass in the empty sequence.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple or score-random (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldValueQuery(ServerExpression fieldName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(String fieldName, String text);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  *
  * <a name="ml-server-type-field-word-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(ServerExpression fieldName, ServerExpression text);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(String fieldName, String text, String... options);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(ServerExpression fieldName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(String fieldName, String text, String options, double weight);
/**
  * Returns a query matching fields with text content containing a given phrase. If the specified field does not exist, this function throws an exception. A field is a named object that specified elements to include and exclude from a search, and can include score weights for any included elements. You create fields at the database level using the Admin Interface. For details on fields, see the chapter on "Fields Database Settings" in the Administrator's Guide.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:field-word-query" target="mlserverdoc">cts:field-word-query</a> server function.
  * @param fieldName  One or more field names to search over. If multiple field names are supplied, the match can be in any of the specified fields (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  The word or phrase to match. If multiple strings are specified, the query matches if any of the words or phrases match (or-query semantics).  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr fieldWordQuery(ServerExpression fieldName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(String pathExpression);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-geospatial-path-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(ServerExpression pathExpression);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (point or long-lat-point) "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type and coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(String pathExpression, String options);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (point or long-lat-point) "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type and coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(ServerExpression pathExpression, ServerExpression options);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (point or long-lat-point) "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type and coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param map  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(String pathExpression, String options, ServerExpression map);
/**
  * Creates a reference to a geospatial path range index, for use as a parameter to cts:value-tuples. This function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-path-reference" target="mlserverdoc">cts:geospatial-path-reference</a> server function.
  * @param pathExpression  A path expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (point or long-lat-point) "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type and coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param map  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialPathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression map);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  *
  * <a name="ml-server-type-geospatial-region-path-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression, String options);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression, ServerExpression options);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression, String options, ServerExpression namespaces);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression namespaces);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression, String options, ServerExpression namespaces, long geohashPrecision);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression namespaces, ServerExpression geohashPrecision);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @param units  The units specified in the index configuration. 'miles', 'km', 'feet', and 'meters' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression, String options, ServerExpression namespaces, long geohashPrecision, String units);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @param units  The units specified in the index configuration. 'miles', 'km', 'feet', and 'meters' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression namespaces, ServerExpression geohashPrecision, ServerExpression units);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @param units  The units specified in the index configuration. 'miles', 'km', 'feet', and 'meters' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param invalidValues  The invalid values setting specified in the index configuration. 'reject' and 'ignore' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(String pathExpression, String options, ServerExpression namespaces, long geohashPrecision, String units, String invalidValues);
/**
  * Create a reference to a geospatial region path index, for use as a parameter to cts:geospatial-region-query and other query operations on geospatial region indexes. This function throws an exception if the specified region path index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-path-reference" target="mlserverdoc">cts:geospatial-region-path-reference</a> server function.
  * @param pathExpression  The XPath expression specified in the index configuration.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Index configuration options. The default is (). These options should match the configuration used when creating the index. Available options:  "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float (default) and double. "unchecked" Read the coordinate-system info only from the input. Do not check the definition against the context database.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param namespaces  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @param geohashPrecision  The geohash precision specified in the index configuration. Values between 1 and 12 inclusive are possible.  (of <a href="{@docRoot}/doc-files/types/xs_integer.html">xs:integer</a>)
  * @param units  The units specified in the index configuration. 'miles', 'km', 'feet', and 'meters' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param invalidValues  The invalid values setting specified in the index configuration. 'reject' and 'ignore' are valid.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr geospatialRegionPathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression namespaces, ServerExpression geohashPrecision, ServerExpression units, ServerExpression invalidValues);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, String operation, CtsRegionExpr... region);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  *
  * <a name="ml-server-type-geospatial-region-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, ServerExpression operation, ServerExpression region);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Available options:   "units=value" Measure distances and the radii of circles using the given units. Allowed values: miles (default), km, feet, and meters. This option only affects regions provided in the $regions parameter, not regions stored in documents. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).  "tolerance=distance" Tolerance is the largest allowable variation in geometry calculations. If the distance between two points is less than tolerance, then the two points are considered equal. For the raw coordinate system, use the units of the coordinates. For geographic coordinate systems, use the units specified by the units option.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, String operation, ServerExpression region, String... options);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Available options:   "units=value" Measure distances and the radii of circles using the given units. Allowed values: miles (default), km, feet, and meters. This option only affects regions provided in the $regions parameter, not regions stored in documents. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).  "tolerance=distance" Tolerance is the largest allowable variation in geometry calculations. If the distance between two points is less than tolerance, then the two points are considered equal. For the raw coordinate system, use the units of the coordinates. For geographic coordinate systems, use the units specified by the units option.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, ServerExpression operation, ServerExpression region, ServerExpression options);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Available options:   "units=value" Measure distances and the radii of circles using the given units. Allowed values: miles (default), km, feet, and meters. This option only affects regions provided in the $regions parameter, not regions stored in documents. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).  "tolerance=distance" Tolerance is the largest allowable variation in geometry calculations. If the distance between two points is less than tolerance, then the two points are considered equal. For the raw coordinate system, use the units of the coordinates. For geographic coordinate systems, use the units specified by the units option.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, String operation, ServerExpression region, String options, double weight);
/**
  * Construct a query to match regions in documents that satisfy a specified relationship relative to other regions. For example, regions in documents that intersect with regions specified in the search criteria.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:geospatial-region-query" target="mlserverdoc">cts:geospatial-region-query</a> server function.
  * @param reference  Zero or more geospatial path region index references that identify regions in your content. To create a reference, see cts:geospatial-region-path-reference.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operation  The match operation to apply between the regions specified in the $geospatial-region-reference parameter and the regions in the $regions parameter. Allowed values: contains, covered-by, covers, disjoint, intersects, overlaps, within, equals, touches, crosses. See the Usage Notes for details.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  Criteria regions to match against the regions specified in the $geospatial-region-reference parameter. These regions function as the right operand of $operation.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Available options:   "units=value" Measure distances and the radii of circles using the given units. Allowed values: miles (default), km, feet, and meters. This option only affects regions provided in the $regions parameter, not regions stored in documents. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).  "tolerance=distance" Tolerance is the largest allowable variation in geometry calculations. If the distance between two points is less than tolerance, then the two points are considered equal. For the raw coordinate system, use the units of the coordinates. For geographic coordinate systems, use the units specified by the units option.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr geospatialRegionQuery(ServerExpression reference, ServerExpression operation, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to the URI lexicon, for use as a parameter to cts:value-tuples. This function requires the URI lexicon to be enabled, otherwise it throws an exception. This reference returns URIs as IRIs.
  *
  * <a name="ml-server-type-iri-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:iri-reference" target="mlserverdoc">cts:iri-reference</a> server function.
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr iriReference();
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(String propertyName, String childName, CtsRegionExpr... region);
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-json-property-child-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(ServerExpression propertyName, ServerExpression childName, ServerExpression region);
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(String propertyName, String childName, ServerExpression region, String... options);
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(ServerExpression propertyName, ServerExpression childName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(String propertyName, String childName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching json properties by name which has specific children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-child-geospatial-query" target="mlserverdoc">cts:json-property-child-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param childName  One or more child property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked. The property must specify both latitude and longitude coordinates.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyChildGeospatialQuery(ServerExpression propertyName, ServerExpression childName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(String propertyName, CtsRegionExpr... region);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-json-property-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(ServerExpression propertyName, ServerExpression region);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(String propertyName, ServerExpression region, String... options);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(ServerExpression propertyName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(String propertyName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching json properties by name whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-geospatial-query" target="mlserverdoc">cts:json-property-geospatial-query</a> server function.
  * @param propertyName  One or more json property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=string" Use the coordinate system at the given precision. Allowed values: float (default) and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyGeospatialQuery(ServerExpression propertyName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(String propertyName, String latitudeName, String longitudeName, CtsRegionExpr... region);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-json-property-pair-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(ServerExpression propertyName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(String propertyName, String latitudeName, String longitudeName, ServerExpression region, String... options);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(ServerExpression propertyName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(String propertyName, String latitudeName, String longitudeName, ServerExpression region, String options, double weight);
/**
  * Returns a query matching json properties by name which has specific property children representing latitude and longitude values for a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-pair-geospatial-query" target="mlserverdoc">cts:json-property-pair-geospatial-query</a> server function.
  * @param propertyName  One or more parent property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param latitudeName  One or more latitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching latitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param longitudeName  One or more longitude property names to match. When multiple names are specified, the query matches if any name matches; however, only the first matching longitude child in any point instance will be checked.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyPairGeospatialQuery(ServerExpression propertyName, ServerExpression latitudeName, ServerExpression longitudeName, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(String propertyName, String operator, String value);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  *
  * <a name="ml-server-type-json-property-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(ServerExpression propertyName, ServerExpression operator, ServerExpression value);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(String propertyName, String operator, String value, String... options);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(ServerExpression propertyName, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(String propertyName, String operator, String value, String options, double weight);
/**
  * Returns a cts:query matching JSON properties by name with a range-index entry equal to a given value. Searches with the cts:json-property-range-query constructor require a property range index on the specified names; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-range-query" target="mlserverdoc">cts:json-property-range-query</a> server function.
  * @param propertyName  One or more property name to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyRangeQuery(ServerExpression propertyName, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to a JSON property value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-reference" target="mlserverdoc">cts:json-property-reference</a> server function.
  * @param property  A property name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr jsonPropertyReference(String property);
/**
  * Creates a reference to a JSON property value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-json-property-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-reference" target="mlserverdoc">cts:json-property-reference</a> server function.
  * @param property  A property name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr jsonPropertyReference(ServerExpression property);
/**
  * Creates a reference to a JSON property value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-reference" target="mlserverdoc">cts:json-property-reference</a> server function.
  * @param property  A property name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr jsonPropertyReference(String property, String options);
/**
  * Creates a reference to a JSON property value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-reference" target="mlserverdoc">cts:json-property-reference</a> server function.
  * @param property  A property name.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr jsonPropertyReference(ServerExpression property, ServerExpression options);
/**
  * Returns a cts:query matching JSON properties by name with the content constrained by the given cts:query in the second parameter. Searches for matches in the specified property and all of its descendants.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-scope-query" target="mlserverdoc">cts:json-property-scope-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param query  A query for the property to match. If a string is entered, the string is treated as a cts:word-query of the specified string.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyScopeQuery(String propertyName, ServerExpression query);
/**
  * Returns a cts:query matching JSON properties by name with the content constrained by the given cts:query in the second parameter. Searches for matches in the specified property and all of its descendants.
  *
  * <a name="ml-server-type-json-property-scope-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-scope-query" target="mlserverdoc">cts:json-property-scope-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param query  A query for the property to match. If a string is entered, the string is treated as a cts:word-query of the specified string.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyScopeQuery(ServerExpression propertyName, ServerExpression query);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(String propertyName, String value);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  *
  * <a name="ml-server-type-json-property-value-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(ServerExpression propertyName, ServerExpression value);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(String propertyName, String value, String... options);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(ServerExpression propertyName, ServerExpression value, ServerExpression options);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(String propertyName, String value, String options, double weight);
/**
  * Returns a query matching JSON properties by name with value equal the given value. For arrays, the query matches if the value of any elements in the array matches the given value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-value-query" target="mlserverdoc">cts:json-property-value-query</a> server function.
  * @param propertyName  One or more property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more property values to match. When multiple values are specified, the query matches if any value matches. The values can be strings, numbers or booleans to match correspondingly typed nodes. If the value is the empty sequence, the query matches null.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyValueQuery(ServerExpression propertyName, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(String propertyName, String text);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  *
  * <a name="ml-server-type-json-property-word-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(ServerExpression propertyName, ServerExpression text);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(String propertyName, String text, String... options);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(ServerExpression propertyName, ServerExpression text, ServerExpression options);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(String propertyName, String text, String options, double weight);
/**
  * Returns a query matching JSON properties by name with text content containing a given phrase. Searches only through immediate text node children of the specified property.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:json-property-word-query" target="mlserverdoc">cts:json-property-word-query</a> server function.
  * @param propertyName  One or more JSON property names to match. When multiple names are specified, the query matches if any name matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  * "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr jsonPropertyWordQuery(ServerExpression propertyName, ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Returns a geospatial linestring value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:linestring" target="mlserverdoc">cts:linestring</a> server function.
  * @param vertices  The waypoints of the linestring, given in order. vertexes.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_linestring.html">cts:linestring</a> server data type
  */
  public ServerExpression linestring(String vertices);
/**
  * Returns a geospatial linestring value.
  *
  * <a name="ml-server-type-linestring"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:linestring" target="mlserverdoc">cts:linestring</a> server function.
  * @param vertices  The waypoints of the linestring, given in order. vertexes.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_linestring.html">cts:linestring</a> server data type
  */
  public ServerExpression linestring(ServerExpression vertices);
/**
  * Returns a query that matches all documents where query matches document-locks. When searching documents or document-properties, cts:locks-fragment-query provides a convenient way to additionally constrain the search against document-locks fragments.
  *
  * <a name="ml-server-type-locks-fragment-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:locks-fragment-query" target="mlserverdoc">cts:locks-fragment-query</a> server function.
  * @param query  A query to be matched against the locks fragment.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr locksFragmentQuery(ServerExpression query);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(String temporalCollection);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  *
  * <a name="ml-server-type-lsqt-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(ServerExpression temporalCollection);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(String temporalCollection, String timestamp);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(ServerExpression temporalCollection, ServerExpression timestamp);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" Break down the query into sub-queries and then cache each one of them for better performance. This is enabled, by default. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(String temporalCollection, String timestamp, String... options);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" Break down the query into sub-queries and then cache each one of them for better performance. This is enabled, by default. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(ServerExpression temporalCollection, ServerExpression timestamp, ServerExpression options);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" Break down the query into sub-queries and then cache each one of them for better performance. This is enabled, by default. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(String temporalCollection, String timestamp, String options, double weight);
/**
  * Returns only documents before LSQT or a timestamp before LSQT for stable query results.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:lsqt-query" target="mlserverdoc">cts:lsqt-query</a> server function.
  * @param temporalCollection  The name of the temporal collection.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param timestamp  Return only temporal documents with a system start time less than or equal to this value. Default is temporal:get-lsqt($temporal-collection). Timestamps larger than LSQT are rejected.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" Break down the query into sub-queries and then cache each one of them for better performance. This is enabled, by default. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr lsqtQuery(ServerExpression temporalCollection, ServerExpression timestamp, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(CtsQueryExpr... queries);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  *
  * <a name="ml-server-type-near-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, double distance);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, XsDoubleVal distance);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param options  Options to this query. The default value is ().  Options include:  "ordered" Any near-query matches must occur in the order of the specified sub-queries. "unordered" Any near-query matches will satisfy the query, regardless of the order they were specified.  "minimum-distance" The minimum distance between two matching queries. The results match if the two queries match and the minimum distance between the two matches is greater than or equal to the specified minimum distance. The default value is zero. A negative distance is treated as 0.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, double distance, String... options);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param options  Options to this query. The default value is ().  Options include:  "ordered" Any near-query matches must occur in the order of the specified sub-queries. "unordered" Any near-query matches will satisfy the query, regardless of the order they were specified.  "minimum-distance" The minimum distance between two matching queries. The results match if the two queries match and the minimum distance between the two matches is greater than or equal to the specified minimum distance. The default value is zero. A negative distance is treated as 0.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, ServerExpression distance, ServerExpression options);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param options  Options to this query. The default value is ().  Options include:  "ordered" Any near-query matches must occur in the order of the specified sub-queries. "unordered" Any near-query matches will satisfy the query, regardless of the order they were specified.  "minimum-distance" The minimum distance between two matching queries. The results match if the two queries match and the minimum distance between the two matches is greater than or equal to the specified minimum distance. The default value is zero. A negative distance is treated as 0.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight attributed to the distance for this query. Higher weights add to the importance of distance (as opposed to term matches) when the relevance order is calculated. The default value is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score. This parameter has no effect if the word positions index is not enabled.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, double distance, String options, double weight);
/**
  * Returns a query matching all of the specified queries, where the matches occur within the specified distance from each other.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:near-query" target="mlserverdoc">cts:near-query</a> server function.
  * @param queries  A sequence of queries to match.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param distance  A distance, in number of words, between any two matching queries. The results match if two queries match and the distance between the two matches is equal to or less than the specified distance. A distance of 0 matches when the text is the exact same text or when there is overlapping text (see the third example below). A negative distance is treated as 0. The default value is 10.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param options  Options to this query. The default value is ().  Options include:  "ordered" Any near-query matches must occur in the order of the specified sub-queries. "unordered" Any near-query matches will satisfy the query, regardless of the order they were specified.  "minimum-distance" The minimum distance between two matching queries. The results match if the two queries match and the minimum distance between the two matches is greater than or equal to the specified minimum distance. The default value is zero. A negative distance is treated as 0.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight attributed to the distance for this query. Higher weights add to the importance of distance (as opposed to term matches) when the relevance order is calculated. The default value is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score. This parameter has no effect if the word positions index is not enabled.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr nearQuery(ServerExpression queries, ServerExpression distance, ServerExpression options, ServerExpression weight);
/**
  * Returns a query matching the first sub-query, where those matches do not occur within 0 distance of the other query.
  *
  * <a name="ml-server-type-not-in-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:not-in-query" target="mlserverdoc">cts:not-in-query</a> server function.
  * @param positiveQuery  A positive query, specifying the search results filtered in.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param negativeQuery  A negative query, specifying the search results to filter out.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr notInQuery(ServerExpression positiveQuery, ServerExpression negativeQuery);
/**
  * Returns a query specifying the matches not specified by its sub-query.
  *
  * <a name="ml-server-type-not-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:not-query" target="mlserverdoc">cts:not-query</a> server function.
  * @param query  A negative query, specifying the search results to filter out.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr notQuery(ServerExpression query);
/**
  * Returns a query specifying the union of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:or-query" target="mlserverdoc">cts:or-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr orQuery(CtsQueryExpr... queries);
/**
  * Returns a query specifying the union of the matches specified by the sub-queries.
  *
  * <a name="ml-server-type-or-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:or-query" target="mlserverdoc">cts:or-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr orQuery(ServerExpression queries);
/**
  * Returns a query specifying the union of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:or-query" target="mlserverdoc">cts:or-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param options  Options to this query. The default is ().  Options include:   "synonym" Specifies that all of the terms in the $queries parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr orQuery(ServerExpression queries, String options);
/**
  * Returns a query specifying the union of the matches specified by the sub-queries.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:or-query" target="mlserverdoc">cts:or-query</a> server function.
  * @param queries  A sequence of sub-queries.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @param options  Options to this query. The default is ().  Options include:   "synonym" Specifies that all of the terms in the $queries parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr orQuery(ServerExpression queries, XsStringSeqVal options);
/**
  * Returns the part of speech for a cts:token, if any.
  *
  * <a name="ml-server-type-part-of-speech"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:part-of-speech" target="mlserverdoc">cts:part-of-speech</a> server function.
  * @param token  A token, as returned from cts:tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression partOfSpeech(ServerExpression token);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(String pathExpression, CtsRegionExpr... region);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  *
  * <a name="ml-server-type-path-geospatial-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(ServerExpression pathExpression, ServerExpression region);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(String pathExpression, ServerExpression region, String... options);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(ServerExpression pathExpression, ServerExpression region, ServerExpression options);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(String pathExpression, ServerExpression region, String options, double weight);
/**
  * Returns a query matching path expressions whose content represents a point contained within the given geographic box, circle, or polygon, or equal to the given point. Points that lie between the southern boundary and the northern boundary of a box, travelling northwards, and between the western boundary and the eastern boundary of the box, travelling eastwards, will match. Points contained within the given radius of the center point of a circle will match, using the curved distance on the surface of the Earth. Points contained within the given polygon will match, using great circle arcs over a spherical model of the Earth as edges. An error may result if the polygon is malformed in some way. Points equal to the a given point will match, taking into account the fact that longitudes converge at the poles. Using the geospatial query constructors requires a valid geospatial license key; without a valid license key, searches that include geospatial queries will throw an exception.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-geospatial-query" target="mlserverdoc">cts:path-geospatial-query</a> server function.
  * @param pathExpression  One or more path expressions to match. When multiple path expressions are specified, the query matches if any path expression matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param region  One or more geographic boxes, circles, polygons, or points. Where multiple regions are specified, the query matches if any region matches.  (of <a href="{@docRoot}/doc-files/types/cts_region.html">cts:region</a>)
  * @param options  Options to this query. The default is (). Options include:   "coordinate-system=string" Use the given coordinate system. Valid values are:  wgs84The WGS84 coordinate system with degrees as the angular unit. wgs84/radiansThe WGS84 coordinate system with radians as the angular unit. wgs84/doubleThe WGS84 coordinate system at double precision with degrees as the angular unit. wgs84/radians/doubleThe WGS84 coordinate system at double precision with radians as the angular unit. etrs89The ETRS89 coordinate system. etrs89/doubleThe ETRS89 coordinate system at double precision. rawThe raw (unmapped) coordinate system. raw/doubleThe raw coordinate system at double precision.   "precision=value" Use the coordinate system at the given precision. Allowed values: float and double. "units=value" Measure distance and the radii of circles in the specified units. Allowed values: miles (default), km, feet, meters. "boundaries-included" Points on boxes', circles', and polygons' boundaries are counted as matching. This is the default. "boundaries-excluded" Points on boxes', circles', and polygons' boundaries are not counted as matching. "boundaries-latitude-excluded" Points on boxes' latitude boundaries are not counted as matching. "boundaries-longitude-excluded" Points on boxes' longitude boundaries are not counted as matching. "boundaries-south-excluded" Points on the boxes' southern boundaries are not counted as matching. "boundaries-west-excluded" Points on the boxes' western boundaries are not counted as matching. "boundaries-north-excluded" Points on the boxes' northern boundaries are not counted as matching. "boundaries-east-excluded" Points on the boxes' eastern boundaries are not counted as matching. "boundaries-circle-excluded" Points on circles' boundary are not counted as matching. "boundaries-endpoints-excluded" Points on linestrings' boundary (the endpoints) are not counted as matching. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "type=long-lat-point" Specifies the format for the point in the data as longitude first, latitude second. "type=point" Specifies the format for the point in the data as latitude first, longitude second. This is the default format. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $regions parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrence of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathGeospatialQuery(ServerExpression pathExpression, ServerExpression region, ServerExpression options, ServerExpression weight);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(String pathName, String operator, String value);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  *
  * <a name="ml-server-type-path-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(ServerExpression pathName, ServerExpression operator, ServerExpression value);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(String pathName, String operator, String value, String... options);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(ServerExpression pathName, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(String pathName, String operator, String value, String options, double weight);
/**
  * Returns a cts:query matching documents where the content addressed by an XPath expression satisfies the specified relationship (=, &lt;, &gt;, etc.) with respect to the input criteria values. A path range index must exist for each path when you perform a search.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-range-query" target="mlserverdoc">cts:path-range-query</a> server function.
  * @param pathName  One or more XPath expressions that identify the content to match. When multiple paths are specified, the query matches if any path matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. These values are compared to the value(s) addressed by the path-expression parameter. When multiple When multiple values are specified, the query matches if any value matches. The value must be a type for which there is a range index defined.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "collation=URI" Use the range index with the collation specified by URI. If not specified, then the default collation from the query is used. If a range index with the specified collation does not exist, an error is thrown. "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "cached-incremental" When querying on a short date or dateTime range, break the query into sub-queries on smaller ranges, and then cache the results of each. See the Usage Notes for details. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr pathRangeQuery(ServerExpression pathName, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(String pathExpression);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  *
  * <a name="ml-server-type-path-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(ServerExpression pathExpression);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(String pathExpression, String options);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(ServerExpression pathExpression, ServerExpression options);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param map  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(String pathExpression, String options, ServerExpression map);
/**
  * Creates a reference to a path value lexicon, for use as a parameter to cts:value-tuples. Since lexicons are implemented with range indexes, this function will throw an exception if the specified range index does not exist.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:path-reference" target="mlserverdoc">cts:path-reference</a> server function.
  * @param pathExpression  A path range index expression.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options. The default is ().  Options include:  "type=type" Use the lexicon with the type specified by type (int, unsignedInt, long, unsignedLong, float, double, decimal, dateTime, time, date, gYearMonth, gYear, gMonth, gDay, yearMonthDuration, dayTimeDuration, string, anyURI, point, or long-lat-point) "collation=URI" Use the lexicon with the collation specified by URI. "nullable" Allow null values in tuples reported from cts:value-tuples when using this lexicon. "unchecked" Read the scalar type, collation and coordinate-system info only from the input. Do not check the definition against the context database. "coordinate-system=name" Create a reference to an index or lexicon based on the specified coordinate system. Allowed values: "wgs84", "wgs84/double", "raw", "raw/double". Only applicable if the index/lexicon value type is point or long-lat-point. "precision=value" Create a reference to an index or lexicon configured with the specified geospatial precision. Allowed values: float and double. Only applicable if the index/lexicon value type is point or long-lat-point. This value takes precedence over the precision implicit in the coordinate system name.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param map  A map of namespace bindings. The keys should be namespace prefixes and the values should be namespace URIs. These namespace bindings will be added to the in-scope namespace bindings in the interpretation of the path.  (of <a href="{@docRoot}/doc-files/types/map_map.html">map:map</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr pathReference(ServerExpression pathExpression, ServerExpression options, ServerExpression map);
/**
  * Creates a period value, for use as a parameter to cts:period-range-query or cts:period-compare-query.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period" target="mlserverdoc">cts:period</a> server function.
  * @param start  The dateTime value indicating start of the period.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param end  The dateTime value indicating end of the period.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a> server data type
  */
  public CtsPeriodExpr period(String start, String end);
/**
  * Creates a period value, for use as a parameter to cts:period-range-query or cts:period-compare-query.
  *
  * <a name="ml-server-type-period"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period" target="mlserverdoc">cts:period</a> server function.
  * @param start  The dateTime value indicating start of the period.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @param end  The dateTime value indicating end of the period.  (of <a href="{@docRoot}/doc-files/types/xs_dateTime.html">xs:dateTime</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a> server data type
  */
  public CtsPeriodExpr period(ServerExpression start, ServerExpression end);
/**
  * Returns a cts:query matching documents that have relevant pair of period values. Searches with the cts:period-compare-query constructor require two valid names of period, if the either of the specified period does not exist, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-compare-query" target="mlserverdoc">cts:period-compare-query</a> server function.
  * @param axis1  Name of the first axis to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator. Period is the two timestamps contained in the axis.  Operators include:  "aln_equals" Match documents whose period1 equals period2. "aln_contains" Match documents whose period1 contains period2. i.e. period1 starts before period2 starts and ends before period2 ends. "aln_contained_by" Match documents whose period1 is contained by period2. "aln_meets" Match documents whose period1 meets period2, i.e. period1 ends at period2 start. "aln_met_by" Match documents whose period1 meets period2, i.e. period1 starts at period2 end. "aln_before" Match documents whose period1 is before period2, i.e. period1 ends before period2 starts. "aln_after" Match documents whose period1 is after period2, i.e. period1 starts after period2 ends. "aln_starts" Match documents whose period1 starts period2, i.e. period1 starts at period2 start and ends before period2 ends. "aln_started_by" Match documents whose period2 starts period1, i.e. period1 starts at period2 start and ends after period2 ends. "aln_finishes" Match documents whose period1 finishes period2, i.e. period1 finishes at period2 finish and starts after period2 starts. "aln_finished_by" Match documents whose period2 finishes period1, i.e. period1 finishes at period2 finish and starts before period2 starts. "aln_overlaps" Match documents whose period1 overlaps period2, i.e. period1 starts before period2 start and ends before period2 ends but after period2 starts. "aln_overlapped_by" Match documents whose period2 overlaps period1, i.e. period1 starts after period2 start but before period2 ends and ends after period2 ends. "iso_contains" Match documents whose period1 contains period2 in sql 2011 standard. i.e. period1 starts before or at period2 starts and ends after or at period2 ends. "iso_overlaps" Match documents whose period1 overlaps period2 in sql 2011 standard. i.e. period1 and period2 have common time period. "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds period2 in sql 2011 standard. i.e. period1 starts at period2 ends "iso_imm_precedes" Match documents whose period1 immediately precedes period2 in sql 2011 standard. i.e. period1 ends at period2 ends   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param axis2  Name of the second period to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodCompareQuery(String axis1, String operator, String axis2);
/**
  * Returns a cts:query matching documents that have relevant pair of period values. Searches with the cts:period-compare-query constructor require two valid names of period, if the either of the specified period does not exist, then an exception is thrown.
  *
  * <a name="ml-server-type-period-compare-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-compare-query" target="mlserverdoc">cts:period-compare-query</a> server function.
  * @param axis1  Name of the first axis to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator. Period is the two timestamps contained in the axis.  Operators include:  "aln_equals" Match documents whose period1 equals period2. "aln_contains" Match documents whose period1 contains period2. i.e. period1 starts before period2 starts and ends before period2 ends. "aln_contained_by" Match documents whose period1 is contained by period2. "aln_meets" Match documents whose period1 meets period2, i.e. period1 ends at period2 start. "aln_met_by" Match documents whose period1 meets period2, i.e. period1 starts at period2 end. "aln_before" Match documents whose period1 is before period2, i.e. period1 ends before period2 starts. "aln_after" Match documents whose period1 is after period2, i.e. period1 starts after period2 ends. "aln_starts" Match documents whose period1 starts period2, i.e. period1 starts at period2 start and ends before period2 ends. "aln_started_by" Match documents whose period2 starts period1, i.e. period1 starts at period2 start and ends after period2 ends. "aln_finishes" Match documents whose period1 finishes period2, i.e. period1 finishes at period2 finish and starts after period2 starts. "aln_finished_by" Match documents whose period2 finishes period1, i.e. period1 finishes at period2 finish and starts before period2 starts. "aln_overlaps" Match documents whose period1 overlaps period2, i.e. period1 starts before period2 start and ends before period2 ends but after period2 starts. "aln_overlapped_by" Match documents whose period2 overlaps period1, i.e. period1 starts after period2 start but before period2 ends and ends after period2 ends. "iso_contains" Match documents whose period1 contains period2 in sql 2011 standard. i.e. period1 starts before or at period2 starts and ends after or at period2 ends. "iso_overlaps" Match documents whose period1 overlaps period2 in sql 2011 standard. i.e. period1 and period2 have common time period. "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds period2 in sql 2011 standard. i.e. period1 starts at period2 ends "iso_imm_precedes" Match documents whose period1 immediately precedes period2 in sql 2011 standard. i.e. period1 ends at period2 ends   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param axis2  Name of the second period to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodCompareQuery(ServerExpression axis1, ServerExpression operator, ServerExpression axis2);
/**
  * Returns a cts:query matching documents that have relevant pair of period values. Searches with the cts:period-compare-query constructor require two valid names of period, if the either of the specified period does not exist, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-compare-query" target="mlserverdoc">cts:period-compare-query</a> server function.
  * @param axis1  Name of the first axis to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator. Period is the two timestamps contained in the axis.  Operators include:  "aln_equals" Match documents whose period1 equals period2. "aln_contains" Match documents whose period1 contains period2. i.e. period1 starts before period2 starts and ends before period2 ends. "aln_contained_by" Match documents whose period1 is contained by period2. "aln_meets" Match documents whose period1 meets period2, i.e. period1 ends at period2 start. "aln_met_by" Match documents whose period1 meets period2, i.e. period1 starts at period2 end. "aln_before" Match documents whose period1 is before period2, i.e. period1 ends before period2 starts. "aln_after" Match documents whose period1 is after period2, i.e. period1 starts after period2 ends. "aln_starts" Match documents whose period1 starts period2, i.e. period1 starts at period2 start and ends before period2 ends. "aln_started_by" Match documents whose period2 starts period1, i.e. period1 starts at period2 start and ends after period2 ends. "aln_finishes" Match documents whose period1 finishes period2, i.e. period1 finishes at period2 finish and starts after period2 starts. "aln_finished_by" Match documents whose period2 finishes period1, i.e. period1 finishes at period2 finish and starts before period2 starts. "aln_overlaps" Match documents whose period1 overlaps period2, i.e. period1 starts before period2 start and ends before period2 ends but after period2 starts. "aln_overlapped_by" Match documents whose period2 overlaps period1, i.e. period1 starts after period2 start but before period2 ends and ends after period2 ends. "iso_contains" Match documents whose period1 contains period2 in sql 2011 standard. i.e. period1 starts before or at period2 starts and ends after or at period2 ends. "iso_overlaps" Match documents whose period1 overlaps period2 in sql 2011 standard. i.e. period1 and period2 have common time period. "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds period2 in sql 2011 standard. i.e. period1 starts at period2 ends "iso_imm_precedes" Match documents whose period1 immediately precedes period2 in sql 2011 standard. i.e. period1 ends at period2 ends   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param axis2  Name of the second period to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodCompareQuery(String axis1, String operator, String axis2, String options);
/**
  * Returns a cts:query matching documents that have relevant pair of period values. Searches with the cts:period-compare-query constructor require two valid names of period, if the either of the specified period does not exist, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-compare-query" target="mlserverdoc">cts:period-compare-query</a> server function.
  * @param axis1  Name of the first axis to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator. Period is the two timestamps contained in the axis.  Operators include:  "aln_equals" Match documents whose period1 equals period2. "aln_contains" Match documents whose period1 contains period2. i.e. period1 starts before period2 starts and ends before period2 ends. "aln_contained_by" Match documents whose period1 is contained by period2. "aln_meets" Match documents whose period1 meets period2, i.e. period1 ends at period2 start. "aln_met_by" Match documents whose period1 meets period2, i.e. period1 starts at period2 end. "aln_before" Match documents whose period1 is before period2, i.e. period1 ends before period2 starts. "aln_after" Match documents whose period1 is after period2, i.e. period1 starts after period2 ends. "aln_starts" Match documents whose period1 starts period2, i.e. period1 starts at period2 start and ends before period2 ends. "aln_started_by" Match documents whose period2 starts period1, i.e. period1 starts at period2 start and ends after period2 ends. "aln_finishes" Match documents whose period1 finishes period2, i.e. period1 finishes at period2 finish and starts after period2 starts. "aln_finished_by" Match documents whose period2 finishes period1, i.e. period1 finishes at period2 finish and starts before period2 starts. "aln_overlaps" Match documents whose period1 overlaps period2, i.e. period1 starts before period2 start and ends before period2 ends but after period2 starts. "aln_overlapped_by" Match documents whose period2 overlaps period1, i.e. period1 starts after period2 start but before period2 ends and ends after period2 ends. "iso_contains" Match documents whose period1 contains period2 in sql 2011 standard. i.e. period1 starts before or at period2 starts and ends after or at period2 ends. "iso_overlaps" Match documents whose period1 overlaps period2 in sql 2011 standard. i.e. period1 and period2 have common time period. "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_succeeds" Match documents whose period1 succeeds period2 in sql 2011 standard. i.e. period1 starts at or after period2 ends "iso_precedes" Match documents whose period1 precedes period2 in sql 2011 standard. i.e. period1 ends at or before period2 ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds period2 in sql 2011 standard. i.e. period1 starts at period2 ends "iso_imm_precedes" Match documents whose period1 immediately precedes period2 in sql 2011 standard. i.e. period1 ends at period2 ends   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param axis2  Name of the second period to compare  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodCompareQuery(ServerExpression axis1, ServerExpression operator, ServerExpression axis2, ServerExpression options);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(String axis, String operator);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  *
  * <a name="ml-server-type-period-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(ServerExpression axis, ServerExpression operator);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param period  the cts:period to perform operations on. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(String axis, String operator, CtsPeriodExpr... period);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param period  the cts:period to perform operations on. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(ServerExpression axis, ServerExpression operator, ServerExpression period);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param period  the cts:period to perform operations on. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query.  zeroThis range query does not contribute to the score. This is the default.  "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(String axis, String operator, ServerExpression period, String options);
/**
  * Returns a cts:query matching axis by name with a period value with an operator. Searches with the cts:period-range-query constructor require a axis definition on the axis name; if there is no axis configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:period-range-query" target="mlserverdoc">cts:period-range-query</a> server function.
  * @param axis  One or more axis to match on.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param operator  A comparison operator.  Operators include:  "aln_equals" Match documents whose period1 equals value. "aln_contains" Match documents whose period1 contains value. i.e. period1 starts before value starts and ends before value ends. "aln_contained_by" Match documents whose period1 is contained by value. "aln_meets" Match documents whose period1 meets value, i.e. period1 ends at value start. "aln_met_by" Match documents whose period1 meets value, i.e. period1 starts at value end. "aln_before" Match documents whose period1 is before value, i.e. period1 ends before value starts. "aln_after" Match documents whose period1 is after value, i.e. period1 starts after value ends. "aln_starts" Match documents whose period1 starts value, i.e. period1 starts at value start and ends before value ends. "aln_started_by" Match documents whose value starts period1, i.e. period1 starts at value start and ends after value ends. "aln_finishes" Match documents whose period1 finishes value, i.e. period1 finishes at value finish and starts after value starts. "aln_finished_by" Match documents whose value finishes period1, i.e. period1 finishes at value finish and starts before value starts. "aln_overlaps" Match documents whose period1 overlaps value, i.e. period1 starts before value start and ends before value ends but after value starts. "aln_overlapped_by" Match documents whose value overlaps period1, i.e. period1 starts after value start but before value ends and ends after value ends. "iso_contains" Match documents whose period1 contains value in sql 2011 standard. i.e. period1 starts before or at value starts and ends after or at value ends. "iso_overlaps" Match documents whose period1 overlaps value in sql 2011 standard. i.e. period1 and value have common time period. "iso_succeeds" Match documents whose period1 succeeds value in sql 2011 standard. i.e. period1 starts at or after value ends "iso_precedes" Match documents whose period1 precedes value in sql 2011 standard. i.e. period1 ends at or before value ends "iso_imm_succeeds" Match documents whose period1 immediately succeeds value in sql 2011 standard. i.e. period1 starts at value end "iso_imm_precedes" Match documents whose period1 immediately precedes value in sql 2011 standard. i.e. period1 ends at value end   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param period  the cts:period to perform operations on. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/cts_period.html">cts:period</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query.  zeroThis range query does not contribute to the score. This is the default.  "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr periodRangeQuery(ServerExpression axis, ServerExpression operator, ServerExpression period, ServerExpression options);
/**
  * Returns a point value.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:point" target="mlserverdoc">cts:point</a> server function.
  * @param latitude  The latitude of the point.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param longitude  The longitude of the point.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a> server data type
  */
  public CtsPointExpr point(double latitude, double longitude);
/**
  * Returns a point value.
  *
  * <a name="ml-server-type-point"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:point" target="mlserverdoc">cts:point</a> server function.
  * @param latitude  The latitude of the point.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @param longitude  The longitude of the point.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a> server data type
  */
  public CtsPointExpr point(ServerExpression latitude, ServerExpression longitude);
/**
  * Returns a point's latitude value.
  *
  * <a name="ml-server-type-point-latitude"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:point-latitude" target="mlserverdoc">cts:point-latitude</a> server function.
  * @param point  The point.  (of <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression pointLatitude(ServerExpression point);
/**
  * Returns a point's longitude value.
  *
  * <a name="ml-server-type-point-longitude"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:point-longitude" target="mlserverdoc">cts:point-longitude</a> server function.
  * @param point  The point.  (of <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_numeric.html">xs:numeric</a> server data type
  */
  public ServerExpression pointLongitude(ServerExpression point);
/**
  * Returns a geospatial polygon value.
  *
  * <a name="ml-server-type-polygon"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:polygon" target="mlserverdoc">cts:polygon</a> server function.
  * @param vertices  The vertices of the polygon, given in order. No edge may cover more than 180 degrees of either latitude or longitude. The polygon as a whole may not encompass both poles. These constraints are necessary to ensure an unambiguous interpretation of the polygon. There must be at least three vertices. The first vertex should be identical to the last vertex to close the polygon. vertexes.  (of <a href="{@docRoot}/doc-files/types/cts_point.html">cts:point</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_polygon.html">cts:polygon</a> server data type
  */
  public CtsPolygonExpr polygon(ServerExpression vertices);
/**
  * Returns a query that matches all documents where query matches document-properties. When searching documents or document-locks, this query type provides a convenient way to additionally constrain the search against document-properties fragments.
  *
  * <a name="ml-server-type-properties-fragment-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:properties-fragment-query" target="mlserverdoc">cts:properties-fragment-query</a> server function.
  * @param query  A query to be matched against the properties fragment.  (of <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr propertiesFragmentQuery(ServerExpression query);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, String operator, String value);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  *
  * <a name="ml-server-type-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, ServerExpression operator, ServerExpression value);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, String operator, String value, String... options);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, ServerExpression operator, ServerExpression value, ServerExpression options);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, String operator, String value, String options, double weight);
/**
  * Returns a cts:query matching specified nodes with a range-index entry compared to a given value. Searches with the cts:range-query constructor require a range index; if there is no range index configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:range-query" target="mlserverdoc">cts:range-query</a> server function.
  * @param index  One or more range index references. When multiple indexes are specified, the query matches if any index matches.  (of <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a>)
  * @param operator  A comparison operator.  Operators include:  "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param value  One or more values to match. When multiple values are specified, the query matches if any value matches.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0. "synonym" Specifies that all of the terms in the $value parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr rangeQuery(ServerExpression index, ServerExpression operator, ServerExpression value, ServerExpression options, ServerExpression weight);
/**
  * Returns the stem(s) for a word.
  *
  * <a name="ml-server-type-stem"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:stem" target="mlserverdoc">cts:stem</a> server function.
  * @param text  A word or phrase to stem.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression stem(ServerExpression text);
/**
  * Returns the stem(s) for a word.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:stem" target="mlserverdoc">cts:stem</a> server function.
  * @param text  A word or phrase to stem.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for stemming. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression stem(ServerExpression text, String language);
/**
  * Returns the stem(s) for a word.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:stem" target="mlserverdoc">cts:stem</a> server function.
  * @param text  A word or phrase to stem.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for stemming. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression stem(ServerExpression text, ServerExpression language);
/**
  * Returns the stem(s) for a word.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:stem" target="mlserverdoc">cts:stem</a> server function.
  * @param text  A word or phrase to stem.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for stemming. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param partOfSpeech  A part of speech to use for stemming. The default is the unspecified part of speech. This parameter is for testing custom stemmers.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression stem(ServerExpression text, String language, String partOfSpeech);
/**
  * Returns the stem(s) for a word.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:stem" target="mlserverdoc">cts:stem</a> server function.
  * @param text  A word or phrase to stem.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for stemming. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param partOfSpeech  A part of speech to use for stemming. The default is the unspecified part of speech. This parameter is for testing custom stemmers.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression stem(ServerExpression text, ServerExpression language, ServerExpression partOfSpeech);
/**
  * Tokenizes text into words, punctuation, and spaces. Returns output in the type cts:token, which has subtypes cts:word, cts:punctuation, and cts:space, all of which are subtypes of xs:string.
  *
  * <a name="ml-server-type-tokenize"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:tokenize" target="mlserverdoc">cts:tokenize</a> server function.
  * @param text  A word or phrase to tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression tokenize(ServerExpression text);
/**
  * Tokenizes text into words, punctuation, and spaces. Returns output in the type cts:token, which has subtypes cts:word, cts:punctuation, and cts:space, all of which are subtypes of xs:string.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:tokenize" target="mlserverdoc">cts:tokenize</a> server function.
  * @param text  A word or phrase to tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for tokenization. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression tokenize(ServerExpression text, String language);
/**
  * Tokenizes text into words, punctuation, and spaces. Returns output in the type cts:token, which has subtypes cts:word, cts:punctuation, and cts:space, all of which are subtypes of xs:string.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:tokenize" target="mlserverdoc">cts:tokenize</a> server function.
  * @param text  A word or phrase to tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for tokenization. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression tokenize(ServerExpression text, ServerExpression language);
/**
  * Tokenizes text into words, punctuation, and spaces. Returns output in the type cts:token, which has subtypes cts:word, cts:punctuation, and cts:space, all of which are subtypes of xs:string.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:tokenize" target="mlserverdoc">cts:tokenize</a> server function.
  * @param text  A word or phrase to tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for tokenization. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param field  A field to use for tokenization. If the field has custom tokenization rules, they will be used. If no field is supplied or the field has no custom tokenization rules, the default tokenization rules are used.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression tokenize(ServerExpression text, String language, String field);
/**
  * Tokenizes text into words, punctuation, and spaces. Returns output in the type cts:token, which has subtypes cts:word, cts:punctuation, and cts:space, all of which are subtypes of xs:string.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:tokenize" target="mlserverdoc">cts:tokenize</a> server function.
  * @param text  A word or phrase to tokenize.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param language  A language to use for tokenization. If not supplied, it uses the database default language.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param field  A field to use for tokenization. If the field has custom tokenization rules, they will be used. If no field is supplied or the field has no custom tokenization rules, the default tokenization rules are used.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a> server data type
  */
  public ServerExpression tokenize(ServerExpression text, ServerExpression language, ServerExpression field);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(String subject, String predicate, String object);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  *
  * <a name="ml-server-type-triple-range-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(ServerExpression subject, ServerExpression predicate, ServerExpression object);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(String subject, String predicate, String object, String operator);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(ServerExpression subject, ServerExpression predicate, ServerExpression object, ServerExpression operator);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(String subject, String predicate, String object, String operator, String... options);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(ServerExpression subject, ServerExpression predicate, ServerExpression object, ServerExpression operator, ServerExpression options);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(String subject, String predicate, String object, String operator, String options, double weight);
/**
  * Returns a cts:query matching triples with a triple index entry equal to the given values. Searches with the cts:triple-range-query constructor require the triple index; if the triple index is not configured, then an exception is thrown.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:triple-range-query" target="mlserverdoc">cts:triple-range-query</a> server function.
  * @param subject  The subjects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any subject are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param predicate  The predicates to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any predicate are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param object  The objects to look up. When multiple values are specified, the query matches if any value matches. When the empty sequence is specified, then triples with any object are matched.  (of <a href="{@docRoot}/doc-files/types/xs_anyAtomicType.html">xs:anyAtomicType</a>)
  * @param operator  If a single string is provided it is treated as the operator for the $object values. If a sequence of three strings are provided, they give the operators for $subject, $predicate and $object in turn. The default operator is "=".  Operators include:  "sameTerm" Match triple index values which are the same RDF term as $value. This compares aspects of values that are ignored in XML Schema comparison semantics, like timezone and derived type of $value. "&lt;" Match range index values less than $value. "&lt;=" Match range index values less than or equal to $value. "&gt;" Match range index values greater than $value. "&gt;=" Match range index values greater than or equal to $value. "=" Match range index values equal to $value. "!=" Match range index values not equal to $value.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "cached" Cache the results of this query in the list cache. "uncached" Do not cache the results of this query in the list cache. "score-function=function" Use the selected scoring function. The score function may be:  linearUse a linear function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. reciprocalUse a reciprocal function of the difference between the specified query value and the matching value in the index to calculate a score for this range query. zeroThis range query does not contribute to the score. This is the default.   "slope-factor=number" Apply the given number as a scaling factor to the slope of the scoring function. The default is 1.0.   (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. The default is 1.0.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr tripleRangeQuery(ServerExpression subject, ServerExpression predicate, ServerExpression object, ServerExpression operator, ServerExpression options, ServerExpression weight);
/**
  * Returns a query that matches all fragments.
  *
  * <a name="ml-server-type-true-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:true-query" target="mlserverdoc">cts:true-query</a> server function.
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr trueQuery();
/**
  * Creates a reference to the URI lexicon, for use as a parameter to cts:value-tuples. This function requires the URI lexicon to be enabled, otherwise it throws an exception.
  *
  * <a name="ml-server-type-uri-reference"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:uri-reference" target="mlserverdoc">cts:uri-reference</a> server function.
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_reference.html">cts:reference</a> server data type
  */
  public CtsReferenceExpr uriReference();
/**
  * Returns a query matching text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(String text);
/**
  * Returns a query matching text content containing a given phrase.
  *
  * <a name="ml-server-type-word-query"></a>
  
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(ServerExpression text);
/**
  * Returns a query matching text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(String text, String... options);
/**
  * Returns a query matching text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(ServerExpression text, ServerExpression options);
/**
  * Returns a query matching text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(String text, String options, double weight);
/**
  * Returns a query matching text content containing a given phrase.
  * <p>
  * Provides a client interface to the <a href="http://docs.marklogic.com/cts:word-query" target="mlserverdoc">cts:word-query</a> server function.
  * @param text  Some words or phrases to match. When multiple strings are specified, the query matches if any string matches.  (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param options  Options to this query. The default is ().  Options include:  "case-sensitive" A case-sensitive query. "case-insensitive" A case-insensitive query. "diacritic-sensitive" A diacritic-sensitive query. "diacritic-insensitive" A diacritic-insensitive query. "punctuation-sensitive" A punctuation-sensitive query. "punctuation-insensitive" A punctuation-insensitive query. "whitespace-sensitive" A whitespace-sensitive query. "whitespace-insensitive" A whitespace-insensitive query. "stemmed" A stemmed query. "unstemmed" An unstemmed query. "wildcarded" A wildcarded query. "unwildcarded" An unwildcarded query. "exact" An exact match query. Shorthand for "case-sensitive", "diacritic-sensitive", "punctuation-sensitive", "whitespace-sensitive", "unstemmed", and "unwildcarded".  "lang=iso639code" Specifies the language of the query. The iso639code code portion is case-insensitive, and uses the languages specified by ISO 639. The default is specified in the database configuration. "distance-weight=number" A weight applied based on the minimum distance between matches of this query. Higher weights add to the importance of proximity (as opposed to term matches) when the relevance order is calculated. The default value is 0.0 (no impact of proximity). The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. This parameter has no effect if the word positions index is not enabled. This parameter has no effect on searches that use score-simple, score-random, or score-zero (because those scoring algorithms do not consider term frequency, proximity is irrelevant).  "min-occurs=number" Specifies the minimum number of occurrences required. If fewer that this number of words occur, the fragment does not match. The default is 1. "max-occurs=number" Specifies the maximum number of occurrences required. If more than this number of words occur, the fragment does not match. The default is unbounded. "synonym" Specifies that all of the terms in the $text parameter are considered synonyms for scoring purposes. The result is that occurrences of more than one of the synonyms are scored as if there are more occurrences of the same term (as opposed to having a separate term that contributes to score).  "lexicon-expand=value" The value is one of full, prefix-postfix, off, or heuristic (the default is heuristic). An option with a value of lexicon-expand=full specifies that wildcards are resolved by expanding the pattern to words in a lexicon (if there is one available), and turning into a series of cts:word-queries, even if this takes a long time to evaluate. An option with a value of lexicon-expand=prefix-postfix specifies that wildcards are resolved by expanding the pattern to the pre- and postfixes of the words in the word lexicon (if there is one), and turning the query into a series of character queries, even if it takes a long time to evaluate. An option with a value of lexicon-expand=off specifies that wildcards are only resolved by looking up character patterns in the search pattern index, not in the lexicon. An option with a value of lexicon-expand=heuristic, which is the default, specifies that wildcards are resolved by using a series of internal rules, such as estimating the number of lexicon entries that need to be scanned, seeing if the estimate crosses certain thresholds, and (if appropriate), using another way besides lexicon expansion to resolve the query.  "lexicon-expansion-limit=number" Specifies the limit for lexicon expansion. This puts a restriction on the number of lexicon expansions that can be performed. If the limit is exceeded, the server may raise an error depending on whether the "limit-check" option is set. The default value for this option will be 4096.  "limit-check" Specifies that an error will be raised if the lexicon expansion exceeds the specified limit. "no-limit-check" Specifies that error will not be raised if the lexicon expansion exceeds the specified limit. The server will try to resolve the wildcard.    (of <a href="{@docRoot}/doc-files/types/xs_string.html">xs:string</a>)
  * @param weight  A weight for this query. Higher weights move search results up in the relevance order. The default is 1.0. The weight should be between 64 and -16. Weights greater than 64 will have the same effect as a weight of 64. Weights less than the absolute value of 0.0625 (between -0.0625 and 0.0625) are rounded to 0, which means that they do not contribute to the score.  (of <a href="{@docRoot}/doc-files/types/xs_double.html">xs:double</a>)
  * @return  a server expression with the <a href="{@docRoot}/doc-files/types/cts_query.html">cts:query</a> server data type
  */
  public CtsQueryExpr wordQuery(ServerExpression text, ServerExpression options, ServerExpression weight);
/**
  * Constructs a sequence of CtsBoxExpr items.
  * @param items  the CtsBoxExpr items collected by the sequence
  * @return  a CtsBoxSeqExpr sequence
  */
  public CtsBoxSeqExpr boxSeq(CtsBoxExpr... items);
 
/**
  * Constructs a sequence of CtsCircleExpr items.
  * @param items  the CtsCircleExpr items collected by the sequence
  * @return  a CtsCircleSeqExpr sequence
  */
  public CtsCircleSeqExpr circleSeq(CtsCircleExpr... items);

/**
  * Constructs a sequence of CtsPeriodExpr items.
  * @param items  the CtsPeriodExpr items collected by the sequence
  * @return  a CtsPeriodSeqExpr sequence
  */
  public CtsPeriodSeqExpr periodSeq(CtsPeriodExpr... items);
 
/**
  * Constructs a sequence of CtsPointExpr items.
  * @param items  the CtsPointExpr items collected by the sequence
  * @return  a CtsPointSeqExpr sequence
  */
  public CtsPointSeqExpr pointSeq(CtsPointExpr... items);
 
/**
  * Constructs a sequence of CtsPolygonExpr items.
  * @param items  the CtsPolygonExpr items collected by the sequence
  * @return  a CtsPolygonSeqExpr sequence
  */
  public CtsPolygonSeqExpr polygonSeq(CtsPolygonExpr... items);
 
/**
  * Constructs a sequence of CtsQueryExpr items.
  * @param items  the CtsQueryExpr items collected by the sequence
  * @return  a CtsQuerySeqExpr sequence
  */
  public CtsQuerySeqExpr querySeq(CtsQueryExpr... items);
 
/**
  * Constructs a sequence of CtsReferenceExpr items.
  * @param items  the CtsReferenceExpr items collected by the sequence
  * @return  a CtsReferenceSeqExpr sequence
  */
  public CtsReferenceSeqExpr referenceSeq(CtsReferenceExpr... items);
 
/**
  * Constructs a sequence of CtsRegionExpr items.
  * @param items  the CtsRegionExpr items collected by the sequence
  * @return  a CtsRegionSeqExpr sequence
  */
  public CtsRegionSeqExpr regionSeq(CtsRegionExpr... items);

}
