/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.extra.httpclient.HttpClientConfigurator;
import com.marklogic.client.extra.okhttpclient.OkHttpClientConfigurator;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.impl.DatabaseClientPropertySource;
import com.marklogic.client.impl.HandleFactoryRegistryImpl;
import com.marklogic.client.impl.OkHttpServices;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class DatabaseClientFactory {
    private static List<ClientConfigurator<?>> clientConfigurators = new ArrayList();
    private static HandleFactoryRegistry handleRegistry = HandleFactoryRegistryImpl.newDefault();

    private DatabaseClientFactory() {
    }

    public static DatabaseClient newClient(Function<String, Object> propertySource) {
        return new DatabaseClientPropertySource(propertySource).newClient();
    }

    public static DatabaseClient newClient(String host, int port, SecurityContext securityContext) {
        return DatabaseClientFactory.newClient(host, port, null, securityContext, null);
    }

    public static DatabaseClient newClient(String host, int port, SecurityContext securityContext, DatabaseClient.ConnectionType connectionType) {
        return DatabaseClientFactory.newClient(host, port, null, securityContext, connectionType);
    }

    public static DatabaseClient newClient(String host, int port, String database, SecurityContext securityContext) {
        return DatabaseClientFactory.newClient(host, port, database, securityContext, null);
    }

    public static DatabaseClient newClient(String host, int port, String database, SecurityContext securityContext, DatabaseClient.ConnectionType connectionType) {
        return DatabaseClientFactory.newClient(host, port, null, database, securityContext, connectionType);
    }

    public static DatabaseClient newClient(String host, int port, String basePath, String database, SecurityContext securityContext, DatabaseClient.ConnectionType connectionType) {
        OkHttpServices services = new OkHttpServices();
        if (securityContext instanceof MarkLogicCloudAuthContext) {
            port = 443;
        }
        services.connect(host, port, basePath, database, securityContext);
        if (clientConfigurators != null) {
            clientConfigurators.forEach(configurator -> {
                if (configurator instanceof OkHttpClientConfigurator) {
                    OkHttpClient okHttpClient = (OkHttpClient)services.getClientImplementation();
                    OkHttpClient.Builder clientBuilder = okHttpClient.newBuilder();
                    ((OkHttpClientConfigurator)configurator).configure(clientBuilder);
                    ((OkHttpServices)services).setClientImplementation(clientBuilder.build());
                } else if (!(configurator instanceof HttpClientConfigurator)) {
                    throw new IllegalArgumentException("A ClientConfigurator must implement OkHttpClientConfigurator");
                }
            });
        }
        DatabaseClientImpl client = new DatabaseClientImpl(services, host, port, basePath, database, securityContext, connectionType);
        client.setHandleRegistry(DatabaseClientFactory.getHandleRegistry().copy());
        return client;
    }

    private static SecurityContext makeSecurityContext(String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        if (Authentication.BASIC == type) {
            return new BasicAuthContext(user, password).withSSLContext(context).withSSLHostnameVerifier(verifier);
        }
        if (Authentication.DIGEST == type) {
            return new DigestAuthContext(user, password).withSSLContext(context).withSSLHostnameVerifier(verifier);
        }
        throw new IllegalStateException("makeSecurityContext should only be called with BASIC or DIGEST Authentication");
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type) {
        return DatabaseClientFactory.newClient(host, port, null, DatabaseClientFactory.makeSecurityContext(user, password, type, null, null), null);
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type) {
        return DatabaseClientFactory.newClient(host, port, database, DatabaseClientFactory.makeSecurityContext(user, password, type, null, null), null);
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type, SSLContext context) {
        return DatabaseClientFactory.newClient(host, port, null, DatabaseClientFactory.makeSecurityContext(user, password, type, context, SSLHostnameVerifier.COMMON), null);
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type, SSLContext context) {
        return DatabaseClientFactory.newClient(host, port, database, DatabaseClientFactory.makeSecurityContext(user, password, type, context, SSLHostnameVerifier.COMMON), null);
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        return DatabaseClientFactory.newClient(host, port, null, DatabaseClientFactory.makeSecurityContext(user, password, type, context, verifier), null);
    }

    @Deprecated
    public static DatabaseClient newClient(String host, int port, String database, String user, String password, Authentication type, SSLContext context, SSLHostnameVerifier verifier) {
        return DatabaseClientFactory.newClient(host, port, database, DatabaseClientFactory.makeSecurityContext(user, password, type, context, verifier), null);
    }

    public static HandleFactoryRegistry getHandleRegistry() {
        return handleRegistry;
    }

    public static void clearHandleRegistry() {
        handleRegistry = new HandleFactoryRegistryImpl();
    }

    public static void registerDefaultHandles() {
        HandleFactoryRegistryImpl.registerDefaults(DatabaseClientFactory.getHandleRegistry());
    }

    public static void addConfigurator(ClientConfigurator<?> configurator) {
        if (!HttpClientConfigurator.class.isInstance(configurator) && !OkHttpClientConfigurator.class.isInstance(configurator)) {
            throw new IllegalArgumentException("Configurator must implement OkHttpClientConfigurator");
        }
        clientConfigurators.add(configurator);
    }

    public static void removeConfigurators() {
        clientConfigurators.clear();
    }

    public static class Bean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String host;
        private int port;
        private String basePath;
        private String database;
        private String user;
        private String password;
        private Authentication authentication;
        private String externalName;
        private DatabaseClient.ConnectionType connectionType;
        private transient SecurityContext securityContext;
        private transient HandleFactoryRegistry handleRegistry = HandleFactoryRegistryImpl.newDefault();
        private transient SSLContext context;
        private transient SSLHostnameVerifier verifier;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Deprecated
        public String getUser() {
            return this.user;
        }

        @Deprecated
        public void setUser(String user) {
            this.user = user;
        }

        @Deprecated
        public String getPassword() {
            return this.password;
        }

        @Deprecated
        public void setPassword(String password) {
            this.password = password;
        }

        @Deprecated
        public String getExternalName() {
            return this.externalName;
        }

        @Deprecated
        public void setExternalName(String externalName) {
            this.externalName = externalName;
        }

        @Deprecated
        public Authentication getAuthentication() {
            return this.authentication;
        }

        @Deprecated
        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        @Deprecated
        public void setAuthenticationValue(String authentication) {
            this.authentication = Authentication.valueOfUncased(authentication);
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        @Deprecated
        public SSLContext getContext() {
            return this.context;
        }

        @Deprecated
        public void setContext(SSLContext context) {
            this.context = context;
        }

        @Deprecated
        public SSLHostnameVerifier getVerifier() {
            return this.verifier;
        }

        @Deprecated
        public void setVerifier(SSLHostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        public void setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        public DatabaseClient.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        public void setConnectionType(DatabaseClient.ConnectionType connectionType) {
            this.connectionType = connectionType;
        }

        public HandleFactoryRegistry getHandleRegistry() {
            return this.handleRegistry;
        }

        public void clearHandleRegistry() {
            this.handleRegistry = new HandleFactoryRegistryImpl();
        }

        public void registerDefaultHandles() {
            HandleFactoryRegistryImpl.registerDefaults(this.getHandleRegistry());
        }

        public DatabaseClient newClient() {
            DatabaseClientImpl client = (DatabaseClientImpl)DatabaseClientFactory.newClient(this.host, this.port, this.basePath, this.database, this.securityContext != null ? this.securityContext : DatabaseClientFactory.makeSecurityContext(this.user, this.password, this.authentication, this.context, this.verifier), this.connectionType);
            client.setHandleRegistry(this.getHandleRegistry().copy());
            return client;
        }
    }

    public static class CertificateAuthContext
    extends AuthContext {
        String certFile;
        String certPassword;

        @Deprecated
        public CertificateAuthContext(SSLContext context) {
            this.sslContext = context;
        }

        public CertificateAuthContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
        }

        @Deprecated
        public CertificateAuthContext(SSLContext context, SSLHostnameVerifier verifier) {
            this.sslContext = context;
            this.sslVerifier = verifier;
        }

        public CertificateAuthContext(SSLContext context, SSLHostnameVerifier verifier, X509TrustManager trustManager) {
            this.sslContext = context;
            this.sslVerifier = verifier;
            this.trustManager = trustManager;
        }

        @Deprecated
        public CertificateAuthContext(String certFile) throws CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            this.certFile = certFile;
            this.certPassword = "";
            this.sslContext = this.createSSLContext();
        }

        public CertificateAuthContext(String certFile, X509TrustManager trustManager) throws CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            this.certFile = certFile;
            this.trustManager = trustManager;
            this.certPassword = "";
            this.sslContext = this.createSSLContext();
        }

        @Deprecated
        public CertificateAuthContext(String certFile, String certPassword) throws CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            this.certFile = certFile;
            this.certPassword = certPassword;
            this.sslContext = this.createSSLContext();
        }

        public CertificateAuthContext(String certFile, String certPassword, X509TrustManager trustManager) throws CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            this.certFile = certFile;
            this.certPassword = certPassword;
            this.trustManager = trustManager;
            this.sslContext = this.createSSLContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SSLContext createSSLContext() throws CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            TrustManager[] trustManagerArray;
            if (this.certPassword == null) {
                throw new IllegalArgumentException("Certificate export password must not be null");
            }
            KeyStore keyStore = null;
            KeyManagerFactory keyManagerFactory = null;
            KeyManager[] keyMgr = null;
            try {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("CertificateAuthContext requires KeyManagerFactory.getInstance(\"SunX509\")");
            }
            try {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("CertificateAuthContext requires KeyStore.getInstance(\"PKCS12\")");
            }
            try {
                try (FileInputStream certFileStream = new FileInputStream(this.certFile);){
                    keyStore.load(certFileStream, this.certPassword.toCharArray());
                }
                keyManagerFactory.init(keyStore, this.certPassword.toCharArray());
                keyMgr = keyManagerFactory.getKeyManagers();
                this.sslContext = SSLContext.getInstance("TLSv1.2");
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("The certificate algorithm used or the Key store Service provider Implementaion (SPI) is invalid. CertificateAuthContext requires SunX509 algorithm and PKCS12 Key store SPI", e);
            }
            if (this.trustManager == null) {
                trustManagerArray = null;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = this.trustManager;
            }
            TrustManager[] trustManagers = trustManagerArray;
            this.sslContext.init(keyMgr, trustManagers, null);
            return this.sslContext;
        }

        @Override
        public CertificateAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }

        public String getCertificate() {
            return this.certFile;
        }

        public String getCertificatePassword() {
            return this.certPassword;
        }
    }

    public static class KerberosConfig {
        private boolean refreshKrb5Config;
        private String principal = null;
        private boolean useTicketCache = true;
        private String ticketCache = null;
        private boolean renewTGT = false;
        private boolean doNotPrompt = true;
        private boolean useKeyTab = false;
        private String keyTab = null;
        private boolean storeKey = false;
        private boolean isInitiator = true;
        private boolean useFirstPass = false;
        private boolean tryFirstPass = false;
        private boolean storePass = false;
        private boolean clearPass = false;
        private boolean debug = false;

        public KerberosConfig withRefreshKrb5Config(boolean refreshKrb5Config) {
            this.refreshKrb5Config = refreshKrb5Config;
            return this;
        }

        public String getRefreshKrb5Config() {
            return String.valueOf(this.refreshKrb5Config);
        }

        public KerberosConfig withPrincipal(String principal) {
            this.principal = principal;
            return this;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public KerberosConfig withUseTicketCache(boolean useTicketCache) {
            this.useTicketCache = useTicketCache;
            return this;
        }

        public String getUseTicketCache() {
            return String.valueOf(this.useTicketCache);
        }

        public KerberosConfig withTicketCache(String ticketCache) {
            this.ticketCache = ticketCache;
            return this;
        }

        public String getTicketCache() {
            return this.ticketCache;
        }

        public KerberosConfig withRenewTGT(boolean renewTGT) {
            this.renewTGT = renewTGT;
            return this;
        }

        public String getRenewTGT() {
            return String.valueOf(this.renewTGT);
        }

        public KerberosConfig withDoNotPrompt(boolean doNotPrompt) {
            this.doNotPrompt = doNotPrompt;
            return this;
        }

        public String getDoNotPrompt() {
            return String.valueOf(this.doNotPrompt);
        }

        public KerberosConfig withUseKeyTab(boolean useKeyTab) {
            this.useKeyTab = useKeyTab;
            return this;
        }

        public String getUseKeyTab() {
            return String.valueOf(this.useKeyTab);
        }

        public KerberosConfig withKeyTab(String keyTab) {
            this.keyTab = keyTab;
            return this;
        }

        public String getKeyTab() {
            return this.keyTab;
        }

        public KerberosConfig withStoreKey(boolean storeKey) {
            this.storeKey = storeKey;
            return this;
        }

        public String getStoreKey() {
            return String.valueOf(this.storeKey);
        }

        public KerberosConfig withUseFirstPass(boolean useFirstPass) {
            this.useFirstPass = useFirstPass;
            return this;
        }

        public String getUseFirstPass() {
            return String.valueOf(this.useFirstPass);
        }

        public KerberosConfig withTryFirstPass(boolean tryFirstPass) {
            this.tryFirstPass = tryFirstPass;
            return this;
        }

        public String getTryFirstPass() {
            return String.valueOf(this.tryFirstPass);
        }

        public KerberosConfig withStorePass(boolean storePass) {
            this.storePass = storePass;
            return this;
        }

        public String getStorePass() {
            return String.valueOf(this.storePass);
        }

        public KerberosConfig withClearPass(boolean clearPass) {
            this.clearPass = clearPass;
            return this;
        }

        public String getClearPass() {
            return String.valueOf(this.clearPass);
        }

        public KerberosConfig withInitiator(boolean initiator) {
            this.isInitiator = initiator;
            return this;
        }

        public String getInitiator() {
            return String.valueOf(this.isInitiator);
        }

        public KerberosConfig withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public String getDebug() {
            return String.valueOf(this.debug);
        }

        public Map<String, String> toOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("refreshKrb5Config", this.getRefreshKrb5Config());
            if (this.getPrincipal() != null) {
                options.put("principal", this.getPrincipal());
            }
            options.put("useTicketCache", this.getUseTicketCache());
            if (this.getUseTicketCache().equals("true") && this.getTicketCache() != null) {
                options.put("ticketCache", this.getTicketCache());
            }
            options.put("renewTGT", this.getRenewTGT());
            options.put("doNotPrompt", this.getDoNotPrompt());
            options.put("useKeyTab", this.getUseKeyTab());
            if (this.getUseKeyTab().equals("true") && this.getKeyTab() != null) {
                options.put("keyTab", this.getKeyTab());
            }
            options.put("storeKey", this.getStoreKey());
            options.put("useFirstPass", this.getUseFirstPass());
            options.put("tryFirstPass", this.getTryFirstPass());
            options.put("storePass", this.getStorePass());
            options.put("clearPass", this.getClearPass());
            options.put("isInitiator", this.getInitiator());
            options.put("debug", this.getDebug());
            return options;
        }
    }

    public static class SAMLAuthContext
    implements SecurityContext {
        private String token;
        private SSLContext sslContext;
        private X509TrustManager trustManager;
        private SSLHostnameVerifier sslVerifier;
        private AuthorizerCallback authorizer;
        private ExpiringSAMLAuth authorization;
        private RenewerCallback renewer;

        public SAMLAuthContext(String authorizationToken) {
            this.token = authorizationToken;
        }

        public SAMLAuthContext(AuthorizerCallback authorizer) {
            this.authorizer = authorizer;
        }

        public SAMLAuthContext(ExpiringSAMLAuth authorization, RenewerCallback renewer) {
            this.authorization = authorization;
            this.renewer = renewer;
        }

        public String getToken() {
            if (this.token == null && this.authorization != null) {
                return this.authorization.getAuthorizationToken();
            }
            return this.token;
        }

        public AuthorizerCallback getAuthorizer() {
            return this.authorizer;
        }

        public RenewerCallback getRenewer() {
            return this.renewer;
        }

        public ExpiringSAMLAuth getAuthorization() {
            return this.authorization;
        }

        public static ExpiringSAMLAuth newExpiringSAMLAuth(final String authorizationToken, final Instant expiry) {
            return new ExpiringSAMLAuth(){

                @Override
                public Instant getExpiry() {
                    return expiry;
                }

                @Override
                public String getAuthorizationToken() {
                    return authorizationToken;
                }
            };
        }

        @Override
        public SAMLAuthContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }

        @Override
        public SAMLAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }

        @Override
        public X509TrustManager getTrustManager() {
            return this.trustManager;
        }

        @Override
        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        @Override
        @Deprecated
        public void setSSLContext(SSLContext context) {
            this.sslContext = context;
        }

        @Override
        public SSLHostnameVerifier getSSLHostnameVerifier() {
            return this.sslVerifier;
        }

        @Override
        public void setSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
        }

        @Override
        @Deprecated
        public SecurityContext withSSLContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        @FunctionalInterface
        public static interface RenewerCallback
        extends Function<ExpiringSAMLAuth, Instant> {
        }

        @FunctionalInterface
        public static interface AuthorizerCallback
        extends Function<ExpiringSAMLAuth, ExpiringSAMLAuth> {
        }

        public static interface ExpiringSAMLAuth {
            public String getAuthorizationToken();

            public Instant getExpiry();
        }
    }

    public static class KerberosAuthContext
    extends AuthContext {
        Map<String, String> krbOptions;

        public Map<String, String> getKrbOptions() {
            return this.krbOptions;
        }

        public KerberosAuthContext() {
            this.krbOptions = Collections.unmodifiableMap(new KerberosConfig().toOptions());
        }

        public KerberosAuthContext(String principal) {
            this.krbOptions = Collections.unmodifiableMap(new KerberosConfig().withPrincipal(principal).toOptions());
        }

        public KerberosAuthContext(KerberosConfig krbConfig) {
            this.krbOptions = Collections.unmodifiableMap(krbConfig.toOptions());
        }

        @Override
        @Deprecated
        public KerberosAuthContext withSSLContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        @Override
        public KerberosAuthContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }

        @Override
        public KerberosAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }
    }

    public static class DigestAuthContext
    extends AuthContext {
        String user;
        String password;

        public DigestAuthContext(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        @Override
        @Deprecated
        public DigestAuthContext withSSLContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        @Override
        public DigestAuthContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }

        @Override
        public DigestAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }
    }

    public static class BasicAuthContext
    extends AuthContext {
        String user;
        String password;

        public BasicAuthContext(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        @Override
        @Deprecated
        public BasicAuthContext withSSLContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        @Override
        public BasicAuthContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }

        @Override
        public BasicAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }
    }

    public static class MarkLogicCloudAuthContext
    extends AuthContext {
        private String tokenEndpoint;
        private String grantType;
        private String apiKey;
        private Integer tokenDuration;

        public MarkLogicCloudAuthContext(String apiKey) {
            this(apiKey, null);
        }

        public MarkLogicCloudAuthContext(String apiKey, Integer tokenDuration) {
            this(apiKey, "/token", "apikey", tokenDuration);
        }

        public MarkLogicCloudAuthContext(String apiKey, String tokenEndpoint, String grantType) {
            this(apiKey, tokenEndpoint, grantType, null);
        }

        public MarkLogicCloudAuthContext(String apiKey, String tokenEndpoint, String grantType, Integer tokenDuration) {
            this.apiKey = apiKey;
            this.tokenEndpoint = tokenEndpoint;
            this.grantType = grantType;
            this.tokenDuration = tokenDuration;
        }

        public String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public String getGrantType() {
            return this.grantType;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public Integer getTokenDuration() {
            return this.tokenDuration;
        }

        @Override
        public MarkLogicCloudAuthContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }

        @Override
        public MarkLogicCloudAuthContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }
    }

    private static class AuthContext
    implements SecurityContext {
        SSLContext sslContext;
        X509TrustManager trustManager;
        SSLHostnameVerifier sslVerifier;

        private AuthContext() {
        }

        @Override
        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        @Override
        @Deprecated
        public void setSSLContext(SSLContext context) {
            this.sslContext = context;
        }

        @Override
        public SSLHostnameVerifier getSSLHostnameVerifier() {
            return this.sslVerifier;
        }

        @Override
        public void setSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
        }

        @Override
        public X509TrustManager getTrustManager() {
            return this.trustManager;
        }

        @Override
        @Deprecated
        public SecurityContext withSSLContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        @Override
        public SecurityContext withSSLHostnameVerifier(SSLHostnameVerifier verifier) {
            this.sslVerifier = verifier;
            return this;
        }

        @Override
        public SecurityContext withSSLContext(SSLContext context, X509TrustManager trustManager) {
            this.sslContext = context;
            this.trustManager = trustManager;
            return this;
        }
    }

    public static interface SecurityContext {
        public SSLContext getSSLContext();

        public X509TrustManager getTrustManager();

        @Deprecated
        public void setSSLContext(SSLContext var1);

        public SSLHostnameVerifier getSSLHostnameVerifier();

        public void setSSLHostnameVerifier(SSLHostnameVerifier var1);

        @Deprecated
        public SecurityContext withSSLContext(SSLContext var1);

        public SecurityContext withSSLContext(SSLContext var1, X509TrustManager var2);

        public SecurityContext withSSLHostnameVerifier(SSLHostnameVerifier var1);
    }

    public static interface ClientConfigurator<T> {
        public void configure(T var1);
    }

    public static interface HandleFactoryRegistry {
        public void register(ContentHandleFactory var1);

        public void register(ContentHandleFactory var1, Class<?> ... var2);

        public boolean isRegistered(Class<?> var1);

        public Set<Class<?>> listRegistered();

        public <C> ContentHandle<C> makeHandle(Class<C> var1);

        public void unregister(Class<?> ... var1);

        public HandleFactoryRegistry copy();
    }

    public static interface SSLHostnameVerifier {
        public static final Builtin ANY = new Builtin("ANY");
        public static final Builtin COMMON = new Builtin("COMMON");
        public static final Builtin STRICT = new Builtin("STRICT");

        public void verify(String var1, String[] var2, String[] var3) throws SSLException;

        public static class Builtin
        implements SSLHostnameVerifier {
            private String name;

            private Builtin(String name) {
                this.name = name;
            }

            @Override
            public void verify(String hostname, String[] cns, String[] subjectAlts) throws SSLException {
                throw new MarkLogicInternalException("SSLHostnameVerifier.Builtin called directly instead of passed as parameter");
            }

            public String getName() {
                return this.name;
            }
        }

        public static class HostnameVerifierAdapter
        implements HostnameVerifier {
            private SSLHostnameVerifier verifier;

            public HostnameVerifierAdapter(SSLHostnameVerifier verifier) {
                this.verifier = verifier;
            }

            @Override
            public boolean verify(String hostname, SSLSession session) {
                try {
                    Certificate[] certificates = session.getPeerCertificates();
                    this.verify(hostname, (X509Certificate)(certificates == null || certificates.length == 0 ? null : certificates[0]));
                    return true;
                }
                catch (SSLException e) {
                    return false;
                }
            }

            public void verify(String hostname, X509Certificate cert) throws SSLException {
                ArrayList<String> cnArray = new ArrayList<String>();
                try {
                    LdapName ldapDN = new LdapName(cert.getSubjectX500Principal().getName());
                    for (Rdn rdn : ldapDN.getRdns()) {
                        Object value = rdn.getValue();
                        if (!"CN".equalsIgnoreCase(rdn.getType()) || !(value instanceof String)) continue;
                        cnArray.add((String)value);
                    }
                    int type_dnsName = 2;
                    int type_ipAddress = 7;
                    ArrayList<String> subjectAltArray = new ArrayList<String>();
                    Collection<List<?>> alts = cert.getSubjectAlternativeNames();
                    if (alts != null) {
                        for (List<?> alt : alts) {
                            Integer type;
                            if (alt == null || alt.size() != 2 || !(alt.get(1) instanceof String) || (type = (Integer)alt.get(0)) != type_dnsName && type != type_ipAddress) continue;
                            subjectAltArray.add((String)alt.get(1));
                        }
                    }
                    String[] cns = cnArray.toArray(new String[cnArray.size()]);
                    String[] subjectAlts = subjectAltArray.toArray(new String[subjectAltArray.size()]);
                    this.verifier.verify(hostname, cns, subjectAlts);
                }
                catch (CertificateParsingException e) {
                    throw new MarkLogicIOException(e);
                }
                catch (InvalidNameException e) {
                    throw new MarkLogicIOException(e);
                }
            }
        }
    }

    @Deprecated
    public static enum Authentication {
        BASIC,
        DIGEST,
        KERBEROS,
        CERTIFICATE,
        SAML;


        public static Authentication valueOfUncased(String name) {
            return Authentication.valueOf(name.toUpperCase());
        }
    }
}

