/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.query;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.AbstractQueryDefinition;
import com.marklogic.client.impl.RawQueryDefinitionImpl;
import com.marklogic.client.impl.XmlFactories;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.util.EditableNamespaceContext;
import com.marklogic.client.util.IterableNamespaceContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Templates;

public class StructuredQueryBuilder {
    public static final String SEARCH_API_NS = "http://marklogic.com/appservices/search";
    private static final Map<String, String> reserved = new HashMap<String, String>();
    private static Templates extractor;
    private String builderOptionsURI = null;
    private IterableNamespaceContext namespaces;

    public StructuredQueryBuilder() {
        this((IterableNamespaceContext)null);
    }

    public StructuredQueryBuilder(String optionsName) {
        this((IterableNamespaceContext)null);
        this.builderOptionsURI = optionsName;
    }

    public StructuredQueryBuilder(IterableNamespaceContext namespaces) {
        this.setNamespaces(namespaces);
    }

    public StructuredQueryBuilder(String optionsName, IterableNamespaceContext namespaces) {
        this(namespaces);
        this.builderOptionsURI = optionsName;
    }

    public RawStructuredQueryDefinition build(StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new RawQueryDefinitionImpl.Structured(new StructuredQueryXMLWriter(queries), this.builderOptionsURI);
    }

    public StructuredQueryDefinition and(StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new AndQuery(queries);
    }

    public StructuredQueryDefinition or(StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new OrQuery(queries);
    }

    public StructuredQueryDefinition not(StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new NotQuery(query);
    }

    public StructuredQueryDefinition andNot(StructuredQueryDefinition positive, StructuredQueryDefinition negative) {
        this.checkQuery(positive);
        this.checkQuery(negative);
        return new AndNotQuery(positive, negative);
    }

    public StructuredQueryDefinition near(StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new NearQuery(queries);
    }

    public StructuredQueryDefinition near(int maximumDistance, double weight, Ordering order, StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new NearQuery(null, maximumDistance, weight, order, queries);
    }

    public StructuredQueryDefinition near(int minimumDistance, int maximumDistance, double weight, Ordering order, StructuredQueryDefinition ... queries) {
        this.checkQueries(queries);
        return new NearQuery(minimumDistance, maximumDistance, weight, order, queries);
    }

    public StructuredQueryDefinition documentFragment(StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new DocumentFragmentQuery(query);
    }

    public StructuredQueryDefinition properties(StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new PropertiesQuery(query);
    }

    public StructuredQueryDefinition locks(StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new LocksQuery(query);
    }

    public StructuredQueryDefinition containerQuery(ContainerIndex index, StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new ContainerQuery(index, query);
    }

    public StructuredQueryDefinition collection(String ... uris) {
        return new CollectionQuery(uris);
    }

    public StructuredQueryDefinition directory(boolean isInfinite, String ... uris) {
        return new DirectoryQuery(isInfinite, uris);
    }

    public StructuredQueryDefinition directory(int depth, String ... uris) {
        return new DirectoryQuery(depth, uris);
    }

    public StructuredQueryDefinition document(String ... uris) {
        return new DocumentQuery(uris);
    }

    public StructuredQueryDefinition term(String ... terms) {
        return new TermQuery(null, terms);
    }

    public StructuredQueryDefinition term(double weight, String ... terms) {
        return new TermQuery(weight, terms);
    }

    public StructuredQueryDefinition value(TextIndex index, String ... values) {
        return new ValueQuery(index, null, null, null, values);
    }

    public StructuredQueryDefinition value(TextIndex index, Boolean value) {
        return new ValueQuery(index, null, null, null, new Object[]{value});
    }

    public StructuredQueryDefinition value(TextIndex index, Number ... values) {
        return new ValueQuery(index, null, null, null, values);
    }

    public StructuredQueryDefinition value(TextIndex index, FragmentScope scope, String[] options, double weight, String ... values) {
        return new ValueQuery(index, scope, options, weight, values);
    }

    public StructuredQueryDefinition value(TextIndex index, FragmentScope scope, String[] options, double weight, Boolean value) {
        return new ValueQuery(index, scope, options, weight, new Object[]{value});
    }

    public StructuredQueryDefinition value(TextIndex index, FragmentScope scope, String[] options, double weight, Number ... values) {
        return new ValueQuery(index, scope, options, weight, values);
    }

    public StructuredQueryDefinition word(TextIndex index, String ... words) {
        return new WordQuery(index, null, null, null, words);
    }

    public StructuredQueryDefinition word(TextIndex index, FragmentScope scope, String[] options, double weight, String ... words) {
        return new WordQuery(index, scope, options, weight, words);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, Operator operator, Object ... values) {
        return new RangeQuery(index, type, null, null, null, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, null, null, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, FragmentScope scope, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, scope, null, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String[] options, Operator operator, Object ... values) {
        return new RangeQuery(index, type, null, null, options, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String[] options, double weight, Operator operator, Object ... values) {
        return new RangeQuery(index, type, null, null, options, weight, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, String[] options, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, null, options, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, String[] options, double weight, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, null, options, weight, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, FragmentScope scope, String[] options, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, scope, options, null, operator, values);
    }

    public StructuredQueryDefinition range(RangeIndex index, String type, String collation, FragmentScope scope, String[] options, double weight, Operator operator, Object ... values) {
        return new RangeQuery(index, type, collation, scope, options, weight, operator, values);
    }

    public StructuredQueryDefinition geospatial(GeospatialIndex index, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialPointQuery(index, null, regions, null, null);
    }

    public StructuredQueryDefinition geospatial(GeospatialIndex index, FragmentScope scope, String[] options, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialPointQuery(index, scope, regions, options, null);
    }

    public StructuredQueryDefinition geospatial(GeospatialIndex index, FragmentScope scope, String[] options, Double weight, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialPointQuery(index, scope, regions, options, weight);
    }

    public StructuredQueryDefinition geospatial(GeospatialRegionIndex index, GeospatialOperator operator, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialRegionQuery((GeoRegionPathImpl)index, operator, null, regions, null, null);
    }

    public StructuredQueryDefinition geospatial(GeospatialRegionIndex index, GeospatialOperator operator, FragmentScope scope, String[] options, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialRegionQuery((GeoRegionPathImpl)index, operator, scope, regions, options, null);
    }

    public StructuredQueryDefinition geospatial(GeospatialRegionIndex index, GeospatialOperator operator, FragmentScope scope, String[] options, Double weight, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialRegionQuery((GeoRegionPathImpl)index, operator, scope, regions, options, weight);
    }

    public Element element(QName qname) {
        return new ElementImpl(qname);
    }

    public Element element(String name) {
        return new ElementImpl(name);
    }

    public Attribute attribute(QName qname) {
        return new AttributeImpl(qname);
    }

    public Attribute attribute(String name) {
        return new AttributeImpl(name);
    }

    public ElementAttribute elementAttribute(Element element, Attribute attribute) {
        return new ElementAttributeImpl(element, attribute);
    }

    public Field field(String name) {
        return new FieldImpl(name);
    }

    public JSONProperty jsonProperty(String name) {
        return new JSONPropertyImpl(name);
    }

    public PathIndex pathIndex(String path) {
        return new PathIndexImpl(path);
    }

    public GeospatialIndex geoJSONProperty(JSONProperty jsonProperty) {
        if (jsonProperty == null) {
            throw new IllegalArgumentException("jsonProperty cannot be null");
        }
        return new GeoJSONPropertyImpl(jsonProperty);
    }

    public GeospatialIndex geoJSONProperty(JSONProperty parent, JSONProperty jsonProperty) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (jsonProperty == null) {
            throw new IllegalArgumentException("jsonProperty cannot be null");
        }
        return new GeoJSONPropertyImpl(parent, jsonProperty);
    }

    public GeospatialIndex geoJSONPropertyPair(JSONProperty parent, JSONProperty lat, JSONProperty lon) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (lat == null) {
            throw new IllegalArgumentException("lat cannot be null");
        }
        if (lon == null) {
            throw new IllegalArgumentException("lon cannot be null");
        }
        return new GeoJSONPropertyPairImpl(parent, lat, lon);
    }

    public GeospatialIndex geoElement(Element element) {
        return new GeoElementImpl(element);
    }

    public GeospatialIndex geoElement(Element parent, Element element) {
        return new GeoElementImpl(parent, element);
    }

    public GeospatialIndex geoElementPair(Element parent, Element lat, Element lon) {
        return new GeoElementPairImpl(parent, lat, lon);
    }

    public GeospatialIndex geoAttributePair(Element parent, Attribute lat, Attribute lon) {
        return new GeoAttributePairImpl(parent, lat, lon);
    }

    public GeospatialIndex geoPath(PathIndex pathIndex) {
        return new GeoPointPathImpl(pathIndex);
    }

    public GeospatialRegionIndex geoRegionPath(PathIndex pathIndex) {
        return new GeoRegionPathImpl(pathIndex);
    }

    public GeospatialRegionIndex geoRegionPath(PathIndex pathIndex, CoordinateSystem coordinateSystem) {
        return new GeoRegionPathImpl(pathIndex, coordinateSystem);
    }

    public Point point(double latitude, double longitude) {
        return new PointImpl(latitude, longitude);
    }

    public Circle circle(double latitude, double longitude, double radius) {
        return new CircleImpl(latitude, longitude, radius);
    }

    public Circle circle(Point center, double radius) {
        return new CircleImpl(center.getLatitude(), center.getLongitude(), radius);
    }

    public Box box(double south, double west, double north, double east) {
        return new BoxImpl(south, west, north, east);
    }

    public Polygon polygon(Point ... points) {
        return new PolygonImpl(points);
    }

    public StructuredQueryDefinition containerConstraint(String constraintName, StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new ContainerConstraintQuery(constraintName, query);
    }

    public StructuredQueryDefinition propertiesConstraint(String constraintName, StructuredQueryDefinition query) {
        this.checkQuery(query);
        return new PropertiesConstraintQuery(constraintName, query);
    }

    public StructuredQueryDefinition collectionConstraint(String constraintName, String ... uris) {
        return new CollectionConstraintQuery(constraintName, uris);
    }

    public StructuredQueryDefinition valueConstraint(String constraintName, String ... values) {
        return new ValueConstraintQuery(constraintName, values);
    }

    public StructuredQueryDefinition valueConstraint(String constraintName, double weight, String ... values) {
        return new ValueConstraintQuery(constraintName, weight, values);
    }

    public StructuredQueryDefinition wordConstraint(String constraintName, String ... words) {
        return new WordConstraintQuery(constraintName, words);
    }

    public StructuredQueryDefinition wordConstraint(String constraintName, double weight, String ... words) {
        return new WordConstraintQuery(constraintName, weight, words);
    }

    public StructuredQueryDefinition rangeConstraint(String constraintName, Operator operator, String ... values) {
        return new RangeConstraintQuery(constraintName, operator, values);
    }

    public GeospatialConstraintQuery geospatialConstraint(String constraintName, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialConstraintQuery(constraintName, regions);
    }

    public StructuredQueryDefinition geospatialRegionConstraint(String constraintName, GeospatialOperator operator, Region ... regions) {
        this.checkRegions(regions);
        return new GeospatialRegionConstraintQuery(constraintName, operator, regions);
    }

    public StructuredQueryDefinition customConstraint(String constraintName, String ... text) {
        return new CustomConstraintQuery(constraintName, text);
    }

    private void checkQueries(StructuredQueryDefinition ... queries) {
        if (queries != null) {
            for (StructuredQueryDefinition query : queries) {
                this.checkQuery(query);
            }
        }
    }

    private void checkQuery(StructuredQueryDefinition query) {
        if (query != null && !AbstractStructuredQuery.class.isAssignableFrom(query.getClass())) {
            throw new IllegalArgumentException("Only built queries are supported: " + query.getClass().getName());
        }
    }

    private void checkRegions(Region ... regions) {
        if (regions != null) {
            for (Region region : regions) {
                this.checkRegion(region);
            }
        }
    }

    private void checkRegion(Region region) {
        if (region != null && !RegionImpl.class.isAssignableFrom(region.getClass())) {
            throw new IllegalArgumentException("Only built regions are supported: " + region.getClass().getName());
        }
    }

    private static XMLStreamWriter makeSerializer(OutputStream out) {
        XMLOutputFactory factory = XmlFactories.getOutputFactory();
        try {
            XMLStreamWriter serializer = factory.createXMLStreamWriter(out, "UTF-8");
            serializer.setDefaultNamespace(SEARCH_API_NS);
            serializer.setPrefix("xs", "http://www.w3.org/2001/XMLSchema");
            return serializer;
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    private String serializeRegions(RegionImpl ... regions) {
        return this.serializeQueriesImpl(regions);
    }

    private String serializeQueries(AbstractStructuredQuery ... queries) {
        return this.serializeQueriesImpl(queries);
    }

    private String serializeQueriesImpl(Object ... objects) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeStructuredQueryImpl(baos, objects);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    private void writeStructuredQuery(OutputStream out, AbstractStructuredQuery ... queries) {
        this.writeStructuredQueryImpl(out, queries);
    }

    private void writeStructuredQueryImpl(OutputStream out, Object ... objects) {
        try {
            XMLStreamWriter serializer = StructuredQueryBuilder.makeSerializer(out);
            StructuredQueryBuilder.writeSearchElement(serializer, "query");
            if (objects != null) {
                if (objects instanceof AbstractStructuredQuery[]) {
                    if (this.namespaces != null) {
                        for (String prefix : this.namespaces.getAllPrefixes()) {
                            serializer.writeNamespace(prefix, this.namespaces.getNamespaceURI(prefix));
                        }
                    }
                    for (AbstractStructuredQuery query : (AbstractStructuredQuery[])objects) {
                        query.innerSerialize(serializer);
                    }
                } else if (objects instanceof RegionImpl[]) {
                    for (RegionImpl region : (RegionImpl[])objects) {
                        region.innerSerialize(serializer);
                    }
                }
            }
            serializer.writeEndElement();
            serializer.flush();
            serializer.close();
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    private static void serializeNamedIndex(XMLStreamWriter serializer, String elemName, QName qname, String name) throws XMLStreamException {
        StructuredQueryBuilder.writeSearchElement(serializer, elemName);
        if (qname != null) {
            String ns = qname.getNamespaceURI();
            serializer.writeAttribute("ns", ns != null ? ns : "");
            serializer.writeAttribute("name", qname.getLocalPart());
        } else {
            serializer.writeAttribute("ns", "");
            serializer.writeAttribute("name", name);
        }
        serializer.writeEndElement();
    }

    private static void writeText(XMLStreamWriter serializer, String container, Object object) throws XMLStreamException {
        if (object == null) {
            return;
        }
        StructuredQueryBuilder.writeSearchElement(serializer, container);
        serializer.writeCharacters(object instanceof String ? (String)object : object.toString());
        serializer.writeEndElement();
    }

    private static void writeTextList(XMLStreamWriter serializer, String container, Object[] objects) throws XMLStreamException {
        if (objects == null) {
            return;
        }
        for (Object object : objects) {
            if (object == null) continue;
            StructuredQueryBuilder.writeSearchElement(serializer, container);
            serializer.writeCharacters(object instanceof String ? (String)object : object.toString());
            serializer.writeEndElement();
        }
    }

    private static void writeQuery(XMLStreamWriter serializer, StructuredQueryDefinition query) throws XMLStreamException {
        ((AbstractStructuredQuery)query).innerSerialize(serializer);
    }

    private static void writeQueryList(XMLStreamWriter serializer, StructuredQueryDefinition ... queries) throws XMLStreamException {
        if (queries == null) {
            return;
        }
        for (AbstractStructuredQuery query : StructuredQueryBuilder.convertQueries(queries)) {
            query.innerSerialize(serializer);
        }
    }

    private static void writeQuery(XMLStreamWriter serializer, String container, AbstractStructuredQuery query) throws XMLStreamException {
        StructuredQueryBuilder.writeSearchElement(serializer, container);
        if (query != null) {
            query.innerSerialize(serializer);
        }
        serializer.writeEndElement();
    }

    private static void writeQueryList(XMLStreamWriter serializer, String container, AbstractStructuredQuery ... queries) throws XMLStreamException {
        StructuredQueryBuilder.writeSearchElement(serializer, container);
        if (queries != null) {
            for (AbstractStructuredQuery query : queries) {
                query.innerSerialize(serializer);
            }
        }
        serializer.writeEndElement();
    }

    private static AbstractStructuredQuery[] convertQueries(StructuredQueryDefinition ... queries) {
        if (queries == null) {
            return null;
        }
        AbstractStructuredQuery[] innerQueries = new AbstractStructuredQuery[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            innerQueries[i] = (AbstractStructuredQuery)queries[i];
        }
        return innerQueries;
    }

    public String[] rangeOptions(String ... options) {
        return options;
    }

    public StructuredQueryDefinition boost(StructuredQueryDefinition matchingQuery, StructuredQueryDefinition boostingQuery) {
        return new BoostQuery(matchingQuery, boostingQuery);
    }

    public StructuredQueryDefinition notIn(StructuredQueryDefinition positive, StructuredQueryDefinition negative) {
        return new NotInQuery(positive, negative);
    }

    public IterableNamespaceContext getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(IterableNamespaceContext namespaces) {
        EditableNamespaceContext newNamespaces = this.makeNamespaces();
        if (namespaces != null) {
            for (String prefix : namespaces.getAllPrefixes()) {
                String nsUri = namespaces.getNamespaceURI(prefix);
                if (!newNamespaces.containsKey(prefix)) {
                    newNamespaces.put(prefix, nsUri);
                    continue;
                }
                if (nsUri.equals(newNamespaces.getNamespaceURI(prefix))) continue;
                throw new IllegalArgumentException("Cannot change namespace URI for prefix: " + prefix);
            }
        }
        this.namespaces = newNamespaces;
    }

    private EditableNamespaceContext makeNamespaces() {
        EditableNamespaceContext newNamespaces = new EditableNamespaceContext();
        for (Map.Entry<String, String> entry : reserved.entrySet()) {
            newNamespaces.put(entry.getKey(), entry.getValue());
        }
        return newNamespaces;
    }

    public Axis axis(String name) {
        return new TemporalAxis(name);
    }

    public Period period(Calendar start, Calendar end) {
        return new TemporalPeriod(DatatypeConverter.printDateTime((Calendar)start), DatatypeConverter.printDateTime((Calendar)end));
    }

    public Period period(String start, String end) {
        return new TemporalPeriod(start, end);
    }

    public StructuredQueryDefinition temporalPeriodRange(Axis axis, TemporalOperator operator, Period period, String ... options) {
        if (axis == null) {
            throw new IllegalArgumentException("axis cannot be null");
        }
        if (period == null) {
            throw new IllegalArgumentException("period cannot be null");
        }
        return this.temporalPeriodRange(new Axis[]{axis}, operator, new Period[]{period}, options);
    }

    public StructuredQueryDefinition temporalPeriodRange(Axis[] axes, TemporalOperator operator, Period[] periods, String ... options) {
        if (axes == null) {
            throw new IllegalArgumentException("axes cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator cannot be null");
        }
        if (periods == null) {
            throw new IllegalArgumentException("periods cannot be null");
        }
        return new TemporalPeriodRangeQuery(axes, operator, periods, options);
    }

    public StructuredQueryDefinition temporalPeriodCompare(Axis axis1, TemporalOperator operator, Axis axis2, String ... options) {
        if (axis1 == null) {
            throw new IllegalArgumentException("axis1 cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator cannot be null");
        }
        if (axis2 == null) {
            throw new IllegalArgumentException("axis2 cannot be null");
        }
        return new TemporalPeriodCompareQuery(axis1, operator, axis2, options);
    }

    public StructuredQueryDefinition temporalLsqtQuery(String temporalCollection, Calendar time, double weight, String ... options) {
        if (temporalCollection == null) {
            throw new IllegalArgumentException("temporalCollection cannot be null");
        }
        return new TemporalLsqtQuery(temporalCollection, DatatypeConverter.printDateTime((Calendar)time), weight, options);
    }

    public StructuredQueryDefinition temporalLsqtQuery(String temporalCollection, String timestamp, double weight, String ... options) {
        if (temporalCollection == null) {
            throw new IllegalArgumentException("temporalCollection cannot be null");
        }
        return new TemporalLsqtQuery(temporalCollection, timestamp, weight, options);
    }

    public StructuredQueryDefinition beforeQuery(long timestamp) {
        if (timestamp == 0L) {
            throw new IllegalArgumentException("timestamp cannot be zero");
        }
        return new TimeQuery(Long.toUnsignedString(timestamp), "before-query");
    }

    public StructuredQueryDefinition afterQuery(long timestamp) {
        if (timestamp == 0L) {
            throw new IllegalArgumentException("timestamp cannot be zero");
        }
        return new TimeQuery(Long.toUnsignedString(timestamp), "after-query");
    }

    private static void writeSearchElement(XMLStreamWriter serializer, String elementName) throws XMLStreamException {
        serializer.writeStartElement(SEARCH_API_NS, elementName);
    }

    static {
        reserved.put("search", SEARCH_API_NS);
        reserved.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        reserved.put("xs", "http://www.w3.org/2001/XMLSchema");
    }

    public static interface Period {
    }

    public static interface Axis {
    }

    public static enum TemporalOperator {
        ALN_EQUALS,
        ALN_CONTAINS,
        ALN_CONTAINED_BY,
        ALN_MEETS,
        ALN_MET_BY,
        ALN_BEFORE,
        ALN_AFTER,
        ALN_STARTS,
        ALN_STARTED_BY,
        ALN_FINISHES,
        ALN_FINISHED_BY,
        ALN_OVERLAPS,
        ALN_OVERLAPPED_BY,
        ISO_CONTAINS,
        ISO_OVERLAPS,
        ISO_SUCCEEDS,
        ISO_PRECEDES,
        ISO_IMM_SUCCEEDS,
        ISO_IMM_PRECEDES,
        ISO_EQUALS;

    }

    class StructuredQueryXMLWriter
    extends BaseHandle<OperationNotSupported, OutputStreamSender>
    implements StructureWriteHandle,
    XMLWriteHandle,
    BufferableHandle,
    OutputStreamSender {
        StructuredQueryDefinition[] queries;

        StructuredQueryXMLWriter(StructuredQueryDefinition[] queries) {
            super.setResendable(true);
            super.setFormat(Format.XML);
            this.queries = queries;
        }

        @Override
        protected OutputStreamSender sendContent() {
            return this;
        }

        @Override
        public void setFormat(Format format) {
            if (format != Format.XML) {
                throw new IllegalArgumentException("StructuredQueryWriter supports the XML format only");
            }
        }

        @Override
        public void fromBuffer(byte[] buffer) {
            throw new UnsupportedOperationException("Cannot set StructuredQueryWriter from buffer");
        }

        @Override
        public byte[] toBuffer() {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                this.write(buffer);
                return buffer.toByteArray();
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        public String toString() {
            try {
                return new String(this.toBuffer(), "UTF-8");
            }
            catch (IOException e) {
                throw new MarkLogicIOException(e);
            }
        }

        @Override
        public void write(OutputStream out) throws IOException {
            StructuredQueryBuilder.this.writeStructuredQuery(out, StructuredQueryBuilder.convertQueries(this.queries));
        }
    }

    protected class PolygonImpl
    extends RegionImpl
    implements Polygon {
        private Point[] points;

        public PolygonImpl(Point ... points) {
            this.points = points;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "polygon");
            for (Point point : this.points) {
                point.innerSerialize(serializer);
            }
            serializer.writeEndElement();
        }
    }

    public static interface Polygon
    extends Region {
    }

    protected class BoxImpl
    extends RegionImpl
    implements Box {
        private double south;
        private double west;
        private double north;
        private double east;

        public BoxImpl(double south, double west, double north, double east) {
            this.south = south;
            this.west = west;
            this.north = north;
            this.east = east;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "box");
            StructuredQueryBuilder.writeText(serializer, "south", String.valueOf(this.south));
            StructuredQueryBuilder.writeText(serializer, "west", String.valueOf(this.west));
            StructuredQueryBuilder.writeText(serializer, "north", String.valueOf(this.north));
            StructuredQueryBuilder.writeText(serializer, "east", String.valueOf(this.east));
            serializer.writeEndElement();
        }
    }

    public static interface Box
    extends Region {
    }

    protected class CircleImpl
    extends RegionImpl
    implements Circle {
        private Point center;
        private double radius;

        public CircleImpl(double latitude, double longitude, double radius) {
            this.center = null;
            this.radius = 0.0;
            this.center = new PointImpl(latitude, longitude);
            this.radius = radius;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "circle");
            StructuredQueryBuilder.writeText(serializer, "radius", String.valueOf(this.radius));
            this.center.innerSerialize(serializer);
            serializer.writeEndElement();
        }
    }

    public static interface Circle
    extends Region {
    }

    protected class PointImpl
    extends RegionImpl
    implements Point {
        private double lat;
        private double lon;

        public PointImpl(double latitude, double longitude) {
            this.lat = 0.0;
            this.lon = 0.0;
            this.lat = latitude;
            this.lon = longitude;
        }

        @Override
        public double getLatitude() {
            return this.lat;
        }

        @Override
        public double getLongitude() {
            return this.lon;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "point");
            StructuredQueryBuilder.writeText(serializer, "latitude", String.valueOf(this.lat));
            StructuredQueryBuilder.writeText(serializer, "longitude", String.valueOf(this.lon));
            serializer.writeEndElement();
        }
    }

    public static interface Point
    extends Region {
        public double getLatitude();

        public double getLongitude();

        @Override
        public String serialize();

        public void innerSerialize(XMLStreamWriter var1) throws XMLStreamException;
    }

    protected abstract class RegionImpl
    extends AbstractStructuredQuery {
        protected RegionImpl() {
        }
    }

    public static interface Region
    extends StructuredQueryDefinition {
    }

    private class GeoRegionPathImpl
    extends GeoBasePathImpl
    implements GeospatialRegionIndex {
        CoordinateSystem coordinateSystem;

        GeoRegionPathImpl(PathIndex pathIndex) {
            super(pathIndex);
            this.coordinateSystem = null;
        }

        GeoRegionPathImpl(PathIndex pathIndex, CoordinateSystem coordinateSystem) {
            super(pathIndex);
            this.coordinateSystem = null;
            this.coordinateSystem = coordinateSystem;
        }
    }

    private class GeoPointPathImpl
    extends GeoBasePathImpl
    implements GeospatialIndex {
        GeoPointPathImpl(PathIndex pathIndex) {
            super(pathIndex);
        }
    }

    private class GeoBasePathImpl
    extends IndexImpl {
        PathIndex pathIndex;

        GeoBasePathImpl(PathIndex pathIndex) {
            this.pathIndex = pathIndex;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            PathIndexImpl pathIndexImpl = (PathIndexImpl)this.pathIndex;
            pathIndexImpl.innerSerialize(serializer);
        }
    }

    protected class GeoAttributePairImpl
    extends IndexImpl
    implements GeospatialIndex {
        Element parent;
        Attribute lat;
        Attribute lon;

        GeoAttributePairImpl(Element parent, Attribute lat, Attribute lon) {
            this.parent = parent;
            this.lat = lat;
            this.lon = lon;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            ElementImpl parentImpl = (ElementImpl)this.parent;
            AttributeImpl latImpl = (AttributeImpl)this.lat;
            AttributeImpl lonImpl = (AttributeImpl)this.lon;
            StructuredQueryBuilder.serializeNamedIndex(serializer, "parent", parentImpl.qname, parentImpl.name);
            StructuredQueryBuilder.serializeNamedIndex(serializer, "lat", latImpl.qname, latImpl.name);
            StructuredQueryBuilder.serializeNamedIndex(serializer, "lon", lonImpl.qname, lonImpl.name);
        }
    }

    protected class GeoElementPairImpl
    extends IndexImpl
    implements GeospatialIndex {
        Element parent;
        Element lat;
        Element lon;

        GeoElementPairImpl(Element parent, Element lat, Element lon) {
            this.parent = parent;
            this.lat = lat;
            this.lon = lon;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            ElementImpl parentImpl = (ElementImpl)this.parent;
            ElementImpl latImpl = (ElementImpl)this.lat;
            ElementImpl lonImpl = (ElementImpl)this.lon;
            StructuredQueryBuilder.serializeNamedIndex(serializer, "parent", parentImpl.qname, parentImpl.name);
            StructuredQueryBuilder.serializeNamedIndex(serializer, "lat", latImpl.qname, latImpl.name);
            StructuredQueryBuilder.serializeNamedIndex(serializer, "lon", lonImpl.qname, lonImpl.name);
        }
    }

    protected class GeoElementImpl
    extends IndexImpl
    implements GeospatialIndex {
        Element parent;
        Element element;

        GeoElementImpl(Element element) {
            this.element = element;
        }

        GeoElementImpl(Element parent, Element element) {
            this(element);
            this.parent = parent;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            IndexImpl parentImpl;
            if (this.parent != null && this.parent instanceof ElementImpl) {
                parentImpl = (ElementImpl)this.parent;
                StructuredQueryBuilder.serializeNamedIndex(serializer, "parent", ((ElementImpl)parentImpl).qname, ((ElementImpl)parentImpl).name);
            } else if (this.parent != null && this.parent instanceof IndexImpl) {
                parentImpl = (IndexImpl)((Object)this.parent);
                parentImpl.innerSerialize(serializer);
            }
            if (this.element instanceof ElementImpl) {
                ElementImpl elementImpl = (ElementImpl)this.element;
                StructuredQueryBuilder.serializeNamedIndex(serializer, "element", elementImpl.qname, elementImpl.name);
            } else if (this.element instanceof IndexImpl) {
                IndexImpl indexImpl = (IndexImpl)((Object)this.element);
                indexImpl.innerSerialize(serializer);
            }
        }
    }

    protected class GeoJSONPropertyPairImpl
    extends IndexImpl
    implements GeospatialIndex {
        JSONProperty parent;
        JSONProperty lat;
        JSONProperty lon;

        GeoJSONPropertyPairImpl(JSONProperty parent, JSONProperty lat, JSONProperty lon) {
            this.parent = parent;
            this.lat = lat;
            this.lon = lon;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            JSONPropertyImpl parentImpl = (JSONPropertyImpl)this.parent;
            JSONPropertyImpl latImpl = (JSONPropertyImpl)this.lat;
            JSONPropertyImpl lonImpl = (JSONPropertyImpl)this.lon;
            StructuredQueryBuilder.writeText(serializer, "parent-property", parentImpl.name);
            StructuredQueryBuilder.writeText(serializer, "lat-property", latImpl.name);
            StructuredQueryBuilder.writeText(serializer, "lon-property", lonImpl.name);
        }
    }

    protected class GeoJSONPropertyImpl
    extends IndexImpl
    implements GeospatialIndex {
        JSONProperty parent;
        JSONProperty jsonProperty;

        GeoJSONPropertyImpl(JSONProperty jsonProperty) {
            this.jsonProperty = jsonProperty;
        }

        GeoJSONPropertyImpl(JSONProperty parent, JSONProperty jsonProperty) {
            this(jsonProperty);
            this.parent = parent;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            if (this.parent != null && this.parent instanceof JSONPropertyImpl) {
                JSONPropertyImpl parentImpl = (JSONPropertyImpl)this.parent;
                StructuredQueryBuilder.writeText(serializer, "parent-property", parentImpl.name);
            }
            JSONPropertyImpl jsonPropertyImpl = (JSONPropertyImpl)this.jsonProperty;
            StructuredQueryBuilder.writeText(serializer, "json-property", jsonPropertyImpl.name);
        }
    }

    protected class PathIndexImpl
    extends IndexImpl
    implements PathIndex {
        String path;

        PathIndexImpl(String path) {
            this.path = path;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeText(serializer, "path-index", this.path);
        }
    }

    protected class JSONPropertyImpl
    extends IndexImpl
    implements JSONProperty {
        String name;

        JSONPropertyImpl(String name) {
            this.name = name;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeText(serializer, "json-property", this.name);
        }
    }

    protected class FieldImpl
    extends IndexImpl
    implements Field {
        String name;

        FieldImpl(String name) {
            this.name = name;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "field");
            serializer.writeAttribute("name", this.name);
            serializer.writeEndElement();
        }
    }

    protected class ElementAttributeImpl
    extends IndexImpl
    implements ElementAttribute {
        Element element;
        Attribute attribute;

        ElementAttributeImpl(Element element, Attribute attribute) {
            this.element = element;
            this.attribute = attribute;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            ((IndexImpl)((Object)this.element)).innerSerialize(serializer);
            ((IndexImpl)((Object)this.attribute)).innerSerialize(serializer);
        }
    }

    protected class AttributeImpl
    extends IndexImpl
    implements Attribute {
        String name;
        QName qname;

        AttributeImpl(QName qname) {
            this.qname = qname;
        }

        AttributeImpl(String name) {
            this.name = name;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.serializeNamedIndex(serializer, "attribute", this.qname, this.name);
        }
    }

    protected class ElementImpl
    extends IndexImpl
    implements Element {
        String name;
        QName qname;

        ElementImpl(QName qname) {
            this.qname = qname;
        }

        ElementImpl(String name) {
            this.name = name;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.serializeNamedIndex(serializer, "element", this.qname, this.name);
        }
    }

    protected abstract class IndexImpl {
        protected IndexImpl() {
        }

        public abstract void innerSerialize(XMLStreamWriter var1) throws XMLStreamException;
    }

    protected class TimeQuery
    extends AbstractStructuredQuery {
        private String formattedTimestamp;
        private String startElement;

        TimeQuery(String timestamp, String startElement) {
            this.formattedTimestamp = null;
            this.startElement = null;
            if (timestamp == null || timestamp.length() == 0) {
                throw new IllegalArgumentException("timestamp cannot be null or empty.");
            }
            this.formattedTimestamp = timestamp;
            this.startElement = startElement;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, this.startElement);
            if (this.formattedTimestamp != null && this.formattedTimestamp.length() > 0) {
                StructuredQueryBuilder.writeText(serializer, "timestamp", this.formattedTimestamp);
            }
            serializer.writeEndElement();
        }
    }

    protected class TemporalLsqtQuery
    extends AbstractStructuredQuery {
        private String temporalCollection;
        private String formattedTimestamp;
        private double weight;
        private String[] options;

        TemporalLsqtQuery(String temporalCollection, String timestamp, double weight, String[] options) {
            this.formattedTimestamp = null;
            this.temporalCollection = temporalCollection;
            if (timestamp != null) {
                this.formattedTimestamp = timestamp;
            }
            this.weight = weight;
            this.options = options;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "lsqt-query");
            StructuredQueryBuilder.writeText(serializer, "temporal-collection", this.temporalCollection);
            if (this.formattedTimestamp != null && this.formattedTimestamp.length() > 0) {
                StructuredQueryBuilder.writeText(serializer, "timestamp", this.formattedTimestamp);
            }
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            StructuredQueryBuilder.writeTextList(serializer, "query-option", this.options);
            serializer.writeEndElement();
        }
    }

    protected class TemporalPeriodCompareQuery
    extends AbstractStructuredQuery {
        private Axis axis1;
        private TemporalOperator operator;
        private Axis axis2;
        private String[] options;

        TemporalPeriodCompareQuery(Axis axis1, TemporalOperator operator, Axis axis2, String[] options) {
            this.axis1 = axis1;
            this.operator = operator;
            this.axis2 = axis2;
            this.options = options;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "period-compare-query");
            StructuredQueryBuilder.writeText(serializer, "axis1", this.axis1);
            StructuredQueryBuilder.writeText(serializer, "temporal-operator", this.operator.toString().toLowerCase());
            StructuredQueryBuilder.writeText(serializer, "axis2", this.axis2);
            StructuredQueryBuilder.writeTextList(serializer, "query-option", this.options);
            serializer.writeEndElement();
        }
    }

    protected class TemporalPeriodRangeQuery
    extends AbstractStructuredQuery {
        private Axis[] axes;
        private TemporalOperator operator;
        private Period[] periods;
        private String[] options;

        TemporalPeriodRangeQuery(Axis[] axes, TemporalOperator operator, Period[] periods, String ... options) {
            this.axes = axes;
            this.operator = operator;
            this.periods = periods;
            this.options = options;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "period-range-query");
            StructuredQueryBuilder.writeTextList(serializer, "axis", this.axes);
            StructuredQueryBuilder.writeText(serializer, "temporal-operator", this.operator.toString().toLowerCase());
            for (Period period : this.periods) {
                ((TemporalPeriod)period).innerSerialize(serializer);
            }
            StructuredQueryBuilder.writeTextList(serializer, "query-option", this.options);
            serializer.writeEndElement();
        }
    }

    protected class TemporalPeriod
    extends AbstractStructuredQuery
    implements Period {
        private String formattedStart;
        private String formattedEnd;
        private String[] options;

        TemporalPeriod(String start, String end) {
            this.formattedStart = start;
            this.formattedEnd = end;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "period");
            StructuredQueryBuilder.writeText(serializer, "period-start", this.formattedStart);
            StructuredQueryBuilder.writeText(serializer, "period-end", this.formattedEnd);
            serializer.writeEndElement();
        }
    }

    protected class TemporalAxis
    implements Axis {
        private String name;

        TemporalAxis(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    protected class GeospatialRegionQuery
    extends GeospatialBaseQuery {
        GeoRegionPathImpl index;
        GeospatialOperator operator;

        GeospatialRegionQuery(GeoRegionPathImpl index, GeospatialOperator operator, FragmentScope scope, Region[] regions, String[] options, Double weight) {
            super(scope, regions, options, weight);
            this.index = index;
            this.operator = operator;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            String elemName = "geo-region-path-query";
            StructuredQueryBuilder.writeSearchElement(serializer, elemName);
            if (this.index.coordinateSystem != null) {
                serializer.writeAttribute("coord", this.index.coordinateSystem.toString());
            }
            ((IndexImpl)this.index).innerSerialize(serializer);
            StructuredQueryBuilder.writeText(serializer, "geospatial-operator", this.operator.toString());
            if (this.scope != null) {
                StructuredQueryBuilder.writeText(serializer, "fragment-scope", this.scope.toString().toLowerCase());
            }
            StructuredQueryBuilder.writeTextList(serializer, "geo-option", this.options);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            for (Region region : this.regions) {
                ((RegionImpl)((Object)region)).innerSerialize(serializer);
            }
            serializer.writeEndElement();
        }
    }

    protected class GeospatialPointQuery
    extends GeospatialBaseQuery {
        GeospatialIndex index;

        GeospatialPointQuery(GeospatialIndex index, FragmentScope scope, Region[] regions, String[] options, Double weight) {
            super(scope, regions, options, weight);
            this.index = index;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            String elemName = null;
            if (this.index instanceof GeoJSONPropertyImpl) {
                elemName = "geo-json-property-query";
            } else if (this.index instanceof GeoJSONPropertyPairImpl) {
                elemName = "geo-json-property-pair-query";
            } else if (this.index instanceof GeoElementImpl) {
                elemName = "geo-elem-query";
            } else if (this.index instanceof GeoElementPairImpl) {
                elemName = "geo-elem-pair-query";
            } else if (this.index instanceof GeoAttributePairImpl) {
                elemName = "geo-attr-pair-query";
            } else if (this.index instanceof GeoPointPathImpl) {
                elemName = "geo-path-query";
            } else {
                throw new IllegalStateException("unknown index class: " + this.index.getClass().getName());
            }
            StructuredQueryBuilder.writeSearchElement(serializer, elemName);
            ((IndexImpl)((Object)this.index)).innerSerialize(serializer);
            if (this.scope != null) {
                StructuredQueryBuilder.writeText(serializer, "fragment-scope", this.scope.toString().toLowerCase());
            }
            StructuredQueryBuilder.writeTextList(serializer, "geo-option", this.options);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            for (Region region : this.regions) {
                ((RegionImpl)((Object)region)).innerSerialize(serializer);
            }
            serializer.writeEndElement();
        }
    }

    abstract class GeospatialBaseQuery
    extends AbstractStructuredQuery {
        FragmentScope scope;
        Region[] regions;
        String[] options;
        Double weight;

        GeospatialBaseQuery(FragmentScope scope, Region[] regions, String[] options, Double weight) {
            this.scope = scope;
            this.regions = regions;
            this.options = options;
            this.weight = weight;
        }
    }

    protected class RangeQuery
    extends AbstractStructuredQuery {
        RangeIndex index;
        FragmentScope scope;
        String type;
        String collation;
        String[] options;
        Double weight;
        Operator operator;
        String[] values;

        RangeQuery(RangeIndex index, String type, String collation, FragmentScope scope, String[] rangeOptions, Double weight, Operator operator, Object[] values) {
            this.index = index;
            this.type = type;
            this.collation = collation;
            this.scope = scope;
            this.options = rangeOptions;
            this.weight = weight;
            this.operator = operator;
            this.values = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                this.values[i] = this.formatValue(value, type);
            }
        }

        String formatValue(Object value, String type) {
            if (value == null) {
                return "null";
            }
            Class<?> valClass = value.getClass();
            if (String.class.isAssignableFrom(valClass)) {
                return (String)value;
            }
            if (type != null && (type.endsWith("date") || type.endsWith("dateTime") || type.endsWith("time")) && (Date.class.isAssignableFrom(valClass) || Calendar.class.isAssignableFrom(valClass))) {
                if (Date.class.isAssignableFrom(valClass)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)value);
                    value = cal;
                }
                if (type.endsWith("date")) {
                    return DatatypeConverter.printDate((Calendar)((Calendar)value));
                }
                if (type.endsWith("dateTime")) {
                    return DatatypeConverter.printDateTime((Calendar)((Calendar)value));
                }
                if (type.endsWith("time")) {
                    return DatatypeConverter.printTime((Calendar)((Calendar)value));
                }
            }
            return value.toString();
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "range-query");
            if (this.type != null) {
                serializer.writeAttribute("type", this.type);
                if (this.collation != null) {
                    serializer.writeAttribute("collation", this.collation);
                }
            }
            ((IndexImpl)((Object)this.index)).innerSerialize(serializer);
            if (this.scope != null) {
                StructuredQueryBuilder.writeText(serializer, "fragment-scope", this.scope.toString().toLowerCase());
            }
            StructuredQueryBuilder.writeTextList(serializer, "value", this.values);
            if (this.operator != null) {
                StructuredQueryBuilder.writeText(serializer, "range-operator", this.operator.toString().toUpperCase());
            }
            StructuredQueryBuilder.writeTextList(serializer, "range-option", this.options);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            serializer.writeEndElement();
        }
    }

    protected class WordQuery
    extends TextQuery {
        WordQuery(TextIndex index, FragmentScope scope, String[] options, Double weight, String[] values) {
            super(index, scope, options, weight, values);
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "word-query");
            super.innerSerialize(serializer);
            serializer.writeEndElement();
        }
    }

    protected class ValueQuery
    extends AbstractStructuredQuery {
        TextIndex index;
        FragmentScope scope;
        String[] options;
        Double weight;
        Object[] values;

        ValueQuery(TextIndex index, FragmentScope scope, String[] options, Double weight, Object[] values) {
            this.index = index;
            this.scope = scope;
            this.options = options;
            this.weight = weight;
            this.values = values;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "value-query");
            if (this.values != null && this.values.length > 0) {
                if (this.values[0] == null) {
                    serializer.writeAttribute("type", "null");
                } else if (this.values[0] instanceof String) {
                    serializer.writeAttribute("type", "string");
                } else if (this.values[0] instanceof Number) {
                    serializer.writeAttribute("type", "number");
                } else if (this.values[0] instanceof Boolean) {
                    serializer.writeAttribute("type", "boolean");
                }
            }
            ((IndexImpl)((Object)this.index)).innerSerialize(serializer);
            if (this.scope != null) {
                if (this.scope == FragmentScope.DOCUMENTS) {
                    StructuredQueryBuilder.writeText(serializer, "fragment-scope", "documents");
                } else {
                    StructuredQueryBuilder.writeText(serializer, "fragment-scope", this.scope.toString().toLowerCase());
                }
            }
            if (this.values != null) {
                for (Object value : this.values) {
                    if (value == null) continue;
                    StructuredQueryBuilder.writeText(serializer, "text", value);
                }
            }
            StructuredQueryBuilder.writeTextList(serializer, "term-option", this.options);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            serializer.writeEndElement();
        }
    }

    abstract class TextQuery
    extends AbstractStructuredQuery {
        TextIndex index;
        FragmentScope scope;
        String[] values;
        String[] options;
        Double weight;

        TextQuery(TextIndex index, FragmentScope scope, String[] options, Double weight, String[] values) {
            this.index = index;
            this.scope = scope;
            this.options = options;
            this.weight = weight;
            this.values = values;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            ((IndexImpl)((Object)this.index)).innerSerialize(serializer);
            if (this.scope != null) {
                if (this.scope == FragmentScope.DOCUMENTS) {
                    StructuredQueryBuilder.writeText(serializer, "fragment-scope", "documents");
                } else {
                    StructuredQueryBuilder.writeText(serializer, "fragment-scope", this.scope.toString().toLowerCase());
                }
            }
            StructuredQueryBuilder.writeTextList(serializer, "text", this.values);
            StructuredQueryBuilder.writeTextList(serializer, "term-option", this.options);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
        }
    }

    protected class ContainerQuery
    extends AbstractStructuredQuery {
        private ContainerIndex index;
        private StructuredQueryDefinition query;

        ContainerQuery(ContainerIndex index, StructuredQueryDefinition query) {
            this.index = index;
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "container-query");
            ((IndexImpl)((Object)this.index)).innerSerialize(serializer);
            StructuredQueryBuilder.writeQuery(serializer, this.query);
            serializer.writeEndElement();
        }
    }

    protected class CustomConstraintQuery
    extends AbstractStructuredQuery {
        private String[] terms;
        private String name;

        public CustomConstraintQuery(String constraintName, String ... terms) {
            this.terms = null;
            this.name = null;
            this.name = constraintName;
            this.terms = terms;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "custom-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeTextList(serializer, "text", this.terms);
            serializer.writeEndElement();
        }
    }

    protected class GeospatialRegionConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        Region[] regions;
        GeospatialOperator operator;

        public GeospatialRegionConstraintQuery(String constraintName, GeospatialOperator operator, Region ... regions) {
            this.name = null;
            this.regions = null;
            this.name = constraintName;
            this.regions = regions;
            this.operator = operator;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "geo-region-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeText(serializer, "geospatial-operator", this.operator.toString());
            for (Region region : this.regions) {
                ((RegionImpl)((Object)region)).innerSerialize(serializer);
            }
            serializer.writeEndElement();
        }
    }

    protected class GeospatialConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        Region[] regions;

        public GeospatialConstraintQuery(String constraintName, Region ... regions) {
            this.name = null;
            this.regions = null;
            this.name = constraintName;
            this.regions = regions;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "geospatial-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            for (Region region : this.regions) {
                ((RegionImpl)((Object)region)).innerSerialize(serializer);
            }
            serializer.writeEndElement();
        }
    }

    protected class RangeConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        String[] values;
        Operator operator;

        public RangeConstraintQuery(String constraintName, Operator operator, String ... values) {
            this.name = null;
            this.values = null;
            this.operator = null;
            this.name = constraintName;
            this.values = values;
            this.operator = operator;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "range-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeTextList(serializer, "value", this.values);
            StructuredQueryBuilder.writeText(serializer, "range-operator", (Object)this.operator);
            serializer.writeEndElement();
        }
    }

    protected class WordConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        String[] words;
        Double weight;

        public WordConstraintQuery(String constraintName, String ... words) {
            this.name = constraintName;
            this.words = words;
        }

        public WordConstraintQuery(String constraintName, Double weight, String ... words) {
            this.name = constraintName;
            this.words = words;
            this.weight = weight;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "word-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeTextList(serializer, "text", this.words);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            serializer.writeEndElement();
        }
    }

    protected class ValueConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        String[] values;
        Double weight;

        public ValueConstraintQuery(String constraintName, String ... values) {
            this.name = constraintName;
            this.values = values;
        }

        public ValueConstraintQuery(String constraintName, Double weight, String ... values) {
            this.name = constraintName;
            this.values = values;
            this.weight = weight;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "value-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeTextList(serializer, "text", this.values);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            serializer.writeEndElement();
        }
    }

    protected class CollectionConstraintQuery
    extends AbstractStructuredQuery {
        String name;
        String[] uris;

        public CollectionConstraintQuery(String constraintName, String ... uris) {
            this.name = null;
            this.uris = null;
            this.name = constraintName;
            this.uris = uris;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "collection-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeTextList(serializer, "uri", this.uris);
            serializer.writeEndElement();
        }
    }

    protected class PropertiesConstraintQuery
    extends AbstractStructuredQuery {
        private String name;
        private StructuredQueryDefinition query;

        public PropertiesConstraintQuery(String constraintName, StructuredQueryDefinition query) {
            this.name = constraintName;
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "properties-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeQuery(serializer, this.query);
            serializer.writeEndElement();
        }
    }

    private class ContainerConstraintQuery
    extends AbstractStructuredQuery {
        private String name;
        private StructuredQueryDefinition query;

        public ContainerConstraintQuery(String constraintName, StructuredQueryDefinition query) {
            this.name = constraintName;
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "container-constraint-query");
            StructuredQueryBuilder.writeText(serializer, "constraint-name", this.name);
            StructuredQueryBuilder.writeQuery(serializer, this.query);
            serializer.writeEndElement();
        }
    }

    protected class LocksQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition query;

        public LocksQuery(StructuredQueryDefinition query) {
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQuery(serializer, "locks-fragment-query", (AbstractStructuredQuery)this.query);
        }
    }

    protected class PropertiesQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition query;

        public PropertiesQuery(StructuredQueryDefinition query) {
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQuery(serializer, "properties-fragment-query", (AbstractStructuredQuery)this.query);
        }
    }

    protected class DocumentFragmentQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition query;

        public DocumentFragmentQuery(StructuredQueryDefinition query) {
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQuery(serializer, "document-fragment-query", (AbstractStructuredQuery)this.query);
        }
    }

    protected class DirectoryQuery
    extends AbstractStructuredQuery {
        private String[] uris;
        private Boolean isInfinite;
        private Integer depth;

        public DirectoryQuery(Boolean isInfinite, String ... uris) {
            this.isInfinite = isInfinite;
            this.uris = uris;
            this.depth = null;
        }

        DirectoryQuery(Integer depth, String ... uris) {
            this.isInfinite = false;
            this.uris = uris;
            this.depth = depth;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "directory-query");
            if (this.depth != null) {
                serializer.writeAttribute("depth", Integer.toString(this.depth));
            }
            StructuredQueryBuilder.writeTextList(serializer, "uri", this.uris);
            StructuredQueryBuilder.writeText(serializer, "infinite", this.isInfinite);
            serializer.writeEndElement();
        }
    }

    protected class CollectionQuery
    extends AbstractStructuredQuery {
        private String[] uris;

        public CollectionQuery(String ... uris) {
            this.uris = null;
            this.uris = uris;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "collection-query");
            StructuredQueryBuilder.writeTextList(serializer, "uri", this.uris);
            serializer.writeEndElement();
        }
    }

    protected class NearQuery
    extends AbstractStructuredQuery {
        private Integer minimumDistance;
        private Integer maximumDistance;
        private Double weight;
        private Ordering order;
        private StructuredQueryDefinition[] queries;

        public NearQuery(StructuredQueryDefinition ... queries) {
            this.queries = queries;
        }

        public NearQuery(Integer minimumDistance, Integer maximumDistance, Double weight, Ordering order, StructuredQueryDefinition ... queries) {
            this.minimumDistance = minimumDistance;
            this.maximumDistance = maximumDistance;
            this.weight = weight;
            this.order = order;
            this.queries = queries;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "near-query");
            StructuredQueryBuilder.writeQueryList(serializer, this.queries);
            if (this.order != null) {
                StructuredQueryBuilder.writeSearchElement(serializer, "ordered");
                serializer.writeCharacters(Boolean.toString(this.order == Ordering.ORDERED));
                serializer.writeEndElement();
            }
            StructuredQueryBuilder.writeText(serializer, "distance", this.maximumDistance);
            StructuredQueryBuilder.writeText(serializer, "minimum-distance", this.minimumDistance);
            StructuredQueryBuilder.writeText(serializer, "distance-weight", this.weight);
            serializer.writeEndElement();
        }
    }

    protected class TermQuery
    extends AbstractStructuredQuery {
        private String[] terms;
        private Double weight;

        public TermQuery(Double weight, String ... terms) {
            this.terms = null;
            this.weight = 0.0;
            this.weight = weight;
            this.terms = terms;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "term-query");
            StructuredQueryBuilder.writeTextList(serializer, "text", this.terms);
            StructuredQueryBuilder.writeText(serializer, "weight", this.weight);
            serializer.writeEndElement();
        }
    }

    protected class DocumentQuery
    extends AbstractStructuredQuery {
        private String[] uris;

        public DocumentQuery(String ... uris) {
            this.uris = null;
            this.uris = uris;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "document-query");
            StructuredQueryBuilder.writeTextList(serializer, "uri", this.uris);
            serializer.writeEndElement();
        }
    }

    private class BoostQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition matchingQuery;
        private StructuredQueryDefinition boostingQuery;

        public BoostQuery(StructuredQueryDefinition matchingQuery, StructuredQueryDefinition boostingQuery) {
            this.matchingQuery = matchingQuery;
            this.boostingQuery = boostingQuery;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "boost-query");
            StructuredQueryBuilder.writeQuery(serializer, "matching-query", (AbstractStructuredQuery)this.matchingQuery);
            StructuredQueryBuilder.writeQuery(serializer, "boosting-query", (AbstractStructuredQuery)this.boostingQuery);
            serializer.writeEndElement();
        }
    }

    protected class AndNotQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition positive;
        private StructuredQueryDefinition negative;

        public AndNotQuery(StructuredQueryDefinition positive, StructuredQueryDefinition negative) {
            this.positive = positive;
            this.negative = negative;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "and-not-query");
            StructuredQueryBuilder.writeQuery(serializer, "positive-query", (AbstractStructuredQuery)this.positive);
            StructuredQueryBuilder.writeQuery(serializer, "negative-query", (AbstractStructuredQuery)this.negative);
            serializer.writeEndElement();
        }
    }

    private class NotInQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition positive;
        private StructuredQueryDefinition negative;

        public NotInQuery(StructuredQueryDefinition positive, StructuredQueryDefinition negative) {
            this.positive = positive;
            this.negative = negative;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeSearchElement(serializer, "not-in-query");
            StructuredQueryBuilder.writeQuery(serializer, "positive-query", (AbstractStructuredQuery)this.positive);
            StructuredQueryBuilder.writeQuery(serializer, "negative-query", (AbstractStructuredQuery)this.negative);
            serializer.writeEndElement();
        }
    }

    protected class NotQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition query;

        public NotQuery(StructuredQueryDefinition query) {
            this.query = query;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQuery(serializer, "not-query", (AbstractStructuredQuery)this.query);
        }
    }

    protected class OrQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition[] queries;

        public OrQuery(StructuredQueryDefinition ... queries) {
            this.queries = queries;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQueryList(serializer, "or-query", StructuredQueryBuilder.convertQueries(this.queries));
        }
    }

    protected class AndQuery
    extends AbstractStructuredQuery {
        private StructuredQueryDefinition[] queries;

        public AndQuery(StructuredQueryDefinition ... queries) {
            this.queries = queries;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws XMLStreamException {
            StructuredQueryBuilder.writeQueryList(serializer, "and-query", StructuredQueryBuilder.convertQueries(this.queries));
        }
    }

    protected abstract class AbstractStructuredQuery
    extends AbstractQueryDefinition
    implements StructuredQueryDefinition {
        private String criteria = null;

        public AbstractStructuredQuery() {
            this.optionsUri = StructuredQueryBuilder.this.builderOptionsURI;
        }

        @Override
        public String getCriteria() {
            return this.criteria;
        }

        @Override
        public void setCriteria(String criteria) {
            this.criteria = criteria;
        }

        @Override
        public AbstractStructuredQuery withCriteria(String criteria) {
            this.setCriteria(criteria);
            return this;
        }

        @Override
        public void serialize(XMLStreamWriter serializer) throws XMLStreamException {
            this.innerSerialize(serializer);
        }

        @Override
        public String serialize() {
            return StructuredQueryBuilder.this.serializeQueries(new AbstractStructuredQuery[]{this});
        }

        public abstract void innerSerialize(XMLStreamWriter var1) throws XMLStreamException;

        @Override
        public boolean canSerializeQueryAsJSON() {
            return StructuredQueryBuilder.this.getNamespaces() == null && this.getOptionsName() == null;
        }
    }

    public static interface PathIndex
    extends RangeIndex {
    }

    public static interface JSONProperty
    extends Element,
    ContainerIndex,
    RangeIndex,
    TextIndex {
    }

    public static interface Field
    extends RangeIndex,
    TextIndex {
    }

    public static interface ElementAttribute
    extends RangeIndex,
    TextIndex {
    }

    public static interface Attribute {
    }

    public static interface Element
    extends ContainerIndex,
    RangeIndex,
    TextIndex {
    }

    public static interface ContainerIndex {
    }

    public static interface GeospatialRegionIndex {
    }

    public static interface GeospatialIndex {
    }

    public static interface RangeIndex {
    }

    public static interface TextIndex {
    }

    public static final class CoordinateSystem {
        private static ConcurrentMap<String, CoordinateSystem> coordMap = new ConcurrentHashMap<String, CoordinateSystem>();
        private String coordinateSystem;
        private boolean doublePrecision = false;
        public static final CoordinateSystem WGS84 = new CoordinateSystem("wgs84");
        public static final CoordinateSystem WGS84DOUBLE = new CoordinateSystem("wgs84", true);
        public static final CoordinateSystem ETRS89 = new CoordinateSystem("etrs89");
        public static final CoordinateSystem ETRS89DOUBLE = new CoordinateSystem("etrs89", true);
        public static final CoordinateSystem RAW = new CoordinateSystem("raw");
        public static final CoordinateSystem RAWDOUBLE = new CoordinateSystem("raw", true);

        private CoordinateSystem(String coordinateSystem) {
            this.coordinateSystem = coordinateSystem;
        }

        private CoordinateSystem(String coordinateSystem, boolean isDoublePrecision) {
            this(coordinateSystem);
            this.doublePrecision = isDoublePrecision;
        }

        public static CoordinateSystem getOther(String coordinateSystem) {
            return CoordinateSystem.getOther(coordinateSystem, false);
        }

        public static CoordinateSystem getOther(String coordinateSystem, boolean isDoublePrecision) {
            String key = coordinateSystem + isDoublePrecision;
            coordMap.putIfAbsent(key, new CoordinateSystem(coordinateSystem, isDoublePrecision));
            return (CoordinateSystem)coordMap.get(key);
        }

        public String getCoordinateSystem() {
            return this.coordinateSystem;
        }

        public boolean getDoublePrecision() {
            return this.doublePrecision;
        }

        public String toString() {
            if (this.doublePrecision) {
                return this.coordinateSystem + "/double";
            }
            return this.coordinateSystem;
        }
    }

    public static enum FragmentScope {
        DOCUMENTS,
        PROPERTIES;

    }

    public static enum Operator {
        LT,
        LE,
        GT,
        GE,
        EQ,
        NE;

    }

    public static enum GeospatialOperator {
        EQUALS,
        DISJOINT,
        TOUCHES,
        CONTAINS,
        COVERS,
        INTERSECTS,
        WITHIN,
        COVEREDBY,
        CROSSES,
        OVERLAPS;


        public String toString() {
            switch (this) {
                case COVEREDBY: {
                    return "covered-by";
                }
            }
            return this.name().toLowerCase();
        }
    }

    public static enum Ordering {
        ORDERED,
        UNORDERED;

    }
}

