/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.impl.PlanBuilderSubImpl;
import com.marklogic.client.impl.XsExprImpl;
import com.marklogic.client.type.PlanAggregateCol;
import com.marklogic.client.type.PlanAggregateColSeq;
import com.marklogic.client.type.PlanCase;
import com.marklogic.client.type.PlanCaseSeq;
import com.marklogic.client.type.PlanColumn;
import com.marklogic.client.type.PlanColumnSeq;
import com.marklogic.client.type.PlanCondition;
import com.marklogic.client.type.PlanConditionSeq;
import com.marklogic.client.type.PlanDocColsIdentifier;
import com.marklogic.client.type.PlanDocColsIdentifierSeq;
import com.marklogic.client.type.PlanDocDescriptor;
import com.marklogic.client.type.PlanDocDescriptorSeq;
import com.marklogic.client.type.PlanExprCol;
import com.marklogic.client.type.PlanExprColSeq;
import com.marklogic.client.type.PlanFunction;
import com.marklogic.client.type.PlanFunctionSeq;
import com.marklogic.client.type.PlanGroup;
import com.marklogic.client.type.PlanGroupSeq;
import com.marklogic.client.type.PlanJoinKey;
import com.marklogic.client.type.PlanJoinKeySeq;
import com.marklogic.client.type.PlanJsonProperty;
import com.marklogic.client.type.PlanJsonPropertySeq;
import com.marklogic.client.type.PlanNamedGroup;
import com.marklogic.client.type.PlanNamedGroupSeq;
import com.marklogic.client.type.PlanNamespaceBindings;
import com.marklogic.client.type.PlanNamespaceBindingsSeq;
import com.marklogic.client.type.PlanParamBindingSeqVal;
import com.marklogic.client.type.PlanParamBindingVal;
import com.marklogic.client.type.PlanRowColTypes;
import com.marklogic.client.type.PlanRowColTypesSeq;
import com.marklogic.client.type.PlanSchemaDef;
import com.marklogic.client.type.PlanSchemaDefSeq;
import com.marklogic.client.type.PlanSortKey;
import com.marklogic.client.type.PlanSortKeySeq;
import com.marklogic.client.type.PlanSystemColumn;
import com.marklogic.client.type.PlanSystemColumnSeq;
import com.marklogic.client.type.PlanTransformDef;
import com.marklogic.client.type.PlanTransformDefSeq;
import com.marklogic.client.type.PlanTriplePattern;
import com.marklogic.client.type.PlanTriplePatternSeq;
import com.marklogic.client.type.PlanTriplePosition;
import com.marklogic.client.type.PlanTriplePositionSeq;
import com.marklogic.client.type.ServerExpression;
import com.marklogic.client.type.XsAnyAtomicTypeSeqVal;
import com.marklogic.client.type.XsAnyAtomicTypeVal;
import com.marklogic.client.type.XsIntVal;
import com.marklogic.client.type.XsQNameVal;
import com.marklogic.client.type.XsStringSeqVal;
import com.marklogic.client.type.XsStringVal;
import java.util.Arrays;

abstract class PlanBuilderImpl
extends PlanBuilderBaseImpl {
    PlanBuilderImpl() {
    }

    @Override
    public ServerExpression add(ServerExpression ... left) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for add() cannot be null");
        }
        return new XsExprImpl.NumericCallImpl("op", "add", left);
    }

    @Override
    public PlanAggregateColSeq aggregateSeq(PlanAggregateCol ... aggregate) {
        if (aggregate == null) {
            throw new IllegalArgumentException("aggregate parameter for aggregateSeq() cannot be null");
        }
        return new AggregateColSeqListImpl(aggregate);
    }

    @Override
    public ServerExpression and(ServerExpression ... left) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for and() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "and", left);
    }

    @Override
    public PlanAggregateCol arrayAggregate(String name, String column) {
        return this.arrayAggregate(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol arrayAggregate(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for arrayAggregate() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for arrayAggregate() cannot be null");
        }
        return new AggregateColCallImpl("op", "array-aggregate", new Object[]{name, column});
    }

    @Override
    public PlanExprCol as(String column, ServerExpression expression) {
        return this.as(column == null ? (PlanColumn)null : this.col(column), expression);
    }

    @Override
    public PlanExprCol as(PlanColumn column, ServerExpression expression) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for as() cannot be null");
        }
        return new ExprColCallImpl("op", "as", new Object[]{column, expression});
    }

    @Override
    public PlanSortKey asc(String column) {
        return this.asc(column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanSortKey asc(PlanExprCol column) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for asc() cannot be null");
        }
        return new SortKeyCallImpl("op", "asc", new Object[]{column});
    }

    @Override
    public PlanAggregateCol avg(String name, String column) {
        return this.avg(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol avg(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for avg() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for avg() cannot be null");
        }
        return new AggregateColCallImpl("op", "avg", new Object[]{name, column});
    }

    @Override
    public PlanNamedGroup bucketGroup(String name, String key, String boundaries) {
        return this.bucketGroup(name == null ? (XsStringVal)null : this.xs.string(name), key == null ? (PlanExprCol)null : this.exprCol(key), boundaries == null ? (XsAnyAtomicTypeVal)null : this.xs.string(boundaries));
    }

    @Override
    public PlanNamedGroup bucketGroup(XsStringVal name, PlanExprCol key, XsAnyAtomicTypeSeqVal boundaries) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for bucketGroup() cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key parameter for bucketGroup() cannot be null");
        }
        if (boundaries == null) {
            throw new IllegalArgumentException("boundaries parameter for bucketGroup() cannot be null");
        }
        return new NamedGroupCallImpl("op", "bucket-group", new Object[]{name, key, boundaries});
    }

    @Override
    public PlanNamedGroup bucketGroup(String name, String key, String boundaries, String collation) {
        return this.bucketGroup(name == null ? (XsStringVal)null : this.xs.string(name), key == null ? (PlanExprCol)null : this.exprCol(key), boundaries == null ? (XsAnyAtomicTypeVal)null : this.xs.string(boundaries), collation == null ? (XsStringVal)null : this.xs.string(collation));
    }

    @Override
    public PlanNamedGroup bucketGroup(XsStringVal name, PlanExprCol key, XsAnyAtomicTypeSeqVal boundaries, XsStringVal collation) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for bucketGroup() cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key parameter for bucketGroup() cannot be null");
        }
        if (boundaries == null) {
            throw new IllegalArgumentException("boundaries parameter for bucketGroup() cannot be null");
        }
        return new NamedGroupCallImpl("op", "bucket-group", new Object[]{name, key, boundaries, collation});
    }

    @Override
    public PlanColumn col(String column) {
        return this.col(column == null ? (XsStringVal)null : this.xs.string(column));
    }

    @Override
    public PlanColumn col(XsStringVal column) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for col() cannot be null");
        }
        return new ColumnCallImpl("op", "col", new Object[]{column});
    }

    @Override
    public PlanExprColSeq colSeq(String ... col) {
        return this.colSeq((PlanExprCol[])Arrays.stream(col).map(item -> this.exprCol((String)item)).toArray(PlanExprCol[]::new));
    }

    @Override
    public PlanExprColSeq colSeq(PlanExprCol ... col) {
        if (col == null) {
            throw new IllegalArgumentException("col parameter for colSeq() cannot be null");
        }
        return new ExprColSeqListImpl(col);
    }

    @Override
    public PlanAggregateCol count(String name) {
        return this.count(name == null ? (PlanColumn)null : this.col(name));
    }

    @Override
    public PlanAggregateCol count(PlanColumn name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for count() cannot be null");
        }
        return new AggregateColCallImpl("op", "count", new Object[]{name});
    }

    @Override
    public PlanAggregateCol count(String name, String column) {
        return this.count(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol count(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for count() cannot be null");
        }
        return new AggregateColCallImpl("op", "count", new Object[]{name, column});
    }

    @Override
    public PlanGroupSeq cube(PlanExprColSeq keys) {
        if (keys == null) {
            throw new IllegalArgumentException("keys parameter for cube() cannot be null");
        }
        return new GroupSeqCallImpl("op", "cube", new Object[]{keys});
    }

    @Override
    public PlanSortKey desc(String column) {
        return this.desc(column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanSortKey desc(PlanExprCol column) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for desc() cannot be null");
        }
        return new SortKeyCallImpl("op", "desc", new Object[]{column});
    }

    @Override
    public ServerExpression divide(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for divide() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for divide() cannot be null");
        }
        return new XsExprImpl.NumericCallImpl("op", "divide", new Object[]{left, right});
    }

    @Override
    public PlanRowColTypesSeq docColTypes() {
        return new RowColTypesSeqCallImpl("op", "doc-col-types", new Object[0]);
    }

    @Override
    public PlanDocColsIdentifier docCols() {
        return new DocColsIdentifierCallImpl("op", "doc-cols", new Object[0]);
    }

    @Override
    public PlanDocColsIdentifier docCols(String qualifier) {
        return this.docCols(qualifier == null ? (XsStringVal)null : this.xs.string(qualifier));
    }

    @Override
    public PlanDocColsIdentifier docCols(XsStringVal qualifier) {
        return new DocColsIdentifierCallImpl("op", "doc-cols", new Object[]{qualifier});
    }

    @Override
    public PlanDocColsIdentifier docCols(String qualifier, String names) {
        return this.docCols(qualifier == null ? (XsStringVal)null : this.xs.string(qualifier), names == null ? (XsStringVal)null : this.xs.string(names));
    }

    @Override
    public PlanDocColsIdentifier docCols(XsStringVal qualifier, XsStringSeqVal names) {
        return new DocColsIdentifierCallImpl("op", "doc-cols", new Object[]{qualifier, names});
    }

    @Override
    public ServerExpression eq(ServerExpression ... operand) {
        if (operand == null) {
            throw new IllegalArgumentException("operand parameter for eq() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "eq", operand);
    }

    @Override
    public PlanSystemColumn fragmentIdCol(String column) {
        return this.fragmentIdCol(column == null ? (XsStringVal)null : this.xs.string(column));
    }

    @Override
    public PlanSystemColumn fragmentIdCol(XsStringVal column) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for fragmentIdCol() cannot be null");
        }
        return new SystemColumnCallImpl("op", "fragment-id-col", new Object[]{column});
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptor ... docDescriptor) {
        return this.fromDocDescriptors(new DocDescriptorSeqListImpl(docDescriptor));
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptorSeq docDescriptor) {
        if (docDescriptor == null) {
            throw new IllegalArgumentException("docDescriptor parameter for fromDocDescriptors() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-doc-descriptors", new Object[]{docDescriptor});
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptorSeq docDescriptor, String qualifier) {
        return this.fromDocDescriptors(docDescriptor, qualifier == null ? (XsStringVal)null : this.xs.string(qualifier));
    }

    @Override
    public PlanBuilder.AccessPlan fromDocDescriptors(PlanDocDescriptorSeq docDescriptor, XsStringVal qualifier) {
        if (docDescriptor == null) {
            throw new IllegalArgumentException("docDescriptor parameter for fromDocDescriptors() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-doc-descriptors", new Object[]{docDescriptor, qualifier});
    }

    @Override
    public PlanBuilder.AccessPlan fromParam(String paramName, String qualifier, PlanRowColTypesSeq rowColTypes) {
        return this.fromParam(paramName == null ? (XsStringVal)null : this.xs.string(paramName), qualifier == null ? (XsStringVal)null : this.xs.string(qualifier), rowColTypes);
    }

    @Override
    public PlanBuilder.AccessPlan fromParam(XsStringVal paramName, XsStringVal qualifier, PlanRowColTypesSeq rowColTypes) {
        if (paramName == null) {
            throw new IllegalArgumentException("paramName parameter for fromParam() cannot be null");
        }
        if (rowColTypes == null) {
            throw new IllegalArgumentException("rowColTypes parameter for fromParam() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-param", new Object[]{paramName, qualifier, rowColTypes});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(String select) {
        return this.fromSparql(select == null ? (XsStringVal)null : this.xs.string(select));
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(XsStringVal select) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSparql() cannot be null");
        }
        return new PlanBuilderSubImpl.ModifyPlanSubImpl("op", "from-sparql", new Object[]{select});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(String select, String qualifierName) {
        return this.fromSparql(select == null ? (XsStringVal)null : this.xs.string(select), qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.ModifyPlan fromSparql(XsStringVal select, XsStringVal qualifierName) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSparql() cannot be null");
        }
        return new PlanBuilderSubImpl.ModifyPlanSubImpl("op", "from-sparql", new Object[]{select, qualifierName});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSql(String select) {
        return this.fromSql(select == null ? (XsStringVal)null : this.xs.string(select));
    }

    @Override
    public PlanBuilder.ModifyPlan fromSql(XsStringVal select) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSql() cannot be null");
        }
        return new PlanBuilderSubImpl.ModifyPlanSubImpl("op", "from-sql", new Object[]{select});
    }

    @Override
    public PlanBuilder.ModifyPlan fromSql(String select, String qualifierName) {
        return this.fromSql(select == null ? (XsStringVal)null : this.xs.string(select), qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.ModifyPlan fromSql(XsStringVal select, XsStringVal qualifierName) {
        if (select == null) {
            throw new IllegalArgumentException("select parameter for fromSql() cannot be null");
        }
        return new PlanBuilderSubImpl.ModifyPlanSubImpl("op", "from-sql", new Object[]{select, qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePattern ... patterns) {
        return this.fromTriples(new TriplePatternSeqListImpl(patterns));
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException("patterns parameter for fromTriples() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-triples", new Object[]{patterns});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, String qualifierName) {
        return this.fromTriples(patterns, qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, XsStringVal qualifierName) {
        if (patterns == null) {
            throw new IllegalArgumentException("patterns parameter for fromTriples() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-triples", new Object[]{patterns, qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, String qualifierName, String graphIris) {
        return this.fromTriples(patterns, qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName), graphIris == null ? (XsStringVal)null : this.xs.string(graphIris));
    }

    @Override
    public PlanBuilder.AccessPlan fromTriples(PlanTriplePatternSeq patterns, XsStringVal qualifierName, XsStringSeqVal graphIris) {
        if (patterns == null) {
            throw new IllegalArgumentException("patterns parameter for fromTriples() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-triples", new Object[]{patterns, qualifierName, graphIris});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(String schema, String view) {
        return this.fromView(schema == null ? (XsStringVal)null : this.xs.string(schema), view == null ? (XsStringVal)null : this.xs.string(view));
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view) {
        if (view == null) {
            throw new IllegalArgumentException("view parameter for fromView() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-view", new Object[]{schema, view});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(String schema, String view, String qualifierName) {
        return this.fromView(schema == null ? (XsStringVal)null : this.xs.string(schema), view == null ? (XsStringVal)null : this.xs.string(view), qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName));
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view, XsStringVal qualifierName) {
        if (view == null) {
            throw new IllegalArgumentException("view parameter for fromView() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-view", new Object[]{schema, view, qualifierName});
    }

    @Override
    public PlanBuilder.AccessPlan fromView(String schema, String view, String qualifierName, PlanSystemColumn sysCols) {
        return this.fromView(schema == null ? (XsStringVal)null : this.xs.string(schema), view == null ? (XsStringVal)null : this.xs.string(view), qualifierName == null ? (XsStringVal)null : this.xs.string(qualifierName), sysCols);
    }

    @Override
    public PlanBuilder.AccessPlan fromView(XsStringVal schema, XsStringVal view, XsStringVal qualifierName, PlanSystemColumn sysCols) {
        if (view == null) {
            throw new IllegalArgumentException("view parameter for fromView() cannot be null");
        }
        return new PlanBuilderSubImpl.AccessPlanSubImpl("op", "from-view", new Object[]{schema, view, qualifierName, sysCols});
    }

    @Override
    public ServerExpression ge(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for ge() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for ge() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "ge", new Object[]{left, right});
    }

    @Override
    public PlanSystemColumn graphCol(String column) {
        return this.graphCol(column == null ? (XsStringVal)null : this.xs.string(column));
    }

    @Override
    public PlanSystemColumn graphCol(XsStringVal column) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for graphCol() cannot be null");
        }
        return new SystemColumnCallImpl("op", "graph-col", new Object[]{column});
    }

    @Override
    public PlanGroup group(PlanExprColSeq keys) {
        return new GroupCallImpl("op", "group", new Object[]{keys});
    }

    @Override
    public PlanAggregateCol groupKey(String name, String column) {
        return this.groupKey(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol groupKey(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for groupKey() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for groupKey() cannot be null");
        }
        return new AggregateColCallImpl("op", "group-key", new Object[]{name, column});
    }

    @Override
    public ServerExpression gt(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for gt() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for gt() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "gt", new Object[]{left, right});
    }

    @Override
    public PlanAggregateCol hasGroupKey(String name, String column) {
        return this.hasGroupKey(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol hasGroupKey(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for hasGroupKey() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for hasGroupKey() cannot be null");
        }
        return new AggregateColCallImpl("op", "has-group-key", new Object[]{name, column});
    }

    @Override
    public ServerExpression in(ServerExpression value, ServerExpression anyOf) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter for in() cannot be null");
        }
        if (anyOf == null) {
            throw new IllegalArgumentException("anyOf parameter for in() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "in", new Object[]{value, anyOf});
    }

    @Override
    public ServerExpression isDefined(ServerExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException("operand parameter for isDefined() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "is-defined", new Object[]{operand});
    }

    @Override
    public PlanJoinKeySeq joinKeySeq(PlanJoinKey ... key) {
        if (key == null) {
            throw new IllegalArgumentException("key parameter for joinKeySeq() cannot be null");
        }
        return new JoinKeySeqListImpl(key);
    }

    @Override
    public ServerExpression jsonBoolean(boolean value) {
        return this.jsonBoolean(this.xs.booleanVal(value));
    }

    @Override
    public ServerExpression jsonBoolean(ServerExpression value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter for jsonBoolean() cannot be null");
        }
        return new BaseTypeImpl.BooleanNodeCallImpl("op", "json-boolean", new Object[]{value});
    }

    @Override
    public ServerExpression jsonDocument(ServerExpression root) {
        if (root == null) {
            throw new IllegalArgumentException("root parameter for jsonDocument() cannot be null");
        }
        return new BaseTypeImpl.DocumentNodeCallImpl("op", "json-document", new Object[]{root});
    }

    @Override
    public ServerExpression jsonNull() {
        return new BaseTypeImpl.NullNodeCallImpl("op", "json-null", new Object[0]);
    }

    @Override
    public ServerExpression jsonNumber(double value) {
        return this.jsonNumber(this.xs.doubleVal(value));
    }

    @Override
    public ServerExpression jsonNumber(ServerExpression value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter for jsonNumber() cannot be null");
        }
        return new BaseTypeImpl.NumberNodeCallImpl("op", "json-number", new Object[]{value});
    }

    @Override
    public ServerExpression jsonString(String value) {
        return this.jsonString(value == null ? (ServerExpression)null : this.xs.string(value));
    }

    @Override
    public ServerExpression jsonString(ServerExpression value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter for jsonString() cannot be null");
        }
        return new BaseTypeImpl.TextNodeCallImpl("op", "json-string", new Object[]{value});
    }

    @Override
    public ServerExpression le(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for le() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for le() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "le", new Object[]{left, right});
    }

    @Override
    public ServerExpression lt(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for lt() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for lt() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "lt", new Object[]{left, right});
    }

    @Override
    public PlanAggregateCol max(String name, String column) {
        return this.max(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol max(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for max() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for max() cannot be null");
        }
        return new AggregateColCallImpl("op", "max", new Object[]{name, column});
    }

    @Override
    public PlanAggregateCol min(String name, String column) {
        return this.min(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol min(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for min() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for min() cannot be null");
        }
        return new AggregateColCallImpl("op", "min", new Object[]{name, column});
    }

    @Override
    public ServerExpression modulo(double left, double right) {
        return this.modulo(this.xs.doubleVal(left), this.xs.doubleVal(right));
    }

    @Override
    public ServerExpression modulo(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for modulo() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for modulo() cannot be null");
        }
        return new XsExprImpl.NumericCallImpl("op", "modulo", new Object[]{left, right});
    }

    @Override
    public ServerExpression multiply(ServerExpression ... left) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for multiply() cannot be null");
        }
        return new XsExprImpl.NumericCallImpl("op", "multiply", left);
    }

    @Override
    public PlanNamedGroup namedGroup(String name) {
        return this.namedGroup(name == null ? (XsStringVal)null : this.xs.string(name));
    }

    @Override
    public PlanNamedGroup namedGroup(XsStringVal name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for namedGroup() cannot be null");
        }
        return new NamedGroupCallImpl("op", "named-group", new Object[]{name});
    }

    @Override
    public PlanNamedGroup namedGroup(String name, String keys) {
        return this.namedGroup(name == null ? (XsStringVal)null : this.xs.string(name), (PlanExprColSeq)(keys == null ? (PlanExprCol)null : this.exprCol(keys)));
    }

    @Override
    public PlanNamedGroup namedGroup(XsStringVal name, PlanExprColSeq keys) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for namedGroup() cannot be null");
        }
        return new NamedGroupCallImpl("op", "named-group", new Object[]{name, keys});
    }

    @Override
    public ServerExpression ne(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for ne() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for ne() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "ne", new Object[]{left, right});
    }

    @Override
    public ServerExpression not(ServerExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException("operand parameter for not() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "not", new Object[]{operand});
    }

    @Override
    public PlanTriplePositionSeq objectSeq(PlanTriplePosition ... object) {
        if (object == null) {
            throw new IllegalArgumentException("object parameter for objectSeq() cannot be null");
        }
        return new TriplePositionSeqListImpl(object);
    }

    @Override
    public PlanJoinKey on(String left, String right) {
        return this.on(left == null ? (PlanExprCol)null : this.exprCol(left), right == null ? (PlanExprCol)null : this.exprCol(right));
    }

    @Override
    public PlanJoinKey on(PlanExprCol left, PlanExprCol right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for on() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for on() cannot be null");
        }
        return new JoinKeyCallImpl("op", "on", new Object[]{left, right});
    }

    @Override
    public ServerExpression or(ServerExpression ... left) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for or() cannot be null");
        }
        return new XsExprImpl.BooleanCallImpl("op", "or", left);
    }

    @Override
    public PlanTriplePattern pattern(PlanTriplePositionSeq subjects, PlanTriplePositionSeq predicates, PlanTriplePositionSeq objects) {
        return new TriplePatternCallImpl("op", "pattern", new Object[]{subjects, predicates, objects});
    }

    @Override
    public PlanTriplePattern pattern(PlanTriplePositionSeq subjects, PlanTriplePositionSeq predicates, PlanTriplePositionSeq objects, PlanSystemColumnSeq sysCols) {
        return new TriplePatternCallImpl("op", "pattern", new Object[]{subjects, predicates, objects, sysCols});
    }

    @Override
    public PlanTriplePatternSeq patternSeq(PlanTriplePattern ... pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern parameter for patternSeq() cannot be null");
        }
        return new TriplePatternSeqListImpl(pattern);
    }

    @Override
    public PlanTriplePositionSeq predicateSeq(PlanTriplePosition ... predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("predicate parameter for predicateSeq() cannot be null");
        }
        return new TriplePositionSeqListImpl(predicate);
    }

    @Override
    public PlanJsonProperty prop(String key, ServerExpression value) {
        return this.prop(key == null ? (ServerExpression)null : this.xs.string(key), value);
    }

    @Override
    public PlanJsonProperty prop(ServerExpression key, ServerExpression value) {
        if (key == null) {
            throw new IllegalArgumentException("key parameter for prop() cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value parameter for prop() cannot be null");
        }
        return new JsonPropertyCallImpl("op", "prop", new Object[]{key, value});
    }

    @Override
    public PlanFunction resolveFunction(String functionName, String modulePath) {
        return this.resolveFunction(functionName == null ? (XsQNameVal)null : this.xs.QName(functionName), modulePath == null ? (XsStringVal)null : this.xs.string(modulePath));
    }

    @Override
    public PlanFunction resolveFunction(XsQNameVal functionName, XsStringVal modulePath) {
        if (functionName == null) {
            throw new IllegalArgumentException("functionName parameter for resolveFunction() cannot be null");
        }
        if (modulePath == null) {
            throw new IllegalArgumentException("modulePath parameter for resolveFunction() cannot be null");
        }
        return new FunctionCallImpl("op", "resolve-function", new Object[]{functionName, modulePath});
    }

    @Override
    public PlanGroupSeq rollup(PlanExprColSeq keys) {
        if (keys == null) {
            throw new IllegalArgumentException("keys parameter for rollup() cannot be null");
        }
        return new GroupSeqCallImpl("op", "rollup", new Object[]{keys});
    }

    @Override
    public PlanAggregateCol sample(String name, String column) {
        return this.sample(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol sample(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for sample() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for sample() cannot be null");
        }
        return new AggregateColCallImpl("op", "sample", new Object[]{name, column});
    }

    @Override
    public PlanColumn schemaCol(String schema, String view, String column) {
        return this.schemaCol(schema == null ? (XsStringVal)null : this.xs.string(schema), view == null ? (XsStringVal)null : this.xs.string(view), column == null ? (XsStringVal)null : this.xs.string(column));
    }

    @Override
    public PlanColumn schemaCol(XsStringVal schema, XsStringVal view, XsStringVal column) {
        if (schema == null) {
            throw new IllegalArgumentException("schema parameter for schemaCol() cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view parameter for schemaCol() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for schemaCol() cannot be null");
        }
        return new ColumnCallImpl("op", "schema-col", new Object[]{schema, view, column});
    }

    @Override
    public PlanAggregateCol sequenceAggregate(String name, String column) {
        return this.sequenceAggregate(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol sequenceAggregate(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for sequenceAggregate() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for sequenceAggregate() cannot be null");
        }
        return new AggregateColCallImpl("op", "sequence-aggregate", new Object[]{name, column});
    }

    @Override
    public PlanSortKeySeq sortKeySeq(PlanSortKey ... key) {
        if (key == null) {
            throw new IllegalArgumentException("key parameter for sortKeySeq() cannot be null");
        }
        return new SortKeySeqListImpl(key);
    }

    @Override
    public PlanCondition sqlCondition(String expression) {
        return this.sqlCondition(expression == null ? (XsStringVal)null : this.xs.string(expression));
    }

    @Override
    public PlanCondition sqlCondition(XsStringVal expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression parameter for sqlCondition() cannot be null");
        }
        return new ConditionCallImpl("op", "sql-condition", new Object[]{expression});
    }

    @Override
    public PlanTriplePositionSeq subjectSeq(PlanTriplePosition ... subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject parameter for subjectSeq() cannot be null");
        }
        return new TriplePositionSeqListImpl(subject);
    }

    @Override
    public ServerExpression subtract(ServerExpression left, ServerExpression right) {
        if (left == null) {
            throw new IllegalArgumentException("left parameter for subtract() cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right parameter for subtract() cannot be null");
        }
        return new XsExprImpl.NumericCallImpl("op", "subtract", new Object[]{left, right});
    }

    @Override
    public PlanAggregateCol sum(String name, String column) {
        return this.sum(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column));
    }

    @Override
    public PlanAggregateCol sum(PlanColumn name, PlanExprCol column) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for sum() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for sum() cannot be null");
        }
        return new AggregateColCallImpl("op", "sum", new Object[]{name, column});
    }

    @Override
    public PlanAggregateCol uda(String name, String column, String module, String function) {
        return this.uda(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column), module == null ? (XsStringVal)null : this.xs.string(module), function == null ? (XsStringVal)null : this.xs.string(function));
    }

    @Override
    public PlanAggregateCol uda(PlanColumn name, PlanExprCol column, XsStringVal module, XsStringVal function) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for uda() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for uda() cannot be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("module parameter for uda() cannot be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("function parameter for uda() cannot be null");
        }
        return new AggregateColCallImpl("op", "uda", new Object[]{name, column, module, function});
    }

    @Override
    public PlanAggregateCol uda(String name, String column, String module, String function, String arg) {
        return this.uda(name == null ? (PlanColumn)null : this.col(name), column == null ? (PlanExprCol)null : this.exprCol(column), module == null ? (XsStringVal)null : this.xs.string(module), function == null ? (XsStringVal)null : this.xs.string(function), arg == null ? (XsAnyAtomicTypeVal)null : this.xs.string(arg));
    }

    @Override
    public PlanAggregateCol uda(PlanColumn name, PlanExprCol column, XsStringVal module, XsStringVal function, XsAnyAtomicTypeVal arg) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for uda() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for uda() cannot be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("module parameter for uda() cannot be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("function parameter for uda() cannot be null");
        }
        return new AggregateColCallImpl("op", "uda", new Object[]{name, column, module, function, arg});
    }

    @Override
    public PlanColumn viewCol(String view, String column) {
        return this.viewCol(view == null ? (XsStringVal)null : this.xs.string(view), column == null ? (XsStringVal)null : this.xs.string(column));
    }

    @Override
    public PlanColumn viewCol(XsStringVal view, XsStringVal column) {
        if (view == null) {
            throw new IllegalArgumentException("view parameter for viewCol() cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column parameter for viewCol() cannot be null");
        }
        return new ColumnCallImpl("op", "view-col", new Object[]{view, column});
    }

    @Override
    public PlanCase when(boolean condition, ServerExpression ... value) {
        return this.when(this.xs.booleanVal(condition), value);
    }

    @Override
    public PlanCase when(ServerExpression condition, ServerExpression ... value) {
        if (condition == null) {
            throw new IllegalArgumentException("condition parameter for when() cannot be null");
        }
        return new CaseCallImpl("op", "when", new Object[]{condition, new BaseTypeImpl.ItemSeqListImpl(value)});
    }

    @Override
    public ServerExpression xmlAttribute(String name, String value) {
        return this.xmlAttribute(name == null ? (ServerExpression)null : this.xs.QName(name), value == null ? (ServerExpression)null : this.xs.string(value));
    }

    @Override
    public ServerExpression xmlAttribute(ServerExpression name, ServerExpression value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for xmlAttribute() cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value parameter for xmlAttribute() cannot be null");
        }
        return new BaseTypeImpl.AttributeNodeCallImpl("op", "xml-attribute", new Object[]{name, value});
    }

    @Override
    public ServerExpression xmlAttributeSeq(ServerExpression ... attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute parameter for xmlAttributeSeq() cannot be null");
        }
        return new BaseTypeImpl.AttributeNodeSeqListImpl(attribute);
    }

    @Override
    public ServerExpression xmlComment(String content) {
        return this.xmlComment(content == null ? (ServerExpression)null : this.xs.string(content));
    }

    @Override
    public ServerExpression xmlComment(ServerExpression content) {
        if (content == null) {
            throw new IllegalArgumentException("content parameter for xmlComment() cannot be null");
        }
        return new BaseTypeImpl.CommentNodeCallImpl("op", "xml-comment", new Object[]{content});
    }

    @Override
    public ServerExpression xmlDocument(ServerExpression root) {
        if (root == null) {
            throw new IllegalArgumentException("root parameter for xmlDocument() cannot be null");
        }
        return new BaseTypeImpl.DocumentNodeCallImpl("op", "xml-document", new Object[]{root});
    }

    @Override
    public ServerExpression xmlElement(String name) {
        return this.xmlElement(name == null ? (ServerExpression)null : this.xs.QName(name));
    }

    @Override
    public ServerExpression xmlElement(ServerExpression name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for xmlElement() cannot be null");
        }
        return new BaseTypeImpl.ElementNodeCallImpl("op", "xml-element", new Object[]{name});
    }

    @Override
    public ServerExpression xmlElement(String name, ServerExpression attributes) {
        return this.xmlElement(name == null ? (ServerExpression)null : this.xs.QName(name), attributes);
    }

    @Override
    public ServerExpression xmlElement(ServerExpression name, ServerExpression attributes) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for xmlElement() cannot be null");
        }
        return new BaseTypeImpl.ElementNodeCallImpl("op", "xml-element", new Object[]{name, attributes});
    }

    @Override
    public ServerExpression xmlElement(String name, ServerExpression attributes, ServerExpression ... content) {
        return this.xmlElement(name == null ? (ServerExpression)null : this.xs.QName(name), attributes, content);
    }

    @Override
    public ServerExpression xmlElement(ServerExpression name, ServerExpression attributes, ServerExpression ... content) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for xmlElement() cannot be null");
        }
        return new BaseTypeImpl.ElementNodeCallImpl("op", "xml-element", new Object[]{name, attributes, new BaseTypeImpl.XmlContentNodeSeqListImpl(content)});
    }

    @Override
    public ServerExpression xmlPi(String name, String value) {
        return this.xmlPi(name == null ? (ServerExpression)null : this.xs.string(name), value == null ? (ServerExpression)null : this.xs.string(value));
    }

    @Override
    public ServerExpression xmlPi(ServerExpression name, ServerExpression value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter for xmlPi() cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value parameter for xmlPi() cannot be null");
        }
        return new BaseTypeImpl.ProcessingInstructionNodeCallImpl("op", "xml-pi", new Object[]{name, value});
    }

    @Override
    public ServerExpression xmlText(String value) {
        return this.xmlText(value == null ? (ServerExpression)null : this.xs.string(value));
    }

    @Override
    public ServerExpression xmlText(ServerExpression value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter for xmlText() cannot be null");
        }
        return new BaseTypeImpl.TextNodeCallImpl("op", "xml-text", new Object[]{value});
    }

    @Override
    public ServerExpression xpath(String column, String path) {
        return this.xpath(column == null ? (PlanColumn)null : this.col(column), path == null ? (ServerExpression)null : this.xs.string(path));
    }

    @Override
    public ServerExpression xpath(PlanColumn column, ServerExpression path) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for xpath() cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path parameter for xpath() cannot be null");
        }
        return new BaseTypeImpl.NodeSeqCallImpl("op", "xpath", new Object[]{column, path});
    }

    @Override
    public ServerExpression xpath(String column, String path, PlanNamespaceBindingsSeq namespaceBindings) {
        return this.xpath(column == null ? (PlanColumn)null : this.col(column), path == null ? (ServerExpression)null : this.xs.string(path), namespaceBindings);
    }

    @Override
    public ServerExpression xpath(PlanColumn column, ServerExpression path, PlanNamespaceBindingsSeq namespaceBindings) {
        if (column == null) {
            throw new IllegalArgumentException("column parameter for xpath() cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path parameter for xpath() cannot be null");
        }
        return new BaseTypeImpl.NodeSeqCallImpl("op", "xpath", new Object[]{column, path, namespaceBindings});
    }

    static abstract class PreparePlanImpl
    extends PlanBuilderSubImpl.ExportablePlanSubImpl
    implements PlanBuilder.PreparePlan {
        PreparePlanImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }

        @Override
        public PlanBuilder.ExportablePlan map(PlanFunction func) {
            if (func == null) {
                throw new IllegalArgumentException("func parameter for map() cannot be null");
            }
            return new PlanBuilderSubImpl.ExportablePlanSubImpl(this, "op", "map", new Object[]{func});
        }

        @Override
        public PlanBuilder.ExportablePlan reduce(PlanFunction func) {
            if (func == null) {
                throw new IllegalArgumentException("func parameter for reduce() cannot be null");
            }
            return new PlanBuilderSubImpl.ExportablePlanSubImpl(this, "op", "reduce", new Object[]{func});
        }

        @Override
        public PlanBuilder.ExportablePlan reduce(PlanFunction func, String seed) {
            return this.reduce(func, seed == null ? (XsAnyAtomicTypeVal)null : xs.string(seed));
        }

        @Override
        public PlanBuilder.ExportablePlan reduce(PlanFunction func, XsAnyAtomicTypeVal seed) {
            if (func == null) {
                throw new IllegalArgumentException("func parameter for reduce() cannot be null");
            }
            return new PlanBuilderSubImpl.ExportablePlanSubImpl(this, "op", "reduce", new Object[]{func, seed});
        }
    }

    static abstract class PlanImpl
    extends PlanBuilderBaseImpl.PlanBaseImpl
    implements PlanBuilder.Plan {
        PlanImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }
    }

    static abstract class ModifyPlanImpl
    extends PlanBuilderSubImpl.PreparePlanSubImpl
    implements PlanBuilder.ModifyPlan {
        ModifyPlanImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }

        @Override
        public PlanBuilder.ModifyPlan bind(PlanExprColSeq columns) {
            if (columns == null) {
                throw new IllegalArgumentException("columns parameter for bind() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "bind", new Object[]{columns});
        }

        @Override
        public PlanBuilder.ModifyPlan bindAs(String column, ServerExpression expression) {
            return this.bindAs(column == null ? (PlanColumn)null : this.col(column), expression);
        }

        @Override
        public PlanBuilder.ModifyPlan bindAs(PlanColumn column, ServerExpression expression) {
            if (column == null) {
                throw new IllegalArgumentException("column parameter for bindAs() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "bind-as", new Object[]{column, expression});
        }

        @Override
        public PlanBuilder.ModifyPlan except(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for except() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "except", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan existsJoin(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for existsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "exists-join", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan existsJoin(PlanBuilder.ModifyPlan right, PlanJoinKey ... keys) {
            return this.existsJoin(right, new JoinKeySeqListImpl(keys));
        }

        @Override
        public PlanBuilder.ModifyPlan existsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for existsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "exists-join", new Object[]{right, keys});
        }

        @Override
        public PlanBuilder.ModifyPlan existsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, boolean condition) {
            return this.existsJoin(right, keys, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan existsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for existsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "exists-join", new Object[]{right, keys, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan groupBy(PlanExprColSeq keys) {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "group-by", new Object[]{keys});
        }

        @Override
        public PlanBuilder.ModifyPlan groupBy(PlanExprColSeq keys, PlanAggregateColSeq aggregates) {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "group-by", new Object[]{keys, aggregates});
        }

        @Override
        public PlanBuilder.ModifyPlan intersect(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for intersect() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "intersect", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan joinCrossProduct(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinCrossProduct() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-cross-product", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan joinCrossProduct(PlanBuilder.ModifyPlan right, boolean condition) {
            return this.joinCrossProduct(right, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan joinCrossProduct(PlanBuilder.ModifyPlan right, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinCrossProduct() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-cross-product", new Object[]{right, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan joinDoc(String docCol, String sourceCol) {
            return this.joinDoc(docCol == null ? (PlanColumn)null : this.col(docCol), sourceCol == null ? (PlanColumn)null : this.col(sourceCol));
        }

        @Override
        public PlanBuilder.ModifyPlan joinDoc(PlanColumn docCol, PlanColumn sourceCol) {
            if (docCol == null) {
                throw new IllegalArgumentException("docCol parameter for joinDoc() cannot be null");
            }
            if (sourceCol == null) {
                throw new IllegalArgumentException("sourceCol parameter for joinDoc() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-doc", new Object[]{docCol, sourceCol});
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocAndUri(String docCol, String uriCol, String sourceCol) {
            return this.joinDocAndUri(docCol == null ? (PlanColumn)null : this.col(docCol), uriCol == null ? (PlanColumn)null : this.col(uriCol), sourceCol == null ? (PlanColumn)null : this.col(sourceCol));
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocAndUri(PlanColumn docCol, PlanColumn uriCol, PlanColumn sourceCol) {
            if (docCol == null) {
                throw new IllegalArgumentException("docCol parameter for joinDocAndUri() cannot be null");
            }
            if (uriCol == null) {
                throw new IllegalArgumentException("uriCol parameter for joinDocAndUri() cannot be null");
            }
            if (sourceCol == null) {
                throw new IllegalArgumentException("sourceCol parameter for joinDocAndUri() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-doc-and-uri", new Object[]{docCol, uriCol, sourceCol});
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocCols(PlanDocColsIdentifier cols, String docIdCol) {
            return this.joinDocCols(cols, docIdCol == null ? (PlanColumn)null : this.col(docIdCol));
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocCols(PlanDocColsIdentifier cols, PlanColumn docIdCol) {
            if (docIdCol == null) {
                throw new IllegalArgumentException("docIdCol parameter for joinDocCols() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-doc-cols", new Object[]{cols, docIdCol});
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocUri(String uriCol, String fragmentIdCol) {
            return this.joinDocUri(uriCol == null ? (PlanColumn)null : this.col(uriCol), fragmentIdCol == null ? (PlanColumn)null : this.col(fragmentIdCol));
        }

        @Override
        public PlanBuilder.ModifyPlan joinDocUri(PlanColumn uriCol, PlanColumn fragmentIdCol) {
            if (uriCol == null) {
                throw new IllegalArgumentException("uriCol parameter for joinDocUri() cannot be null");
            }
            if (fragmentIdCol == null) {
                throw new IllegalArgumentException("fragmentIdCol parameter for joinDocUri() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-doc-uri", new Object[]{uriCol, fragmentIdCol});
        }

        @Override
        public PlanBuilder.ModifyPlan joinFullOuter(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinFullOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-full-outer", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan joinFullOuter(PlanBuilder.ModifyPlan right, PlanJoinKey ... keys) {
            return this.joinFullOuter(right, new JoinKeySeqListImpl(keys));
        }

        @Override
        public PlanBuilder.ModifyPlan joinFullOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinFullOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-full-outer", new Object[]{right, keys});
        }

        @Override
        public PlanBuilder.ModifyPlan joinFullOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, boolean condition) {
            return this.joinFullOuter(right, keys, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan joinFullOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinFullOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-full-outer", new Object[]{right, keys, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan joinInner(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinInner() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-inner", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan joinInner(PlanBuilder.ModifyPlan right, PlanJoinKey ... keys) {
            return this.joinInner(right, new JoinKeySeqListImpl(keys));
        }

        @Override
        public PlanBuilder.ModifyPlan joinInner(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinInner() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-inner", new Object[]{right, keys});
        }

        @Override
        public PlanBuilder.ModifyPlan joinInner(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, boolean condition) {
            return this.joinInner(right, keys, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan joinInner(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinInner() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-inner", new Object[]{right, keys, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan joinLeftOuter(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinLeftOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-left-outer", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan joinLeftOuter(PlanBuilder.ModifyPlan right, PlanJoinKey ... keys) {
            return this.joinLeftOuter(right, new JoinKeySeqListImpl(keys));
        }

        @Override
        public PlanBuilder.ModifyPlan joinLeftOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinLeftOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-left-outer", new Object[]{right, keys});
        }

        @Override
        public PlanBuilder.ModifyPlan joinLeftOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, boolean condition) {
            return this.joinLeftOuter(right, keys, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan joinLeftOuter(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for joinLeftOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "join-left-outer", new Object[]{right, keys, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan notExistsJoin(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for notExistsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "not-exists-join", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan notExistsJoin(PlanBuilder.ModifyPlan right, PlanJoinKey ... keys) {
            return this.notExistsJoin(right, new JoinKeySeqListImpl(keys));
        }

        @Override
        public PlanBuilder.ModifyPlan notExistsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for notExistsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "not-exists-join", new Object[]{right, keys});
        }

        @Override
        public PlanBuilder.ModifyPlan notExistsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, boolean condition) {
            return this.notExistsJoin(right, keys, xs.booleanVal(condition));
        }

        @Override
        public PlanBuilder.ModifyPlan notExistsJoin(PlanBuilder.ModifyPlan right, PlanJoinKeySeq keys, ServerExpression condition) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for notExistsJoin() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "not-exists-join", new Object[]{right, keys, condition});
        }

        @Override
        public PlanBuilder.ModifyPlan orderBy(PlanSortKeySeq keys) {
            if (keys == null) {
                throw new IllegalArgumentException("keys parameter for orderBy() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "order-by", new Object[]{keys});
        }

        @Override
        public PlanBuilder.PreparePlan prepare(int optimize) {
            return this.prepare(xs.intVal(optimize));
        }

        @Override
        public PlanBuilder.PreparePlan prepare(XsIntVal optimize) {
            if (optimize == null) {
                throw new IllegalArgumentException("optimize parameter for prepare() cannot be null");
            }
            return new PlanBuilderSubImpl.PreparePlanSubImpl(this, "op", "prepare", new Object[]{optimize});
        }

        @Override
        public PlanBuilder.ModifyPlan select(PlanExprCol ... columns) {
            return this.select(new ExprColSeqListImpl(columns));
        }

        @Override
        public PlanBuilder.ModifyPlan select(PlanExprColSeq columns) {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "select", new Object[]{columns});
        }

        @Override
        public PlanBuilder.ModifyPlan select(PlanExprColSeq columns, String qualifierName) {
            return this.select(columns, qualifierName == null ? (XsStringVal)null : xs.string(qualifierName));
        }

        @Override
        public PlanBuilder.ModifyPlan select(PlanExprColSeq columns, XsStringVal qualifierName) {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "select", new Object[]{columns, qualifierName});
        }

        @Override
        public PlanBuilder.ModifyPlan union(PlanBuilder.ModifyPlan right) {
            if (right == null) {
                throw new IllegalArgumentException("right parameter for union() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "union", new Object[]{right});
        }

        @Override
        public PlanBuilder.ModifyPlan unnestInner(String inputColumn, String valueColumn) {
            return this.unnestInner(inputColumn == null ? (PlanExprCol)null : this.exprCol(inputColumn), valueColumn == null ? (PlanExprCol)null : this.exprCol(valueColumn));
        }

        @Override
        public PlanBuilder.ModifyPlan unnestInner(PlanExprCol inputColumn, PlanExprCol valueColumn) {
            if (inputColumn == null) {
                throw new IllegalArgumentException("inputColumn parameter for unnestInner() cannot be null");
            }
            if (valueColumn == null) {
                throw new IllegalArgumentException("valueColumn parameter for unnestInner() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "unnest-inner", new Object[]{inputColumn, valueColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan unnestInner(String inputColumn, String valueColumn, String ordinalColumn) {
            return this.unnestInner(inputColumn == null ? (PlanExprCol)null : this.exprCol(inputColumn), valueColumn == null ? (PlanExprCol)null : this.exprCol(valueColumn), ordinalColumn == null ? (PlanExprCol)null : this.exprCol(ordinalColumn));
        }

        @Override
        public PlanBuilder.ModifyPlan unnestInner(PlanExprCol inputColumn, PlanExprCol valueColumn, PlanExprCol ordinalColumn) {
            if (inputColumn == null) {
                throw new IllegalArgumentException("inputColumn parameter for unnestInner() cannot be null");
            }
            if (valueColumn == null) {
                throw new IllegalArgumentException("valueColumn parameter for unnestInner() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "unnest-inner", new Object[]{inputColumn, valueColumn, ordinalColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan unnestLeftOuter(String inputColumn, String valueColumn) {
            return this.unnestLeftOuter(inputColumn == null ? (PlanExprCol)null : this.exprCol(inputColumn), valueColumn == null ? (PlanExprCol)null : this.exprCol(valueColumn));
        }

        @Override
        public PlanBuilder.ModifyPlan unnestLeftOuter(PlanExprCol inputColumn, PlanExprCol valueColumn) {
            if (inputColumn == null) {
                throw new IllegalArgumentException("inputColumn parameter for unnestLeftOuter() cannot be null");
            }
            if (valueColumn == null) {
                throw new IllegalArgumentException("valueColumn parameter for unnestLeftOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "unnest-left-outer", new Object[]{inputColumn, valueColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan unnestLeftOuter(String inputColumn, String valueColumn, String ordinalColumn) {
            return this.unnestLeftOuter(inputColumn == null ? (PlanExprCol)null : this.exprCol(inputColumn), valueColumn == null ? (PlanExprCol)null : this.exprCol(valueColumn), ordinalColumn == null ? (PlanExprCol)null : this.exprCol(ordinalColumn));
        }

        @Override
        public PlanBuilder.ModifyPlan unnestLeftOuter(PlanExprCol inputColumn, PlanExprCol valueColumn, PlanExprCol ordinalColumn) {
            if (inputColumn == null) {
                throw new IllegalArgumentException("inputColumn parameter for unnestLeftOuter() cannot be null");
            }
            if (valueColumn == null) {
                throw new IllegalArgumentException("valueColumn parameter for unnestLeftOuter() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "unnest-left-outer", new Object[]{inputColumn, valueColumn, ordinalColumn});
        }

        @Override
        public PlanBuilder.ModifyPlan validateDoc(String validateDocCol, PlanSchemaDef schemaDef) {
            return this.validateDoc(validateDocCol == null ? (PlanColumn)null : this.col(validateDocCol), schemaDef);
        }

        @Override
        public PlanBuilder.ModifyPlan validateDoc(PlanColumn validateDocCol, PlanSchemaDef schemaDef) {
            if (validateDocCol == null) {
                throw new IllegalArgumentException("validateDocCol parameter for validateDoc() cannot be null");
            }
            if (schemaDef == null) {
                throw new IllegalArgumentException("schemaDef parameter for validateDoc() cannot be null");
            }
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "validate-doc", new Object[]{validateDocCol, schemaDef});
        }

        @Override
        public PlanBuilder.ModifyPlan whereDistinct() {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "where-distinct", new Object[0]);
        }

        @Override
        public PlanBuilder.ModifyPlan write() {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "write", new Object[0]);
        }

        @Override
        public PlanBuilder.ModifyPlan write(PlanDocColsIdentifier docCols) {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "write", new Object[]{docCols});
        }
    }

    static abstract class ExportablePlanImpl
    extends PlanBuilderSubImpl.PlanSubImpl
    implements PlanBuilder.ExportablePlan {
        ExportablePlanImpl(PlanBuilderBaseImpl.PlanBaseImpl prior, String fnPrefix, String fnName, Object[] fnArgs) {
            super(prior, fnPrefix, fnName, fnArgs);
        }
    }

    static abstract class AccessPlanImpl
    extends PlanBuilderSubImpl.ModifyPlanSubImpl
    implements PlanBuilder.AccessPlan {
        AccessPlanImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super((PlanBuilderBaseImpl.PlanBaseImpl)null, fnPrefix, fnName, fnArgs);
        }

        @Override
        public PlanColumn col(String column) {
            return this.col(column == null ? (XsStringVal)null : xs.string(column));
        }

        @Override
        public PlanColumn col(XsStringVal column) {
            if (column == null) {
                throw new IllegalArgumentException("column parameter for col() cannot be null");
            }
            return new ColumnCallImpl("op", "col", new Object[]{column});
        }

        @Override
        public PlanBuilder.ModifyPlan sampleBy() {
            return new PlanBuilderSubImpl.ModifyPlanSubImpl(this, "op", "sample-by", new Object[0]);
        }
    }

    static class TriplePositionCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTriplePosition {
        TriplePositionCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TriplePositionSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTriplePositionSeq {
        TriplePositionSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TriplePositionSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanTriplePositionSeq {
        TriplePositionSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class TriplePatternCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTriplePattern {
        TriplePatternCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TriplePatternSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTriplePatternSeq {
        TriplePatternSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TriplePatternSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanTriplePatternSeq {
        TriplePatternSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class TransformDefCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTransformDef {
        TransformDefCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TransformDefSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanTransformDefSeq {
        TransformDefSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class TransformDefSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanTransformDefSeq {
        TransformDefSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class SystemColumnCallImpl
    extends ColumnCallImpl
    implements PlanSystemColumn {
        SystemColumnCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SystemColumnSeqCallImpl
    extends ColumnCallImpl
    implements PlanSystemColumnSeq {
        SystemColumnSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SystemColumnSeqListImpl
    extends ColumnSeqListImpl
    implements PlanSystemColumnSeq {
        SystemColumnSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class SortKeyCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanSortKey {
        SortKeyCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SortKeySeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanSortKeySeq {
        SortKeySeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SortKeySeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanSortKeySeq {
        SortKeySeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class SchemaDefCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanSchemaDef {
        SchemaDefCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SchemaDefSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanSchemaDefSeq {
        SchemaDefSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class SchemaDefSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanSchemaDefSeq {
        SchemaDefSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class RowColTypesCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanRowColTypes {
        RowColTypesCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class RowColTypesSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanRowColTypesSeq {
        RowColTypesSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class RowColTypesSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanRowColTypesSeq {
        RowColTypesSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ParamBindingCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanParamBindingVal {
        ParamBindingCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ParamBindingSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanParamBindingSeqVal {
        ParamBindingSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ParamBindingSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanParamBindingSeqVal {
        ParamBindingSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class NamespaceBindingsCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanNamespaceBindings {
        NamespaceBindingsCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NamespaceBindingsSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanNamespaceBindingsSeq {
        NamespaceBindingsSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NamespaceBindingsSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanNamespaceBindingsSeq {
        NamespaceBindingsSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class NamedGroupCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanNamedGroup {
        NamedGroupCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NamedGroupSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanNamedGroupSeq {
        NamedGroupSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class NamedGroupSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanNamedGroupSeq {
        NamedGroupSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class JsonPropertyCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanJsonProperty {
        JsonPropertyCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class JsonPropertySeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanJsonPropertySeq {
        JsonPropertySeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class JsonPropertySeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanJsonPropertySeq {
        JsonPropertySeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class JoinKeyCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanJoinKey {
        JoinKeyCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class JoinKeySeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanJoinKeySeq {
        JoinKeySeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class JoinKeySeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanJoinKeySeq {
        JoinKeySeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class GroupCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanGroup {
        GroupCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class GroupSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanGroupSeq {
        GroupSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class GroupSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanGroupSeq {
        GroupSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class FunctionCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanFunction {
        FunctionCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class FunctionSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanFunctionSeq {
        FunctionSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class FunctionSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanFunctionSeq {
        FunctionSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ExprColCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanExprCol {
        ExprColCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ExprColSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanExprColSeq {
        ExprColSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ExprColSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanExprColSeq {
        ExprColSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class DocDescriptorCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanDocDescriptor {
        DocDescriptorCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class DocDescriptorSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanDocDescriptorSeq {
        DocDescriptorSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class DocDescriptorSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanDocDescriptorSeq {
        DocDescriptorSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class DocColsIdentifierCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanDocColsIdentifier {
        DocColsIdentifierCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class DocColsIdentifierSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanDocColsIdentifierSeq {
        DocColsIdentifierSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class DocColsIdentifierSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanDocColsIdentifierSeq {
        DocColsIdentifierSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ConditionCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanCondition {
        ConditionCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ConditionSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanConditionSeq {
        ConditionSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ConditionSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanConditionSeq {
        ConditionSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class ColumnCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanColumn {
        ColumnCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ColumnSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanColumnSeq {
        ColumnSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class ColumnSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanColumnSeq {
        ColumnSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class CaseCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanCase {
        CaseCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class CaseSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanCaseSeq {
        CaseSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class CaseSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanCaseSeq {
        CaseSeqListImpl(Object[] items) {
            super(items);
        }
    }

    static class AggregateColCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanAggregateCol {
        AggregateColCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class AggregateColSeqCallImpl
    extends PlanBuilderBaseImpl.PlanCallImpl
    implements PlanAggregateColSeq {
        AggregateColSeqCallImpl(String fnPrefix, String fnName, Object[] fnArgs) {
            super(fnPrefix, fnName, fnArgs);
        }
    }

    static class AggregateColSeqListImpl
    extends PlanBuilderBaseImpl.PlanSeqListImpl
    implements PlanAggregateColSeq {
        AggregateColSeqListImpl(Object[] items) {
            super(items);
        }
    }
}

