/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.burgstaller.okhttp.digest.Credentials;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.BasicAuthInterceptor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class BasicAuthenticationConfigurer
implements AuthenticationConfigurer<DatabaseClientFactory.BasicAuthContext> {
    @Override
    public void configureAuthentication(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.BasicAuthContext securityContext) {
        String user = securityContext.getUser();
        String password = securityContext.getPassword();
        if (user == null) {
            throw new IllegalArgumentException("No user provided");
        }
        if (password == null) {
            throw new IllegalArgumentException("No password provided");
        }
        clientBuilder.addInterceptor((Interceptor)new BasicAuthInterceptor(new Credentials(user, password)));
    }
}

