/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DigestAuthenticationConfigurer
implements AuthenticationConfigurer<DatabaseClientFactory.DigestAuthContext> {
    @Override
    public void configureAuthentication(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.DigestAuthContext securityContext) {
        String user = securityContext.getUser();
        String password = securityContext.getPassword();
        if (user == null) {
            throw new IllegalArgumentException("No user provided");
        }
        if (password == null) {
            throw new IllegalArgumentException("No password provided");
        }
        ConcurrentHashMap authCache = new ConcurrentHashMap();
        DigestAuthenticator authenticator = new DigestAuthenticator(new Credentials(user, password));
        clientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)authenticator, authCache));
        clientBuilder.addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache));
    }
}

