/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.impl.HTTPKerberosAuthInterceptor;
import com.marklogic.client.impl.HTTPSamlAuthInterceptor;
import com.marklogic.client.impl.SSLUtil;
import com.marklogic.client.impl.okhttp.AuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.BasicAuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.DigestAuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.MarkLogicCloudAuthenticationConfigurer;
import com.marklogic.client.impl.okhttp.SSLSocketFactoryDelegator;
import com.marklogic.client.impl.okhttp.SocketFactoryDelegator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public abstract class OkHttpUtil {
    private static final ConnectionPool connectionPool = new ConnectionPool();

    public static OkHttpClient.Builder newOkHttpClientBuilder(String host, DatabaseClientFactory.SecurityContext securityContext) {
        OkHttpClient.Builder clientBuilder = OkHttpUtil.newClientBuilder();
        AuthenticationConfigurer<DatabaseClientFactory.BasicAuthContext> authenticationConfigurer = null;
        if (securityContext instanceof DatabaseClientFactory.BasicAuthContext) {
            authenticationConfigurer = new BasicAuthenticationConfigurer();
        } else if (securityContext instanceof DatabaseClientFactory.DigestAuthContext) {
            authenticationConfigurer = new DigestAuthenticationConfigurer();
        } else if (securityContext instanceof DatabaseClientFactory.KerberosAuthContext) {
            OkHttpUtil.configureKerberosAuth((DatabaseClientFactory.KerberosAuthContext)securityContext, host, clientBuilder);
        } else if (!(securityContext instanceof DatabaseClientFactory.CertificateAuthContext)) {
            if (securityContext instanceof DatabaseClientFactory.SAMLAuthContext) {
                OkHttpUtil.configureSAMLAuth((DatabaseClientFactory.SAMLAuthContext)securityContext, clientBuilder);
            } else if (securityContext instanceof DatabaseClientFactory.MarkLogicCloudAuthContext) {
                authenticationConfigurer = new MarkLogicCloudAuthenticationConfigurer(host);
            } else {
                throw new IllegalArgumentException("Unsupported security context: " + securityContext.getClass());
            }
        }
        if (authenticationConfigurer != null) {
            authenticationConfigurer.configureAuthentication(clientBuilder, (DatabaseClientFactory.BasicAuthContext)securityContext);
        }
        SSLContext sslContext = securityContext.getSSLContext();
        X509TrustManager trustManager = securityContext.getTrustManager();
        DatabaseClientFactory.SSLHostnameVerifier sslVerifier = null;
        if (sslContext != null || securityContext instanceof DatabaseClientFactory.CertificateAuthContext) {
            sslVerifier = securityContext.getSSLHostnameVerifier() != null ? securityContext.getSSLHostnameVerifier() : DatabaseClientFactory.SSLHostnameVerifier.COMMON;
        }
        OkHttpUtil.configureSocketFactory(clientBuilder, sslContext, trustManager);
        OkHttpUtil.configureHostnameVerifier(clientBuilder, sslVerifier);
        return clientBuilder;
    }

    static OkHttpClient.Builder newClientBuilder() {
        return new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).connectionPool(connectionPool).cookieJar(CookieJar.NO_COOKIES).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).dns((Dns)new DnsImpl());
    }

    private static void configureKerberosAuth(DatabaseClientFactory.KerberosAuthContext keberosAuthContext, String host, OkHttpClient.Builder clientBuilder) {
        Map<String, String> kerberosOptions = keberosAuthContext.getKrbOptions();
        HTTPKerberosAuthInterceptor interceptor = new HTTPKerberosAuthInterceptor(host, kerberosOptions);
        clientBuilder.addInterceptor((Interceptor)interceptor);
    }

    private static void configureSAMLAuth(DatabaseClientFactory.SAMLAuthContext samlAuthContext, OkHttpClient.Builder clientBuilder) {
        HTTPSamlAuthInterceptor interceptor;
        String authorizationTokenValue = samlAuthContext.getToken();
        if (authorizationTokenValue != null && authorizationTokenValue.length() > 0) {
            interceptor = new HTTPSamlAuthInterceptor(authorizationTokenValue);
        } else if (samlAuthContext.getAuthorizer() != null) {
            interceptor = new HTTPSamlAuthInterceptor(samlAuthContext.getAuthorizer());
        } else if (samlAuthContext.getRenewer() != null) {
            interceptor = new HTTPSamlAuthInterceptor(samlAuthContext.getAuthorization(), samlAuthContext.getRenewer());
        } else {
            throw new IllegalArgumentException("Either a call back or renewer expected.");
        }
        clientBuilder.addInterceptor((Interceptor)interceptor);
    }

    static void configureHostnameVerifier(OkHttpClient.Builder clientBuilder, DatabaseClientFactory.SSLHostnameVerifier sslVerifier) {
        HostnameVerifier hostnameVerifier = null;
        if (DatabaseClientFactory.SSLHostnameVerifier.ANY.equals(sslVerifier)) {
            hostnameVerifier = (hostname, session) -> true;
        } else if (DatabaseClientFactory.SSLHostnameVerifier.COMMON.equals(sslVerifier) || DatabaseClientFactory.SSLHostnameVerifier.STRICT.equals(sslVerifier)) {
            hostnameVerifier = null;
        } else if (sslVerifier != null) {
            hostnameVerifier = new DatabaseClientFactory.SSLHostnameVerifier.HostnameVerifierAdapter(sslVerifier);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
    }

    static void configureSocketFactory(OkHttpClient.Builder clientBuilder, SSLContext sslContext, X509TrustManager trustManager) {
        if (sslContext == null) {
            clientBuilder.socketFactory((SocketFactory)new SocketFactoryDelegator(SocketFactory.getDefault()));
        } else if (trustManager != null) {
            clientBuilder.sslSocketFactory((SSLSocketFactory)new SSLSocketFactoryDelegator(sslContext.getSocketFactory()), trustManager);
        } else {
            OkHttpUtil.initializeSslContext(clientBuilder, sslContext);
        }
    }

    private static void initializeSslContext(OkHttpClient.Builder clientBuilder, SSLContext sslContext) {
        TrustManager[] trustManagers = SSLUtil.getDefaultTrustManagers();
        try {
            sslContext.init(null, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Unable to initialize SSLContext; cause: " + e.getMessage(), e);
        }
        clientBuilder.sslSocketFactory((SSLSocketFactory)new SSLSocketFactoryDelegator(sslContext.getSocketFactory()), (X509TrustManager)trustManagers[0]);
    }

    static class DnsImpl
    implements Dns {
        DnsImpl() {
        }

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            ArrayList<InetAddress> rawAddresses = Dns.SYSTEM.lookup(hostname);
            ArrayList<InetAddress> ipv4Addresses = new ArrayList<InetAddress>();
            for (InetAddress address : rawAddresses) {
                if (!(address instanceof Inet4Address)) continue;
                ipv4Addresses.add(address);
            }
            return ipv4Addresses.isEmpty() ? rawAddresses : ipv4Addresses;
        }
    }
}

