/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.impl.FailedRequest;
import com.marklogic.client.impl.FailedRequestParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class JSONErrorParser
implements FailedRequestParser {
    @Override
    public FailedRequest parseFailedRequest(int httpStatus, InputStream content) {
        FailedRequest failure = new FailedRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map errorData = (Map)mapper.readValue(content, Map.class);
            Map errorBody = (Map)errorData.get("errorResponse");
            failure.setStatusCode(httpStatus);
            failure.setStatusString((String)errorBody.get("status"));
            failure.setMessageCode((String)errorBody.get("messageCode"));
            failure.setMessageString((String)errorBody.get("message"));
            failure.setStackTrace((String)errorBody.get("stackTrace"));
        }
        catch (JsonParseException e1) {
            failure.setStatusCode(httpStatus);
            failure.setMessageString("Request failed. Error body not received from server");
        }
        catch (JsonMappingException e1) {
            failure.setStatusCode(httpStatus);
            failure.setMessageString("Request failed. Error body not received from server");
        }
        catch (IOException e1) {
            failure.setStatusCode(httpStatus);
            failure.setMessageString("Request failed. Error body not received from server");
        }
        return failure;
    }
}

