/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLEventReaderHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
StreamingContentHandle<XMLEventReader, InputStream>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(XMLEventReaderHandle.class);
    private XMLResolver resolver;
    private XMLEventReader content;
    private XMLInputFactory factory;
    private InputStream underlyingStream;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{XMLEventReader.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return XMLEventReader.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                XMLEventReaderHandle handle = this.isHandled(type) ? new XMLEventReaderHandle() : null;
                return handle;
            }
        };
    }

    public XMLEventReaderHandle() {
        super.setFormat(Format.XML);
        this.setResendable(false);
    }

    public XMLEventReaderHandle(XMLEventReader content) {
        this();
        this.set(content);
    }

    public XMLResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XMLEventReader get() {
        return this.content;
    }

    @Override
    public void set(XMLEventReader content) {
        this.content = content;
    }

    public XMLEventReaderHandle with(XMLEventReader content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<XMLEventReader> getContentClass() {
        return XMLEventReader.class;
    }

    @Override
    public XMLEventReaderHandle newHandle() {
        return new XMLEventReaderHandle().withMimetype(this.getMimetype());
    }

    public XMLEventReaderHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new XMLEventReaderHandle[length];
    }

    public XMLEventReader[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new XMLEventReader[length];
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("XMLEventReaderHandle supports the XML format only");
        }
    }

    public XMLEventReaderHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public XMLEventReader toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            XMLInputFactory factory = this.getFactory();
            if (factory == null) {
                throw new MarkLogicInternalException("Failed to make StAX input factory");
            }
            if (this.resolver != null) {
                factory.setXMLResolver(this.resolver);
            }
            return factory.createXMLEventReader(serialization, "UTF-8");
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX events from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (FactoryConfigurationError e) {
            logger.error("Failed to parse StAX events from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public XMLEventReader bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(XMLEventReader content) {
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.write(content, buffer);
        return buffer.toByteArray();
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    public XMLInputFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.makeXMLInputFactory();
        }
        return this.factory;
    }

    public void setFactory(XMLInputFactory factory) {
        this.factory = factory;
    }

    protected XMLInputFactory makeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            factory.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isValidating", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        this.underlyingStream = content;
        if (logger.isInfoEnabled()) {
            logger.info("Parsing StAX events from input stream");
        }
        this.content = this.toContent(content);
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No input source to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(this.content, out);
    }

    private void write(XMLEventReader content, OutputStream out) {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLEventWriter writer = factory.createXMLEventWriter(out, "UTF-8");
            writer.add(content);
            writer.flush();
            writer.close();
            content.close();
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX events from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public void close() {
        if (this.underlyingStream != null) {
            try {
                this.underlyingStream.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

