/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.impl.DocDescriptorUtil;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ContentParam {
    private PlanBuilderBaseImpl.PlanParamBase planParam;
    private AbstractWriteHandle content;
    private Map<String, Map<String, AbstractWriteHandle>> columnAttachments;

    public ContentParam(PlanBuilderBaseImpl.PlanParamBase planParam, AbstractWriteHandle content) {
        this.planParam = planParam;
        this.content = content;
    }

    public ContentParam(PlanBuilderBaseImpl.PlanParamBase planParam, AbstractWriteHandle content, Map<String, Map<String, AbstractWriteHandle>> columnAttachments) {
        this(planParam, content);
        this.columnAttachments = columnAttachments;
    }

    public PlanBuilderBaseImpl.PlanParamBase getPlanParam() {
        return this.planParam;
    }

    public AbstractWriteHandle getContent() {
        return this.content;
    }

    public Map<String, Map<String, AbstractWriteHandle>> getColumnAttachments() {
        return this.columnAttachments;
    }

    public static ContentParam fromDocumentWriteSet(PlanBuilderBaseImpl.PlanParamBase param, DocumentWriteSet writeSet) {
        HashMap<String, AbstractWriteHandle> attachments = new HashMap<String, AbstractWriteHandle>();
        ArrayNode contentRows = DocDescriptorUtil.buildDocDescriptors(writeSet, attachments);
        Map<String, Map<String, AbstractWriteHandle>> columnAttachments = attachments.isEmpty() ? null : Collections.singletonMap("doc", attachments);
        JacksonHandle content = new JacksonHandle((JsonNode)contentRows);
        return new ContentParam(param, content, columnAttachments);
    }
}

