/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientBuilder;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.HostAvailabilityListener;
import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.NoResponseListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.RowBatcher;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.datamovement.impl.DataMovementServices;
import com.marklogic.client.datamovement.impl.QueryBatcherImpl;
import com.marklogic.client.datamovement.impl.QueryJobReportListener;
import com.marklogic.client.datamovement.impl.RowBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteJobReportListener;
import com.marklogic.client.impl.DatabaseClientImpl;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.query.CtsQueryDefinition;
import com.marklogic.client.query.RawCombinedQueryDefinition;
import com.marklogic.client.query.RawCtsQueryDefinition;
import com.marklogic.client.query.RawStructuredQueryDefinition;
import com.marklogic.client.query.SearchQueryDefinition;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMovementManagerImpl
implements DataMovementManager {
    private static final Logger logger = LoggerFactory.getLogger(DataMovementManager.class);
    private DataMovementServices service = new DataMovementServices();
    private static final ConcurrentHashMap<String, JobTicket> activeJobs = new ConcurrentHashMap();
    private ForestConfiguration forestConfig;
    private DatabaseClient primaryClient;
    private final Map<String, DatabaseClient> clientMap = new HashMap<String, DatabaseClient>();

    public DataMovementManagerImpl(DatabaseClient client) {
        this.setPrimaryClient(client);
        this.clientMap.put(this.primaryClient.getHost(), this.primaryClient);
    }

    @Override
    public void release() {
        for (DatabaseClient client : this.clientMap.values()) {
            try {
                if (this.primaryClient == client) continue;
                client.release();
            }
            catch (Throwable t) {
                logger.error("Failed to release client for host \"" + client.getHost() + "\"", t);
            }
        }
    }

    @Override
    public JobTicket startJob(QueryBatcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        return this.service.startJob(batcher, activeJobs);
    }

    @Override
    public JobTicket startJob(WriteBatcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        return this.service.startJob(batcher, activeJobs);
    }

    @Override
    public JobReport getJobReport(JobTicket ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        return this.service.getJobReport(ticket);
    }

    @Override
    public void stopJob(JobTicket ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        logger.info("Stopping {} job with ID: {}", (Object)ticket.getJobType(), (Object)ticket.getJobId());
        this.service.stopJob(ticket, activeJobs);
    }

    @Override
    public void stopJob(Batcher batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        logger.info("Stopping batcher; job name: {}; job ID: {}", (Object)batcher.getJobName(), (Object)batcher.getJobId());
        this.service.stopJob(batcher, activeJobs);
    }

    @Override
    public WriteBatcher newWriteBatcher() {
        WriteBatcherImpl batcher = new WriteBatcherImpl(this, this.getForestConfig());
        batcher.onBatchFailure(new HostAvailabilityListener(this));
        WriteJobReportListener writeJobListener = new WriteJobReportListener();
        batcher.onBatchFailure(writeJobListener);
        batcher.onBatchFailure(new NoResponseListener(this));
        batcher.onBatchSuccess(writeJobListener);
        return batcher;
    }

    @Override
    public QueryBatcher newQueryBatcher(CtsQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(StructuredQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawStructuredQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(StringQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawCombinedQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    @Override
    public QueryBatcher newQueryBatcher(RawCtsQueryDefinition query) {
        return this.newQueryBatcherImpl(query);
    }

    private QueryBatcher newQueryBatcherImpl(SearchQueryDefinition query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        QueryBatcherImpl queryBatcher = null;
        if (Long.compareUnsigned(this.getServerVersion(), Long.parseUnsignedLong("10000500")) >= 0) {
            DataMovementServices.QueryConfig queryConfig = this.service.initConfig("POST", query);
            queryBatcher = new QueryBatcherImpl(query, this, queryConfig.forestConfig, queryConfig.serializedCtsQuery, queryConfig.filtered, queryConfig.maxDocToUriBatchRatio, queryConfig.defaultDocBatchSize, queryConfig.maxUriBatchSize);
        } else {
            queryBatcher = new QueryBatcherImpl(query, (DataMovementManager)this, this.getForestConfig());
        }
        return this.newQueryBatcher(queryBatcher);
    }

    @Override
    public QueryBatcher newQueryBatcher(Iterator<String> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator must not be null");
        }
        return this.newQueryBatcher(new QueryBatcherImpl(iterator, (DataMovementManager)this, this.getForestConfig()));
    }

    private QueryBatcher newQueryBatcher(QueryBatcherImpl batcher) {
        batcher.onQueryFailure(new HostAvailabilityListener(this));
        QueryJobReportListener queryJobListener = new QueryJobReportListener();
        batcher.onQueryFailure(queryJobListener);
        batcher.onQueryFailure(new NoResponseListener(this));
        batcher.onUrisReady(queryJobListener);
        return batcher;
    }

    ForestConfiguration getForestConfig() {
        if (this.forestConfig != null) {
            return this.forestConfig;
        }
        return this.readForestConfig();
    }

    @Override
    public ForestConfiguration readForestConfig() {
        this.forestConfig = this.service.readForestConfig();
        return this.forestConfig;
    }

    public DatabaseClient getForestClient(Forest forest) {
        if (forest == null) {
            throw new IllegalArgumentException("forest must not be null");
        }
        return this.getHostClient(forest.getPreferredHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseClient getHostClient(String hostName) {
        if (this.getConnectionType() == DatabaseClient.ConnectionType.GATEWAY) {
            return this.getPrimaryClient();
        }
        DatabaseClient client = this.clientMap.get(hostName);
        if (client != null) {
            return client;
        }
        Map<String, DatabaseClient> map = this.clientMap;
        synchronized (map) {
            client = this.clientMap.get(hostName);
            if (client != null) {
                return client;
            }
            client = new DatabaseClientBuilder().withHost(hostName).withPort(this.primaryClient.getPort()).withDatabase(this.primaryClient.getDatabase()).withBasePath(this.primaryClient.getBasePath()).withSecurityContext(this.primaryClient.getSecurityContext()).build();
            this.clientMap.put(hostName, client);
        }
        return client;
    }

    @Override
    public JobTicket getActiveJob(String jobId) {
        if (jobId == null) {
            throw new IllegalArgumentException("Job id must not be null");
        }
        return activeJobs.getOrDefault(jobId, null);
    }

    @Override
    public DatabaseClient.ConnectionType getConnectionType() {
        return this.primaryClient.getConnectionType();
    }

    @Override
    public <T> RowBatcher<T> newRowBatcher(ContentHandle<T> rowsHandle) {
        return new RowBatcherImpl<T>(this, rowsHandle);
    }

    @Override
    public JobTicket startJob(RowBatcher<?> batcher) {
        if (batcher == null) {
            throw new IllegalArgumentException("batcher must not be null");
        }
        return this.service.startJob(batcher, activeJobs);
    }

    public DataMovementServices getDataMovementServices() {
        return this.service;
    }

    public void setDataMovementServices(DataMovementServices service) {
        this.service = service;
    }

    public void setPrimaryClient(DatabaseClient client) {
        this.primaryClient = client;
        this.service.setClient(this.primaryClient);
    }

    public DatabaseClient getPrimaryClient() {
        return this.primaryClient;
    }

    public long getServerVersion() {
        return ((DatabaseClientImpl)this.getPrimaryClient()).getServerVersion();
    }
}

