/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.impl.BaseCallerImpl;
import com.marklogic.client.dataservices.impl.CallContextImpl;
import com.marklogic.client.dataservices.impl.HandleProvider;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

abstract class IOCallerImpl<I, O>
extends BaseCallerImpl {
    private final JsonNode apiDeclaration;
    private final String endpointPath;
    private final BaseProxy.DBFunctionRequest requester;
    private BaseCallerImpl.ParamdefImpl endpointStateParamdef;
    private BaseCallerImpl.ParamdefImpl sessionParamdef;
    private BaseCallerImpl.ParamdefImpl endpointConstantsParamdef;
    private BaseCallerImpl.ParamdefImpl inputParamdef;
    private BaseCallerImpl.ReturndefImpl returndef;
    private final HandleProvider<I, O> handleProvider;

    IOCallerImpl(JSONWriteHandle apiDeclaration, HandleProvider<I, O> handleProvider) {
        if (apiDeclaration == null) {
            throw new IllegalArgumentException("null endpoint declaration");
        }
        if (handleProvider == null) {
            throw new IllegalArgumentException("null handle provider");
        }
        this.apiDeclaration = NodeConverter.handleToJsonNode(apiDeclaration);
        if (!this.apiDeclaration.isObject()) {
            throw new IllegalArgumentException("endpoint declaration must be object: " + this.apiDeclaration);
        }
        this.handleProvider = handleProvider;
        this.endpointPath = IOCallerImpl.getText(this.apiDeclaration.get("endpoint"));
        if (this.endpointPath == null || this.endpointPath.length() == 0) {
            throw new IllegalArgumentException("no endpoint in endpoint declaration: " + this.apiDeclaration);
        }
        int nodeArgCount = 0;
        BaseHandle inputHandleBase = (BaseHandle)((Object)handleProvider.getInputHandle());
        BaseHandle outputHandleBase = (BaseHandle)((Object)handleProvider.getOutputHandle());
        JsonNode functionParams = this.apiDeclaration.get("params");
        if (functionParams != null) {
            if (!functionParams.isArray()) {
                throw new IllegalArgumentException("params must be array in endpoint declaration: " + this.apiDeclaration);
            }
            int paramCount = functionParams.size();
            if (paramCount > 0) {
                block13: for (JsonNode functionParam : functionParams) {
                    String paramName;
                    if (!functionParam.isObject()) {
                        throw new IllegalArgumentException("parameter must be object in endpoint declaration: " + functionParam);
                    }
                    BaseCallerImpl.ParamdefImpl paramdef = new BaseCallerImpl.ParamdefImpl(functionParam);
                    switch (paramName = paramdef.getParamName()) {
                        case "endpointState": {
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException("endpointState parameter cannot be multiple");
                            }
                            if (!paramdef.isNullable()) {
                                throw new IllegalArgumentException("endpointState parameter must be nullable");
                            }
                            this.endpointStateParamdef = paramdef;
                            ++nodeArgCount;
                            continue block13;
                        }
                        case "input": {
                            if (!paramdef.isMultiple()) {
                                throw new IllegalArgumentException("input parameter must be multiple");
                            }
                            if (!paramdef.isNullable()) {
                                throw new IllegalArgumentException("input parameter must be nullable");
                            }
                            this.inputParamdef = paramdef;
                            if (inputHandleBase == null) {
                                throw new IllegalArgumentException("no input handle provided for input parameter");
                            }
                            inputHandleBase.setFormat(paramdef.getFormat());
                            nodeArgCount += 2;
                            continue block13;
                        }
                        case "session": {
                            if (!"session".equalsIgnoreCase(paramdef.getDataType())) {
                                throw new IllegalArgumentException("session parameter must have session data type");
                            }
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException("session parameter cannot be multiple");
                            }
                            this.sessionParamdef = paramdef;
                            continue block13;
                        }
                        case "endpointConstants": 
                        case "workUnit": {
                            if (this.endpointConstantsParamdef != null) {
                                throw new IllegalArgumentException("can only declare one of " + paramName + " and " + this.endpointConstantsParamdef.getParamName());
                            }
                            if (paramdef.isMultiple()) {
                                throw new IllegalArgumentException(paramName + " parameter cannot be multiple");
                            }
                            this.endpointConstantsParamdef = paramdef;
                            ++nodeArgCount;
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException("unknown parameter name: " + paramName);
                }
            }
        }
        if (this.inputParamdef == null && inputHandleBase != null) {
            throw new IllegalArgumentException("no input parameter declared but input handle provided");
        }
        JsonNode functionReturn = this.apiDeclaration.get("return");
        if (functionReturn != null) {
            if (!functionReturn.isObject()) {
                throw new IllegalArgumentException("return must be object in endpoint declaration: " + functionReturn);
            }
            this.returndef = new BaseCallerImpl.ReturndefImpl(functionReturn);
            if (!this.returndef.isNullable()) {
                throw new IllegalArgumentException("return must be nullable");
            }
            if (outputHandleBase != null) {
                outputHandleBase.setFormat(this.returndef.getFormat());
            } else if (this.endpointStateParamdef == null) {
                throw new IllegalArgumentException("no output handle provided for return values");
            }
        } else if (outputHandleBase != null) {
            throw new IllegalArgumentException("no return values declared but output handle provided");
        }
        if (this.endpointStateParamdef != null) {
            if (this.returndef == null) {
                throw new IllegalArgumentException("endpointState parameter requires return in endpoint: " + this.getEndpointPath());
            }
            if (this.endpointStateParamdef.getFormat() != this.returndef.getFormat() && !"anyDocument".equals(this.returndef.getDataType())) {
                throw new IllegalArgumentException("endpointState format must match return format in endpoint: " + this.getEndpointPath());
            }
        }
        this.requester = BaseProxy.moduleRequest(this.getEndpointPath(), BaseProxy.ParameterValuesKind.forNodeCount(nodeArgCount));
    }

    BufferableContentHandle<?, ?>[] bufferableInputHandleOn(I[] input) {
        return this.handleProvider.bufferableInputHandleOn(input);
    }

    I[] newContentInputArray(int length) {
        return this.handleProvider.newInputArray(length);
    }

    O[] newContentOutputArray(int length) {
        return this.handleProvider.newOutputArray(length);
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, CallContextImpl<I, O> callCtxt) {
        return this.makeRequest(db, callCtxt, (RESTServices.CallField)null);
    }

    BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, CallContextImpl<I, O> callCtxt, BufferableContentHandle<?, ?>[] input) {
        RESTServices.MultipleNodeCallField inputField = null;
        BaseCallerImpl.ParamdefImpl paramdef = this.getInputParamdef();
        if (paramdef != null) {
            inputField = BaseProxy.documentParam("input", paramdef.isNullable(), input);
        } else if (input != null && input.length > 0) {
            throw new IllegalArgumentException("input parameter not supported by endpoint: " + this.getEndpointPath());
        }
        return this.makeRequest(db, callCtxt, inputField);
    }

    private BaseProxy.DBFunctionRequest makeRequest(DatabaseClient db, CallContextImpl<I, O> callCtxt, RESTServices.CallField inputField) {
        BaseProxy.DBFunctionRequest request = this.getRequester().on(db);
        SessionState session = callCtxt.getSessionState();
        if (this.getSessionParamdef() != null) {
            request = request.withSession(this.getSessionParamdef().getParamName(), session, this.getSessionParamdef().isNullable());
        } else if (session != null) {
            throw new IllegalArgumentException("session not supported by endpoint: " + this.getEndpointPath());
        }
        int fieldNum = 0;
        RESTServices.SingleNodeCallField endpointStateField = null;
        BytesHandle endpointState = callCtxt.getEndpointState();
        if (this.getEndpointStateParamdef() != null) {
            endpointStateField = BaseProxy.documentParam("endpointState", this.getEndpointStateParamdef().isNullable(), NodeConverter.withFormat(endpointState, this.getEndpointStateParamdef().getFormat()));
            if (endpointState != null) {
                ++fieldNum;
            }
        } else if (endpointState != null) {
            throw new IllegalArgumentException("endpointState parameter not supported by endpoint: " + this.getEndpointPath());
        }
        RESTServices.SingleNodeCallField endpointConstantsField = null;
        BytesHandle endpointConstants = callCtxt.getEndpointConstants();
        if (this.getEndpointConstantsParamdef() != null) {
            endpointConstantsField = BaseProxy.documentParam(this.getEndpointConstantsParamdef().getParamName(), this.getEndpointConstantsParamdef().isNullable(), NodeConverter.withFormat(endpointConstants, this.getEndpointConstantsParamdef().getFormat()));
            if (endpointConstants != null) {
                ++fieldNum;
            }
        } else if (endpointConstants != null) {
            throw new IllegalArgumentException(callCtxt.getEndpointConstantsParamName() + " parameter not supported by endpoint: " + this.getEndpointPath());
        }
        if (inputField != null) {
            ++fieldNum;
        }
        if (fieldNum > 0) {
            RESTServices.CallField[] fields = new RESTServices.CallField[fieldNum];
            fieldNum = 0;
            if (endpointStateField != null) {
                fields[fieldNum++] = endpointStateField;
            }
            if (endpointConstantsField != null) {
                fields[fieldNum++] = endpointConstantsField;
            }
            if (inputField != null) {
                fields[fieldNum++] = inputField;
            }
            request = request.withParams(fields);
        }
        return request;
    }

    boolean responseWithState(BaseProxy.DBFunctionRequest request, CallContextImpl<I, O> callCtxt) {
        if (this.getReturndef() == null) {
            request.responseNone();
            return false;
        }
        if (this.getReturndef().isMultiple()) {
            throw new UnsupportedOperationException("multiple return from endpoint: " + this.getEndpointPath());
        }
        return request.responseSingle(this.getReturndef().isNullable(), this.getReturndef().getFormat()).asEndpointState(callCtxt.getEndpointState());
    }

    O[] responseMultipleAsArray(BaseProxy.DBFunctionRequest request, CallContextImpl<I, O> callCtxt) {
        return this.handleProvider.outputAsArray(callCtxt, this.responseMultiple(request));
    }

    private RESTServices.MultipleCallResponse responseMultiple(BaseProxy.DBFunctionRequest request) {
        if (this.getReturndef() == null) {
            throw new UnsupportedOperationException("no return from endpoint: " + this.getEndpointPath());
        }
        if (!this.getReturndef().isMultiple()) {
            throw new UnsupportedOperationException("single return from endpoint: " + this.getEndpointPath());
        }
        return request.responseMultiple(this.getReturndef().isNullable(), this.getReturndef().getFormat());
    }

    JsonNode getApiDeclaration() {
        return this.apiDeclaration;
    }

    String getEndpointPath() {
        return this.endpointPath;
    }

    BaseCallerImpl.ParamdefImpl getEndpointStateParamdef() {
        return this.endpointStateParamdef;
    }

    BaseCallerImpl.ParamdefImpl getSessionParamdef() {
        return this.sessionParamdef;
    }

    BaseCallerImpl.ParamdefImpl getEndpointConstantsParamdef() {
        return this.endpointConstantsParamdef;
    }

    BaseCallerImpl.ParamdefImpl getInputParamdef() {
        return this.inputParamdef;
    }

    BaseCallerImpl.ReturndefImpl getReturndef() {
        return this.returndef;
    }

    BaseProxy.DBFunctionRequest getRequester() {
        return this.requester;
    }
}

