/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicInternalException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter {
    private XMLStreamWriter serializer;

    public DOMWriter() {
    }

    public DOMWriter(XMLStreamWriter serializer) {
        this();
        this.serializer = serializer;
    }

    public void serializeNodeList(NodeList list) throws XMLStreamException {
        for (int i = 0; i < list.getLength(); ++i) {
            this.serializeNode(list.item(i));
        }
    }

    public void serializeNode(Node node) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 9: {
                this.serializeDocument((Document)node);
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 4: {
                this.serializeCDATASection((CDATASection)node);
                break;
            }
            case 3: {
                this.serializeText((Text)node);
                break;
            }
            case 7: {
                this.serializeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.serializeComment((Comment)node);
                break;
            }
            default: {
                throw new MarkLogicInternalException("Cannot process node type of: " + node.getClass().getName());
            }
        }
    }

    public void serializeDocument(Document document) throws XMLStreamException {
        String encoding = document.getInputEncoding();
        String version = document.getXmlVersion();
        if (encoding != null) {
            this.serializer.writeStartDocument(encoding, version);
        } else {
            this.serializer.writeStartDocument(version);
        }
        if (document.hasChildNodes()) {
            this.serializeNodeList(document.getChildNodes());
        }
        this.serializer.writeEndDocument();
    }

    public void serializeElement(Element element) throws XMLStreamException {
        String localName;
        String namespaceURI = element.getNamespaceURI();
        String prefix = namespaceURI != null ? element.getPrefix() : null;
        String string = localName = namespaceURI != null ? element.getLocalName() : element.getTagName();
        if (element.hasChildNodes()) {
            if (prefix != null) {
                this.serializer.writeStartElement(prefix, localName, namespaceURI);
            } else if (namespaceURI != null) {
                this.serializer.writeStartElement("", localName, namespaceURI);
            } else {
                this.serializer.writeStartElement(localName);
            }
            if (element.hasAttributes()) {
                this.serializeAttributes(element.getAttributes());
            }
            this.serializeNodeList(element.getChildNodes());
            this.serializer.writeEndElement();
        } else {
            if (prefix != null) {
                this.serializer.writeEmptyElement(prefix, localName, namespaceURI);
            } else if (namespaceURI != null) {
                this.serializer.writeEmptyElement("", localName, namespaceURI);
            } else {
                this.serializer.writeEmptyElement(localName);
            }
            if (element.hasAttributes()) {
                this.serializeAttributes(element.getAttributes());
            }
        }
    }

    public void serializeAttributes(NamedNodeMap attributes) throws XMLStreamException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceURI = attribute.getNamespaceURI();
            String prefix = namespaceURI != null ? attribute.getPrefix() : null;
            String localName = namespaceURI != null ? attribute.getLocalName() : attribute.getName();
            String value = attribute.getValue();
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) continue;
            if (prefix != null) {
                this.serializer.writeAttribute(prefix, namespaceURI, localName, value);
                continue;
            }
            if (namespaceURI != null) {
                this.serializer.writeAttribute(namespaceURI, localName, value);
                continue;
            }
            this.serializer.writeAttribute(localName, value);
        }
    }

    public void serializeText(Text text) throws XMLStreamException {
        if (text != null) {
            this.serializer.writeCharacters(text.getData());
        }
    }

    public void serializeCDATASection(CDATASection cdata) throws XMLStreamException {
        this.serializer.writeCData(cdata.getData());
    }

    public void serializeComment(Comment comment) throws XMLStreamException {
        this.serializer.writeComment(comment.getData());
    }

    public void serializeProcessingInstruction(ProcessingInstruction pi) throws XMLStreamException {
        String target = pi.getTarget();
        String data = pi.getData();
        if (data != null) {
            this.serializer.writeProcessingInstruction(target, data);
        } else {
            this.serializer.writeProcessingInstruction(target);
        }
    }
}

