/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.document.DocumentDescriptor;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocumentWriteSetImpl
implements Set<DocumentWriteOperation>,
DocumentWriteSet {
    private List<DocumentWriteOperation> operations = new ArrayList<DocumentWriteOperation>();
    Boolean canSort = true;

    DocumentWriteSetImpl() {
    }

    @Override
    public DocumentWriteSet addDefault(DocumentMetadataWriteHandle metadataHandle) {
        if (this.canSort.booleanValue() && this.operations.size() > 0) {
            this.canSort = false;
        }
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.METADATA_DEFAULT, null, metadataHandle, null));
        return this;
    }

    @Override
    public DocumentWriteSet disableDefault() {
        if (this.canSort.booleanValue() && this.operations.size() > 0) {
            this.canSort = false;
        }
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DISABLE_METADATA_DEFAULT, null, new StringHandle("{ }").withFormat(Format.JSON), null));
        return this;
    }

    @Override
    public DocumentWriteSet add(String docId, AbstractWriteHandle contentHandle) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, docId, null, contentHandle));
        return this;
    }

    @Override
    public DocumentWriteSet addAs(String docId, Object content) {
        return this.addAs(docId, null, content);
    }

    @Override
    public DocumentWriteSet add(String docId, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, docId, metadataHandle, contentHandle));
        return this;
    }

    @Override
    public DocumentWriteSet addAs(String docId, DocumentMetadataWriteHandle metadataHandle, Object content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        Class<?> as = content.getClass();
        ContentHandle<?> handle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
        Utilities.setHandleContent(handle, content);
        return this.add(docId, metadataHandle, handle);
    }

    @Override
    public DocumentWriteSet add(DocumentDescriptor desc, AbstractWriteHandle contentHandle) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, desc.getUri(), null, contentHandle));
        return this;
    }

    @Override
    public DocumentWriteSet add(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, desc.getUri(), metadataHandle, contentHandle));
        return this;
    }

    @Override
    public DocumentWriteSet add(String docId, AbstractWriteHandle contentHandle, String temporalDocumentURI) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, docId, null, contentHandle, temporalDocumentURI));
        return this;
    }

    @Override
    public DocumentWriteSet addAs(String docId, Object content, String temporalDocumentURI) {
        return this.addAs(docId, null, content, temporalDocumentURI);
    }

    @Override
    public DocumentWriteSet add(String docId, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle, String temporalDocumentURI) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, docId, metadataHandle, contentHandle, temporalDocumentURI));
        return this;
    }

    @Override
    public DocumentWriteSet addAs(String docId, DocumentMetadataWriteHandle metadataHandle, Object content, String temporalDocumentURI) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        Class<?> as = content.getClass();
        ContentHandle<?> handle = DatabaseClientFactory.getHandleRegistry().makeHandle(as);
        Utilities.setHandleContent(handle, content);
        return this.add(docId, metadataHandle, handle, temporalDocumentURI);
    }

    @Override
    public DocumentWriteSet add(DocumentDescriptor desc, AbstractWriteHandle contentHandle, String temporalDocumentURI) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, desc.getUri(), null, contentHandle, temporalDocumentURI));
        return this;
    }

    @Override
    public DocumentWriteSet add(DocumentDescriptor desc, DocumentMetadataWriteHandle metadataHandle, AbstractWriteHandle contentHandle, String temporalDocumentURI) {
        this.add(new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, desc.getUri(), metadataHandle, contentHandle, temporalDocumentURI));
        return this;
    }

    @Override
    public int size() {
        return this.operations.size();
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.operations.contains(o);
    }

    @Override
    public Iterator<DocumentWriteOperation> iterator() {
        if (this.canSort.booleanValue()) {
            Collections.sort(this.operations);
        }
        return this.operations.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.operations.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.operations.toArray(a);
    }

    @Override
    public boolean add(DocumentWriteOperation documentWriteOperation) {
        return this.operations.add(documentWriteOperation);
    }

    @Override
    public boolean remove(Object o) {
        return this.operations.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.operations.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends DocumentWriteOperation> c) {
        return this.operations.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.operations.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.operations.removeAll(c);
    }

    @Override
    public void clear() {
        this.operations.clear();
    }
}

