/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.document.DocumentPage;
import com.marklogic.client.impl.BasicPage;
import com.marklogic.client.io.JacksonDatabindHandle;
import com.marklogic.client.pojo.PojoPage;
import java.util.Iterator;

public class PojoPageImpl<T>
extends BasicPage<T>
implements PojoPage<T>,
Iterator<T> {
    private Class<T> entityClass;
    private DocumentPage docPage;

    public PojoPageImpl(DocumentPage docPage, Class<T> entityClass) {
        super(entityClass);
        this.setStart(docPage.getStart());
        this.setSize(docPage.size());
        this.setPageSize(docPage.getPageSize());
        this.setTotalSize(docPage.getTotalSize());
        this.docPage = docPage;
        this.entityClass = entityClass;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.docPage.hasNext();
    }

    @Override
    public T next() {
        JacksonDatabindHandle<Class<T>> handle = new JacksonDatabindHandle<Class<T>>(this.entityClass);
        handle.getMapper().enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
        return (T)this.docPage.nextContent(handle).get();
    }

    @Override
    public void close() {
        this.docPage.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

