/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.JacksonBaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class JacksonHandle
extends JacksonBaseHandle<JsonNode>
implements ResendableContentHandle<JsonNode, InputStream>,
OutputStreamSender,
JSONReadHandle,
JSONWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
SPARQLResultsReadHandle {
    private JsonNode content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{JsonNode.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return JsonNode.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                JacksonHandle handle = this.isHandled(type) ? new JacksonHandle() : null;
                return handle;
            }
        };
    }

    public JacksonHandle() {
        this.setResendable(true);
    }

    public JacksonHandle(JsonNode content) {
        this();
        this.set(content);
    }

    public JacksonHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public JacksonHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public JsonNode get() {
        return this.content;
    }

    @Override
    public void set(JsonNode content) {
        this.content = content;
    }

    public JacksonHandle with(JsonNode content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<JsonNode> getContentClass() {
        return JsonNode.class;
    }

    @Override
    public JacksonHandle newHandle() {
        return new JacksonHandle().withMimetype(this.getMimetype());
    }

    public JacksonHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JacksonHandle[length];
    }

    public JsonNode[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new JsonNode[length];
    }

    @Override
    public JsonNode toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            JsonNode jsonNode = (JsonNode)this.getMapper().readValue((Reader)new InputStreamReader(serialization, StandardCharsets.UTF_8), JsonNode.class);
            return jsonNode;
        }
        catch (JsonParseException e) {
            throw new MarkLogicIOException(e);
        }
        catch (JsonMappingException e) {
            throw new MarkLogicIOException(e);
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
        finally {
            try {
                serialization.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected OutputStreamSender sendContent(JsonNode content) {
        if (content == null) {
            throw new IllegalStateException("No document to write");
        }
        return new OutputStreamSenderImpl(this.getMapper(), content);
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this.sendContent(this.get());
    }

    @Override
    protected void receiveContent(InputStream content) {
        this.set(this.toContent(content));
    }

    @Override
    protected boolean hasContent() {
        return this.content != null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final ObjectMapper mapper;
        private final JsonNode content;

        private OutputStreamSenderImpl(ObjectMapper mapper, JsonNode content) {
            this.mapper = mapper;
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            this.mapper.writeValue((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), (Object)this.content);
        }
    }
}

