/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
StreamingContentHandle<Reader, InputStream>,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamHandle.class);
    private Reader content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{Reader.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return Reader.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                ReaderHandle handle = this.isHandled(type) ? new ReaderHandle() : null;
                return handle;
            }
        };
    }

    public ReaderHandle() {
        this.setResendable(false);
    }

    public ReaderHandle(Reader content) {
        this();
        this.set(content);
    }

    @Override
    public Reader get() {
        return this.content;
    }

    @Override
    public void set(Reader content) {
        this.content = content;
    }

    public ReaderHandle with(Reader content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<Reader> getContentClass() {
        return Reader.class;
    }

    @Override
    public ReaderHandle newHandle() {
        return new ReaderHandle().withFormat(this.getFormat()).withMimetype(this.getMimetype());
    }

    public ReaderHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new ReaderHandle[length];
    }

    public Reader[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new Reader[length];
    }

    public ReaderHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public ReaderHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public Reader toContent(InputStream serialization) {
        return serialization == null ? null : new InputStreamReader(serialization, StandardCharsets.UTF_8);
    }

    @Override
    public Reader bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(Reader content) {
        if (content == null) {
            return null;
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            Utilities.write(content, (OutputStream)buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new MarkLogicIOException("Could not convert Reader to byte[] array", e);
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.content = new InputStreamReader(content, StandardCharsets.UTF_8);
    }

    @Override
    protected ReaderHandle sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No character stream to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.content == null) {
            throw new IllegalStateException("No character stream to send as output");
        }
        Utilities.write(this.content, out);
    }

    @Override
    public void close() {
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                logger.error("Failed to close underlying InputStream", (Throwable)e);
                throw new MarkLogicIOException(e);
            }
        }
    }
}

