/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class StringHandle
extends BaseHandle<byte[], OutputStreamSender>
implements ResendableContentHandle<String, byte[]>,
OutputStreamSender,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
SPARQLResultsReadHandle {
    private String content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{String.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return String.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                StringHandle handle = this.isHandled(type) ? new StringHandle() : null;
                return handle;
            }
        };
    }

    public StringHandle() {
        this.setResendable(true);
    }

    public StringHandle(String content) {
        this();
        this.set(content);
    }

    public StringHandle(Reader content) {
        this();
        this.from(content);
    }

    @Override
    public String get() {
        return this.content;
    }

    @Override
    public void set(String content) {
        this.content = content;
    }

    public StringHandle with(String content) {
        this.set(content);
        return this;
    }

    public StringHandle from(Reader content) {
        this.set(NodeConverter.ReaderToString(content));
        return this;
    }

    @Override
    public Class<String> getContentClass() {
        return String.class;
    }

    @Override
    public StringHandle newHandle() {
        return new StringHandle().withFormat(this.getFormat()).withMimetype(this.getMimetype());
    }

    public StringHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new StringHandle[length];
    }

    public String[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new String[length];
    }

    public StringHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public StringHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public String bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] contentToBytes(String content) {
        if (content == null) {
            return null;
        }
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.content;
    }

    @Override
    public String toContent(byte[] serialization) {
        if (serialization == null) {
            return null;
        }
        return new String(serialization, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<byte[]> receiveAs() {
        return byte[].class;
    }

    @Override
    protected void receiveContent(byte[] content) {
        this.set(this.toContent(content));
    }

    @Override
    protected OutputStreamSender sendContent() {
        return new OutputStreamSenderImpl(this.get());
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.sendContent().write(out);
    }

    private static class OutputStreamSenderImpl
    implements OutputStreamSender {
        private final String content;

        private OutputStreamSenderImpl(String content) {
            if (content == null) {
                throw new IllegalStateException("No string to send");
            }
            this.content = content;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            writer.write(this.content);
            writer.flush();
        }
    }
}

