/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.StreamingContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStreamReaderHandle
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
StreamingContentHandle<XMLStreamReader, InputStream>,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(XMLStreamReaderHandle.class);
    private XMLResolver resolver;
    private XMLStreamReader content;
    private InputStream contentSource;
    private XMLInputFactory factory;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{XMLStreamReader.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return XMLStreamReader.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                XMLStreamReaderHandle handle = this.isHandled(type) ? new XMLStreamReaderHandle() : null;
                return handle;
            }
        };
    }

    public XMLStreamReaderHandle() {
        super.setFormat(Format.XML);
        this.setResendable(false);
    }

    public XMLStreamReaderHandle(XMLStreamReader content) {
        this();
        this.set(content);
    }

    public XMLResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XMLStreamReader get() {
        return this.content;
    }

    @Override
    public void set(XMLStreamReader content) {
        this.content = content;
    }

    public XMLStreamReaderHandle with(XMLStreamReader content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<XMLStreamReader> getContentClass() {
        return XMLStreamReader.class;
    }

    @Override
    public XMLStreamReaderHandle newHandle() {
        return new XMLStreamReaderHandle().withMimetype(this.getMimetype());
    }

    public XMLStreamReaderHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new XMLStreamReaderHandle[length];
    }

    public XMLStreamReader[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new XMLStreamReader[length];
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("XMLStreamReaderHandle supports the XML format only");
        }
    }

    public XMLStreamReaderHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            this.content = null;
        } else {
            this.receiveContent(new ByteArrayInputStream(buffer));
        }
    }

    @Override
    public byte[] toBuffer() {
        try {
            if (this.content == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.write(buffer);
            byte[] b = buffer.toByteArray();
            this.fromBuffer(b);
            return b;
        }
        catch (IOException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public XMLStreamReader toContent(InputStream serialization) {
        if (serialization == null) {
            return null;
        }
        try {
            XMLInputFactory factory = this.getFactory();
            if (factory == null) {
                throw new MarkLogicInternalException("Failed to make StAX input factory");
            }
            if (this.resolver != null) {
                factory.setXMLResolver(this.resolver);
            }
            return factory.createXMLStreamReader(serialization, "UTF-8");
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX stream from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
        catch (FactoryConfigurationError e) {
            logger.error("Failed to parse StAX stream from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }

    @Override
    public XMLStreamReader bytesToContent(byte[] buffer) {
        return buffer == null || buffer.length == 0 ? null : this.toContent(new ByteArrayInputStream(buffer));
    }

    @Override
    public byte[] contentToBytes(XMLStreamReader content) {
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.write(this.content, buffer);
        return buffer.toByteArray();
    }

    @Override
    public void close() {
        try {
            if (this.content != null) {
                this.content.close();
            }
        }
        catch (XMLStreamException e) {
            logger.error("Failed to close underlying XMLStreamReader", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        finally {
            if (this.contentSource != null) {
                try {
                    this.contentSource.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close underlying InputStream", (Throwable)e);
                    throw new MarkLogicIOException(e);
                }
            }
        }
    }

    public String toString() {
        byte[] buffer = this.toBuffer();
        return buffer == null ? null : new String(buffer, StandardCharsets.UTF_8);
    }

    public XMLInputFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.makeXMLInputFactory();
        }
        return this.factory;
    }

    public void setFactory(XMLInputFactory factory) {
        this.factory = factory;
    }

    protected XMLInputFactory makeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            factory.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isValidating", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        if (content == null) {
            this.content = null;
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Parsing StAX stream from input stream");
        }
        this.content = this.toContent(content);
        this.contentSource = content;
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No input source to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(this.content, out);
    }

    private void write(XMLStreamReader content, OutputStream out) {
        try {
            XMLInputFactory inputFactory = this.getFactory();
            if (inputFactory == null) {
                throw new MarkLogicInternalException("Failed to make StAX input factory");
            }
            XMLEventReader reader = inputFactory.createXMLEventReader(content);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLEventWriter writer = outputFactory.createXMLEventWriter(out, "UTF-8");
            writer.add(reader);
            writer.flush();
            writer.close();
            content.close();
        }
        catch (XMLStreamException e) {
            logger.error("Failed to parse StAX events from input stream", (Throwable)e);
            throw new MarkLogicInternalException(e);
        }
    }
}

