/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class CacheBusterDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        Resource resource;
        String text = documentFile.getModifiedContent();
        if (text == null && (resource = documentFile.getResource()) != null) {
            try {
                text = new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()));
            }
            catch (IOException ie) {
                this.logger.warn("Unable to replace tokens in file: " + documentFile.getUri() + "; cause: " + ie.getMessage());
            }
        }
        if (text != null) {
            resource = documentFile.getResource();
            String comment = "";
            if (FilenameUtil.isJavascriptFile((String)resource.getFilename())) {
                comment = "// cache buster: " + UUID.randomUUID().toString() + "\n";
            } else if (FilenameUtil.isXqueryFile((String)resource.getFilename())) {
                comment = "(: cache buster: " + UUID.randomUUID().toString() + " :)\n";
            }
            text = comment + text;
            documentFile.setModifiedContent(text);
        }
        return documentFile;
    }
}

