/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub;

import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.InstallInfo;
import com.marklogic.hub.deploy.util.HubDeployStatusListener;
import com.marklogic.hub.error.CantUpgradeException;
import com.marklogic.hub.impl.DataHubImpl;
import com.marklogic.hub.util.Versions;
import java.util.HashMap;
import java.util.List;

public interface DataHub {
    public static DataHub create(HubConfig hubConfig) {
        return new DataHubImpl(hubConfig);
    }

    public void clearDatabase(String var1);

    public InstallInfo isInstalled();

    public boolean isServerVersionValid(String var1);

    public void initProject();

    public void clearUserModules();

    public HashMap runPreInstallCheck();

    public HashMap runPreInstallCheck(Versions var1);

    public void install();

    public void install(HubDeployStatusListener var1);

    public void updateIndexes();

    public void uninstall();

    public void uninstall(HubDeployStatusListener var1);

    public boolean isSafeToInstall();

    public boolean isPortInUse(DatabaseKind var1);

    public void setPortInUseBy(DatabaseKind var1, String var2);

    public String getPortInUseBy(DatabaseKind var1);

    public boolean isServerVersionOk();

    public void setServerVersionOk(boolean var1);

    public String getServerVersion();

    public void setServerVersion(String var1);

    public boolean upgradeHub() throws CantUpgradeException;

    public boolean upgradeHub(List<String> var1) throws CantUpgradeException;
}

