/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.impl.HubConfigImpl;
import java.nio.file.Path;
import javax.net.ssl.SSLContext;

@JsonDeserialize(as=HubConfigImpl.class)
@JsonSerialize(as=HubConfigImpl.class)
public interface HubConfig {
    public static final String HUB_MODULES_DEPLOY_TIMESTAMPS_PROPERTIES = "hub-modules-deploy-timestamps.properties";
    public static final String USER_MODULES_DEPLOY_TIMESTAMPS_PROPERTIES = "user-modules-deploy-timestamps.properties";
    public static final String USER_CONTENT_DEPLOY_TIMESTAMPS_PROPERTIES = "user-content-deploy-timestamps.properties";
    public static final String HUB_CONFIG_DIR = "hub-internal-config";
    public static final String USER_CONFIG_DIR = "user-config";
    public static final String ENTITY_CONFIG_DIR = "entity-config";
    public static final String STAGING_ENTITY_QUERY_OPTIONS_FILE = "staging-entity-options.xml";
    public static final String FINAL_ENTITY_QUERY_OPTIONS_FILE = "final-entity-options.xml";
    public static final String DEFAULT_STAGING_NAME = "data-hub-STAGING";
    public static final String DEFAULT_FINAL_NAME = "data-hub-FINAL";
    public static final String DEFAULT_TRACE_NAME = "data-hub-TRACING";
    public static final String DEFAULT_JOB_NAME = "data-hub-JOBS";
    public static final String DEFAULT_MODULES_DB_NAME = "data-hub-MODULES";
    public static final String DEFAULT_TRIGGERS_DB_NAME = "data-hub-TRIGGERS";
    public static final String DEFAULT_SCHEMAS_DB_NAME = "data-hub-SCHEMAS";
    public static final String DEFAULT_ROLE_NAME = "data-hub-role";
    public static final String DEFAULT_USER_NAME = "data-hub-user";
    public static final Integer DEFAULT_STAGING_PORT = 8010;
    public static final Integer DEFAULT_FINAL_PORT = 8011;
    public static final Integer DEFAULT_TRACE_PORT = 8012;
    public static final Integer DEFAULT_JOB_PORT = 8013;
    public static final String DEFAULT_AUTH_METHOD = "digest";
    public static final String DEFAULT_SCHEME = "http";
    public static final Integer DEFAULT_FORESTS_PER_HOST = 4;
    public static final String DEFAULT_CUSTOM_FOREST_PATH = "forests";

    public String getHost();

    public static HubConfig create(String projectDir) {
        return new HubConfigImpl(projectDir);
    }

    public String getDbName(DatabaseKind var1);

    public void setDbName(DatabaseKind var1, String var2);

    public String getHttpName(DatabaseKind var1);

    public void setHttpName(DatabaseKind var1, String var2);

    public Integer getForestsPerHost(DatabaseKind var1);

    public void setForestsPerHost(DatabaseKind var1, Integer var2);

    public Integer getPort(DatabaseKind var1);

    public void setPort(DatabaseKind var1, Integer var2);

    public SSLContext getSslContext(DatabaseKind var1);

    public void setSslContext(DatabaseKind var1, SSLContext var2);

    public void setSslHostnameVerifier(DatabaseKind var1, DatabaseClientFactory.SSLHostnameVerifier var2);

    public DatabaseClientFactory.SSLHostnameVerifier getSslHostnameVerifier(DatabaseKind var1);

    public String getAuthMethod(DatabaseKind var1);

    public void setAuthMethod(DatabaseKind var1, String var2);

    public String getScheme(DatabaseKind var1);

    public void setScheme(DatabaseKind var1, String var2);

    public boolean getSimpleSsl(DatabaseKind var1);

    public void setSimpleSsl(DatabaseKind var1, Boolean var2);

    public String getCertFile(DatabaseKind var1);

    public void setCertFile(DatabaseKind var1, String var2);

    public String getCertPassword(DatabaseKind var1);

    public void setCertPass(DatabaseKind var1, String var2);

    public String getExternalName(DatabaseKind var1);

    public void setExternalName(DatabaseKind var1, String var2);

    public String getHubRoleName();

    public void setHubRoleName(String var1);

    public String getHubUserName();

    public void setHubUserName(String var1);

    public String[] getLoadBalancerHosts();

    public String getCustomForestPath();

    public String getModulePermissions();

    public String getProjectDir();

    public void setProjectDir(String var1);

    public HubProject getHubProject();

    public void initHubProject();

    public String getHubModulesDeployTimestampFile();

    public String getUserModulesDeployTimestampFile();

    public DatabaseClient newAppServicesClient();

    public DatabaseClient newStagingClient();

    public DatabaseClient newStagingClient(String var1);

    public DatabaseClient newFinalClient();

    public DatabaseClient newJobDbClient();

    public DatabaseClient newTraceDbClient();

    public DatabaseClient newModulesDbClient();

    public Path getHubPluginsDir();

    public Path getHubEntitiesDir();

    public Path getHubConfigDir();

    public Path getHubDatabaseDir();

    public Path getHubServersDir();

    public Path getHubSecurityDir();

    public Path getUserConfigDir();

    public Path getUserSecurityDir();

    public Path getUserDatabaseDir();

    public Path getUserServersDir();

    public Path getEntityDatabaseDir();

    @JsonIgnore
    public AppConfig getAppConfig();

    public void setAppConfig(AppConfig var1);

    public void setAppConfig(AppConfig var1, boolean var2);

    public String getJarVersion();
}

