/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.collector.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.collector.Collector;
import com.marklogic.hub.collector.DiskQueue;
import com.marklogic.hub.flow.CodeFormat;
import com.marklogic.rest.util.MgmtResponseErrorHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLEncoder;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class CollectorImpl
implements Collector {
    private DatabaseClient client = null;
    private HubConfig hubConfig = null;
    private CodeFormat codeFormat;
    private String module;

    public CollectorImpl() {
    }

    public CollectorImpl(String module, CodeFormat codeFormat) {
        this.module = module;
        this.codeFormat = codeFormat;
    }

    @Override
    public void setHubConfig(HubConfig config) {
        this.hubConfig = config;
    }

    @Override
    public HubConfig getHubConfig() {
        return this.hubConfig;
    }

    @Override
    public void setClient(DatabaseClient client) {
        this.client = client;
    }

    @Override
    public DatabaseClient getClient() {
        return this.client;
    }

    @Override
    public CodeFormat getCodeFormat() {
        return this.codeFormat;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public DiskQueue<String> run(String jobId, String entity, String flow, int threadCount, Map<String, Object> options) {
        try {
            DiskQueue<String> results = new DiskQueue<String>(5000);
            AppConfig appConfig = this.hubConfig.getAppConfig();
            RestTemplate template = this.newRestTemplate(appConfig.getAppServicesUsername(), appConfig.getAppServicesPassword());
            String uriString = String.format("%s://%s:%d%s?job-id=%s&entity-name=%s&flow-name=%s&database=%s", this.client.getSecurityContext().getSSLContext() != null ? "https" : "http", this.client.getHost(), this.client.getPort(), "/v1/internal/hubcollector", URLEncoder.encode(jobId, "UTF-8"), URLEncoder.encode(entity, "UTF-8"), URLEncoder.encode(flow, "UTF-8"), URLEncoder.encode(this.client.getDatabase(), "UTF-8"));
            if (options != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                uriString = uriString + "&options=" + URLEncoder.encode(objectMapper.writeValueAsString(options), "UTF-8");
            }
            URI uri = new URI(uriString);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept", "text/plain");
            Resource responseBody = (Resource)template.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), Resource.class).getBody();
            if (responseBody != null) {
                String line;
                InputStream inputStream = responseBody.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = bufferedReader.readLine()) != null) {
                    results.add(line);
                }
                inputStream.close();
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private RestTemplate newRestTemplate(String username, String password) {
        DatabaseClientFactory.SecurityContext securityContext = this.client.getSecurityContext();
        BasicCredentialsProvider prov = new BasicCredentialsProvider();
        prov.setCredentials(new AuthScope(this.client.getHost(), this.client.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(username, password));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)prov);
        if (securityContext != null) {
            DatabaseClientFactory.SSLHostnameVerifier hostnameVerifier;
            SSLContext sslContext = securityContext.getSSLContext();
            if (sslContext != null) {
                httpClientBuilder.setSslcontext(sslContext);
            }
            if ((hostnameVerifier = securityContext.getSSLHostnameVerifier()) != null) {
                httpClientBuilder.setHostnameVerifier((X509HostnameVerifier)new HostnameVerifierAdapter(hostnameVerifier));
            }
        }
        CloseableHttpClient client = httpClientBuilder.build();
        RestTemplate rt = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)client));
        rt.setErrorHandler((ResponseErrorHandler)new MgmtResponseErrorHandler());
        return rt;
    }

    private static class HostnameVerifierAdapter
    implements X509HostnameVerifier {
        private DatabaseClientFactory.SSLHostnameVerifier verifier;

        HostnameVerifierAdapter(DatabaseClientFactory.SSLHostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public boolean verify(String hostname, SSLSession session) {
            try {
                Certificate[] certificates = session.getPeerCertificates();
                this.verify(hostname, (X509Certificate)certificates[0]);
                return true;
            }
            catch (SSLException e) {
                return false;
            }
        }

        public void verify(String s, SSLSocket sslSocket) throws IOException {
        }

        public void verify(String hostname, X509Certificate cert) throws SSLException {
            ArrayList<String> cnArray = new ArrayList<String>();
            try {
                LdapName ldapDN = new LdapName(cert.getSubjectX500Principal().getName());
                for (Rdn rdn : ldapDN.getRdns()) {
                    Object value = rdn.getValue();
                    if (!"CN".equalsIgnoreCase(rdn.getType()) || !(value instanceof String)) continue;
                    cnArray.add((String)value);
                }
                int type_dnsName = 2;
                int type_ipAddress = 7;
                ArrayList<String> subjectAltArray = new ArrayList<String>();
                Collection<List<?>> alts = cert.getSubjectAlternativeNames();
                if (alts != null) {
                    for (List<?> alt : alts) {
                        Integer type;
                        if (alt == null || alt.size() != 2 || !(alt.get(1) instanceof String) || (type = (Integer)alt.get(0)) != type_dnsName && type != type_ipAddress) continue;
                        subjectAltArray.add((String)alt.get(1));
                    }
                }
                String[] cns = cnArray.toArray(new String[cnArray.size()]);
                String[] subjectAlts = subjectAltArray.toArray(new String[subjectAltArray.size()]);
                this.verifier.verify(hostname, cns, subjectAlts);
            }
            catch (CertificateParsingException e) {
                throw new MarkLogicIOException((Throwable)e);
            }
            catch (InvalidNameException e) {
                throw new MarkLogicIOException((Throwable)e);
            }
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }
    }
}

