/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.UndoableCommand;
import com.marklogic.appdeployer.impl.SimpleAppDeployer;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.hub.deploy.util.HubDeployStatusListener;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HubAppDeployer
extends SimpleAppDeployer {
    private ManageClient manageClient;
    private AdminManager adminManager;
    private HubDeployStatusListener listener;

    public HubAppDeployer(ManageClient manageClient, AdminManager adminManager, HubDeployStatusListener listener) {
        super(manageClient, adminManager, new Command[0]);
        this.manageClient = manageClient;
        this.adminManager = adminManager;
        this.listener = listener;
    }

    public void deploy(AppConfig appConfig) {
        this.logger.info(this.format("Deploying app %s with config dir of: %s\n", new Object[]{appConfig.getName(), appConfig.getFirstConfigDir().getBaseDir().getAbsolutePath()}));
        List commands = this.getCommands();
        Collections.sort(commands, new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                return o1.getExecuteSortOrder().compareTo(o2.getExecuteSortOrder());
            }

            @Override
            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        });
        CommandContext context = new CommandContext(appConfig, this.manageClient, this.adminManager);
        int count = commands.size();
        int completed = 0;
        this.onStatusChange(0, "Installing...");
        for (Command command : commands) {
            String name = command.getClass().getName();
            this.logger.info(this.format("Executing command [%s] with sort order [%d]", new Object[]{name, command.getExecuteSortOrder()}));
            float percent = (float)completed / (float)count * 100.0f;
            this.onStatusChange((int)percent, this.format("[Step %d of %d]  %s", new Object[]{completed + 1, count, name}));
            command.execute(context);
            this.logger.info(this.format("Finished executing command [%s]\n", new Object[]{name}));
            ++completed;
        }
        this.onStatusChange(100, "Installation Complete");
        ServerEvaluationCall eval = appConfig.newDatabaseClient().newServerEval();
        String query = "xdmp:feature-metric-increment(xdmp:feature-metric-register(\"datahub.core.install.count\"))";
        try {
            eval.xquery(query).eval().close();
        }
        catch (FailedRequestException e) {
            this.logger.error("Failed to increment feature metric telemetry count: " + query, (Throwable)e);
            e.printStackTrace();
        }
        this.logger.info(this.format("Deployed app %s", new Object[]{appConfig.getName()}));
    }

    public void undeploy(AppConfig appConfig) {
        this.logger.info(this.format("Undeploying app %s with config dir: %s\n", new Object[]{appConfig.getName(), appConfig.getFirstConfigDir().getBaseDir().getAbsolutePath()}));
        List commands = this.getCommands();
        ArrayList<UndoableCommand> undoableCommands = new ArrayList<UndoableCommand>();
        for (Command command : commands) {
            if (!(command instanceof UndoableCommand)) continue;
            undoableCommands.add((UndoableCommand)command);
        }
        Collections.sort(undoableCommands, new Comparator<UndoableCommand>(){

            @Override
            public int compare(UndoableCommand o1, UndoableCommand o2) {
                return o1.getUndoSortOrder().compareTo(o2.getUndoSortOrder());
            }

            @Override
            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        });
        int count = undoableCommands.size();
        int completed = 0;
        this.onStatusChange(0, "Uninstalling...");
        for (UndoableCommand command : undoableCommands) {
            String name = command.getClass().getName();
            this.logger.info(this.format("Undoing command [%s] with sort order [%d]", new Object[]{name, command.getUndoSortOrder()}));
            float percent = (float)completed / (float)count * 100.0f;
            this.onStatusChange((int)percent, this.format("[Step %d of %d]  %s", new Object[]{completed + 1, count, name}));
            command.undo(new CommandContext(appConfig, this.manageClient, this.adminManager));
            this.logger.info(this.format("Finished undoing command [%s]\n", new Object[]{name}));
            ++completed;
        }
        this.onStatusChange(100, "Installation Complete");
        this.logger.info(this.format("Undeployed app %s", new Object[]{appConfig.getName()}));
    }

    private void onStatusChange(int percentComplete, String message) {
        if (this.listener != null) {
            this.listener.onStatusChange(percentComplete, message);
        }
    }

    private void onError() {
        if (this.listener != null) {
            this.listener.onError();
        }
    }
}

