/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.appdeployer.command.forests.DeployForestsCommand;
import com.marklogic.hub.HubConfig;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class DeployHubDatabaseCommand
extends DeployDatabaseCommand {
    private HubConfig hubConfig;
    private String databaseFilename;
    private boolean createDatabaseWithoutFile = false;
    private String databaseName;
    private String forestFilename;
    private int forestsPerHost = 1;
    private boolean createForestsOnEachHost = true;
    private String forestDelete = "data";
    private int undoSortOrder;

    public DeployHubDatabaseCommand(HubConfig config, String databaseFilename) {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_DATABASES);
        this.hubConfig = config;
        this.databaseFilename = databaseFilename;
        this.setForestFilename(databaseFilename.replace("-database", "-forest"));
    }

    public String toString() {
        return this.databaseFilename;
    }

    public Integer getUndoSortOrder() {
        return this.undoSortOrder;
    }

    public void execute(CommandContext context) {
        String payload = this.buildPayload(context);
        if (payload != null) {
            DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
            SaveReceipt receipt = dbMgr.save(payload);
            int forestCount = this.determineForestCountPerHost(payload, context);
            if (forestCount > 0) {
                this.buildDeployForestsCommand(payload, receipt, context).execute(context);
            }
        }
    }

    public void undo(CommandContext context) {
        String payload = this.buildPayload(context);
        if (payload != null) {
            DatabaseManager dbMgr = new DatabaseManager(context.getManageClient());
            dbMgr.setForestDelete(this.forestDelete);
            dbMgr.delete(payload, new String[0]);
        }
    }

    public String buildPayload(CommandContext context) {
        String payload = this.getPayload(context);
        return payload != null ? this.payloadTokenReplacer.replaceTokens(payload, context.getAppConfig(), false) : null;
    }

    protected String getPayload(CommandContext context) {
        JsonNode node = this.mergeDatabaseFiles(context.getAppConfig());
        if (node == null) {
            this.logger.info("No content database files found, so not processing");
            return null;
        }
        String str = node.toString();
        return str != null ? this.payloadTokenReplacer.replaceTokens(str, context.getAppConfig(), false) : str;
    }

    protected JsonNode mergeDatabaseFiles(AppConfig appConfig) {
        File entityDatabaseFile;
        ArrayList<File> files = new ArrayList<File>();
        File databaseDir = this.hubConfig.getHubDatabaseDir().toFile();
        File userDatabaseDir = this.hubConfig.getUserDatabaseDir().toFile();
        File entityDatabaseDir = this.hubConfig.getEntityDatabaseDir().toFile();
        files.add(new File(databaseDir, this.databaseFilename));
        File userDatabaseFile = new File(userDatabaseDir, this.databaseFilename);
        if (userDatabaseFile != null && userDatabaseFile.exists()) {
            files.add(userDatabaseFile);
        }
        if ((entityDatabaseFile = new File(entityDatabaseDir, this.databaseFilename)) != null && entityDatabaseFile.exists()) {
            files.add(entityDatabaseFile);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Merging JSON files at locations: " + files);
        }
        return JsonNodeUtil.mergeJsonFiles(files);
    }

    protected DeployForestsCommand buildDeployForestsCommand(String dbPayload, SaveReceipt receipt, CommandContext context) {
        DeployForestsCommand c = new DeployForestsCommand();
        c.setCreateForestsOnEachHost(this.createForestsOnEachHost);
        c.setForestsPerHost(this.determineForestCountPerHost(dbPayload, context));
        c.setForestFilename(this.forestFilename);
        c.setDatabaseName(receipt.getResourceId());
        c.setForestPayload("{\"forest-name\": \"%%FOREST_NAME%%\", \"host\": \"%%FOREST_HOST%%\", \"database\": \"%%FOREST_DATABASE%%\"}");
        return c;
    }

    protected int determineForestCountPerHost(String dbPayload, CommandContext context) {
        int forestCount = this.forestsPerHost;
        if (dbPayload != null) {
            try {
                Integer i;
                String dbName = new PayloadParser().getPayloadFieldValue(dbPayload, "database-name");
                Map forestCounts = context.getAppConfig().getForestCounts();
                if (forestCounts != null && forestCounts.containsKey(dbName) && (i = (Integer)forestCounts.get(dbName)) != null) {
                    forestCount = i;
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unable to determine forest counts, cause: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return forestCount;
    }

    protected String buildDefaultDatabasePayload(CommandContext context) {
        return this.format("{\"database-name\": \"%s\"}", new Object[]{this.databaseName});
    }

    public String getForestDelete() {
        return this.forestDelete;
    }

    public void setForestDelete(String forestDelete) {
        this.forestDelete = forestDelete;
    }

    public int getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(int forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public String getForestFilename() {
        return this.forestFilename;
    }

    public void setForestFilename(String forestFilename) {
        this.forestFilename = forestFilename;
    }

    public void setUndoSortOrder(int undoSortOrder) {
        this.undoSortOrder = undoSortOrder;
    }

    public String getDatabaseFilename() {
        return this.databaseFilename;
    }

    public void setDatabaseFilename(String databaseFilename) {
        this.databaseFilename = databaseFilename;
    }

    public boolean isCreateDatabaseWithoutFile() {
        return this.createDatabaseWithoutFile;
    }

    public void setCreateDatabaseWithoutFile(boolean createDatabaseWithoutFile) {
        this.createDatabaseWithoutFile = createDatabaseWithoutFile;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isCreateForestsOnEachHost() {
        return this.createForestsOnEachHost;
    }

    public void setCreateForestsOnEachHost(boolean createForestsOnEachHost) {
        this.createForestsOnEachHost = createForestsOnEachHost;
    }
}

