/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractUndoableCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandComparator;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.commands.DeployHubDatabaseCommand;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DeployHubDatabasesCommand
extends AbstractUndoableCommand {
    private HubConfig hubConfig;

    public DeployHubDatabasesCommand(HubConfig config) {
        this.hubConfig = config;
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_DATABASES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_DATABASES);
    }

    public void execute(CommandContext context) {
        List<DeployDatabaseCommand> list = this.buildDatabaseCommands(context);
        this.sortCommandsBeforeExecute(list, context);
        for (DeployDatabaseCommand c : list) {
            c.execute(context);
        }
    }

    protected void sortCommandsBeforeExecute(List<DeployDatabaseCommand> list, CommandContext context) {
        Collections.sort(list, new DeployDatabaseCommandComparator(context, false));
    }

    public void undo(CommandContext context) {
        List<DeployDatabaseCommand> list = this.buildDatabaseCommands(context);
        this.sortCommandsBeforeUndo(list, context);
        for (DeployDatabaseCommand c : list) {
            c.undo(context);
        }
    }

    protected void sortCommandsBeforeUndo(List<DeployDatabaseCommand> list, CommandContext context) {
        Collections.sort(list, new DeployDatabaseCommandComparator(context, true));
    }

    protected List<DeployDatabaseCommand> buildDatabaseCommands(CommandContext context) {
        ArrayList<DeployDatabaseCommand> dbCommands = new ArrayList<DeployDatabaseCommand>();
        ConfigDir configDir = new ConfigDir(this.hubConfig.getHubConfigDir().toFile());
        File dir = configDir.getDatabasesDir();
        if (dir != null && dir.exists()) {
            HashSet<String> ignore = new HashSet<String>();
            for (File f : configDir.getContentDatabaseFiles()) {
                ignore.add(f.getName());
            }
            ignore.add("schemas-database.json");
            ignore.add("triggers-database.json");
            ResourceFilenameFilter filter = new ResourceFilenameFilter(ignore);
            this.setResourceFilenameFilter((FilenameFilter)filter);
            for (File f : this.listFilesInDirectory(dir)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Will process other database in file: " + f.getName());
                }
                DeployHubDatabaseCommand c = new DeployHubDatabaseCommand(this.hubConfig, f.getName());
                dbCommands.add(c);
            }
        }
        return dbCommands;
    }
}

