/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceFilenameFilter;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.hub.HubConfig;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public class DeployHubServersCommand
extends AbstractResourceCommand {
    private HubConfig hubConfig;

    public DeployHubServersCommand(HubConfig config) {
        this.hubConfig = config;
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_OTHER_SERVERS);
        this.setUndoSortOrder(SortOrderConstants.DELETE_OTHER_SERVERS);
        this.setRestartAfterDelete(true);
        this.setCatchExceptionOnDeleteFailure(true);
        this.setResourceFilenameFilter((FilenameFilter)new ResourceFilenameFilter(new String[]{"rest-api-server.xml", "rest-api-server.json"}));
    }

    protected File[] getResourceDirs(CommandContext context) {
        return new File[]{this.hubConfig.getHubServersDir().toFile()};
    }

    protected ResourceManager getResourceManager(CommandContext context) {
        return new ServerManager(context.getManageClient(), context.getAppConfig().getGroupName());
    }

    public Integer getUndoSortOrder() {
        return 0;
    }

    protected SaveReceipt saveResource(ResourceManager mgr, CommandContext context, File f) {
        String payload = this.getPayload(f, context);
        return mgr.save(payload);
    }

    protected void deleteResource(ResourceManager mgr, CommandContext context, File f) {
        String payload = this.getPayload(f, context);
        if (this.isRestartAfterDelete()) {
            context.getAdminManager().invokeActionRequiringRestart(() -> mgr.delete(payload, new String[0]).isDeleted());
        } else {
            mgr.delete(payload, new String[0]);
        }
    }

    protected String getPayload(File f, CommandContext context) {
        JsonNode node = this.mergeServerFiles(f);
        if (node == null) {
            this.logger.info("No server files found, so not processing");
            return null;
        }
        String str = node.toString();
        return str != null ? this.payloadTokenReplacer.replaceTokens(str, context.getAppConfig(), false) : str;
    }

    protected JsonNode mergeServerFiles(File f) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(f);
        File userServerDir = this.hubConfig.getUserServersDir().toFile();
        File otherServerFile = new File(userServerDir, f.getName());
        if (otherServerFile != null && otherServerFile.exists()) {
            files.add(otherServerFile);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Merging JSON files at locations: " + files);
        }
        return JsonNodeUtil.mergeJsonFiles(files);
    }
}

