/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.es.GenerateModelArtifactsCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.es.CodeGenerationRequest;
import com.marklogic.client.ext.es.EntityServicesManager;
import com.marklogic.client.ext.es.GeneratedCode;
import com.marklogic.hub.HubConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateHubTDETemplateCommand
extends GenerateModelArtifactsCommand {
    private static final String ENTITY_FILE_EXTENSION = ".entity.json";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HubConfig hubConfig;
    private String entityNames;

    public GenerateHubTDETemplateCommand(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        DatabaseClient client = appConfig.newDatabaseClient();
        EntityServicesManager mgr = new EntityServicesManager(client);
        CodeGenerationRequest request = GenerateHubTDETemplateCommand.createCodeGenerationRequest();
        List<File> entityFiles = this.findEntityFiles();
        if (!entityFiles.isEmpty()) {
            Map<String, File> entityNameFileMap = GenerateHubTDETemplateCommand.createEntityNameFileMap(entityFiles);
            this.logger.debug("Found the following entities->files: {} " + entityNameFileMap);
            this.filterEntities(entityNameFileMap);
            if (!entityNameFileMap.isEmpty()) {
                this.logger.warn("About to generate a template for the following entities: {} into directory {} ", entityNameFileMap.keySet(), (Object)this.hubConfig.getAppConfig().getSchemasPath());
                for (File f : entityNameFileMap.values()) {
                    GeneratedCode code = this.loadModelDefinition(request, f, mgr);
                    this.generateExtractionTemplate(appConfig, code);
                }
            }
        } else {
            this.logger.info("No data hub entity files found under {} or its sub-directories.", (Object)this.hubConfig.getHubEntitiesDir());
        }
    }

    public String getEntityNames() {
        return this.entityNames;
    }

    public void setEntityNames(String entityNames) {
        this.entityNames = entityNames;
    }

    protected void filterEntities(Map<String, File> entityNameFileMap) {
        Set<String> entityNameFileMapKeys = entityNameFileMap.keySet();
        if (this.entityNames != null && !this.entityNames.isEmpty()) {
            List<String> entityNamesAsList = Arrays.asList(this.entityNames.split(","));
            this.logger.info("Entities specified for TDE Generation: {} " + entityNamesAsList);
            entityNameFileMapKeys.retainAll(entityNamesAsList);
            if (entityNameFileMapKeys.isEmpty()) {
                this.logger.warn("No entities files found under {} or its sub-directories with the entity name(s) {}", (Object)this.hubConfig.getHubEntitiesDir(), entityNamesAsList);
            }
        }
    }

    protected static Map<String, File> createEntityNameFileMap(List<File> entityFiles) {
        if (entityFiles == null) {
            return Collections.emptyMap();
        }
        return entityFiles.stream().collect(Collectors.toMap(GenerateHubTDETemplateCommand.extractEntityNameFunction(), Function.identity()));
    }

    protected List<File> findEntityFiles() {
        ArrayList<File> entities = new ArrayList<File>();
        Path entitiesPath = this.hubConfig.getHubEntitiesDir();
        File[] entityDirectories = entitiesPath.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.isHidden());
        if (entityDirectories != null) {
            List entityNames = Arrays.stream(entityDirectories).map(file -> file.getName()).collect(Collectors.toList());
            for (String entityName : entityNames) {
                File[] entityDefs = entitiesPath.resolve(entityName).toFile().listFiles((dir, name) -> name.endsWith(ENTITY_FILE_EXTENSION));
                if (entityDefs == null) continue;
                entities.addAll(Arrays.asList(entityDefs));
            }
        }
        return entities;
    }

    protected static Optional<String> extactEntityNameFromFilename(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return Optional.of(null);
        }
        int index = filename.indexOf(ENTITY_FILE_EXTENSION);
        if (index < 0) {
            return Optional.of(null);
        }
        return Optional.of(filename.substring(0, index));
    }

    private static Function<File, String> extractEntityNameFunction() {
        Function<File, String> fileName = File::getName;
        return fileName.andThen(name -> GenerateHubTDETemplateCommand.extactEntityNameFromFilename(name).get());
    }

    private static final CodeGenerationRequest createCodeGenerationRequest() {
        CodeGenerationRequest request = new CodeGenerationRequest();
        request.setGenerateExtractionTemplate(true);
        request.setGenerateDatabaseProperties(false);
        request.setGenerateInstanceConverter(false);
        request.setGenerateSchema(false);
        request.setGenerateSearchOptions(false);
        return request;
    }
}

