/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.CollectionsDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.file.JarDocumentFileReader;
import com.marklogic.client.ext.file.PermissionsDocumentFileProcessor;
import com.marklogic.client.ext.file.TokenReplacerDocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.tokenreplacer.DefaultTokenReplacer;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.com.marklogic.client.ext.modulesloader.impl.SearchOptionsFinder;
import com.marklogic.hub.HubConfig;
import java.util.Map;
import java.util.Properties;

public class LoadHubModulesCommand
extends AbstractCommand {
    private HubConfig hubConfig;
    private Throwable caughtException;

    public LoadHubModulesCommand(HubConfig hubConfig) {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_MODULES);
        this.hubConfig = hubConfig;
    }

    private TokenReplacer buildModuleTokenReplacer(AppConfig appConfig) {
        DefaultTokenReplacer r = new DefaultTokenReplacer();
        Map customTokens = appConfig.getCustomTokens();
        if (customTokens != null && !customTokens.isEmpty()) {
            r.addPropertiesSource(() -> {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)customTokens);
                return p;
            });
        }
        return r;
    }

    public void execute(CommandContext context) {
        String timestampFile = this.hubConfig.getHubModulesDeployTimestampFile();
        PropertiesModuleManager propsManager = new PropertiesModuleManager(timestampFile);
        propsManager.deletePropertiesFile();
        DatabaseClient modulesClient = this.hubConfig.newModulesDbClient();
        AppConfig appConfig = context.getAppConfig();
        AssetFileLoader assetFileLoader = new AssetFileLoader(modulesClient);
        JarDocumentFileReader jarDocumentFileReader = new JarDocumentFileReader();
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new TokenReplacerDocumentFileProcessor(this.buildModuleTokenReplacer(appConfig)));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new CollectionsDocumentFileProcessor(new String[]{"hub-core-module"}));
        jarDocumentFileReader.addDocumentFileProcessor((DocumentFileProcessor)new PermissionsDocumentFileProcessor(appConfig.getModulePermissions()));
        assetFileLoader.setDocumentFileReader((DocumentFileReader)jarDocumentFileReader);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.addFailureListener(throwable -> {
            if (this.caughtException == null) {
                this.caughtException = throwable;
            }
        });
        modulesLoader.setModulesManager((ModulesManager)propsManager);
        if (this.caughtException == null) {
            modulesLoader.loadModules("classpath*:/ml-modules", (ModulesFinder)new DefaultModulesFinder(), modulesClient);
        }
        if (this.caughtException == null) {
            modulesLoader.loadModules("classpath*:/ml-modules-traces", (ModulesFinder)new SearchOptionsFinder(), this.hubConfig.newTraceDbClient());
        }
        if (this.caughtException == null) {
            modulesLoader.loadModules("classpath*:/ml-modules-jobs", (ModulesFinder)new SearchOptionsFinder(), this.hubConfig.newJobDbClient());
        }
        if (this.caughtException == null) {
            modulesLoader.loadModules("classpath*:/ml-modules-final", (ModulesFinder)new SearchOptionsFinder(), this.hubConfig.newFinalClient());
        }
        if (this.caughtException != null) {
            throw new RuntimeException(this.caughtException);
        }
    }
}

