/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.modules.AllButAssetsModulesFinder;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.Modules;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.com.marklogic.client.ext.modulesloader.impl.EntityDefModulesFinder;
import com.marklogic.com.marklogic.client.ext.modulesloader.impl.UserModulesFinder;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.HubFileFilter;
import com.marklogic.hub.error.LegacyFlowsException;
import com.marklogic.hub.flow.Flow;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class LoadUserModulesCommand
extends AbstractCommand {
    private HubConfig hubConfig;
    private DocumentPermissionsParser documentPermissionsParser = new DefaultDocumentPermissionsParser();
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private boolean forceLoad = false;

    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    public LoadUserModulesCommand(HubConfig hubConfig) {
        this.setExecuteSortOrder(SortOrderConstants.LOAD_MODULES + 1);
        this.hubConfig = hubConfig;
    }

    private PropertiesModuleManager getModulesManager() {
        String timestampFile = this.hubConfig.getUserModulesDeployTimestampFile();
        PropertiesModuleManager pmm = new PropertiesModuleManager(timestampFile);
        if (this.forceLoad) {
            pmm.deletePropertiesFile();
        }
        return pmm;
    }

    private AssetFileLoader getAssetFileLoader(AppConfig config, PropertiesModuleManager moduleManager) {
        AssetFileLoader assetFileLoader = new AssetFileLoader(this.hubConfig.newModulesDbClient(), (ModulesManager)moduleManager);
        assetFileLoader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        assetFileLoader.addFileFilter((FileFilter)new HubFileFilter());
        assetFileLoader.setPermissions(config.getModulePermissions());
        return assetFileLoader;
    }

    private DefaultModulesLoader getStagingModulesLoader(AppConfig config) {
        this.threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        this.threadPoolTaskExecutor.setCorePoolSize(16);
        this.threadPoolTaskExecutor.setAwaitTerminationSeconds(600);
        this.threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        this.threadPoolTaskExecutor.afterPropertiesSet();
        PropertiesModuleManager moduleManager = this.getModulesManager();
        AssetFileLoader assetFileLoader = this.getAssetFileLoader(config, moduleManager);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.setModulesManager((ModulesManager)moduleManager);
        modulesLoader.setTaskExecutor((TaskExecutor)this.threadPoolTaskExecutor);
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(false);
        return modulesLoader;
    }

    boolean isInputRestDir(Path dir) {
        return dir.endsWith("REST") && dir.toString().matches(".*[/\\\\]input[/\\\\].*");
    }

    boolean isHarmonizeRestDir(Path dir) {
        return dir.endsWith("REST") && dir.toString().matches(".*[/\\\\]harmonize[/\\\\].*");
    }

    boolean isEntityDir(Path dir, Path startPath) {
        String dirStr = dir.toString();
        String startPathStr = Pattern.quote(startPath.toString());
        String regex = startPathStr + "[/\\\\][^/\\\\]+$";
        return dirStr.matches(regex);
    }

    boolean isFlowPropertiesFile(Path dir) {
        Path parent = dir.getParent();
        return dir.toFile().isFile() && dir.getFileName().toString().endsWith(".properties") && parent.toString().matches(".*[/\\\\](input|harmonize)[/\\\\][^/\\\\]+$") && dir.getFileName().toString().equals(parent.getFileName().toString() + ".properties");
    }

    public void execute(CommandContext context) {
        final FlowManager flowManager = FlowManager.create(this.hubConfig);
        List<String> legacyFlows = flowManager.getLegacyFlows();
        if (legacyFlows.size() > 0) {
            throw new LegacyFlowsException(legacyFlows);
        }
        AppConfig config = context.getAppConfig();
        final DatabaseClient stagingClient = this.hubConfig.newStagingClient();
        final DatabaseClient finalClient = this.hubConfig.newFinalClient();
        Path userModulesPath = this.hubConfig.getHubPluginsDir();
        String baseDir = userModulesPath.normalize().toAbsolutePath().toString();
        final Path startPath = userModulesPath.resolve("entities");
        final DefaultModulesLoader modulesLoader = this.getStagingModulesLoader(config);
        modulesLoader.loadModules(baseDir, (ModulesFinder)new UserModulesFinder(), stagingClient);
        final JSONDocumentManager entityDocMgr = finalClient.newJSONDocumentManager();
        final AllButAssetsModulesFinder allButAssetsModulesFinder = new AllButAssetsModulesFinder();
        Path dir = Paths.get(this.hubConfig.getProjectDir(), "entity-config");
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        EntityManager entityManager = EntityManager.create(this.hubConfig);
        entityManager.deployQueryOptions();
        try {
            if (startPath.toFile().exists()) {
                XMLDocumentManager documentManager = this.hubConfig.newModulesDbClient().newXMLDocumentManager();
                final DocumentWriteSet documentWriteSet = documentManager.newWriteSet();
                final ModulesManager modulesManager = modulesLoader.getModulesManager();
                Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String currentDir = dir.normalize().toAbsolutePath().toString();
                        if (LoadUserModulesCommand.this.isInputRestDir(dir)) {
                            modulesLoader.loadModules(currentDir, (ModulesFinder)allButAssetsModulesFinder, stagingClient);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (LoadUserModulesCommand.this.isHarmonizeRestDir(dir)) {
                            modulesLoader.loadModules(currentDir, (ModulesFinder)allButAssetsModulesFinder, finalClient);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (LoadUserModulesCommand.this.isEntityDir(dir, startPath.toAbsolutePath())) {
                            Modules modules = new EntityDefModulesFinder().findModules(dir.toString());
                            DocumentMetadataHandle meta = new DocumentMetadataHandle();
                            meta.getCollections().add((Object)"http://marklogic.com/entity-services/models");
                            LoadUserModulesCommand.this.documentPermissionsParser.parsePermissions(LoadUserModulesCommand.this.hubConfig.getModulePermissions(), meta.getPermissions());
                            for (Resource r : modules.getAssets()) {
                                if (!LoadUserModulesCommand.this.forceLoad && !modulesManager.hasFileBeenModifiedSinceLastLoaded(r.getFile())) continue;
                                InputStream inputStream = r.getInputStream();
                                StringHandle handle = new StringHandle(IOUtils.toString((InputStream)inputStream));
                                inputStream.close();
                                entityDocMgr.write("/entities/" + r.getFilename(), (DocumentMetadataWriteHandle)meta, (AbstractWriteHandle)handle);
                                modulesManager.saveLastLoadedTimestamp(r.getFile(), new Date());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (LoadUserModulesCommand.this.isFlowPropertiesFile(file) && modulesManager.hasFileBeenModifiedSinceLastLoaded(file.toFile())) {
                            Flow flow = flowManager.getFlowFromProperties(file);
                            StringHandle handle = new StringHandle(flow.serialize());
                            handle.setFormat(Format.XML);
                            documentWriteSet.add(flow.getFlowDbPath(), (AbstractWriteHandle)handle);
                            modulesManager.saveLastLoadedTimestamp(file.toFile(), new Date());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (documentWriteSet.size() > 0) {
                    documentManager.write(documentWriteSet);
                }
            }
            this.threadPoolTaskExecutor.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

