/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.flow;

import com.marklogic.hub.collector.Collector;
import com.marklogic.hub.collector.impl.CollectorImpl;
import com.marklogic.hub.flow.CodeFormat;
import com.marklogic.hub.flow.DataFormat;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.FlowType;
import com.marklogic.hub.flow.impl.FlowImpl;
import com.marklogic.hub.main.MainPlugin;
import com.marklogic.hub.main.impl.MainPluginImpl;

public class FlowBuilder {
    Flow flow = new FlowImpl();

    private FlowBuilder() {
    }

    public static FlowBuilder newFlow() {
        return new FlowBuilder();
    }

    public FlowBuilder withName(String flowName) {
        this.flow.setName(flowName);
        return this;
    }

    public FlowBuilder withEntityName(String entityName) {
        this.flow.setEntityName(entityName);
        return this;
    }

    public FlowBuilder withType(FlowType type) {
        this.flow.setType(type);
        return this;
    }

    public FlowBuilder withDataFormat(DataFormat dataFormat) {
        this.flow.setDataFormat(dataFormat);
        return this;
    }

    public FlowBuilder withCodeFormat(CodeFormat codeFormat) {
        this.flow.setCodeFormat(codeFormat);
        return this;
    }

    public FlowBuilder withCollector(Collector collector) {
        this.flow.setCollector(collector);
        return this;
    }

    public FlowBuilder withMain(MainPlugin main) {
        this.flow.setMain(main);
        return this;
    }

    public Flow build() {
        if (this.flow.getCollector() == null && this.flow.getType().equals((Object)FlowType.HARMONIZE)) {
            String collectorModule = "collector." + this.flow.getCodeFormat().toString();
            this.flow.setCollector(new CollectorImpl(collectorModule, this.flow.getCodeFormat()));
        }
        if (this.flow.getMain() == null) {
            String mainModule = "main." + this.flow.getCodeFormat().toString();
            this.flow.setMain(new MainPluginImpl(mainModule, this.flow.getCodeFormat()));
        }
        return this.flow;
    }
}

