/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.flow.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.hub.collector.Collector;
import com.marklogic.hub.collector.impl.CollectorImpl;
import com.marklogic.hub.flow.CodeFormat;
import com.marklogic.hub.flow.DataFormat;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.FlowBuilder;
import com.marklogic.hub.flow.FlowType;
import com.marklogic.hub.main.MainPlugin;
import com.marklogic.hub.main.impl.MainPluginImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FlowImpl
implements Flow {
    private String entityName;
    private String name;
    private FlowType type;
    private DataFormat dataFormat;
    private CodeFormat codeFormat;
    private Collector collector;
    private MainPlugin main;

    @Override
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(FlowType type) {
        this.type = type;
    }

    @Override
    public FlowType getType() {
        return this.type;
    }

    @Override
    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void setCodeFormat(CodeFormat codeFormat) {
        this.codeFormat = codeFormat;
    }

    @Override
    public CodeFormat getCodeFormat() {
        return this.codeFormat;
    }

    @Override
    public Collector getCollector() {
        return this.collector;
    }

    @Override
    public void setCollector(Collector collector) {
        this.collector = collector;
    }

    @Override
    public MainPlugin getMain() {
        return this.main;
    }

    @Override
    public void setMain(MainPlugin main) {
        this.main = main;
    }

    private XMLStreamWriter makeXMLSerializer(StringWriter writer) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        try {
            return factory.createXMLStreamWriter(writer);
        }
        catch (Exception e) {
            throw new MarkLogicIOException((Throwable)e);
        }
    }

    @Override
    public String serialize() {
        try {
            StringWriter writer = new StringWriter();
            XMLStreamWriter serializer = this.makeXMLSerializer(writer);
            serializer.writeStartDocument();
            serializer.writeComment("This file is autogenerated. Please don't edit.");
            serializer.setDefaultNamespace("http://marklogic.com/data-hub");
            serializer.writeStartElement("flow");
            serializer.writeStartElement("name");
            serializer.writeCharacters(this.name);
            serializer.writeEndElement();
            serializer.writeStartElement("entity");
            serializer.writeCharacters(this.entityName);
            serializer.writeEndElement();
            serializer.writeStartElement("type");
            serializer.writeCharacters(this.type.toString());
            serializer.writeEndElement();
            serializer.writeStartElement("data-format");
            serializer.writeCharacters(this.dataFormat.toString());
            serializer.writeEndElement();
            serializer.writeStartElement("code-format");
            serializer.writeCharacters(this.codeFormat.toString());
            serializer.writeEndElement();
            String flowDir = "/entities/" + this.getEntityName() + "/" + this.getType().toString() + "/" + this.getName() + "/";
            if (this.collector != null) {
                serializer.writeStartElement("collector");
                serializer.writeAttribute("code-format", this.collector.getCodeFormat().toString());
                serializer.writeAttribute("module", flowDir + this.collector.getModule());
                serializer.writeEndElement();
            }
            if (this.main != null) {
                serializer.writeStartElement("main");
                serializer.writeAttribute("code-format", this.main.getCodeFormat().toString());
                serializer.writeAttribute("module", flowDir + this.main.getModule());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
            serializer.writeEndDocument();
            serializer.flush();
            serializer.close();
            StringWriter finalWriter = new StringWriter();
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            t.transform(new StreamSource(new StringReader(writer.toString())), new StreamResult(finalWriter));
            return finalWriter.toString().replaceFirst("<!--", "\n<!--").replaceFirst("-->", "-->\n");
        }
        catch (Exception e) {
            throw new MarkLogicIOException((Throwable)e);
        }
    }

    @Override
    public Properties toProperties() {
        Properties flowProperties = new Properties();
        flowProperties.setProperty("dataFormat", this.dataFormat.toString());
        flowProperties.setProperty("codeFormat", this.codeFormat.toString());
        if (this.collector != null) {
            flowProperties.setProperty("collectorCodeFormat", this.collector.getCodeFormat().toString());
            flowProperties.setProperty("collectorModule", this.collector.getModule());
        }
        if (this.main != null) {
            flowProperties.setProperty("mainCodeFormat", this.main.getCodeFormat().toString());
            flowProperties.setProperty("mainModule", this.main.getModule());
        }
        return flowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flow loadFromFile(File file) {
        Flow flow = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            flow = FlowImpl.fromXml(doc.getDocumentElement());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return flow;
    }

    public static Flow fromXml(Node xml) {
        FlowBuilder flowBuilder = FlowBuilder.newFlow();
        NodeList children = xml.getChildNodes();
        block18: for (int i = 0; i < children.getLength(); ++i) {
            String nodeName;
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            switch (nodeName = node.getLocalName()) {
                case "name": {
                    flowBuilder.withName(node.getTextContent());
                    continue block18;
                }
                case "data-format": {
                    flowBuilder.withDataFormat(DataFormat.getDataFormat(node.getTextContent()));
                    continue block18;
                }
                case "code-format": {
                    flowBuilder.withCodeFormat(CodeFormat.getCodeFormat(node.getTextContent()));
                    continue block18;
                }
                case "type": {
                    flowBuilder.withType(FlowType.getFlowType(node.getTextContent()));
                    continue block18;
                }
                case "entity": {
                    flowBuilder.withEntityName(node.getTextContent());
                    continue block18;
                }
                case "collector": {
                    CollectorImpl collector = new CollectorImpl(node.getAttributes().getNamedItem("module").getNodeValue(), CodeFormat.getCodeFormat(node.getAttributes().getNamedItem("code-format").getNodeValue()));
                    flowBuilder.withCollector(collector);
                    continue block18;
                }
                case "main": {
                    MainPluginImpl main = new MainPluginImpl(node.getAttributes().getNamedItem("module").getNodeValue(), CodeFormat.getCodeFormat(node.getAttributes().getNamedItem("code-format").getNodeValue()));
                    flowBuilder.withMain(main);
                }
            }
        }
        return flowBuilder.build();
    }

    @Override
    public String getFlowDbPath() {
        return "/entities/" + this.getEntityName() + "/" + this.getType().toString() + "/" + this.getName() + "/" + this.getName() + ".xml";
    }
}

