/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.command.CommandMapBuilder;
import com.marklogic.appdeployer.command.appservers.DeployOtherServersCommand;
import com.marklogic.appdeployer.command.forests.DeployCustomForestsCommand;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.hub.DataHub;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.InstallInfo;
import com.marklogic.hub.deploy.HubAppDeployer;
import com.marklogic.hub.deploy.commands.DeployHubDatabasesCommand;
import com.marklogic.hub.deploy.commands.DeployHubOtherDatabasesCommand;
import com.marklogic.hub.deploy.commands.DeployHubRolesCommand;
import com.marklogic.hub.deploy.commands.DeployHubSchemasDatabaseCommand;
import com.marklogic.hub.deploy.commands.DeployHubServersCommand;
import com.marklogic.hub.deploy.commands.DeployHubTriggersDatabaseCommand;
import com.marklogic.hub.deploy.commands.DeployHubUsersCommand;
import com.marklogic.hub.deploy.commands.LoadHubModulesCommand;
import com.marklogic.hub.deploy.commands.LoadUserModulesCommand;
import com.marklogic.hub.deploy.util.HubDeployStatusListener;
import com.marklogic.hub.error.CantUpgradeException;
import com.marklogic.hub.error.InvalidDBOperationError;
import com.marklogic.hub.error.ServerValidationException;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.util.Versions;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DataHubImpl
implements DataHub {
    private ManageClient _manageClient;
    private DatabaseManager _databaseManager;
    private ServerManager _serverManager;
    private HubConfigImpl hubConfig;
    private AdminManager _adminManager;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean stagingPortInUse;
    private String stagingPortInUseBy;
    private boolean finalPortInUse;
    private String finalPortInUseBy;
    private boolean jobPortInUse;
    private String jobPortInUseBy;
    private boolean tracePortInUse;
    private String tracePortInUseBy;
    private boolean serverVersionOk;
    private String serverVersion;
    public static String MIN_UPGRADE_VERSION = "2.0.0";

    public DataHubImpl(HubConfig hubConfig) {
        this.hubConfig = (HubConfigImpl)hubConfig;
    }

    private ManageClient getManageClient() {
        if (this._manageClient == null) {
            this._manageClient = this.hubConfig.getManageClient();
        }
        return this._manageClient;
    }

    @Override
    public void clearDatabase(String database) {
        DatabaseManager mgr = new DatabaseManager(this.getManageClient());
        mgr.clearDatabase(database);
    }

    private AdminManager getAdminManager() {
        if (this._adminManager == null) {
            this._adminManager = this.hubConfig.getAdminManager();
        }
        return this._adminManager;
    }

    void setAdminManager(AdminManager manager) {
        this._adminManager = manager;
    }

    private DatabaseManager getDatabaseManager() {
        if (this._databaseManager == null) {
            this._databaseManager = new DatabaseManager(this.getManageClient());
        }
        return this._databaseManager;
    }

    private ServerManager getServerManager() {
        if (this._serverManager == null) {
            this._serverManager = new ServerManager(this.getManageClient());
        }
        return this._serverManager;
    }

    public void setServerManager(ServerManager manager) {
        this._serverManager = manager;
    }

    @Override
    public InstallInfo isInstalled() {
        Fragment f;
        InstallInfo installInfo = InstallInfo.create();
        ResourcesFragment srf = this.getServerManager().getAsXml();
        installInfo.setAppServerExistent(DatabaseKind.STAGING, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.STAGING)));
        installInfo.setAppServerExistent(DatabaseKind.FINAL, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.FINAL)));
        installInfo.setAppServerExistent(DatabaseKind.TRACE, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.TRACE)));
        installInfo.setAppServerExistent(DatabaseKind.JOB, srf.resourceExists(this.hubConfig.getHttpName(DatabaseKind.JOB)));
        ResourcesFragment drf = this.getDatabaseManager().getAsXml();
        installInfo.setDbExistent(DatabaseKind.STAGING, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.STAGING)));
        installInfo.setDbExistent(DatabaseKind.FINAL, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.FINAL)));
        installInfo.setDbExistent(DatabaseKind.TRACE, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.TRACE)));
        installInfo.setDbExistent(DatabaseKind.JOB, drf.resourceExists(this.hubConfig.getDbName(DatabaseKind.JOB)));
        if (installInfo.isDbExistent(DatabaseKind.STAGING)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.STAGING), new String[0]);
            installInfo.setTripleIndexOn(DatabaseKind.STAGING, Boolean.parseBoolean(f.getElementValue("//m:triple-index")));
            installInfo.setCollectionLexiconOn(DatabaseKind.STAGING, Boolean.parseBoolean(f.getElementValue("//m:collection-lexicon")));
            installInfo.setForestsExistent(DatabaseKind.STAGING, f.getElements("//m:forest").size() > 0);
        }
        if (installInfo.isDbExistent(DatabaseKind.FINAL)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.FINAL), new String[0]);
            installInfo.setTripleIndexOn(DatabaseKind.FINAL, Boolean.parseBoolean(f.getElementValue("//m:triple-index")));
            installInfo.setCollectionLexiconOn(DatabaseKind.FINAL, Boolean.parseBoolean(f.getElementValue("//m:collection-lexicon")));
            installInfo.setForestsExistent(DatabaseKind.FINAL, f.getElements("//m:forest").size() > 0);
        }
        if (installInfo.isDbExistent(DatabaseKind.TRACE)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.TRACE), new String[0]);
            installInfo.setForestsExistent(DatabaseKind.TRACE, f.getElements("//m:forest").size() > 0);
        }
        if (installInfo.isDbExistent(DatabaseKind.JOB)) {
            f = this.getDatabaseManager().getPropertiesAsXml(this.hubConfig.getDbName(DatabaseKind.JOB), new String[0]);
            installInfo.setForestsExistent(DatabaseKind.JOB, f.getElements("//m:forest").size() > 0);
        }
        this.logger.info(installInfo.toString());
        return installInfo;
    }

    @Override
    public boolean isServerVersionValid(String versionString) {
        try {
            int major;
            if (versionString == null) {
                versionString = new Versions(this.hubConfig).getMarkLogicVersion();
            }
            if ((major = Integer.parseInt(versionString.replaceAll("([^.]+)\\..*", "$1"))) < 9) {
                return false;
            }
            boolean isNightly = versionString.matches("[^-]+-(\\d{4})(\\d{2})(\\d{2})");
            if (major == 9) {
                String alteredString = versionString.replaceAll("[^\\d]+", "");
                if (alteredString.length() < 4) {
                    alteredString = StringUtils.rightPad((String)alteredString, (int)4, (String)"0");
                }
                int ver = Integer.parseInt(alteredString.substring(0, 4));
                if (!isNightly && ver < 9011) {
                    return false;
                }
            }
            if (isNightly) {
                String dateString = versionString.replaceAll("[^-]+-(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3");
                Date minDate = new GregorianCalendar(2017, 6, 1).getTime();
                Date date = new SimpleDateFormat("y-M-d").parse(dateString);
                if (date.before(minDate)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            throw new ServerValidationException(e.toString());
        }
        return true;
    }

    @Override
    public void initProject() {
        this.logger.info("Initializing the Hub Project");
        this.hubConfig.initHubProject();
    }

    @Override
    public void clearUserModules() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(DataHub.class.getClassLoader());
        try {
            ArrayList<String> options = new ArrayList<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/options/*.xml")) {
                options.add(r.getFilename().replace(".xml", ""));
            }
            for (Resource r : resolver.getResources("classpath*:/ml-modules-traces/options/*.xml")) {
                options.add(r.getFilename().replace(".xml", ""));
            }
            for (Resource r : resolver.getResources("classpath*:/ml-modules-jobs/options/*.xml")) {
                options.add(r.getFilename().replace(".xml", ""));
            }
            ArrayList<String> services = new ArrayList<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/services/*.xqy")) {
                services.add(r.getFilename().replaceAll("\\.(xqy|sjs)", ""));
            }
            ArrayList<String> transforms = new ArrayList<String>();
            for (Resource r : resolver.getResources("classpath*:/ml-modules/transforms/*")) {
                transforms.add(r.getFilename().replaceAll("\\.(xqy|sjs)", ""));
            }
            String query = "cts:uris((),(),cts:not-query(cts:collection-query('hub-core-module')))[\n  fn:not(\n    fn:matches(., \"^.+options/(" + String.join((CharSequence)"|", options) + ").xml$\") or\n" + "    fn:matches(., \"/marklogic.rest.resource/(" + String.join((CharSequence)"|", services) + ")/assets/(metadata\\.xml|resource\\.(xqy|sjs))\") or\n" + "    fn:matches(., \"/marklogic.rest.transform/(" + String.join((CharSequence)"|", transforms) + ")/assets/(metadata\\.xml|transform\\.(xqy|sjs))\")\n" + "  )\n" + "] ! xdmp:document-delete(.)\n";
            this.runInDatabase(query, this.hubConfig.getDbName(DatabaseKind.MODULES));
        }
        catch (FailedRequestException e) {
            this.logger.error("Failed to clear user modules");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Command> getCommandList() {
        Map<String, List<Command>> commandMap = this.getCommands();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (String name : commandMap.keySet()) {
            commands.addAll((Collection<Command>)commandMap.get(name));
        }
        return commands;
    }

    @Override
    public HashMap runPreInstallCheck() {
        return this.runPreInstallCheck(null);
    }

    @Override
    public HashMap runPreInstallCheck(Versions versions) {
        Map<Integer, String> portsInUse = this.getServerPortsInUse();
        Set<Integer> ports = portsInUse.keySet();
        String serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.STAGING));
        boolean bl = this.stagingPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.STAGING)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.STAGING));
        if (this.stagingPortInUse) {
            this.stagingPortInUseBy = serverName;
        }
        serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.FINAL));
        boolean bl2 = this.finalPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.FINAL)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.FINAL));
        if (this.finalPortInUse) {
            this.finalPortInUseBy = serverName;
        }
        serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.JOB));
        boolean bl3 = this.jobPortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.JOB)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.JOB));
        if (this.jobPortInUse) {
            this.jobPortInUseBy = serverName;
        }
        serverName = portsInUse.get(this.hubConfig.getPort(DatabaseKind.TRACE));
        boolean bl4 = this.tracePortInUse = ports.contains(this.hubConfig.getPort(DatabaseKind.TRACE)) && serverName != null && !serverName.equals(this.hubConfig.getHttpName(DatabaseKind.TRACE));
        if (this.tracePortInUse) {
            this.tracePortInUseBy = serverName;
        }
        if (versions == null) {
            versions = new Versions(this.hubConfig);
        }
        this.serverVersion = versions.getMarkLogicVersion();
        this.serverVersionOk = this.isServerVersionValid(this.serverVersion);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("serverVersion", this.serverVersion);
        response.put("serverVersionOk", this.serverVersionOk);
        response.put("stagingPortInUse", this.stagingPortInUse);
        response.put("stagingPortInUseBy", this.stagingPortInUseBy);
        response.put("finalPortInUse", this.finalPortInUse);
        response.put("finalPortInUseBy", this.finalPortInUseBy);
        response.put("jobPortInUse", this.jobPortInUse);
        response.put("jobPortInUseBy", this.jobPortInUseBy);
        response.put("tracePortInUse", this.tracePortInUse);
        response.put("tracePortInUseBy", this.tracePortInUseBy);
        response.put("safeToInstall", this.isSafeToInstall());
        return response;
    }

    @Override
    public void install() {
        this.install(null);
    }

    @Override
    public void install(HubDeployStatusListener listener) {
        this.initProject();
        this.logger.warn("Installing the Data Hub into MarkLogic");
        AppConfig config = this.hubConfig.getAppConfig();
        HubAppDeployer deployer = new HubAppDeployer(this.getManageClient(), this.getAdminManager(), listener);
        deployer.setCommands(this.getCommandList());
        deployer.deploy(config);
    }

    @Override
    public void updateIndexes() {
        AppConfig config = this.hubConfig.getAppConfig();
        HubAppDeployer deployer = new HubAppDeployer(this.getManageClient(), this.getAdminManager(), null);
        ArrayList<DeployHubDatabasesCommand> commands = new ArrayList<DeployHubDatabasesCommand>();
        commands.add(new DeployHubDatabasesCommand(this.hubConfig));
        deployer.setCommands(commands);
        deployer.deploy(config);
    }

    @Override
    public void uninstall() {
        this.uninstall(null);
    }

    @Override
    public void uninstall(HubDeployStatusListener listener) {
        this.logger.warn("Uninstalling the Data Hub from MarkLogic");
        AppConfig config = this.hubConfig.getAppConfig();
        HubAppDeployer deployer = new HubAppDeployer(this.getManageClient(), this.getAdminManager(), listener);
        deployer.setCommands(this.getCommandList());
        deployer.undeploy(config);
    }

    private void runInDatabase(String query, String databaseName) {
        ServerEvaluationCall eval = this.hubConfig.newModulesDbClient().newServerEval();
        String xqy = "xdmp:invoke-function(function() {" + query + "}," + "<options xmlns=\"xdmp:eval\">" + "  <database>{xdmp:database(\"" + databaseName + "\")}</database>" + "  <transaction-mode>update-auto-commit</transaction-mode>" + "</options>)";
        eval.xquery(xqy).eval();
    }

    private Map<String, List<Command>> getCommands() {
        Map commandMap = new CommandMapBuilder().buildCommandMap();
        List securityCommands = (List)commandMap.get("mlSecurityCommands");
        securityCommands.set(0, new DeployHubRolesCommand(this.hubConfig));
        securityCommands.set(1, new DeployHubUsersCommand(this.hubConfig));
        ArrayList<Object> dbCommands = new ArrayList<Object>();
        dbCommands.add((Object)new DeployHubDatabasesCommand(this.hubConfig));
        dbCommands.add((Object)new DeployHubOtherDatabasesCommand(this.hubConfig));
        dbCommands.add((Object)new DeployHubTriggersDatabaseCommand(this.hubConfig));
        dbCommands.add((Object)new DeployHubSchemasDatabaseCommand(this.hubConfig));
        commandMap.put("mlDatabaseCommands", dbCommands);
        commandMap.remove("mlRestApiCommands");
        ArrayList<DeployHubServersCommand> serverCommands = new ArrayList<DeployHubServersCommand>();
        serverCommands.add(new DeployHubServersCommand(this.hubConfig));
        DeployOtherServersCommand otherServersCommand = new DeployOtherServersCommand();
        otherServersCommand.setFilenamesToIgnore(new String[]{"staging-server.json", "final-server.json", "job-server.json", "trace-server.json"});
        serverCommands.add((DeployHubServersCommand)otherServersCommand);
        commandMap.put("mlServerCommands", serverCommands);
        ArrayList<AbstractCommand> moduleCommands = new ArrayList<AbstractCommand>();
        moduleCommands.add(new LoadHubModulesCommand(this.hubConfig));
        moduleCommands.add(new LoadUserModulesCommand(this.hubConfig));
        commandMap.put("mlModuleCommands", moduleCommands);
        List forestCommands = (List)commandMap.get("mlForestCommands");
        DeployCustomForestsCommand deployCustomForestsCommand = (DeployCustomForestsCommand)forestCommands.get(0);
        deployCustomForestsCommand.setCustomForestsPath(this.hubConfig.getCustomForestPath());
        return commandMap;
    }

    private Map<Integer, String> getServerPortsInUse() {
        HashMap<Integer, String> portsInUse = new HashMap<Integer, String>();
        ResourcesFragment srf = this.getServerManager().getAsXml();
        srf.getListItemNameRefs().forEach(s -> {
            Fragment fragment = this.getServerManager().getPropertiesAsXml(s, new String[0]);
            int port = Integer.parseInt(fragment.getElementValue("//m:port"));
            portsInUse.put(port, (String)s);
        });
        return portsInUse;
    }

    @Override
    public boolean isSafeToInstall() {
        return !this.isPortInUse(DatabaseKind.FINAL) && !this.isPortInUse(DatabaseKind.STAGING) && !this.isPortInUse(DatabaseKind.JOB) && !this.isPortInUse(DatabaseKind.TRACE) && this.isServerVersionOk();
    }

    @Override
    public boolean isPortInUse(DatabaseKind kind) {
        boolean inUse;
        switch (kind) {
            case STAGING: {
                inUse = this.stagingPortInUse;
                break;
            }
            case FINAL: {
                inUse = this.finalPortInUse;
                break;
            }
            case JOB: {
                inUse = this.jobPortInUse;
                break;
            }
            case TRACE: {
                inUse = this.tracePortInUse;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check for port use");
            }
        }
        return inUse;
    }

    @Override
    public void setPortInUseBy(DatabaseKind kind, String usedBy) {
        switch (kind) {
            case STAGING: {
                this.stagingPortInUseBy = usedBy;
                break;
            }
            case FINAL: {
                this.finalPortInUseBy = usedBy;
                break;
            }
            case JOB: {
                this.jobPortInUseBy = usedBy;
                break;
            }
            case TRACE: {
                this.tracePortInUseBy = usedBy;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set if port in use");
            }
        }
    }

    @Override
    public String getPortInUseBy(DatabaseKind kind) {
        String inUseBy;
        switch (kind) {
            case STAGING: {
                inUseBy = this.stagingPortInUseBy;
                break;
            }
            case FINAL: {
                inUseBy = this.finalPortInUseBy;
                break;
            }
            case JOB: {
                inUseBy = this.jobPortInUseBy;
                break;
            }
            case TRACE: {
                inUseBy = this.tracePortInUseBy;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check if port is in use");
            }
        }
        return inUseBy;
    }

    @Override
    public boolean isServerVersionOk() {
        return this.serverVersionOk;
    }

    @Override
    public void setServerVersionOk(boolean serverVersionOk) {
        this.serverVersionOk = serverVersionOk;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public boolean upgradeHub() throws CantUpgradeException {
        return this.upgradeHub(null);
    }

    @Override
    public boolean upgradeHub(List<String> updatedFlows) throws CantUpgradeException {
        boolean isHubInstalled = this.isInstalled().isInstalled();
        String currentVersion = new Versions(this.hubConfig).getHubVersion();
        int compare = Versions.compare(currentVersion, MIN_UPGRADE_VERSION);
        if (compare == -1) {
            throw new CantUpgradeException(currentVersion, MIN_UPGRADE_VERSION);
        }
        boolean result = false;
        boolean alreadyInitialized = this.hubConfig.getHubProject().isInitialized();
        File buildGradle = Paths.get(this.hubConfig.getProjectDir(), "build.gradle").toFile();
        try {
            this.hubConfig.initHubProject();
            if (alreadyInitialized) {
                String text = FileUtils.readFileToString((File)buildGradle);
                String version = this.hubConfig.getJarVersion();
                text = Pattern.compile("^(\\s*)id\\s+['\"]com.marklogic.ml-data-hub['\"]\\s+version.+$", 8).matcher(text).replaceAll("$1id 'com.marklogic.ml-data-hub' version '" + version + "'");
                text = Pattern.compile("^(\\s*)compile.+marklogic-data-hub.+$", 8).matcher(text).replaceAll("$1compile 'com.marklogic:marklogic-data-hub:" + version + "'");
                FileUtils.writeStringToFile((File)buildGradle, (String)text);
                this.hubConfig.getHubSecurityDir().resolve("roles").resolve("data-hub-user.json").toFile().delete();
            }
            List<String> flows = FlowManager.create(this.hubConfig).updateLegacyFlows(currentVersion);
            if (updatedFlows != null) {
                updatedFlows.addAll(flows);
            }
            this.runInDatabase("cts:uris(\"\", (), cts:and-not-query(cts:collection-query(\"hub-core-module\"), cts:document-query((\"/com.marklogic.hub/config.sjs\", \"/com.marklogic.hub/config.xqy\")))) ! xdmp:document-delete(.)", this.hubConfig.getDbName(DatabaseKind.MODULES));
            if (isHubInstalled) {
                this.install();
            }
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

