/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.error.EntityServicesGenerationException;
import com.marklogic.hub.util.HubModuleManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class EntityManagerImpl
extends LoggingObject
implements EntityManager {
    private static final String ENTITY_FILE_EXTENSION = ".entity.json";
    private HubConfig hubConfig;

    public EntityManagerImpl(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    @Override
    public boolean saveQueryOptions() {
        QueryOptionsGenerator generator = new QueryOptionsGenerator(this.hubConfig.newStagingClient());
        try {
            Path dir = Paths.get(this.hubConfig.getProjectDir(), "entity-config");
            if (!dir.toFile().exists()) {
                dir.toFile().mkdirs();
            }
            File stagingFile = Paths.get(dir.toString(), "staging-entity-options.xml").toFile();
            File finalFile = Paths.get(dir.toString(), "final-entity-options.xml").toFile();
            long lastModified = Math.max(stagingFile.lastModified(), finalFile.lastModified());
            List<JsonNode> entities = this.getModifiedRawEntities(lastModified);
            if (entities.size() > 0) {
                String options = generator.generateOptions(entities);
                FileUtils.writeStringToFile((File)stagingFile, (String)options);
                FileUtils.writeStringToFile((File)finalFile, (String)options);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public HashMap<Enum, Boolean> deployQueryOptions() {
        File finalFile;
        this.saveQueryOptions();
        HubModuleManager propsManager = this.getPropsMgr();
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(new AssetFileLoader(this.hubConfig.newFinalClient(), (ModulesManager)propsManager));
        modulesLoader.setModulesManager((ModulesManager)propsManager);
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(false);
        HashMap<Enum, Boolean> loadedResources = new HashMap<Enum, Boolean>();
        Path dir = Paths.get(this.hubConfig.getProjectDir(), "entity-config");
        File stagingFile = Paths.get(dir.toString(), "staging-entity-options.xml").toFile();
        if (stagingFile.exists()) {
            modulesLoader.setDatabaseClient(this.hubConfig.newStagingClient());
            Resource r = modulesLoader.installQueryOptions((Resource)new FileSystemResource(stagingFile));
            if (r != null) {
                loadedResources.put(DatabaseKind.STAGING, true);
            }
        }
        if ((finalFile = Paths.get(dir.toString(), "final-entity-options.xml").toFile()).exists()) {
            modulesLoader.setDatabaseClient(this.hubConfig.newFinalClient());
            Resource r = modulesLoader.installQueryOptions((Resource)new FileSystemResource(finalFile));
            if (r != null) {
                loadedResources.put(DatabaseKind.FINAL, true);
            }
        }
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(true);
        modulesLoader.waitForTaskExecutorToFinish();
        return loadedResources;
    }

    @Override
    public boolean saveDbIndexes() {
        try {
            Path dir = this.hubConfig.getEntityDatabaseDir();
            if (!dir.toFile().exists()) {
                dir.toFile().mkdirs();
            }
            File finalFile = dir.resolve("final-database.json").toFile();
            File stagingFile = dir.resolve("staging-database.json").toFile();
            long lastModified = Math.max(finalFile.lastModified(), stagingFile.lastModified());
            List<JsonNode> entities = this.getModifiedRawEntities(lastModified);
            if (entities.size() > 0) {
                DbIndexGenerator generator = new DbIndexGenerator(this.hubConfig.newFinalClient());
                String indexes = generator.getIndexes(entities);
                FileUtils.writeStringToFile((File)finalFile, (String)indexes);
                FileUtils.writeStringToFile((File)stagingFile, (String)indexes);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private HubModuleManager getPropsMgr() {
        String timestampFile = this.hubConfig.getUserModulesDeployTimestampFile();
        HubModuleManager propertiesModuleManager = new HubModuleManager(timestampFile);
        return propertiesModuleManager;
    }

    private List<JsonNode> getModifiedRawEntities(long minimumFileTimestampToLoad) {
        this.logger.info("min modified: " + minimumFileTimestampToLoad);
        HubModuleManager propsManager = this.getPropsMgr();
        propsManager.setMinimumFileTimestampToLoad(minimumFileTimestampToLoad);
        ArrayList<JsonNode> entities = new ArrayList<JsonNode>();
        ArrayList<JsonNode> tempEntities = new ArrayList<JsonNode>();
        Path entitiesPath = this.hubConfig.getHubEntitiesDir();
        File[] entityFiles = entitiesPath.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.isHidden());
        if (entityFiles != null) {
            List entityNames = Arrays.stream(entityFiles).map(file -> file.getName()).collect(Collectors.toList());
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                boolean hasOneChanged = false;
                for (String entityName : entityNames) {
                    File[] entityDefs;
                    for (File entityDef : entityDefs = entitiesPath.resolve(entityName).toFile().listFiles((dir, name) -> name.endsWith(ENTITY_FILE_EXTENSION))) {
                        if (propsManager.hasFileBeenModifiedSinceLastLoaded(entityDef)) {
                            hasOneChanged = true;
                        }
                        FileInputStream fileInputStream = new FileInputStream(entityDef);
                        tempEntities.add(objectMapper.readTree((InputStream)fileInputStream));
                        fileInputStream.close();
                    }
                }
                if (hasOneChanged) {
                    entities.addAll(tempEntities);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return entities;
    }

    private class DbIndexGenerator
    extends ResourceManager {
        private static final String NAME = "ml:dbConfigs";
        private RequestParameters params = new RequestParameters();

        DbIndexGenerator(DatabaseClient client) {
            client.init(NAME, (ResourceManager)this);
        }

        public String getIndexes(List<JsonNode> entities) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode node = objectMapper.valueToTree(entities);
                ResourceServices.ServiceResultIterator resultItr = this.getServices().post(this.params, (AbstractWriteHandle)new JacksonHandle(node), new String[0]);
                if (resultItr == null || !resultItr.hasNext()) {
                    throw new IOException("Unable to generate database indexes");
                }
                ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
                return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "{}";
            }
        }
    }

    private class QueryOptionsGenerator
    extends ResourceManager {
        private static final String NAME = "ml:searchOptionsGenerator";
        private RequestParameters params = new RequestParameters();

        QueryOptionsGenerator(DatabaseClient client) {
            client.init(NAME, (ResourceManager)this);
        }

        String generateOptions(List<JsonNode> entities) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode node = objectMapper.valueToTree(entities);
                ResourceServices.ServiceResultIterator resultItr = this.getServices().post(this.params, (AbstractWriteHandle)new JacksonHandle(node), new String[0]);
                if (resultItr == null || !resultItr.hasNext()) {
                    throw new IOException("Unable to generate query options");
                }
                ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
                return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "{}";
            }
        }
    }

    private class PiiGenerator
    extends ResourceManager {
        private static final String NAME = "ml:piiGenerator";
        private RequestParameters params = new RequestParameters();

        PiiGenerator(DatabaseClient client) {
            client.init(NAME, (ResourceManager)this);
        }

        public String piiGenerate(List<JsonNode> entities) {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode node = objectMapper.valueToTree(entities);
            ResourceServices.ServiceResultIterator resultItr = this.getServices().post(this.params, (AbstractWriteHandle)new JacksonHandle(node), new String[0]);
            if (resultItr == null || !resultItr.hasNext()) {
                throw new EntityServicesGenerationException("Unable to generate pii config");
            }
            ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
            return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get();
        }
    }
}

