/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.collector.impl.CollectorImpl;
import com.marklogic.hub.flow.CodeFormat;
import com.marklogic.hub.flow.DataFormat;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.FlowBuilder;
import com.marklogic.hub.flow.FlowRunner;
import com.marklogic.hub.flow.FlowType;
import com.marklogic.hub.flow.impl.FlowRunnerImpl;
import com.marklogic.hub.job.JobManager;
import com.marklogic.hub.main.impl.MainPluginImpl;
import com.marklogic.hub.scaffold.Scaffolding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowManagerImpl
extends ResourceManager
implements FlowManager {
    private static final String HUB_NS = "http://marklogic.com/data-hub";
    private static final String NAME = "ml:flow";
    private DatabaseClient stagingClient;
    private DatabaseClient finalClient;
    private DatabaseClient jobClient;
    private HubConfig hubConfig;
    private JobManager jobManager;
    private DataMovementManager dataMovementManager;

    public FlowManagerImpl(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        this.stagingClient = hubConfig.newStagingClient();
        this.finalClient = hubConfig.newFinalClient();
        this.jobClient = hubConfig.newJobDbClient();
        this.jobManager = JobManager.create(this.jobClient, this.hubConfig.newTraceDbClient());
        this.dataMovementManager = this.stagingClient.newDataMovementManager();
        this.stagingClient.init(NAME, (ResourceManager)this);
    }

    @Override
    public List<Flow> getLocalFlows() {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        Path entitiesDir = this.hubConfig.getHubEntitiesDir();
        File[] entities = entitiesDir.toFile().listFiles(pathname -> pathname.isDirectory());
        if (entities != null) {
            for (File entity : entities) {
                String entityName = entity.getName();
                flows.addAll(this.getLocalFlowsForEntity(entityName));
            }
        }
        return flows;
    }

    @Override
    public List<Flow> getLocalFlowsForEntity(String entityName) {
        return this.getLocalFlowsForEntity(entityName, null);
    }

    @Override
    public List<Flow> getLocalFlowsForEntity(String entityName, FlowType flowType) {
        File[] harmonizeFlows;
        Flow flow;
        File[] inputFlows;
        ArrayList<Flow> flows = new ArrayList<Flow>();
        Path entitiesDir = this.hubConfig.getHubEntitiesDir();
        Path entityDir = entitiesDir.resolve(entityName);
        Path inputDir = entityDir.resolve("input");
        Path harmonizeDir = entityDir.resolve("harmonize");
        boolean getInputFlows = false;
        boolean getHarmonizeFlows = false;
        if (flowType == null) {
            getHarmonizeFlows = true;
            getInputFlows = true;
        } else if (flowType.equals((Object)FlowType.INPUT)) {
            getInputFlows = true;
        } else if (flowType.equals((Object)FlowType.HARMONIZE)) {
            getHarmonizeFlows = true;
        }
        if (getInputFlows && (inputFlows = inputDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"))) != null) {
            for (File inputFlow : inputFlows) {
                flow = this.getLocalFlow(entityName, inputFlow.toPath(), FlowType.INPUT);
                if (flow == null) continue;
                flows.add(flow);
            }
        }
        if (getHarmonizeFlows && (harmonizeFlows = harmonizeDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"))) != null) {
            for (File harmonizeFlow : harmonizeFlows) {
                flow = this.getLocalFlow(entityName, harmonizeFlow.toPath(), FlowType.HARMONIZE);
                if (flow == null) continue;
                flows.add(flow);
            }
        }
        return flows;
    }

    @Override
    public Flow getFlowFromProperties(Path propertiesFile) {
        String quotedSeparator = Pattern.quote(File.separator);
        String flowTypeRegex = ".+" + quotedSeparator + "(input|harmonize)" + quotedSeparator + ".+";
        FlowType flowType = propertiesFile.toString().replaceAll(flowTypeRegex, "$1").equals("input") ? FlowType.INPUT : FlowType.HARMONIZE;
        String entityName = propertiesFile.toString().replaceAll(".+" + quotedSeparator + "([^/\\\\]+)" + quotedSeparator + "(input|harmonize)" + quotedSeparator + ".+", "$1");
        return this.getLocalFlow(entityName, propertiesFile.getParent(), flowType);
    }

    private Flow getLocalFlow(String entityName, Path flowDir, FlowType flowType) {
        try {
            String flowName = flowDir.getFileName().toString();
            File propertiesFile = flowDir.resolve(flowName + ".properties").toFile();
            if (propertiesFile.exists()) {
                Properties properties = new Properties();
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                fis.close();
                FlowBuilder flowBuilder = FlowBuilder.newFlow().withEntityName(entityName).withName(flowName).withType(flowType).withCodeFormat(CodeFormat.getCodeFormat((String)properties.get("codeFormat"))).withDataFormat(DataFormat.getDataFormat((String)properties.get("dataFormat"))).withMain(new MainPluginImpl((String)properties.get("mainModule"), CodeFormat.getCodeFormat((String)properties.get("mainCodeFormat"))));
                if (flowType.equals((Object)FlowType.HARMONIZE)) {
                    flowBuilder.withCollector(new CollectorImpl((String)properties.get("collectorModule"), CodeFormat.getCodeFormat((String)properties.get("collectorCodeFormat"))));
                }
                return flowBuilder.build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<Flow> getFlows(String entityName) {
        RequestParameters params = new RequestParameters();
        params.add("entity-name", entityName);
        ResourceServices.ServiceResultIterator resultItr = this.getServices().get(params, new String[0]);
        if (resultItr == null || !resultItr.hasNext()) {
            return null;
        }
        ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
        DOMHandle handle = new DOMHandle();
        Document parent = ((DOMHandle)res.getContent((AbstractReadHandle)handle)).get();
        NodeList children = parent.getDocumentElement().getChildNodes();
        ArrayList<Flow> flows = null;
        if (children.getLength() > 0) {
            flows = new ArrayList<Flow>();
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            flows.add(FlowManager.flowFromXml((Element)children.item(i)));
        }
        return flows;
    }

    @Override
    public Flow getFlow(String entityName, String flowName) {
        return this.getFlow(entityName, flowName, null);
    }

    @Override
    public Flow getFlow(String entityName, String flowName, FlowType flowType) {
        ResourceServices.ServiceResultIterator resultItr;
        RequestParameters params = new RequestParameters();
        params.add("entity-name", entityName);
        params.add("flow-name", flowName);
        if (flowType != null) {
            params.add("flow-type", flowType.toString());
        }
        if ((resultItr = this.getServices().get(params, new String[0])) == null || !resultItr.hasNext()) {
            return null;
        }
        ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
        DOMHandle handle = new DOMHandle();
        Document parent = ((DOMHandle)res.getContent((AbstractReadHandle)handle)).get();
        return FlowManager.flowFromXml(parent.getDocumentElement());
    }

    @Override
    public List<String> getLegacyFlows() {
        ArrayList<String> oldFlows = new ArrayList<String>();
        Path entitiesDir = this.hubConfig.getHubEntitiesDir();
        File[] entityDirs = entitiesDir.toFile().listFiles(pathname -> pathname.isDirectory());
        if (entityDirs != null) {
            for (File entityDir : entityDirs) {
                Path inputDir = entityDir.toPath().resolve("input");
                Path harmonizeDir = entityDir.toPath().resolve("harmonize");
                File[] inputFlows = inputDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"));
                this.addLegacyFlowToList(oldFlows, entityDir, inputFlows);
                File[] harmonizeFlows = harmonizeDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"));
                this.addLegacyFlowToList(oldFlows, entityDir, harmonizeFlows);
            }
        }
        return oldFlows;
    }

    private void addLegacyFlowToList(List<String> oldFlows, File entityDir, File[] flows) {
        if (flows != null) {
            for (File flow : flows) {
                File[] mainFiles = flow.listFiles((dir, name) -> name.matches("main\\.(sjs|xqy)"));
                File[] flowFiles = flow.listFiles((dir, name) -> name.matches(flow.getName() + "\\.xml"));
                if (mainFiles.length < 1 && flowFiles.length == 1) {
                    oldFlows.add(entityDir.getName() + " => " + flow.getName());
                    continue;
                }
                if (mainFiles.length != 1 || !mainFiles[0].getName().contains(".sjs")) continue;
                try {
                    String mainFile = FileUtils.readFileToString((File)mainFiles[0]);
                    if (!mainFile.contains("dhf.xqy")) continue;
                    oldFlows.add(entityDir.getName() + " => " + flow.getName());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List<String> updateLegacyFlows(String fromVersion) {
        Scaffolding scaffolding = Scaffolding.create(this.hubConfig.getProjectDir(), this.hubConfig.newFinalClient());
        ArrayList<String> updatedFlows = new ArrayList<String>();
        File[] entityDirs = this.hubConfig.getHubEntitiesDir().toFile().listFiles(pathname -> pathname.isDirectory());
        if (entityDirs != null) {
            for (File entityDir : entityDirs) {
                updatedFlows.addAll(scaffolding.updateLegacyFlows(fromVersion, entityDir.getName()));
            }
        }
        return updatedFlows;
    }

    @Override
    public FlowRunner newFlowRunner() {
        return new FlowRunnerImpl(this.hubConfig);
    }
}

