/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.DefaultAppConfigFactory;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubConfigBuilder;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.mgmt.DefaultManageConfigFactory;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.admin.DefaultAdminConfigFactory;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.SimplePropertySource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;

public class HubConfigBuilderImpl
implements HubConfigBuilder {
    private static final String GRADLE_PROPERTIES_FILENAME = "gradle.properties";
    private HubConfigImpl hubConfig;
    private String projectDir;
    private Properties properties;
    private boolean usePropertiesFromEnvironment = false;
    private String environment;
    private ManageConfig manageConfig;
    private ManageClient manageClient;
    private AdminConfig adminConfig;
    private AdminManager adminManager;
    private AppConfig appConfig;

    public HubConfigBuilderImpl(String projectDir) {
        this.projectDir = projectDir;
        this.hubConfig = (HubConfigImpl)HubConfig.create(projectDir);
    }

    @Override
    public HubConfigBuilder withPropertiesFromEnvironment() {
        return this.withPropertiesFromEnvironment(null);
    }

    @Override
    public HubConfigBuilder withPropertiesFromEnvironment(String environment) {
        this.usePropertiesFromEnvironment = true;
        this.environment = environment;
        return this;
    }

    @Override
    public HubConfigBuilder withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public HubConfigBuilder withAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    @Override
    public HubConfigBuilder withAdminConfig(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
        return this;
    }

    @Override
    public HubConfigBuilder withAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
        return this;
    }

    @Override
    public HubConfigBuilder withManageConfig(ManageConfig manageConfig) {
        this.manageConfig = manageConfig;
        return this;
    }

    @Override
    public HubConfigBuilder withManageClient(ManageClient manageClient) {
        this.manageClient = manageClient;
        return this;
    }

    @Override
    public HubConfig build() {
        Properties actualProperties = null;
        if (this.usePropertiesFromEnvironment) {
            actualProperties = this.getPropertiesFromEnvironment();
        }
        if (actualProperties == null) {
            actualProperties = new Properties();
        }
        Properties tmpProperties = actualProperties;
        if (this.properties != null) {
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)tmpProperties::put));
        }
        this.hubConfig.loadConfigurationFromProperties(actualProperties);
        SimplePropertySource propertySource = new SimplePropertySource(actualProperties);
        if (this.appConfig != null) {
            this.hubConfig.setAppConfig(this.appConfig);
        } else {
            this.hubConfig.setAppConfig(new DefaultAppConfigFactory((PropertySource)propertySource).newAppConfig());
        }
        if (this.adminConfig != null) {
            this.hubConfig.setAdminConfig(this.adminConfig);
        } else {
            this.hubConfig.setAdminConfig(new DefaultAdminConfigFactory((PropertySource)propertySource).newAdminConfig());
        }
        if (this.adminManager != null) {
            this.hubConfig.setAdminManager(this.adminManager);
        } else {
            this.hubConfig.setAdminManager(new AdminManager(this.hubConfig.getAdminConfig()));
        }
        if (this.manageConfig != null) {
            this.hubConfig.setManageConfig(this.manageConfig);
        } else {
            this.hubConfig.setManageConfig(new DefaultManageConfigFactory((PropertySource)propertySource).newManageConfig());
        }
        if (this.manageClient != null) {
            this.hubConfig.setManageClient(this.manageClient);
        } else {
            this.hubConfig.setManageClient(new ManageClient(this.hubConfig.getManageConfig()));
        }
        return this.hubConfig;
    }

    private Properties getPropertiesFromEnvironment() {
        Properties environmentProperties = new Properties();
        File file = new File(this.projectDir, GRADLE_PROPERTIES_FILENAME);
        this.loadPropertiesFromFile(file, environmentProperties);
        if (this.environment != null) {
            File envPropertiesFile = new File(this.projectDir, "gradle-" + this.environment + ".properties");
            this.loadPropertiesFromFile(envPropertiesFile, environmentProperties);
        }
        return environmentProperties;
    }

    private void loadPropertiesFromFile(File propertiesFile, Properties loadedProperties) {
        try {
            if (propertiesFile.exists()) {
                FileInputStream is = new FileInputStream(propertiesFile);
                loadedProperties.load(is);
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

