/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.client.ext.modulesloader.ssl.SimpleX509TrustManager;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.error.InvalidDBOperationError;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.admin.AdminConfig;
import com.marklogic.mgmt.admin.AdminManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC, getterVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public class HubConfigImpl
implements HubConfig {
    protected String stagingDbName = "data-hub-STAGING";
    protected String stagingHttpName = "data-hub-STAGING";
    protected Integer stagingForestsPerHost = DEFAULT_FORESTS_PER_HOST;
    protected Integer stagingPort = DEFAULT_STAGING_PORT;
    protected String stagingAuthMethod = "digest";
    private String stagingScheme = "http";
    private boolean stagingSimpleSsl = false;
    private SSLContext stagingSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier stagingSslHostnameVerifier;
    private String stagingCertFile;
    private String stagingCertPassword;
    private String stagingExternalName;
    protected String finalDbName = "data-hub-FINAL";
    protected String finalHttpName = "data-hub-FINAL";
    protected Integer finalForestsPerHost = DEFAULT_FORESTS_PER_HOST;
    protected Integer finalPort = DEFAULT_FINAL_PORT;
    protected String finalAuthMethod = "digest";
    private String finalScheme = "http";
    private boolean finalSimpleSsl = false;
    private SSLContext finalSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier finalSslHostnameVerifier;
    private String finalCertFile;
    private String finalCertPassword;
    private String finalExternalName;
    protected String traceDbName = "data-hub-TRACING";
    protected String traceHttpName = "data-hub-TRACING";
    protected Integer traceForestsPerHost = 1;
    protected Integer tracePort = DEFAULT_TRACE_PORT;
    protected String traceAuthMethod = "digest";
    private String traceScheme = "http";
    private boolean traceSimpleSsl = false;
    private SSLContext traceSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier traceSslHostnameVerifier;
    private String traceCertFile;
    private String traceCertPassword;
    private String traceExternalName;
    protected String jobDbName = "data-hub-JOBS";
    protected String jobHttpName = "data-hub-JOBS";
    protected Integer jobForestsPerHost = 1;
    protected Integer jobPort = DEFAULT_JOB_PORT;
    protected String jobAuthMethod = "digest";
    private String jobScheme = "http";
    private boolean jobSimpleSsl = false;
    private SSLContext jobSslContext;
    private DatabaseClientFactory.SSLHostnameVerifier jobSslHostnameVerifier;
    private String jobCertFile;
    private String jobCertPassword;
    private String jobExternalName;
    protected String modulesDbName = "data-hub-MODULES";
    protected Integer modulesForestsPerHost = 1;
    protected String triggersDbName = "data-hub-TRIGGERS";
    protected Integer triggersForestsPerHost = 1;
    protected String schemasDbName = "data-hub-SCHEMAS";
    protected Integer schemasForestsPerHost = 1;
    private String hubRoleName = "data-hub-role";
    private String hubUserName = "data-hub-user";
    private String[] loadBalancerHosts;
    protected String customForestPath = "forests";
    protected String modulePermissions = "rest-reader,read,rest-writer,insert,rest-writer,update,rest-extension-user,execute";
    private String projectDir;
    private Properties environmentProperties;
    private HubProject hubProject;
    private ManageConfig manageConfig;
    private ManageClient manageClient;
    private AdminConfig adminConfig;
    private AdminManager adminManager;
    private AppConfig appConfig;
    private static final Logger logger = LoggerFactory.getLogger(HubConfigImpl.class);

    public HubConfigImpl() {
    }

    public HubConfigImpl(String projectDir) {
        this.setProjectDir(new File(projectDir).getAbsolutePath());
    }

    @Override
    public String getHost() {
        return this.appConfig.getHost();
    }

    @Override
    public String getDbName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.stagingDbName;
                break;
            }
            case FINAL: {
                name = this.finalDbName;
                break;
            }
            case JOB: {
                name = this.jobDbName;
                break;
            }
            case TRACE: {
                name = this.traceDbName;
                break;
            }
            case MODULES: {
                name = this.modulesDbName;
                break;
            }
            case TRIGGERS: {
                name = this.triggersDbName;
                break;
            }
            case SCHEMAS: {
                name = this.schemasDbName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab database name");
            }
        }
        return name;
    }

    @Override
    public void setDbName(DatabaseKind kind, String dbName) {
        switch (kind) {
            case STAGING: {
                this.stagingDbName = dbName;
                break;
            }
            case FINAL: {
                this.finalDbName = dbName;
                break;
            }
            case JOB: {
                this.jobDbName = dbName;
                break;
            }
            case TRACE: {
                this.traceDbName = dbName;
                break;
            }
            case MODULES: {
                this.modulesDbName = dbName;
                break;
            }
            case TRIGGERS: {
                this.triggersDbName = dbName;
                break;
            }
            case SCHEMAS: {
                this.schemasDbName = dbName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set database name");
            }
        }
    }

    @Override
    public String getHttpName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.stagingHttpName;
                break;
            }
            case FINAL: {
                name = this.finalHttpName;
                break;
            }
            case JOB: {
                name = this.jobHttpName;
                break;
            }
            case TRACE: {
                name = this.traceHttpName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab http name");
            }
        }
        return name;
    }

    @Override
    public void setHttpName(DatabaseKind kind, String httpName) {
        switch (kind) {
            case STAGING: {
                this.stagingHttpName = httpName;
                break;
            }
            case FINAL: {
                this.finalHttpName = httpName;
                break;
            }
            case JOB: {
                this.jobHttpName = httpName;
                break;
            }
            case TRACE: {
                this.traceHttpName = httpName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set http name");
            }
        }
    }

    @Override
    public Integer getForestsPerHost(DatabaseKind kind) {
        Integer forests;
        switch (kind) {
            case STAGING: {
                forests = this.stagingForestsPerHost;
                break;
            }
            case FINAL: {
                forests = this.finalForestsPerHost;
                break;
            }
            case JOB: {
                forests = this.jobForestsPerHost;
                break;
            }
            case TRACE: {
                forests = this.traceForestsPerHost;
                break;
            }
            case MODULES: {
                forests = this.modulesForestsPerHost;
                break;
            }
            case TRIGGERS: {
                forests = this.triggersForestsPerHost;
                break;
            }
            case SCHEMAS: {
                forests = this.schemasForestsPerHost;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab count of forests per host");
            }
        }
        return forests;
    }

    @Override
    public void setForestsPerHost(DatabaseKind kind, Integer forestsPerHost) {
        switch (kind) {
            case STAGING: {
                this.stagingForestsPerHost = forestsPerHost;
                break;
            }
            case FINAL: {
                this.finalForestsPerHost = forestsPerHost;
                break;
            }
            case JOB: {
                this.jobForestsPerHost = forestsPerHost;
                break;
            }
            case TRACE: {
                this.traceForestsPerHost = forestsPerHost;
                break;
            }
            case MODULES: {
                this.modulesForestsPerHost = forestsPerHost;
                break;
            }
            case TRIGGERS: {
                this.triggersForestsPerHost = forestsPerHost;
                break;
            }
            case SCHEMAS: {
                this.schemasForestsPerHost = forestsPerHost;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set count of forests per host");
            }
        }
    }

    @Override
    public Integer getPort(DatabaseKind kind) {
        Integer port;
        switch (kind) {
            case STAGING: {
                port = this.stagingPort;
                break;
            }
            case FINAL: {
                port = this.finalPort;
                break;
            }
            case JOB: {
                port = this.jobPort;
                break;
            }
            case TRACE: {
                port = this.tracePort;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "grab app port");
            }
        }
        return port;
    }

    @Override
    public void setPort(DatabaseKind kind, Integer port) {
        switch (kind) {
            case STAGING: {
                this.stagingPort = port;
                break;
            }
            case FINAL: {
                this.finalPort = port;
                break;
            }
            case JOB: {
                this.jobPort = port;
                break;
            }
            case TRACE: {
                this.tracePort = port;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set app port");
            }
        }
    }

    @Override
    public SSLContext getSslContext(DatabaseKind kind) {
        SSLContext sslContext;
        switch (kind) {
            case STAGING: {
                sslContext = this.stagingSslContext;
                break;
            }
            case FINAL: {
                sslContext = this.finalSslContext;
                break;
            }
            case JOB: {
                sslContext = this.jobSslContext;
                break;
            }
            case TRACE: {
                sslContext = this.traceSslContext;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get ssl context");
            }
        }
        return sslContext;
    }

    @Override
    public void setSslContext(DatabaseKind kind, SSLContext sslContext) {
        switch (kind) {
            case STAGING: {
                this.stagingSslContext = sslContext;
                break;
            }
            case FINAL: {
                this.finalSslContext = sslContext;
                break;
            }
            case JOB: {
                this.jobSslContext = sslContext;
                break;
            }
            case TRACE: {
                this.traceSslContext = sslContext;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set ssl context");
            }
        }
    }

    @Override
    public DatabaseClientFactory.SSLHostnameVerifier getSslHostnameVerifier(DatabaseKind kind) {
        DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier;
        switch (kind) {
            case STAGING: {
                sslHostnameVerifier = this.stagingSslHostnameVerifier;
                break;
            }
            case FINAL: {
                sslHostnameVerifier = this.finalSslHostnameVerifier;
                break;
            }
            case JOB: {
                sslHostnameVerifier = this.jobSslHostnameVerifier;
                break;
            }
            case TRACE: {
                sslHostnameVerifier = this.traceSslHostnameVerifier;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get ssl hostname verifier");
            }
        }
        return sslHostnameVerifier;
    }

    @Override
    public void setSslHostnameVerifier(DatabaseKind kind, DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier) {
        switch (kind) {
            case STAGING: {
                this.stagingSslHostnameVerifier = sslHostnameVerifier;
                break;
            }
            case FINAL: {
                this.finalSslHostnameVerifier = sslHostnameVerifier;
                break;
            }
            case JOB: {
                this.jobSslHostnameVerifier = sslHostnameVerifier;
                break;
            }
            case TRACE: {
                this.traceSslHostnameVerifier = sslHostnameVerifier;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set ssl hostname verifier");
            }
        }
    }

    @Override
    public String getAuthMethod(DatabaseKind kind) {
        String authMethod;
        switch (kind) {
            case STAGING: {
                authMethod = this.stagingAuthMethod;
                break;
            }
            case FINAL: {
                authMethod = this.finalAuthMethod;
                break;
            }
            case JOB: {
                authMethod = this.jobAuthMethod;
                break;
            }
            case TRACE: {
                authMethod = this.traceAuthMethod;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get auth method");
            }
        }
        return authMethod;
    }

    @Override
    public void setAuthMethod(DatabaseKind kind, String authMethod) {
        switch (kind) {
            case STAGING: {
                this.stagingAuthMethod = authMethod;
                break;
            }
            case FINAL: {
                this.finalAuthMethod = authMethod;
                break;
            }
            case JOB: {
                this.jobAuthMethod = authMethod;
                break;
            }
            case TRACE: {
                this.traceAuthMethod = authMethod;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @Override
    public String getScheme(DatabaseKind kind) {
        String scheme;
        switch (kind) {
            case STAGING: {
                scheme = this.stagingScheme;
                break;
            }
            case FINAL: {
                scheme = this.finalScheme;
                break;
            }
            case JOB: {
                scheme = this.jobScheme;
                break;
            }
            case TRACE: {
                scheme = this.traceScheme;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get scheme");
            }
        }
        return scheme;
    }

    @Override
    public void setScheme(DatabaseKind kind, String scheme) {
        switch (kind) {
            case STAGING: {
                this.stagingScheme = scheme;
                break;
            }
            case FINAL: {
                this.finalScheme = scheme;
                break;
            }
            case JOB: {
                this.jobScheme = scheme;
                break;
            }
            case TRACE: {
                this.traceScheme = scheme;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @Override
    public boolean getSimpleSsl(DatabaseKind kind) {
        boolean simple;
        switch (kind) {
            case STAGING: {
                simple = this.stagingSimpleSsl;
                break;
            }
            case FINAL: {
                simple = this.finalSimpleSsl;
                break;
            }
            case JOB: {
                simple = this.jobSimpleSsl;
                break;
            }
            case TRACE: {
                simple = this.traceSimpleSsl;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get simple ssl");
            }
        }
        return simple;
    }

    @Override
    public void setSimpleSsl(DatabaseKind kind, Boolean simpleSsl) {
        switch (kind) {
            case STAGING: {
                this.stagingSimpleSsl = simpleSsl;
                break;
            }
            case FINAL: {
                this.finalSimpleSsl = simpleSsl;
                break;
            }
            case JOB: {
                this.jobSimpleSsl = simpleSsl;
                break;
            }
            case TRACE: {
                this.traceSimpleSsl = simpleSsl;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set simple ssl");
            }
        }
    }

    @Override
    public String getCertFile(DatabaseKind kind) {
        String certFile;
        switch (kind) {
            case STAGING: {
                certFile = this.stagingCertFile;
                break;
            }
            case FINAL: {
                certFile = this.finalCertFile;
                break;
            }
            case JOB: {
                certFile = this.jobCertFile;
                break;
            }
            case TRACE: {
                certFile = this.traceCertFile;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get cert file");
            }
        }
        return certFile;
    }

    @Override
    public void setCertFile(DatabaseKind kind, String certFile) {
        switch (kind) {
            case STAGING: {
                this.stagingCertFile = certFile;
                break;
            }
            case FINAL: {
                this.finalCertFile = certFile;
                break;
            }
            case JOB: {
                this.jobCertFile = certFile;
                break;
            }
            case TRACE: {
                this.traceCertFile = certFile;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set certificate file");
            }
        }
    }

    @Override
    public String getCertPassword(DatabaseKind kind) {
        String certPass;
        switch (kind) {
            case STAGING: {
                certPass = this.stagingCertPassword;
                break;
            }
            case FINAL: {
                certPass = this.finalCertPassword;
                break;
            }
            case JOB: {
                certPass = this.jobCertPassword;
                break;
            }
            case TRACE: {
                certPass = this.traceCertPassword;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get cert password");
            }
        }
        return certPass;
    }

    @Override
    public void setCertPass(DatabaseKind kind, String certPassword) {
        switch (kind) {
            case STAGING: {
                this.stagingCertPassword = certPassword;
                break;
            }
            case FINAL: {
                this.finalCertPassword = certPassword;
                break;
            }
            case JOB: {
                this.jobCertPassword = certPassword;
                break;
            }
            case TRACE: {
                this.traceCertPassword = certPassword;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set certificate password");
            }
        }
    }

    @Override
    public String getExternalName(DatabaseKind kind) {
        String name;
        switch (kind) {
            case STAGING: {
                name = this.stagingExternalName;
                break;
            }
            case FINAL: {
                name = this.finalExternalName;
                break;
            }
            case JOB: {
                name = this.jobExternalName;
                break;
            }
            case TRACE: {
                name = this.traceExternalName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "get external name");
            }
        }
        return name;
    }

    @Override
    public void setExternalName(DatabaseKind kind, String externalName) {
        switch (kind) {
            case STAGING: {
                this.stagingExternalName = externalName;
                break;
            }
            case FINAL: {
                this.finalExternalName = externalName;
                break;
            }
            case JOB: {
                this.jobExternalName = externalName;
                break;
            }
            case TRACE: {
                this.traceExternalName = externalName;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set auth method");
            }
        }
    }

    @Override
    public String getHubRoleName() {
        return this.hubRoleName;
    }

    @Override
    public void setHubRoleName(String hubRoleName) {
        this.hubRoleName = hubRoleName;
    }

    @Override
    public String getHubUserName() {
        return this.hubUserName;
    }

    @Override
    public void setHubUserName(String hubUserName) {
        this.hubUserName = hubUserName;
    }

    @Override
    @JsonIgnore
    public String[] getLoadBalancerHosts() {
        return this.loadBalancerHosts;
    }

    public void setLoadBalancerHosts(String[] loadBalancerHosts) {
        this.loadBalancerHosts = loadBalancerHosts;
    }

    @Override
    public String getCustomForestPath() {
        return this.customForestPath;
    }

    public void setCustomForestPath(String customForestPath) {
        this.customForestPath = customForestPath;
    }

    @Override
    public String getModulePermissions() {
        return this.modulePermissions;
    }

    public void setModulePermissions(String modulePermissions) {
        this.modulePermissions = modulePermissions;
    }

    @Override
    public String getProjectDir() {
        return this.projectDir;
    }

    @Override
    public void setProjectDir(String projectDir) {
        this.projectDir = projectDir;
        this.hubProject = HubProject.create(projectDir);
    }

    @Override
    @JsonIgnore
    public HubProject getHubProject() {
        return this.hubProject;
    }

    @Override
    public void initHubProject() {
        this.hubProject.init(this.getCustomTokens());
    }

    @Override
    @JsonIgnore
    public String getHubModulesDeployTimestampFile() {
        return Paths.get(this.projectDir, ".tmp", "hub-modules-deploy-timestamps.properties").toString();
    }

    @Override
    @JsonIgnore
    public String getUserModulesDeployTimestampFile() {
        return Paths.get(this.projectDir, ".tmp", "user-modules-deploy-timestamps.properties").toString();
    }

    @JsonIgnore
    public File getUserContentDeployTimestampFile() {
        return Paths.get(this.projectDir, ".tmp", "user-content-deploy-timestamps.properties").toFile();
    }

    public void loadConfigurationFromProperties(Properties environmentProperties) {
        this.environmentProperties = environmentProperties;
        if (this.environmentProperties != null) {
            this.stagingDbName = this.getEnvPropString(environmentProperties, "mlStagingDbName", this.stagingDbName);
            this.stagingHttpName = this.getEnvPropString(environmentProperties, "mlStagingAppserverName", this.stagingHttpName);
            this.stagingForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlStagingForestsPerHost", this.stagingForestsPerHost);
            this.stagingPort = this.getEnvPropInteger(environmentProperties, "mlStagingPort", this.stagingPort);
            this.stagingAuthMethod = this.getEnvPropString(environmentProperties, "mlStagingAuth", this.stagingAuthMethod);
            this.stagingScheme = this.getEnvPropString(environmentProperties, "mlStagingScheme", this.stagingScheme);
            this.stagingSimpleSsl = this.getEnvPropBoolean(environmentProperties, "mlStagingSimpleSsl", false);
            if (this.stagingSimpleSsl) {
                this.stagingSslContext = SimpleX509TrustManager.newSSLContext();
                this.stagingSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            this.stagingCertFile = this.getEnvPropString(environmentProperties, "mlStagingCertFile", this.stagingCertFile);
            this.stagingCertPassword = this.getEnvPropString(environmentProperties, "mlStagingCertPassword", this.stagingCertPassword);
            this.stagingExternalName = this.getEnvPropString(environmentProperties, "mlStagingExternalName", this.stagingExternalName);
            this.finalDbName = this.getEnvPropString(environmentProperties, "mlFinalDbName", this.finalDbName);
            this.finalHttpName = this.getEnvPropString(environmentProperties, "mlFinalAppserverName", this.finalHttpName);
            this.finalForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlFinalForestsPerHost", this.finalForestsPerHost);
            this.finalPort = this.getEnvPropInteger(environmentProperties, "mlFinalPort", this.finalPort);
            this.finalAuthMethod = this.getEnvPropString(environmentProperties, "mlFinalAuth", this.finalAuthMethod);
            this.finalScheme = this.getEnvPropString(environmentProperties, "mlFinalScheme", this.finalScheme);
            this.finalSimpleSsl = this.getEnvPropBoolean(environmentProperties, "mlFinalSimpleSsl", false);
            if (this.finalSimpleSsl) {
                this.finalSslContext = SimpleX509TrustManager.newSSLContext();
                this.finalSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            this.finalCertFile = this.getEnvPropString(environmentProperties, "mlFinalCertFile", this.finalCertFile);
            this.finalCertPassword = this.getEnvPropString(environmentProperties, "mlFinalCertPassword", this.finalCertPassword);
            this.finalExternalName = this.getEnvPropString(environmentProperties, "mlFinalExternalName", this.finalExternalName);
            this.traceDbName = this.getEnvPropString(environmentProperties, "mlTraceDbName", this.traceDbName);
            this.traceHttpName = this.getEnvPropString(environmentProperties, "mlTraceAppserverName", this.traceHttpName);
            this.traceForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlTraceForestsPerHost", this.traceForestsPerHost);
            this.tracePort = this.getEnvPropInteger(environmentProperties, "mlTracePort", this.tracePort);
            this.traceAuthMethod = this.getEnvPropString(environmentProperties, "mlTraceAuth", this.traceAuthMethod);
            this.traceScheme = this.getEnvPropString(environmentProperties, "mlTraceScheme", this.traceScheme);
            this.traceSimpleSsl = this.getEnvPropBoolean(environmentProperties, "mlTraceSimpleSsl", false);
            if (this.traceSimpleSsl) {
                this.traceSslContext = SimpleX509TrustManager.newSSLContext();
                this.traceSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            this.traceCertFile = this.getEnvPropString(environmentProperties, "mlTraceCertFile", this.traceCertFile);
            this.traceCertPassword = this.getEnvPropString(environmentProperties, "mlTraceCertPassword", this.traceCertPassword);
            this.traceExternalName = this.getEnvPropString(environmentProperties, "mlTraceExternalName", this.traceExternalName);
            this.jobDbName = this.getEnvPropString(environmentProperties, "mlJobDbName", this.jobDbName);
            this.jobHttpName = this.getEnvPropString(environmentProperties, "mlJobAppserverName", this.jobHttpName);
            this.jobForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlJobForestsPerHost", this.jobForestsPerHost);
            this.jobPort = this.getEnvPropInteger(environmentProperties, "mlJobPort", this.jobPort);
            this.jobAuthMethod = this.getEnvPropString(environmentProperties, "mlJobAuth", this.jobAuthMethod);
            this.jobScheme = this.getEnvPropString(environmentProperties, "mlJobScheme", this.jobScheme);
            this.jobSimpleSsl = this.getEnvPropBoolean(environmentProperties, "mlJobSimpleSsl", false);
            if (this.jobSimpleSsl) {
                this.jobSslContext = SimpleX509TrustManager.newSSLContext();
                this.jobSslHostnameVerifier = DatabaseClientFactory.SSLHostnameVerifier.ANY;
            }
            this.jobCertFile = this.getEnvPropString(environmentProperties, "mlJobCertFile", this.jobCertFile);
            this.jobCertPassword = this.getEnvPropString(environmentProperties, "mlJobCertPassword", this.jobCertPassword);
            this.jobExternalName = this.getEnvPropString(environmentProperties, "mlJobExternalName", this.jobExternalName);
            this.customForestPath = this.getEnvPropString(environmentProperties, "mlCustomForestPath", this.customForestPath);
            this.modulesDbName = this.getEnvPropString(environmentProperties, "mlModulesDbName", this.modulesDbName);
            this.modulesForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlModulesForestsPerHost", this.modulesForestsPerHost);
            this.modulePermissions = this.getEnvPropString(environmentProperties, "mlModulePermissions", this.modulePermissions);
            this.triggersDbName = this.getEnvPropString(environmentProperties, "mlTriggersDbName", this.triggersDbName);
            this.triggersForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlTriggersForestsPerHost", this.triggersForestsPerHost);
            this.schemasDbName = this.getEnvPropString(environmentProperties, "mlSchemasDbName", this.schemasDbName);
            this.schemasForestsPerHost = this.getEnvPropInteger(environmentProperties, "mlSchemasForestsPerHost", this.schemasForestsPerHost);
            this.hubRoleName = this.getEnvPropString(environmentProperties, "mlHubUserRole", this.hubRoleName);
            this.hubUserName = this.getEnvPropString(environmentProperties, "mlHubUserName", this.hubUserName);
            String lbh = this.getEnvPropString(environmentProperties, "mlLoadBalancerHosts", null);
            if (lbh != null && lbh.length() > 0) {
                this.loadBalancerHosts = lbh.split(",");
            }
            this.projectDir = this.getEnvPropString(environmentProperties, "hubProjectDir", this.projectDir);
            logger.info("Hub Project Dir: " + this.projectDir);
        } else {
            logger.error("Missing environmentProperties");
        }
    }

    @JsonIgnore
    public ManageConfig getManageConfig() {
        return this.manageConfig;
    }

    public void setManageConfig(ManageConfig manageConfig) {
        this.manageConfig = manageConfig;
    }

    @JsonIgnore
    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public void setManageClient(ManageClient manageClient) {
        this.manageClient = manageClient;
    }

    @JsonIgnore
    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public void setAdminConfig(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
    }

    @JsonIgnore
    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public void setAdminManager(AdminManager adminManager) {
        this.adminManager = adminManager;
    }

    @Override
    public DatabaseClient newAppServicesClient() {
        return this.getAppConfig().newAppServicesDatabaseClient(null);
    }

    @Override
    public DatabaseClient newStagingClient() {
        return this.newStagingClient(this.stagingDbName);
    }

    @Override
    public DatabaseClient newStagingClient(String databaseName) {
        AppConfig appConfig = this.getAppConfig();
        DatabaseClientConfig config = new DatabaseClientConfig(appConfig.getHost(), this.stagingPort.intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword());
        config.setDatabase(databaseName);
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.stagingAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.stagingSslHostnameVerifier);
        config.setSslContext(this.stagingSslContext);
        config.setCertFile(this.stagingCertFile);
        config.setCertPassword(this.stagingCertPassword);
        config.setExternalName(this.stagingExternalName);
        return appConfig.getConfiguredDatabaseClientFactory().newDatabaseClient(config);
    }

    @Override
    public DatabaseClient newFinalClient() {
        AppConfig appConfig = this.getAppConfig();
        DatabaseClientConfig config = new DatabaseClientConfig(appConfig.getHost(), this.finalPort.intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword());
        config.setDatabase(this.finalDbName);
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.finalAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.finalSslHostnameVerifier);
        config.setSslContext(this.finalSslContext);
        config.setCertFile(this.finalCertFile);
        config.setCertPassword(this.finalCertPassword);
        config.setExternalName(this.finalExternalName);
        return appConfig.getConfiguredDatabaseClientFactory().newDatabaseClient(config);
    }

    @Override
    public DatabaseClient newJobDbClient() {
        AppConfig appConfig = this.getAppConfig();
        DatabaseClientConfig config = new DatabaseClientConfig(appConfig.getHost(), this.jobPort.intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword());
        config.setDatabase(this.jobDbName);
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.jobAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.jobSslHostnameVerifier);
        config.setSslContext(this.jobSslContext);
        config.setCertFile(this.jobCertFile);
        config.setCertPassword(this.jobCertPassword);
        config.setExternalName(this.jobExternalName);
        return appConfig.getConfiguredDatabaseClientFactory().newDatabaseClient(config);
    }

    @Override
    public DatabaseClient newTraceDbClient() {
        AppConfig appConfig = this.getAppConfig();
        DatabaseClientConfig config = new DatabaseClientConfig(appConfig.getHost(), this.tracePort.intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword());
        config.setDatabase(this.traceDbName);
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.traceAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.traceSslHostnameVerifier);
        config.setSslContext(this.traceSslContext);
        config.setCertFile(this.traceCertFile);
        config.setCertPassword(this.traceCertPassword);
        config.setExternalName(this.traceExternalName);
        return appConfig.getConfiguredDatabaseClientFactory().newDatabaseClient(config);
    }

    @Override
    public DatabaseClient newModulesDbClient() {
        AppConfig appConfig = this.getAppConfig();
        DatabaseClientConfig config = new DatabaseClientConfig(appConfig.getHost(), this.stagingPort.intValue(), appConfig.getRestAdminUsername(), appConfig.getRestAdminPassword());
        config.setDatabase(appConfig.getModulesDatabaseName());
        config.setSecurityContextType(SecurityContextType.valueOf((String)this.stagingAuthMethod.toUpperCase()));
        config.setSslHostnameVerifier(this.stagingSslHostnameVerifier);
        config.setSslContext(this.stagingSslContext);
        config.setCertFile(this.stagingCertFile);
        config.setCertPassword(this.stagingCertPassword);
        config.setExternalName(this.stagingExternalName);
        return appConfig.getConfiguredDatabaseClientFactory().newDatabaseClient(config);
    }

    @Override
    @JsonIgnore
    public Path getHubPluginsDir() {
        return this.hubProject.getHubPluginsDir();
    }

    @Override
    @JsonIgnore
    public Path getHubEntitiesDir() {
        return this.hubProject.getHubEntitiesDir();
    }

    @Override
    @JsonIgnore
    public Path getHubConfigDir() {
        return this.hubProject.getHubConfigDir();
    }

    @Override
    @JsonIgnore
    public Path getHubDatabaseDir() {
        return this.hubProject.getHubDatabaseDir();
    }

    @Override
    @JsonIgnore
    public Path getHubServersDir() {
        return this.hubProject.getHubServersDir();
    }

    @Override
    @JsonIgnore
    public Path getHubSecurityDir() {
        return this.hubProject.getHubSecurityDir();
    }

    @Override
    @JsonIgnore
    public Path getUserSecurityDir() {
        return this.hubProject.getUserSecurityDir();
    }

    @Override
    @JsonIgnore
    public Path getUserConfigDir() {
        return this.hubProject.getUserConfigDir();
    }

    @Override
    @JsonIgnore
    public Path getUserDatabaseDir() {
        return this.hubProject.getUserDatabaseDir();
    }

    @Override
    @JsonIgnore
    public Path getEntityDatabaseDir() {
        return this.hubProject.getEntityDatabaseDir();
    }

    @Override
    @JsonIgnore
    public Path getUserServersDir() {
        return this.hubProject.getUserServersDir();
    }

    @Override
    @JsonIgnore
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @Override
    public void setAppConfig(AppConfig config) {
        this.setAppConfig(config, false);
    }

    @Override
    public void setAppConfig(AppConfig config, boolean skipUpdate) {
        this.appConfig = config;
        if (!skipUpdate) {
            this.updateAppConfig(this.appConfig);
        }
    }

    @Override
    public String getJarVersion() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("version.properties");
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String version = (String)properties.get("version");
        if (version.equals("${project.version}")) {
            version = "3.0.0";
        }
        return version;
    }

    private Map<String, String> getCustomTokens() {
        AppConfig appConfig = this.getAppConfig();
        return this.getCustomTokens(appConfig, appConfig.getCustomTokens());
    }

    private Map<String, String> getCustomTokens(AppConfig appConfig, Map<String, String> customTokens) {
        customTokens.put("%%mlHost%%", appConfig.getHost());
        customTokens.put("%%mlStagingAppserverName%%", this.stagingHttpName);
        customTokens.put("\"%%mlStagingPort%%\"", this.stagingPort.toString());
        customTokens.put("%%mlStagingDbName%%", this.stagingDbName);
        customTokens.put("%%mlStagingForestsPerHost%%", this.stagingForestsPerHost.toString());
        customTokens.put("%%mlStagingAuth%%", this.stagingAuthMethod);
        customTokens.put("%%mlFinalAppserverName%%", this.finalHttpName);
        customTokens.put("\"%%mlFinalPort%%\"", this.finalPort.toString());
        customTokens.put("%%mlFinalDbName%%", this.finalDbName);
        customTokens.put("%%mlFinalForestsPerHost%%", this.finalForestsPerHost.toString());
        customTokens.put("%%mlFinalAuth%%", this.finalAuthMethod);
        customTokens.put("%%mlTraceAppserverName%%", this.traceHttpName);
        customTokens.put("\"%%mlTracePort%%\"", this.tracePort.toString());
        customTokens.put("%%mlTraceDbName%%", this.traceDbName);
        customTokens.put("%%mlTraceForestsPerHost%%", this.traceForestsPerHost.toString());
        customTokens.put("%%mlTraceAuth%%", this.traceAuthMethod);
        customTokens.put("%%mlJobAppserverName%%", this.jobHttpName);
        customTokens.put("\"%%mlJobPort%%\"", this.jobPort.toString());
        customTokens.put("%%mlJobDbName%%", this.jobDbName);
        customTokens.put("%%mlJobForestsPerHost%%", this.jobForestsPerHost.toString());
        customTokens.put("%%mlJobAuth%%", this.jobAuthMethod);
        customTokens.put("%%mlModulesDbName%%", this.modulesDbName);
        customTokens.put("%%mlModulesForestsPerHost%%", this.modulesForestsPerHost.toString());
        customTokens.put("%%mlTriggersDbName%%", this.triggersDbName);
        customTokens.put("%%mlTriggersForestsPerHost%%", this.triggersForestsPerHost.toString());
        customTokens.put("%%mlSchemasDbName%%", this.schemasDbName);
        customTokens.put("%%mlSchemasForestsPerHost%%", this.schemasForestsPerHost.toString());
        customTokens.put("%%mlHubUserRole%%", this.hubRoleName);
        customTokens.put("%%mlHubUserName%%", this.hubUserName);
        RandomStringGenerator randomStringGenerator = new RandomStringGenerator.Builder().withinRange(33, 126).filteredBy(new CharacterPredicate[]{codePoint -> codePoint != 92 && codePoint != 34}).build();
        customTokens.put("%%mlHubUserPassword%%", randomStringGenerator.generate(20));
        customTokens.put("%%mlCustomForestPath%%", this.customForestPath);
        if (this.environmentProperties != null) {
            Enumeration<?> keyEnum = this.environmentProperties.propertyNames();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.matches("^ml[A-Z].+") || customTokens.containsKey(key)) continue;
                customTokens.put("%%" + key + "%%", (String)this.environmentProperties.get(key));
            }
        }
        return customTokens;
    }

    private void updateAppConfig(AppConfig config) {
        config.setRestPort(this.stagingPort);
        config.setModulesDatabaseName(this.modulesDbName);
        config.setTriggersDatabaseName(this.triggersDbName);
        config.setSchemasDatabaseName(this.schemasDbName);
        config.setModulesDatabaseName(this.modulesDbName);
        config.setReplaceTokensInModules(true);
        config.setUseRoxyTokenPrefix(false);
        config.setModulePermissions(this.modulePermissions);
        HashMap<String, Integer> forestCounts = new HashMap<String, Integer>();
        forestCounts.put(this.stagingDbName, this.stagingForestsPerHost);
        forestCounts.put(this.finalDbName, this.finalForestsPerHost);
        forestCounts.put(this.traceDbName, this.traceForestsPerHost);
        forestCounts.put(this.jobDbName, this.jobForestsPerHost);
        forestCounts.put(this.modulesDbName, this.modulesForestsPerHost);
        forestCounts.put(this.triggersDbName, this.triggersForestsPerHost);
        forestCounts.put(this.schemasDbName, this.schemasForestsPerHost);
        config.setForestCounts(forestCounts);
        ConfigDir configDir = new ConfigDir(this.getUserConfigDir().toFile());
        config.setConfigDir(configDir);
        config.setSchemasPath(this.getUserConfigDir().resolve("schemas").toString());
        Map<String, String> customTokens = this.getCustomTokens(config, config.getCustomTokens());
        if (this.environmentProperties != null) {
            Enumeration<?> keyEnum = this.environmentProperties.propertyNames();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.matches("^ml[A-Z].+") || customTokens.containsKey(key)) continue;
                customTokens.put("%%" + key + "%%", (String)this.environmentProperties.get(key));
            }
        }
        String version = this.getJarVersion();
        customTokens.put("%%mlHubVersion%%", version);
        this.appConfig = config;
    }

    private String getEnvPropString(Properties environmentProperties, String key, String fallback) {
        String value = environmentProperties.getProperty(key);
        if (value == null) {
            value = fallback;
        }
        return value;
    }

    private int getEnvPropInteger(Properties environmentProperties, String key, int fallback) {
        String value = environmentProperties.getProperty(key);
        int res = value != null ? Integer.parseInt(value) : fallback;
        return res;
    }

    private boolean getEnvPropBoolean(Properties environmentProperties, String key, boolean fallback) {
        String value = environmentProperties.getProperty(key);
        boolean res = value != null ? Boolean.parseBoolean(value) : fallback;
        return res;
    }
}

