/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.hub.HubProject;
import com.marklogic.hub.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubProjectImpl
implements HubProject {
    public static final String ENTITY_CONFIG_DIR = "entity-config";
    private Path projectDir;
    private Path pluginsDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HubProjectImpl(String projectDirStr) {
        this.projectDir = Paths.get(projectDirStr, new String[0]).toAbsolutePath();
        this.pluginsDir = this.projectDir.resolve("plugins");
    }

    @Override
    public Path getHubPluginsDir() {
        return this.pluginsDir;
    }

    @Override
    public Path getHubEntitiesDir() {
        return this.pluginsDir.resolve("entities");
    }

    @Override
    public Path getHubConfigDir() {
        return this.projectDir.resolve("hub-internal-config");
    }

    @Override
    public Path getHubDatabaseDir() {
        return this.getHubConfigDir().resolve("databases");
    }

    @Override
    public Path getHubServersDir() {
        return this.getHubConfigDir().resolve("servers");
    }

    @Override
    public Path getHubSecurityDir() {
        return this.getHubConfigDir().resolve("security");
    }

    @Override
    public Path getUserConfigDir() {
        return this.projectDir.resolve("user-config");
    }

    @Override
    public Path getUserSecurityDir() {
        return this.getUserConfigDir().resolve("security");
    }

    @Override
    public Path getUserDatabaseDir() {
        return this.getUserConfigDir().resolve("databases");
    }

    @Override
    public Path getUserSchemasDir() {
        return this.getUserConfigDir().resolve("schemas");
    }

    @Override
    public Path getUserServersDir() {
        return this.getUserConfigDir().resolve("servers");
    }

    @Override
    public Path getEntityConfigDir() {
        return this.projectDir.resolve(ENTITY_CONFIG_DIR);
    }

    @Override
    public Path getEntityDatabaseDir() {
        return this.getEntityConfigDir().resolve("databases");
    }

    @Override
    public boolean isInitialized() {
        File buildGradle = this.projectDir.resolve("build.gradle").toFile();
        File gradleProperties = this.projectDir.resolve("gradle.properties").toFile();
        File hubConfigDir = this.getHubConfigDir().toFile();
        File userConfigDir = this.getUserConfigDir().toFile();
        File databasesDir = this.getHubDatabaseDir().toFile();
        File serversDir = this.getHubServersDir().toFile();
        File securityDir = this.getHubSecurityDir().toFile();
        boolean newConfigInitialized = hubConfigDir.exists() && hubConfigDir.isDirectory() && userConfigDir.exists() && userConfigDir.isDirectory() && databasesDir.exists() && databasesDir.isDirectory() && serversDir.exists() && serversDir.isDirectory() && securityDir.exists() && securityDir.isDirectory();
        return buildGradle.exists() && gradleProperties.exists() && newConfigInitialized;
    }

    @Override
    public void init(Map<String, String> customTokens) {
        this.pluginsDir.toFile().mkdirs();
        Path serversDir = this.getHubServersDir();
        serversDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/servers/staging-server.json", serversDir.resolve("staging-server.json"), true);
        this.writeResourceFile("ml-config/servers/final-server.json", serversDir.resolve("final-server.json"), true);
        this.writeResourceFile("ml-config/servers/trace-server.json", serversDir.resolve("trace-server.json"), true);
        this.writeResourceFile("ml-config/servers/job-server.json", serversDir.resolve("job-server.json"), true);
        Path databasesDir = this.getHubDatabaseDir();
        databasesDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/databases/staging-database.json", databasesDir.resolve("staging-database.json"), true);
        this.writeResourceFile("ml-config/databases/final-database.json", databasesDir.resolve("final-database.json"), true);
        this.writeResourceFile("ml-config/databases/trace-database.json", databasesDir.resolve("trace-database.json"), true);
        this.writeResourceFile("ml-config/databases/job-database.json", databasesDir.resolve("job-database.json"), true);
        this.writeResourceFile("ml-config/databases/modules-database.json", databasesDir.resolve("modules-database.json"), true);
        this.writeResourceFile("ml-config/databases/schemas-database.json", databasesDir.resolve("schemas-database.json"), true);
        this.writeResourceFile("ml-config/databases/triggers-database.json", databasesDir.resolve("triggers-database.json"), true);
        Path securityDir = this.getHubSecurityDir();
        Path rolesDir = securityDir.resolve("roles");
        Path usersDir = securityDir.resolve("users");
        rolesDir.toFile().mkdirs();
        usersDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/security/roles/data-hub-role.json", rolesDir.resolve("data-hub-role.json"), true);
        this.writeResourceFile("ml-config/security/users/data-hub-user.json", usersDir.resolve("data-hub-user.json"), true);
        this.getUserServersDir().toFile().mkdirs();
        this.getUserDatabaseDir().toFile().mkdirs();
        Path gradlew = this.projectDir.resolve("gradlew");
        this.writeResourceFile("scaffolding/gradlew", gradlew);
        this.makeExecutable(gradlew);
        Path gradlewbat = this.projectDir.resolve("gradlew.bat");
        this.writeResourceFile("scaffolding/gradlew.bat", gradlewbat);
        this.makeExecutable(gradlewbat);
        Path gradleWrapperDir = this.projectDir.resolve("gradle").resolve("wrapper");
        gradleWrapperDir.toFile().mkdirs();
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.jar", gradleWrapperDir.resolve("gradle-wrapper.jar"));
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.properties", gradleWrapperDir.resolve("gradle-wrapper.properties"));
        this.writeResourceFile("scaffolding/build_gradle", this.projectDir.resolve("build.gradle"));
        this.writeResourceFileWithReplace(customTokens, "scaffolding/gradle_properties", this.projectDir.resolve("gradle.properties"));
        this.writeResourceFile("scaffolding/gradle-local_properties", this.projectDir.resolve("gradle-local.properties"));
    }

    private void makeExecutable(Path file) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(file, perms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeResourceFile(String srcFile, Path dstFile) {
        this.writeResourceFile(srcFile, dstFile, false);
    }

    private void writeResourceFile(String srcFile, Path dstFile, boolean overwrite) {
        if (overwrite || !dstFile.toFile().exists()) {
            this.logger.info("Getting file: " + srcFile);
            InputStream inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
            FileUtil.copy(inputStream, dstFile.toFile());
        }
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile) {
        this.writeResourceFileWithReplace(customTokens, srcFile, dstFile, false);
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile, boolean overwrite) {
        try {
            if (overwrite || !dstFile.toFile().exists()) {
                this.logger.info("Getting file with Replace: " + srcFile);
                InputStream inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
                String fileContents = IOUtils.toString((InputStream)inputStream);
                for (String key : customTokens.keySet()) {
                    String value = customTokens.get(key);
                    if (value == null) continue;
                    fileContents = fileContents.replace(key, value);
                }
                FileWriter writer = new FileWriter(dstFile.toFile());
                writer.write(fileContents);
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

