/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.InstallInfo;
import com.marklogic.hub.error.InvalidDBOperationError;

public class InstallInfoImpl
implements InstallInfo {
    private boolean stagingAppServerExists = false;
    private boolean finalAppServerExists = false;
    private boolean traceAppServerExists = false;
    private boolean jobAppServerExists = false;
    private boolean stagingDbExists = false;
    private boolean finalDbExists = false;
    private boolean traceDbExists = false;
    private boolean jobDbExists = false;
    private boolean stagingTripleIndexOn = false;
    private boolean stagingCollectionLexiconOn = false;
    private boolean finalTripleIndexOn = false;
    private boolean finalCollectionLexiconOn = false;
    private boolean stagingForestsExist = false;
    private boolean finalForestsExist = false;
    private boolean traceForestsExist = false;
    private boolean jobForestsExist = false;

    @Override
    public boolean isPartiallyInstalled() {
        return this.isAppServerExistent(DatabaseKind.STAGING) || this.isAppServerExistent(DatabaseKind.FINAL) || this.isAppServerExistent(DatabaseKind.TRACE) || this.isAppServerExistent(DatabaseKind.JOB) || this.isDbExistent(DatabaseKind.STAGING) || this.isTripleIndexOn(DatabaseKind.STAGING) || this.isCollectionLexiconOn(DatabaseKind.STAGING) || this.isDbExistent(DatabaseKind.FINAL) || this.isTripleIndexOn(DatabaseKind.FINAL) || this.isCollectionLexiconOn(DatabaseKind.FINAL) || this.isDbExistent(DatabaseKind.TRACE) || this.isDbExistent(DatabaseKind.JOB) || this.areForestsExistent(DatabaseKind.STAGING) || this.areForestsExistent(DatabaseKind.FINAL) || this.areForestsExistent(DatabaseKind.TRACE) || this.areForestsExistent(DatabaseKind.JOB);
    }

    @Override
    public boolean isInstalled() {
        boolean appserversOk = this.isAppServerExistent(DatabaseKind.STAGING) && this.isAppServerExistent(DatabaseKind.FINAL) && this.isAppServerExistent(DatabaseKind.TRACE) && this.isAppServerExistent(DatabaseKind.JOB);
        boolean dbsOk = this.isDbExistent(DatabaseKind.STAGING) && this.isTripleIndexOn(DatabaseKind.STAGING) && this.isCollectionLexiconOn(DatabaseKind.STAGING) && this.isDbExistent(DatabaseKind.FINAL) && this.isTripleIndexOn(DatabaseKind.FINAL) && this.isCollectionLexiconOn(DatabaseKind.FINAL) && this.isDbExistent(DatabaseKind.TRACE) && this.isDbExistent(DatabaseKind.JOB);
        boolean forestsOk = this.areForestsExistent(DatabaseKind.STAGING) && this.areForestsExistent(DatabaseKind.FINAL) && this.areForestsExistent(DatabaseKind.TRACE) && this.areForestsExistent(DatabaseKind.JOB);
        return appserversOk && dbsOk && forestsOk;
    }

    @Override
    public String toString() {
        return "\nChecking MarkLogic Installation:\n\tAppServers:\n\t\tStaging: " + (this.isAppServerExistent(DatabaseKind.STAGING) ? "exists" : "MISSING") + "\n" + "\t\tFinal:   " + (this.isAppServerExistent(DatabaseKind.FINAL) ? "exists" : "MISSING") + "\n" + "\t\tTrace:   " + (this.isAppServerExistent(DatabaseKind.TRACE) ? "exists" : "MISSING") + "\n" + "\t\tJob:     " + (this.isAppServerExistent(DatabaseKind.JOB) ? "exists" : "MISSING") + "\n" + "\tDatabases:\n" + "\t\tStaging: " + (this.isDbExistent(DatabaseKind.STAGING) ? "exists" : "MISSING") + "\n" + "\t\tFinal:   " + (this.isDbExistent(DatabaseKind.FINAL) ? "exists" : "MISSING") + "\n" + "\t\tTrace:   " + (this.isDbExistent(DatabaseKind.TRACE) ? "exists" : "MISSING") + "\n" + "\t\tJob:     " + (this.isDbExistent(DatabaseKind.JOB) ? "exists" : "MISSING") + "\n" + "\tDatabases Indexes:\n" + "\t\tStaging Triples Index : " + (this.isTripleIndexOn(DatabaseKind.STAGING) ? "exists" : "MISSING") + "\n" + "\t\tStaging Collection Lexicon : " + (this.isCollectionLexiconOn(DatabaseKind.STAGING) ? "exists" : "MISSING") + "\n" + "\t\tFinal Triples Index : " + (this.isTripleIndexOn(DatabaseKind.FINAL) ? "exists" : "MISSING") + "\n" + "\t\tFinal Collection Lexicon : " + (this.isCollectionLexiconOn(DatabaseKind.FINAL) ? "exists" : "MISSING") + "\n" + "\tForests\n" + "\t\tStaging: " + (this.areForestsExistent(DatabaseKind.STAGING) ? "exists" : "MISSING") + "\n" + "\t\tFinal:   " + (this.areForestsExistent(DatabaseKind.FINAL) ? "exists" : "MISSING") + "\n" + "\t\tTrace:   " + (this.areForestsExistent(DatabaseKind.TRACE) ? "exists" : "MISSING") + "\n" + "\t\tJob:     " + (this.areForestsExistent(DatabaseKind.JOB) ? "exists" : "MISSING") + "\n" + "\n\n" + "OVERAL RESULT: " + (this.isInstalled() ? "INSTALLED" : "NOT INSTALLED") + "\n";
    }

    @Override
    public boolean isAppServerExistent(DatabaseKind kind) {
        boolean exists = false;
        switch (kind) {
            case STAGING: {
                exists = this.stagingAppServerExists;
                break;
            }
            case FINAL: {
                exists = this.finalAppServerExists;
                break;
            }
            case JOB: {
                exists = this.jobAppServerExists;
                break;
            }
            case TRACE: {
                exists = this.traceAppServerExists;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "test appserver existence");
            }
        }
        return exists;
    }

    @Override
    public void setAppServerExistent(DatabaseKind kind, boolean exists) {
        switch (kind) {
            case STAGING: {
                this.stagingAppServerExists = exists;
                break;
            }
            case FINAL: {
                this.finalAppServerExists = exists;
                break;
            }
            case TRACE: {
                this.traceAppServerExists = exists;
                break;
            }
            case JOB: {
                this.jobAppServerExists = exists;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set the triple index");
            }
        }
    }

    @Override
    public boolean isDbExistent(DatabaseKind kind) {
        boolean exists = false;
        switch (kind) {
            case STAGING: {
                exists = this.stagingDbExists;
                break;
            }
            case FINAL: {
                exists = this.finalDbExists;
                break;
            }
            case JOB: {
                exists = this.jobDbExists;
                break;
            }
            case TRACE: {
                exists = this.traceDbExists;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "test database existence");
            }
        }
        return exists;
    }

    @Override
    public void setDbExistent(DatabaseKind kind, boolean exists) {
        switch (kind) {
            case STAGING: {
                this.stagingDbExists = exists;
                break;
            }
            case FINAL: {
                this.finalDbExists = exists;
                break;
            }
            case TRACE: {
                this.traceDbExists = exists;
                break;
            }
            case JOB: {
                this.jobDbExists = exists;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set the triple index");
            }
        }
    }

    @Override
    public boolean isTripleIndexOn(DatabaseKind kind) {
        boolean on = false;
        switch (kind) {
            case STAGING: {
                on = this.stagingTripleIndexOn;
                break;
            }
            case FINAL: {
                on = this.finalTripleIndexOn;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check the triple index");
            }
        }
        return on;
    }

    @Override
    public void setTripleIndexOn(DatabaseKind kind, boolean tripleIndexOn) {
        switch (kind) {
            case STAGING: {
                this.stagingTripleIndexOn = tripleIndexOn;
                break;
            }
            case FINAL: {
                this.finalTripleIndexOn = tripleIndexOn;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set the triple index");
            }
        }
    }

    @Override
    public boolean isCollectionLexiconOn(DatabaseKind kind) {
        boolean on = false;
        switch (kind) {
            case STAGING: {
                on = this.stagingCollectionLexiconOn;
                break;
            }
            case FINAL: {
                on = this.finalCollectionLexiconOn;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check the collection lexicon");
            }
        }
        return on;
    }

    @Override
    public void setCollectionLexiconOn(DatabaseKind kind, boolean collectionLexiconOn) {
        switch (kind) {
            case STAGING: {
                this.stagingCollectionLexiconOn = collectionLexiconOn;
                break;
            }
            case FINAL: {
                this.finalCollectionLexiconOn = collectionLexiconOn;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set the collection lexicon");
            }
        }
    }

    @Override
    public boolean areForestsExistent(DatabaseKind kind) {
        boolean exists = false;
        switch (kind) {
            case STAGING: {
                exists = this.stagingForestsExist;
                break;
            }
            case FINAL: {
                exists = this.finalForestsExist;
                break;
            }
            case TRACE: {
                exists = this.traceForestsExist;
                break;
            }
            case JOB: {
                exists = this.jobForestsExist;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "check forest existence");
            }
        }
        return exists;
    }

    @Override
    public void setForestsExistent(DatabaseKind kind, boolean forestsExistent) {
        switch (kind) {
            case STAGING: {
                this.stagingForestsExist = forestsExistent;
                break;
            }
            case FINAL: {
                this.finalForestsExist = forestsExistent;
                break;
            }
            case TRACE: {
                this.traceForestsExist = forestsExistent;
                break;
            }
            case JOB: {
                this.jobForestsExist = forestsExistent;
                break;
            }
            default: {
                throw new InvalidDBOperationError(kind, "set forest existence");
            }
        }
    }
}

